;============================================================================
; (c) Copyright Elect Software International Inc., 1992, Toronto. Anyone can
; use this code for anything as long as it is not resold as a software
; development resource, as long as the copyright notice isn't removed, as
; long as changes are clearly marked as to authorship, and as long as users
; indemnify Elect from any liability.
; Comments welcome. Henrik Bechmann, CIS:72701,3717; Tel:416-534-8176.
;============================================================================

; Demo for ButtonMan, Version 1.5 January, 1993

Librarian.HasControl = True
Play Sdir() + "buttnman"
Play Sdir() + "eventman"
Play Sdir() + "packman"
Play Sdir() + "keybar"
Play Sdir() + "colorpal"
Release vars
   Librarian.HasControl

EventMan.Constructor()
EventMan.SetObjectTagProc = "EventMan.SetIndexedObjectTag"
ButtonMan.Constructor()

Proc Demo.MakeABeep()
   Beep
   Return 1
EndProc

Proc Demo.CloseButtonBar()
   ButtonMan.DestroyButtonBar(ButtonMan.ButtonBarTag)
   Return 1
EndProc

Proc Demo.Quit()
   Return 2
EndProc

Proc Demo.MakeRadioButtonBar()
   Private
      PropertyBag,
      ButtonBag,
      WindowBag,
      ColorBag
   Dynarray PropertyBag[]
   Dynarray ButtonBag[]
   Dynarray WindowBag[]
   Dynarray ColorBag[]

   PropertyBag["ObjectTag"] = "ButtonBar1"
   PropertyBag["Action"] = "Radio"
   PropertyBag["ButtonStyle"] = "Border"
   PropertyBag["ButtonColor"] = 96 + 14
   PropertyBag["SelectedColor"] = 96 + 15
   PropertyBag["UserScript"] = "!Button1"

   ButtonBag["First"]   = Chr(1)  + "Demo.MakeABeep"
   ButtonBag["Second"]  = Chr(2)  + "Demo.MakeABeep"
   ButtonBag["Third"]   = Chr(3)  + "Demo.MakeABeep"
   ButtonBag["Fourth"]  = Chr(4)  + "Demo.MakeABeep"
   ButtonBag["Fifth"]   = Chr(5)  + "Demo.MakeABeep"
   ButtonBag["Sixth"]   = Chr(6)  + "Demo.MakeABeep"
   ButtonBag["Seventh"] = Chr(7)  + "Demo.MakeABeep"
   ButtonBag["Eighth"]  = Chr(8)  + "Demo.MakeABeep"
   ButtonBag["Close"]   = Chr(9)  + "Demo.CloseButtonBar"
   ButtonBag["Quit"]    = Chr(10) + "Demo.Quit"

   WindowBag["Title"] = "Radio Button Bar"
   WindowBag["OriginRow"] = 2
   WindowBag["OriginCol"] = 0
   WindowBag["CanResize"] = True
   WindowBag["HasFrame"] = True
   WindowBag["Floating"] = False

   ButtonMan.MakeButtonBar(PropertyBag,ButtonBag,WindowBag,ColorBag)
EndProc ; Demo.MakeRadioButtonBar

Proc Demo.MakeToggleButtonBar()
   Private
      PropertyBag,
      ButtonBag,
      WindowBag,
      ColorBag
   Dynarray PropertyBag[]
   Dynarray ButtonBag[]
   Dynarray WindowBag[]
   Dynarray ColorBag[]

   PropertyBag["ObjectTag"] = "ButtonBar2"
   PropertyBag["Action"] = "Toggle"
   PropertyBag["ButtonStyle"] = "Flat"
   PropertyBag["ButtonColor"] = 64 + 15 ; 32 + 14
   PropertyBag["SelectedColor"] = 32 + 15
   PropertyBag["CanvasColor"] = 64 + 0
   PropertyBag["ShadowColor"] = 64 + 0
   PropertyBag["WrapCount"] = 4
   PropertyBag["UserScript"] = "!Button2"

   ButtonBag["One"]     = Chr(1)  + "Demo.MakeABeep"
   ButtonBag["Two"]     = Chr(2)  + "Demo.MakeABeep"
   ButtonBag["Three"]   = Chr(3)  + "Demo.MakeABeep"
   ButtonBag["Four"]    = Chr(4)  + "Demo.MakeABeep"
   ButtonBag["Five"]    = Chr(5)  + "Demo.MakeABeep"
   ButtonBag["Six"]     = Chr(6)  + "Demo.MakeABeep"
   ButtonBag["Seven"]   = Chr(7)  + "Demo.MakeABeep"
   ButtonBag["Eight"]   = Chr(8)  + "Demo.MakeABeep"
   ButtonBag["Close"]   = Chr(9)  + "Demo.CloseButtonBar"
   ButtonBag["DoProcess"] = Chr(10) + "Demo.DoProcess,DoProcess"
   ButtonBag["Quit"]    = Chr(11) + "Demo.Quit"

   WindowBag["Title"] = "Toggle Button Bar"
   WindowBag["OriginRow"] = 12
   WindowBag["OriginCol"] = 0
   WindowBag["CanResize"] = True
   WindowBag["HasFrame"] = True

   ButtonMan.MakeButtonBar(PropertyBag,ButtonBag,WindowBag,ColorBag)
EndProc ; Demo.MakeToggleButtonBar()

Proc Demo.DoProcess()
   Private
      CurrentWindow
   Demo.MakeProcessButtonBar()
   CurrentWindow = GetWindow()
   Window Select EventMan.ObjectTagWindow["ProcessBar"]
   Message "Please wait while your request is being processed..."
   Sleep 1000
   ButtonMan.SelectButton("ProcessBar","Two")
   ButtonMan.EnableButton("ProcessBar","One",False)
   Sleep 1000
   ButtonMan.SelectButton("ProcessBar","Three")
   ButtonMan.EnableButton("ProcessBar","Two",False)
   Sleep 1000
   ButtonMan.SelectButton("ProcessBar","Four")
   ButtonMan.EnableButton("ProcessBar","Three",False)
   Sleep 1000
   ButtonMan.SelectButton("ProcessBar","Five")
   ButtonMan.EnableButton("ProcessBar","Four",False)
   Sleep 1000
   ButtonMan.SelectButton("ProcessBar","Six")
   ButtonMan.EnableButton("ProcessBar","Five",False)
   Sleep 1000
   ButtonMan.SelectButton("ProcessBar","Seven")
   ButtonMan.EnableButton("ProcessBar","Six",False)
   Sleep 1000
   ButtonMan.SelectButton("ProcessBar","Eight")
   ButtonMan.EnableButton("ProcessBar","Seven",False)
   Sleep 1000
   ButtonMan.SelectButton("ProcessBar","Nine")
   ButtonMan.EnableButton("ProcessBar","Eight",False)
   Sleep 1000
   ButtonMan.SelectButton("ProcessBar","Ten")
   ButtonMan.EnableButton("ProcessBar","Nine",False)
   Sleep 1000
   ButtonMan.DestroyButtonBar("ProcessBar")
   Message "Done."
   Return 1
EndProc ; DoProcess

Proc Demo.MakeProcessButtonBar()
   Private
      PropertyBag,
      ButtonBag,
      WindowBag,
      ColorBag
   Dynarray PropertyBag[]
   Dynarray ButtonBag[]
   Dynarray WindowBag[]
   Dynarray ColorBag[]

   PropertyBag["ObjectTag"] = "ProcessBar"
   PropertyBag["Action"] = "Radio"
   PropertyBag["ButtonStyle"] = "Border"
   PropertyBag["Orientation"] = "Vertical"
   PropertyBag["WrapCount"] = 5

   ButtonBag["One"]     = Chr(1)  + ",This is the first step."
   ButtonBag["Two"]     = Chr(2)  + ",We now move to the second."
   ButtonBag["Three"]   = Chr(3)  + ",The third step after 2."
   ButtonBag["Four"]    = Chr(4)  + ",Now for the fourth."
   ButtonBag["Five"]    = Chr(5)  + ",The end of the first set."
   ButtonBag["Six"]     = Chr(6)  + ",Now we start the second set."
   ButtonBag["Seven"]   = Chr(7)  + ",The other buttons are dimmed."
   ButtonBag["Eight"]   = Chr(8)  + ",Almost done."
   ButtonBag["Nine"]    = Chr(9)  + ",Only one more to go!"
   ButtonBag["Ten"]     = Chr(10) + ",Now we are finished."

   WindowBag["Title"] = "Progress report"
   WindowBag["OriginRow"] = 5
   WindowBag["OriginCol"] = 3
   WindowBag["CanResize"] = False
   WindowBag["HasFrame"] = True

   ButtonMan.MakeButtonBar(PropertyBag,ButtonBag,WindowBag,ColorBag)
EndProc ; Demo.MakeProcessButtonBar

Proc Demo.MakeCheckbox()
   Private
      PropertyBag,
      ButtonBag,
      WindowBag,
      ColorBag
   Dynarray PropertyBag[]
   Dynarray ButtonBag[]
   Dynarray WindowBag[]
   Dynarray ColorBag[]

   PropertyBag["ObjectTag"] = "ButtonBar3"
   PropertyBag["Action"] = "Checkbox"
   PropertyBag["Orientation"] = "Vertical"
   PropertyBag["ButtonStyle"] = "Shadow"
   PropertyBag["ButtonColor"] = 64 + 15
   PropertyBag["SelectedColor"] = 32 + 15
   PropertyBag["SelectedHotKeyColor"] = 32 + 12
   PropertyBag["CanvasColor"] = 80 + 14
   PropertyBag["ShadowColor"] = 80 + 0
   PropertyBag["HighLightColor"] = 80 + 13
   PropertyBag["HotKeyColor"] = 80 + 12
   PropertyBag["DisableColor"] = 64 + 7
   PropertyBag["UserScript"] = "!Button3"

   ButtonBag["One"]   = Chr(1)  + "Demo.MakeABeep,The ~F~irst"
   ButtonBag["Two"]   = Chr(2)  + "Demo.MakeABeep,The ~S~econd"
   ButtonBag["Three"] = Chr(3)  + "Demo.MakeABeep,The ~T~hird"
   ButtonBag["Four"]  = Chr(4)  + "Demo.MakeABeep,The F~o~urth"
   ButtonBag["Five"]  = Chr(5)  + "Demo.MakeABeep,The F~i~fth"
   ButtonBag["Six"]   = Chr(6)  + "Demo.MakeABeep,The Si~x~th"
   ButtonBag["Seven"] = Chr(7)  + "Demo.MakeABeep,The S~e~venth"
   ButtonBag["Eight"] = Chr(8)  + "Demo.MakeABeep,The Ei~g~hth"
   ButtonBag["Nine"]  = Chr(9)  + "Demo.CloseButtonBar,~C~lose"
   ButtonBag["Ten"]   = Chr(10) + "Demo.Quit,~Q~uit"

   WindowBag["Title"] = "Checkbox"
   WindowBag["OriginRow"] = 5
   WindowBag["OriginCol"] = 59
   WindowBag["HasFrame"] = True

   ButtonMan.MakeButtonBar(PropertyBag,ButtonBag,WindowBag,ColorBag)
EndProc ; Demo.MakeCheckBox

SetCanvas Default
Echo Normal
Cursor off

KeyBar.Constructor()
Demo.MakeRadioButtonBar()
Demo.MakeToggleButtonBar()
Demo.MakeCheckBox()
ButtonMan.EnableButton("ButtonBar3","Two",False)
ButtonMan.EnableButton("ButtonBar3","Five",False)
KeyBar.MakeButtonBar()

Message "Right click on any ButtonBar for an inspector"

EventMan.DoGetEvent()

ButtonMan.DestroyButtonBar("ButtonBar1")
ButtonMan.DestroyButtonBar("ButtonBar2")
ButtonMan.DestroyButtonBar("ButtonBar3")
KeyBar.DestroyButtonBar()

KeyBar.Destructor()
ButtonMan.Destructor()
EventMan.Destructor()