



BRIEF INTRODUCTION TO LOTTOPROF
===============================

LottoProf stands alone amongst lotto programs.  Unlike the others,
LottoProf does not waste your time on "lottery trend analysis".  Instead,
the focus is where it really matters, on the probability analysis of bet
combinations.  Using proprietary technology, LottoProf provides you with
unprecedented information.  A playing advantage found nowhere else.

Briefly, you have this advantage by ...

Selecting, from the "Wager" top menu, a bet combination -- it may be 
one supplied or one of your own design.  Whichever, it will be loaded 
into a table for you to view and edit.  Then press "F2" to select the 
"Analysis Options Menu".

You may then instruct LottoProf to perform a winning probability
analysis.  Along with computing your chances in detail, a number will be
assigned -- the greater the number the better your chances of winning.  
You may then add the results to the integrated database, and then view
the entire database graphically.  This allows you to visually select the
best play for the price.  Once selected, add it to your Player Program.
If you wish, print the bet combination you've decided to play, and, if 
you have an HP LaserJet compatible printer, print out bet slips directly.

Exit LottoProf.  Wait for your lottery to hold its next draw.

Draw complete?  Return to LottoProf.

From the "Draw" top menu, select the appropriate lottery history file.
Enter the winning numbers, and if you have them, the prize values.  
Escape to the top menu level and from beneath "Wager" load your Player
Program.  Automatically, LottoProf will check the combination you played
against the numbers drawn.  With luck you'll be a winner.  If so, the 
combination you played will be loaded into the table, with the winning
tickets identified.

Now go collect your winnings!



LOTTOPROF 3.0  REFERENCE MANUAL
===============================
Shareware Version


When you register your copy of LottoProf, you receive an exten-
sive User's Guide.  Because of its complexity, it is not possible 
to include it on disk.  Instead, this manual is provided to help 
you understand LottoProf.  Contained within is a brief descrip-
tion of each menu option in the program.



MENU STRUCTURE
==============

The following "table of contents" gives an overview of the menu 
structure of LottoProf.

         Read Me                     
            Release Notes            
            Brief Introduction       
            Questions and Answers    
            Order Information        
         Wager                       
            Select Bet Combination   
               Internal Combination  
               File Combination      
            Construct Bet Combination
            Generate Bet Combination 
            Random Bet Combination   
            System Bet Combination   
         Draw                        
            Select Lottery           
            Create Lottery           
         Config                      
            Printer                  
            History Table Size       
            Player Table Size        
            Memory                   
            Edit Ticket              
            Opening Screen           
            Beep Threshold           
            Favorite Numbers         
            Game Type                


All the 'Draw' options will lead you to the 'Lottery Drawing 
History' table.  By pressing the F2 key the options for this 
table pop up.  They are:

         Edit History        
         Save History to File
         Hot Numbers         
         Print History       
         Display History     
         Frequency of Draws  
         Add Player          


All of the 'Wager' options will load a bet combination in to the 
'Bet Combination Table.'  There you can examine and modify the 
numbers played.  If you press the F2 key then menu options for 
this table pop up.  The options available here (called 'Analysis 
Options') are:

         Edit Bet Combination    
         Quick Analysis          
         Probability Analysis    
         Winning Numbers Check   
         Lottery History Check   
         Favorite Numbers        
            Sequentially         
            Popularity           
            Manually             
         Change Upper Limit      
         Order Bet Combination   
         Save Combination to File
         Add to Database         
         Display Database Graph  
         Print Bet Combination   
            Listing              
            Bet Slips            
            Database             
         Adjust Bet Combination  
         Player Maintenance      
            View Play Program    
            Enter Play           
            Nullify  Play        
            Copy Play            
            Print Play Program   
            Load Play            
            Information          
            Recalculate Winnings 


MENU OPTIONS REFERENCE
======================

Read Me --> Release Note
   Brief Description of Enhancements found in current version.

Read Me --> Brief Introduction
   A brief introduction to LottoProf, indicating how the various 
   parts fit together.

Read Me --> Questions and Answers
   A forum for questions about lotteries.

Read Me --> Order Information
   How to register your copy of LottoProf.

Wager  --> Select Bet Combination --> Internal Combination
   LottoProf comes with a set of bet combinations built in.  You 
   select them from this menu.

Wager  --> Select Bet Combination --> File Combination
   Here you select a bet combination stored on disk.  It may be 
   one supplied with LottoProf or one you created previously.

Wager  --> Construct Bet Combination
   Build your own bet combination from scratch.

Wager --> Generate Bet Combination
   You tell LottoProf how many boards you want to play and how 
   many numbers to cover.  LottoProf will then create a bet combina-
   tion for you -- one with good even coverage.

Wager --> Random Bet Combination
   You tell LottoProf how many boards you want to play and how 
   many numbers to cover.  LottoProf will then create a randomly 
   generated bet combination.  This is similar to the "Quick Pick" 
   feature offered by many lotteries.

Wager --> System Bet Combination
   Creates various "System Bets" offered by many lotteries.

Draw --> Select Lottery
   Load a lottery's winning numbers from a disk file.

Draw --> Create Lottery
   Create a new lottery from scratch.

Config --> Printer
   A PC may be connected up to three printers.  On the backside 
   of a PC, the connector that you plug a printer cable into is 
   called a "port".  The computer assigns names to these ports: 
   "LPT1", "LPT2", "LPT3".  When you send data to a printer, it 
   flows through one of these ports.  LottoProf allows you to choose 
   which port through which you wish to send data.  The asterisk 
   indicates the current selection.  If you only have one printer, 
   it is probably connected to LPT1, so the default setting should 
   be fine.


Config --> History Table Size
   The Lottery Drawing History table is preset to hold 1040 
   draws -- enough for 20 years of results from a weekly lottery.  
   The size of the table can be changed, however.  If you actually 
   need to make it bigger to hold more draws, you can do so.  The 
   maximum size is 4000 rows, or whatever is allowed by your compu-
   ter's available memory.  If you don't have enough memory, Lotto-
   Prof will tell you when you try to load a draw.  In such a situa-
   tion, reduce the size of the table.

Config --> Player Table Size
   Likewise, you may configure the size of the Player Program 
   table.  It too has a maximum size of 4000 rows (memory permit-
   ting).  The default size is 500.

Config --> Memory
   As mentioned above, you can vary the size of the Lottery 
   Drawing History table and Player Program table to fit your memory 
   condition.  But how do you tell?  LottoProf will tell you.  If 
   you select "Show active free memory", LottoProf will display, in 
   the upper right corner, the number of free bytes of memory.  

Config --> Edit Ticket
   This is an advanced feature.  You can define the geometrical 
   shape of the bet slips of your favorite lottery.  With such 
   information LottoProf can print your wagers directly onto the bet 
   slips.  Provided you have an HP LaserJet compatible printer, that 
   is.

Config --> Opening Screen
   All commercial programs should, of course, have a snazzy 
   opening screen.  Too seldom, however, can you deactivate it.  
   With LottoProf you can enable it or disable it.  

Config --> Beep Threshold
   This has to do with the probability analysis options.  If an 
   analysis take longer than (in this case) 30 seconds, LottoProf 
   will beep when the computation completes.  This applies to both 
   full and quick analysis options.  If you want it to beep every 
   time, set the threshold to 0.  If you don't want it to beep, set 
   it to some really big number.  (There are about 31,000,000 sec-
   onds in a year.)  

Config --> Favorite Numbers
   You can tell LottoProf your favorite numbers and save them 
   between runs.  

Config --> Game Type
   This option is new in version 3.0 and allows you to configure 
   LottoProf for either 5-ball or 6-ball lotto games.  The changes 
   take effect immediately and the setting is stored between program 
   runs.  


The following is a summary of menu options available from the 
'Bet Combination Table.'  You get here by selecting one of the 
options under the 'Wager' main menu item, and then  pressing the 
F2 key.

Edit Bet Combination
   Returns you to the 'Bet Combination Table.'

Quick Analysis
   Analyzes the winning chances of a bet combination without 
   giving the full details.

Probability Analysis
   Analyzes the winning chances of a bet combination with full 
   details provided.

Winning Numbers Check
   You can check if you've got any winners.  Especially useful if 
   the size of the bet combination is large.

Lottery History Check
   You can see how well a bet would have done had you played it 
   for all the drawings held by the lottery.

Favorite Numbers --> Sequentially/Popularity/Manually
   The numbers stored in a bet combination often cover 1,2,3,...
   With this option you can change the numbers currently stored to 
   those that are your favorites.  You can set your favorite numbers 
   under the 'Config' main menu option.

Change Upper Limit
   The "Upper Limit" represents the largest number than can be 
   played in a lottery.  If your lottery is 6/49, for instance, set 
   Upper Limit to 49.

Order Bet Combination
   Take a bet combination that is randomly generated or otherwise 
   messed up, and orders the individual board sequentially.

Save Combination to File
   This is where you save new bet combinations that you created.  
   LottoProf will ask you the name of the new file.

Add to Database
   After you have analyzed the winning chances of a bet combina-
   tion (using 'Quick Analysis' or 'Probability Analysis'), you can 
   the save the results in a database.  That way, you only have to 
   do the computation once.

Display Database Graph
   Displays all the points in the database as a graph.  This 
   allows you to visually compare the strengths of various bet 
   combinations so you can choose the best play for the money.

Print Bet Combination --> Listing
   Prints a listing of the current bet combination.

Print Bet Combination --> Bet Slips
   Prints the current bet combination onto bet slips.   You need 
   an HP LaserJet compatible printer for this option to work.

Print Bet Combination --> Database
   Prints the contents of the database.

Adjust Bet Combination
   This gives you a way of changing the bet combination without 
   having to type in numbers.  You do it visually by moving little 
   squares.  Each square represents a number.

Player Maintenance
   This is an advanced option that is described fully in the 
   User's Guide provided when you register your copy of LottoProf.
   Briefly, it allows you to keep a record of all the bets you
   place in your lottery.  LottoProf will keep track of your
   winnings.      



The following options are available from the 'Lottery Drawing 
History' table.  You get there by choose one of the options under 
the 'Draw' main menu and then pressing the F2 key.

Edit History
   Returns you to the 'Lottery Drawing History' table.  Here you 
   add the new results of your lottery's drawings.

Save History to File
   Saves to disk the updates you made to the lottery file.

Hot Numbers
   Determines which numbers have been drawn most often in recent 
   draws.  You determine how far back to check.

Print History
   Prints out the lottery's winning numbers.  You can print the 
   whole history or only a smaller range.

Display History
   Displays the winning numbers in a graph format.

Frequency of Draws 
   Sometimes a lottery will change the drawing frequency from, 
   say, once a week to twice a week.  This option tells LottoProf 
   how many drawings are held each week.

Add Player
   LottoProf can set up a 'Player Program' for more than one person
   Use of this option is fully explained in the User's Guide 
   you will receive when you register your version of LottoProf.

