******************************************************************************
* PROGRAM ----: DEMO.PRG 
* AUTHOR -----: Kevin E. Saffer
* CREATED ----: 5/27/1993 at 10:21
******************************************************************************
* demonstrates the KBROWSE function with incremental search and record marking
******************************************************************************

* open a data file and build indexes           
USE address EXCLUSIVE
IF .NOT. FILE("addrname" + INDEXEXT())
  INDEX ON UPPER(lastname)+UPPER(firstname)+initial+"   " TO addrname
  INDEX ON ssn + " " TO addrssn
ENDIF
SET INDEX TO addrname,addrssn  && note that the index order is used later!

* set up browsing arrays
m_marked = {}                 
m_retexp = {|| A->lastname}
m_array = {;
  { "Last Name"     , {|| A->lastname}, 1, "@!" },; && use index 1 with a search clause
  { "First Name"    , {|| A->firstname} },;
  { "I"             , {|| A->initial}   },;
  { "SSN"           , {|| A->ssn}, 2, "" },;   && index 2, no search clause
  { "Marked"        , {|| IIF(ASCAN(m_marked,RECNO()) = 0," ","")} },;  && a marking function
  { "Address Line 1", {|| A->addr1}     },;
  { "Address Line 2", {|| A->addr2}     },;
  { "Address Line 3", {|| A->addr3}     },;
  { "City"          , {|| A->city}      },;
  { "St"            , {|| A->state}     },;
  { "Zip Code"      , {|| A->zipcode}   };
}

* set up the screen
CLEAR
@ 00,00 TO 15,79 DOUBLE
@ 16,00 SAY ""
TEXT
 Up Arrow:    Up 1 Record           PgUp:      Up 1 screen     SpaceBar: Marks
 Down Arrow:  Down 1 Record         PgDn:      Down 1 screen   Alpha: Search
 Right Arrow: Column Right          Ctrl-PgUp: Top of File     Enter: Select
 Left Arrow:  Column Left           Ctrl-PgDn: Bottom of File  Esc:   Exit
 Ctrl-Right:  Arrow: Screen Right   Home:      Left Column
 Ctrl-Left:   Arrow: Screen Right   End:       Right Column

   Note that moving into an indexed column re-sorts the display accordingly.
ENDTEXT

* perform the browse with array parameters, locking the lastname column
m_retval = KBROWSE(01,01,14,78,m_array,m_retexp,"","  ",@m_marked,0)

* just for fun, perform a full screen browse
KBROWSE()

CLOSE DATABASES
CLEAR
RETURN

