*:*****************************************************************************
*:
*: Procedure file: D:\FP25EROR\FP25EROR.PRG
*:
*:         System: FP25EROR - FoxPro DOS Error Handler
*:         Author: Pat Adams                    v 1.06
*:      Copyright (c) 1993, DB Unlimited
*:  Last modified: 5/26/93     11:58
*:
*:  Procs & Fncts: XLOW_MEM
*:               : LOW_MEM
*:               : GO_MASTR
*:               : ERORSET
*:               : NO_FILE
*:               : FILE_BUSY
*:               : GO_AGAIN
*:               : TOO_HIGH
*:               : LOWFILES
*:               : REALBAD
*:               : INDEX_ER
*:               : SETENVMT
*:               : SAVE_IT
*:               : QQUIT
*:               : UPMVCOUNT
*:               : TOOBIG
*:               : NOMEMO
*:               : BAD_RPT
*:               : BADMEMFL
*:               : NOSPACE
*:               : TO_PRN
*:               : KORRUPT
*:               : REC_BUSY
*:               : LREADONLY
*:               : READONLY
*:               : BAD_DIF
*:               : BAD_SYLK
*:               : INVALPRN
*:               : NOTREADY
*:               : NOTRIGHT
*:               : BADLOTUS
*:               : REC2BIG
*:               : SQL_INTL
*:               : SQLTRASH
*:               : NOSQLIDX
*:               : SQL_IDX
*:               : SQLABORT
*:               : IO_FAILED
*:               : MEM_PROB
*:               : KODEKORUP
*:               : BADCHAIN
*:               : BAD_API
*:               : BADRIGHTS
*:               : NOCREAT
*:               : READ_ERR
*:               : RITE_ERR
*:               : TRANSACTN
*:               : BADCLOSE
*:               : BAD_OBJ
*:               : NOTFOXEXE
*:               : VERBOSE
*:               : BAD_RESRC
*:               : NORUN
*:               : BAD_WIN
*:               : PKORRUPT
*:               : BADEXCEL
*:               : ENKRYPTED
*:               : BADSYMPH
*:               : A_ONLY
*:               : L_HIDE
*:               : BAD_PARDX
*:               : DNOACCES
*:               : NOACCESS
*:               : SNOACCES
*:               : NO_CDX
*:               : NOAPI
*:               : NOPSERVER
*:               : NO_QUE
*:               : NO_PLB
*:               : NOSQLOPEN
*:               : PROGBUG
*:               : RAZBERRY
*:               : LOGVIEW
*:               : MEMOVIEW
*:               : YES_NO
*:               : NICECHIM
*:               : A_LERT
*:               : KANCEL
*:               : DEVELOPER
*:               : LAN_ADMIN
*:               : APP_ADMIN
*:               : USTRING
*:
*:         Set by: ERORSET            (procedure in FP25EROR.PRG)
*:
*:          Calls: XLOW_MEM           (procedure in FP25EROR.PRG)
*:               : LOW_MEM            (procedure in FP25EROR.PRG)
*:               : GO_MASTR           (procedure in FP25EROR.PRG)
*:               : ERORSET            (procedure in FP25EROR.PRG)
*:               : NO_FILE            (procedure in FP25EROR.PRG)
*:               : FILE_BUSY          (procedure in FP25EROR.PRG)
*:               : GO_AGAIN           (procedure in FP25EROR.PRG)
*:               : TOO_HIGH           (procedure in FP25EROR.PRG)
*:               : LOWFILES           (procedure in FP25EROR.PRG)
*:               : REALBAD            (procedure in FP25EROR.PRG)
*:               : INDEX_ER           (procedure in FP25EROR.PRG)
*:               : SETENVMT           (procedure in FP25EROR.PRG)
*:               : SAVE_IT            (procedure in FP25EROR.PRG)
*:               : QQUIT              (procedure in FP25EROR.PRG)
*:               : UPMVCOUNT          (procedure in FP25EROR.PRG)
*:               : TOOBIG             (procedure in FP25EROR.PRG)
*:               : NOMEMO             (procedure in FP25EROR.PRG)
*:               : BAD_RPT            (procedure in FP25EROR.PRG)
*:               : BADMEMFL           (procedure in FP25EROR.PRG)
*:               : NOSPACE            (procedure in FP25EROR.PRG)
*:               : TO_PRN             (procedure in FP25EROR.PRG)
*:               : KORRUPT            (procedure in FP25EROR.PRG)
*:               : REC_BUSY           (procedure in FP25EROR.PRG)
*:               : LREADONLY          (procedure in FP25EROR.PRG)
*:               : READONLY           (procedure in FP25EROR.PRG)
*:               : BAD_DIF            (procedure in FP25EROR.PRG)
*:               : BAD_SYLK           (procedure in FP25EROR.PRG)
*:               : INVALPRN           (procedure in FP25EROR.PRG)
*:               : NOTREADY           (procedure in FP25EROR.PRG)
*:               : NOTRIGHT           (procedure in FP25EROR.PRG)
*:               : BADLOTUS           (procedure in FP25EROR.PRG)
*:               : REC2BIG            (procedure in FP25EROR.PRG)
*:               : SQL_INTL           (procedure in FP25EROR.PRG)
*:               : SQLTRASH           (procedure in FP25EROR.PRG)
*:               : NOSQLIDX           (procedure in FP25EROR.PRG)
*:               : SQL_IDX            (procedure in FP25EROR.PRG)
*:               : SQLABORT           (procedure in FP25EROR.PRG)
*:               : IO_FAILED          (procedure in FP25EROR.PRG)
*:               : MEM_PROB           (procedure in FP25EROR.PRG)
*:               : KODEKORUP          (procedure in FP25EROR.PRG)
*:               : BADCHAIN           (procedure in FP25EROR.PRG)
*:               : BAD_API            (procedure in FP25EROR.PRG)
*:               : BADRIGHTS          (procedure in FP25EROR.PRG)
*:               : NOCREAT            (procedure in FP25EROR.PRG)
*:               : READ_ERR           (procedure in FP25EROR.PRG)
*:               : RITE_ERR           (procedure in FP25EROR.PRG)
*:               : TRANSACTN          (procedure in FP25EROR.PRG)
*:               : BADCLOSE           (procedure in FP25EROR.PRG)
*:               : BAD_OBJ            (procedure in FP25EROR.PRG)
*:               : NOTFOXEXE          (procedure in FP25EROR.PRG)
*:               : VERBOSE            (procedure in FP25EROR.PRG)
*:               : BAD_RESRC          (procedure in FP25EROR.PRG)
*:               : NORUN              (procedure in FP25EROR.PRG)
*:               : BAD_WIN            (procedure in FP25EROR.PRG)
*:               : PKORRUPT           (procedure in FP25EROR.PRG)
*:               : BADEXCEL           (procedure in FP25EROR.PRG)
*:               : ENKRYPTED          (procedure in FP25EROR.PRG)
*:               : BADSYMPH           (procedure in FP25EROR.PRG)
*:               : A_ONLY             (procedure in FP25EROR.PRG)
*:               : L_HIDE             (procedure in FP25EROR.PRG)
*:               : BAD_PARDX          (procedure in FP25EROR.PRG)
*:               : DNOACCES           (procedure in FP25EROR.PRG)
*:               : NOACCESS           (procedure in FP25EROR.PRG)
*:               : SNOACCES           (procedure in FP25EROR.PRG)
*:               : NO_CDX             (procedure in FP25EROR.PRG)
*:               : NOAPI              (procedure in FP25EROR.PRG)
*:               : NOPSERVER          (procedure in FP25EROR.PRG)
*:               : NO_QUE             (procedure in FP25EROR.PRG)
*:               : NO_PLB             (procedure in FP25EROR.PRG)
*:               : NOSQLOPEN          (procedure in FP25EROR.PRG)
*:               : PROGBUG            (procedure in FP25EROR.PRG)
*:
*:           Uses: SYSDATA.DBF        
*:
*:*****************************************************************************
*   PROGRAM: FP25EROR.PRG
*   VERSION: 1.06
*   AUTHOR:  Pat Adams, DB Unlimited  (718) 469-4032
*   DATE:    5/26/93
*
*   USE RESTRICTIONS: You may use FP25EROR and modifications
*   thereof as part of your custom applications without prior authorization
*   from DB Unlimited and without payment to DB Unlimited.  FP25EROR
*   may be freely distributed on electronic BBSes and via non-profit
*   user group disk libraries.
*
*   FP25EROR and modifications thereof may *NOT* be sold as shareware
*   or as a commercial product.  Use of the FP25EROR routine and modifi-
*   cations thereof in articles and books is reserved solely to DB Unlimited.
*
*   FP25EROR and modifications thereof may not be incorporated into
*   vertical market or commercial products without prior arrangement
*   with DB Unlimited.
*
*   NOTE: This routine is specific to FoxPro 2.5.  In some instances
*   FoxPro 2.5 uses different error numbers for error conditons than
*   FoxPro 2.0.  Both the FoxPro 2.0 error numbers and the FoxPro 2.5
*   error numbers have been included to the extent possible.  However,
*   the original PROERROR.PRG should be used with FoxPro 1.x and
*   PRO2EROR should be employed with FoxPro 2.0.
*
*   Information is stored to the FP25EROR.DBF file and then
*   the user is returned to master calling program if a RETRY
*   is not issued.  Please note that FP25EROR closes all files
*   and indexes before issuing a RETURN TO MASTER.  FP25EROR expects
*   that the MASTER level file will (re)initialize all necessary global
*   memvars, open databases and indexes, etc. as required for a
*   particular system.
*
*   When it is necessary to provide the user with the name and phone
*   number of an individual to call regarding an error the SYSDATA
*   database is opened and the record for the appropriate individual
*   is sought.  The titles supplied in the SYSDATA database which
*   accompanies this program should not be changed without modification
*   of the FP25EROR program.  The information for DEVELOPER is displayed
*   if the error is the result of a programming bug or syntax error.
*   Information for APP ADMINISTRATOR is called if files are missing
*   or other errors occur which require the attention of the applications
*   administrator.  LAN ADMINISTRATOR information is displayed if the
*   errors are related to specific LAN situations such as inappropriate
*   user authorizations on the LAN.
*
*   Because FoxPro 2.5 is both single user and multi-user, unlike
*   earlier versions of the Fox product line, a logical .T. should
*   be placed in the MULTI_USER field of each record if your appli-
*   cation is multi-user.  If your application is for use in stand-
*   alone mode only then a logical .F. should be placed in this
*   field.  SYSDATA.DBF is delivered with a logical .T. in the
*   MULTI_USER field of each record.
*
*   DOS based LANs such as Novell Netware Lite, InvisibleNET and
*   LANtastic that utilize SHARE treat the #1705 error message
*   differently than Novell, Lan Man or Banyan.  Therefore, if your
*   application will be running on a LAN that utilizes SHARE the
*   DOS_LAN field in each record of the SYSDATA database should be
*   initialized to a logical .T.  FP25EROR will utilize the info in
*   this field to determine which error message will be presented
*   when error #1705 is encountered.  SYSDATA.DBF is delivered with
*   a logical .F. as the default value for the DOS_LAN file.
*
*   Initializing a logical PUBLIC memvar named TESTING during test cycles
*   of your code will trigger an option in the STORE_IT module which
*   will provide you with the option of viewing the FP25EROR file at
*   the time the error condition occurs.  This module also permits
*   exit to DOS via use of the CONTROL-Q key combination.  If the
*   interactive version of FoxPro 2.5 is in use the ESC key can be
*   used to return to the command window after viewing the error log.
*
*   Colors for the windows and text are contained primarily in
*   the set-up for COLOR SCHEME 20 and the memvars REDBLINK and
*   LOWTEXT.
*
*   You *MUST* hard code your name and phone number in procedure
*   VERBOSE for the reasons stated in the procedure file header.
*
*   Utilize the following command to set up this system to
*   respond to FoxPro 2.5 errors:
*
*   ON ERROR DO FP25EROR WITH ERROR(), MESSAGE(), MESSAGE(1), ;
*      SYS(16), LINENO(), SYS(102), SYS(100), SYS(101), LASTKEY(), ;
*       ALIAS(), SYS(18), SYS(5), SYS(12), SYS(6), SYS(2003), WONTOP(), ;
*       SYS(2011), SYS(2018), SET("CURSOR")
*
*   or as an alternative:
*
*       [SET PROCEDURE TO FP25EROR]
*       DO erorset
*
*  Parameters are:
*
*   xerno =    The numeric code of the number provided by ERROR()
*   xmsg =     The error message provided by MESSAGE()
*   xkode =    The contents of the line of code which
*                 triggered the error as provided by MESSAGE(1)
*   xmodul =   The name of the code module, SYS(16)
*   xline =    The number of the line of code triggering the
*                 error, LINENO()
*   xprint =    Current PRINTER setting as per SYS(102)
*   xkonsol =   Current CONSOLE setting as per SYS(100)
*   xdevice =   Current DEVICE setting as per SYS(101)
*   keypress =  LASTKEY()
*   curr_dbf =  Selected .DBF when error occurred
*   getfield =  Field of GET...READ at time error occurred
*   def_drive = Default drive at time error occurred - SYS(5)
*   run_memry = Amount of DOS memory available for RUN command - SYS(12)
*   prnt_devic= Current SET PRINTER TO setting - SYS(6)
*   cur_direc = Current directory at time error occurred - SYS(2003)
*   top_win =   Top window at time error occurred
*   xlocked =   Record or file lock status at time error occurred -
*                 SYS(2011)
*   xmissing =  Missing file, window, etc.
*   curs_set =  Cursor setting at time error occurred.
*
*  In addition to this information, the routine saves the information
*  from LIST MEMORY and LIST STATUS is saved into the memo field.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS xerno, xmsg, xkode, xmodul, xline, xprint, ;
    xkonsol, xdevice, keypress, curr_dbf, getfield, def_drive, ;
    run_memry, prnt_devic, cur_direc, top_win, xlocked, ;
    xmissing, curs_set

IF AT(" ", ALLTRIM(top_win)) > 0
* ==================================================
* Modified 5/26/93 by Pat Adams.  If window name is
* actually a window title with more than one word
* shorten it to just the first word
* ==================================================
    STORE LEFT(top_win, AT(" ", ALLTRIM(top_win) -1) TO top_win
ENDIF AT(

IF xerno = 43 OR xerno = 809 OR xerno = 1809 OR xerno = ;
        845 OR xerno = 1845 OR xerno = 1149 OR xerno = ;
        1150 OR xerno = 1151 OR xerno = 1250 OR xerno = ;
        1281 OR xerno = 1310 OR xerno = 1600
    * ==============================
    *$ Insufficient memory
    *  Modified 4/6/93 - Routine now
    *  differentiates between Standard
    *  and Extended Edition and pro-
    *  vides different messages.
    * ==============================
    IF "(X)" $ VERS(1)
        DO xlow_mem
    ELSE
        DO low_mem
    ENDIF ("(X)" $ VERS(1))
    
    DO go_mastr
ENDIF (xerno = 43 OR xerno = 809 OR xerno = 1809 OR xerno = ;)

PRIVATE tryagain, printit, redblink, scheme20, ;
    lowtext, kontinu
* =========================================
*$ Initialize colors to be used in messages
* =========================================
STORE SCHEME(20) TO scheme20
SET COLOR OF SCHEME 20 TO "N/W, N/W, +*R/W"
STORE "+*R/W" TO redblink
STORE "+N/W" TO lowtext
SET PRINT OFF
SET DEVICE TO SCREEN
STORE .F. TO tryagain
ON ERROR ?? CHR(7)
CLEAR TYPEAHEAD

IF xerno=104 OR xerno=181 OR xerno=182 OR xerno= ;
        279 OR xerno=4 OR xerno=1107 OR ;
        xerno=1164 OR (xerno=91 AND "RELEASE" $ xkode)
    * ===========================================================
    *$ Ignore these errors and continue with program execution
    *
    * Error #104 occurs when ON KEY LABEL calls to function keys
    * F11 and F12 are made on older keyboards which do not support
    * these keys.  It does not trap illegal SET FUNCTION x calls.
    *
    * Error #181, "MENU is already in use", occurs when an
    * attempt is made to activate a MENU which has already
    * been activated.
    *
    * Error #182, "POPUP is already in use", occurs when an
    * attempt is made to activate a POPUP which has already
    * been activated.
    *
    * Error #279, "Prompts for this popup have already been
    * defined" occurs when an attempt is made to use the BAR
    * option to define contents of a POPUP already defined
    * with PROMPT.
    *
    * Error #4 = "End of file encountered"
    *
    * Error #1107 = "Structural CDX file reference removed"
    *
    * Error #91 - "File was not LOADed"  An attempt was made to
    *              CALL a .BIN file which has not been loaded
    *              or RELEASE a .BIN file or .PLB that has not
    *              been loaded.  FP25EROR will ignore calls to
    *              RELEASE modules that are not loaded.
    *
    * Error #1164 - "Browse structure changed."
    *                The structure of a BROWSE window was
    *                changed by a BROWSE validation routine.
    * ===========================================================
    SET CONSOLE &xkonsol
    * =========================================
    * &macro substitution is utilized since
    * EVALUATE() does not work with SET commands
    * =========================================
    SET DEVICE TO &xdevice
    DO erorset
    * ==================================================
    * Ignore the error and return to the line of
    * code following the one which generated the error
    * ==================================================
    RETURN
ENDIF (xerno=104 OR xerno=181 OR xerno=182 OR xerno= ;)

IF xerno = 1726 OR xerno = 1642
    * =======================================================
    *$ Ignore error and continue with program.
    *
    *$ #1706 - API library not found.
    *          This error occurs when a SET
    *          LIBRARY TO or RELEASE LIBRARY has been
    *          issued and the .PLB is not been loaded.
    *          (If .PLB can not be found error #1
    *          is generated.)
    *
    *$ #1642 - COLORSET resource not found
    * =============================================
    SET CONSOLE &xkonsol
    SET DEVICE TO &xdevice
    DO erorset
    RETURN
ENDIF (xerno = 1726 OR xerno = 1642)

SET TALK OFF
SET PRINT OFF
SET PRINTER TO prn
SET DEVICE TO SCREEN

DO CASE xerno
    CASE xerno = 1 OR xerno = 802 OR xerno = ;
        1162 OR xerno = 1802
        * =================================================
        *$ File does not exist or can not be found.
        *  Error #1 applies to standard FoxPro file while
        *  error #802 or #1802 specifically references a SQL table
        *  Error #1162 applies to an unfound PROCEDURE
        *  Error #1802 applies to a SQL table or .DBF
        *  Pop up window to inform user
        * =================================================
        DO no_file WITH xmissing
        DO go_mastr
        
    CASE xerno = 3 OR xerno = 108 OR xerno = 1503
        * ============================================================
        *$ Advise user file is in use and provide option to try again
        *  NOTE: This case statement can be omitted for single user aps
        *        since it will only be triggered in a multi-user
        *        environment where someone else has a file in
        *        EXCLUSIVE use.
        * ============================================================
        DO file_busy WITH tryagain
        
        IF tryagain
            * =============================
            *$ Retry for use of the file
            * =============================
            DO go_again
            SET CURSOR &curs_set
            RETRY
        ELSE
            * ============================================
            *$ Abort and return to the MASTER module
            *  Information is saved to FP25EROR database
            *  to provide a log of how often LAN users can
            *  not get use of a file.  If this situation
            *  occurs frequently it may mean that others on
            *  the LAN are using files interactively with
            *  EXCLUSIVE ON or that the source code needs to be
            *  rewritten to avoid such frequent contentions.
            * ============================================
            DO go_mastr
        ENDIF (tryagain)
        
    CASE xerno = 5
        * =======================================
        *$ Record is out of range
        *  Advise user & return to MASTER module
        * =======================================
        DO too_high
        DO go_mastr
        
    CASE xerno = 6
        * =====================
        *$ Too many files open
        * =====================
        DO lowfiles
        DO go_mastr
        
    CASE xerno = 15 OR xerno = 1111
        * ================================
        *$ # 15 - Database is trashed
        *$ #1111 - Invalid file descriptor
        * ================================
        DO realbad
        DO go_mastr
        
    CASE xerno = 19 OR xerno = 20 OR xerno = ;
        114 OR xerno = 1141 OR xerno = 1683 OR xerno = 1103
        * ==============================================
        *$ Index error problems - Recreate indexes
        * ==============================================
        DO index_er
        DO setenvmt
        DO save_it
        * ==============
        *$ Quit to DOS
        * ==============
        DO qquit
        
    CASE xerno = 21 OR xerno = 22
        * ==================================
        *$ String memory variable area overflow
        *$ Too many memory variables
        *
        *  The MVCOUNT statement in the
        *  CONFIG.FP file needs to be increased.
        * ====================================
        DO upmvcount
        DO go_mastr
        
    CASE xerno = 38
        * ==============================================
        *$ Attempt has been made to position record
        *  pointer before the first record in the file.
        *  Correct by going to top of file, skipping down
        *  one record, then retrying the same command line.
        * ==============================================
        GO TOP
        SKIP
        DO go_again
        RETRY
        
    CASE xerno = 39
        * =========================================
        *$ Numeric overflow (data was lost)
        * =========================================
        DO toobig
        DO go_mastr
        
    CASE xerno = 41
        * =========================================
        *$ Missing or invalid MEMO file
        *  NOTE: Depending upon the application,
        *  it may be desirable to modify this
        *  CASE statement to return the user to DOS
        * =========================================
        DO nomemo
        DO go_mastr
        
    CASE xerno = 50 OR xerno = 54 OR xerno = 1241 ;
        OR xerno = 1243 OR xerno = 1245 OR ;
        xerno = 1246 OR xerno = 1645 OR ;
        xerno = 1646 OR xerno = 1647 OR xerno = 1653
        * ===============================================
        *$ Report form or label form problems
        * ===============================================
        DO bad_rpt WITH xerno
        DO go_mastr
        
    CASE xerno = 55
        * ======================
        *$ Invalid .MEM file
        * ======================
        DO badmemfl
        * ==================================
        * NOTE: If info in the .MEM file is
        * necessary for the entire application
        * this should be changed so user is
        * returned to DOS
        * =================================
        DO go_mastr
        
    CASE xerno = 56
        * =========================================
        *$ Out of disk space error.  Return to DOS
        * =========================================
        STORE .F. TO printit
        DO nospace WITH printit
        
        IF printit
            * ============================
            * Send error info to printer
            * ============================
            DO to_prn
        ENDIF (printit)
        * ======================================
        *$ Quit to DOS - No attempt is
        *$ made to close databases since
        *$ the error condition may preclude it
        * ======================================
        SET CURSOR ON
        SET COLOR TO W/N
        CLEAR
        SET CLEAR OFF && Suppresses "Normal Shutdown" message
        QUIT
        
    CASE xerno = 67 OR xerno = 1309
        * ====================================
        *$ Expression evaluator fault.
        *$ Object file corrupted
        * ====================================
        DO korrupt
        DO go_mastr
        
    CASE xerno = 109 OR xerno = 130 OR xerno = 1502
        * ========================================
        *$ Record is locked by another user
        *$ Record is not locked
        *$ Record is in use: Cannot write
        *  Inform user & provide option to retry
        * ========================================
        DO rec_busy WITH tryagain
        
        IF tryagain
            * =============================
            *$ Retry for use of the record
            * =============================
            DO go_again
            GO RECNO()
            RETRY
        ELSE
            * ============================================
            *$ Abort and return to the MASTER module
            *  Information is saved to FP25EROR database
            *  to provide a log of how often LAN users can
            *  not get use of a record.  If this situation
            *  occurs frequently it may mean that a
            *  different methodology is required in the
            *  source code to prevent a high incidents of
            *  contentions.
            * ============================================
            DO go_mastr
        ENDIF (tryagain)
        
    CASE xerno = 111 OR xerno = 1718
        * ===============================================
        *$ Attempt was made to write to a read-only file
        * ===============================================
        IF ! USED("SYSDATA")
            SELECT 0
            USE sysdata NOUPDATE
        ELSE
            SELECT sysdata
        ENDIF (! USED("SYSDATA"))
        
        IF sysdata.multi_user
            * ==============================
            * If we're on a LAN call up
            * the LAN version of message
            * ==============================
            DO lreadonly
            DO go_mastr
        ELSE
            * =====================================
            * If user is working in stand-alone mode
            * =====================================
            DO readonly
            DO go_mastr
        ENDIF (sysdata.multi_user)
        
    CASE xerno = 115 OR xerno = 116 OR xerno = 117
        * =========================================
        *$ Invalid DIF file header
        *$ Invalid DIF vector/DBF field mismatch
        *$ Invalid DIF type indicator
        * =========================================
        DO bad_dif
        DO go_mastr
        
    CASE xerno = 119 OR xerno = 120 OR xerno = ;
            121 OR xerno = 1670
        * ================================================
        *$ #119 - Invalid SYLK file header
        *$ #120 - Invalid SYLK file dimension bounds
        *$ #121 - Invalid SYLK file format
        *$ #1670 - Invalid Multiplan v 4.0 format
        * ================================================
        DO bad_sylk
        DO go_mastr
        
    CASE xerno = 124
        * =============================
        *$ Invalid printer redirection
        * =============================
        DO invalprn
        DO go_mastr
        
    CASE xerno = 125
        * ===========================================
        * Printer not ready.
        * Provide user with option to retry
        * for use of printer or abort to MASTER
        * ===========================================
        DO notready WITH tryagain
        
        IF tryagain
            * =============================
            *$ Retry for use of printer
            * =============================
            DO go_again
            RETRY
        ELSE
            * ======================================
            *$ Abort and return to the MASTER module
            * ======================================
            DO go_mastr
        ENDIF (tryagain)
        
    CASE xerno = 176 OR xerno = 177
        * =======================================
        *$ Error #176 - Cannot clear menu in use
        *$ Error #177 - Cannot clear popup in use
        *
        *  Attempt was made to CLEAR or RELEASE
        *  MENU or POPUP which has not been
        *  deactivated.  Simply DEACTIVATE and
        *  RETRY the command.
        * =======================================
        IF xerno = 176
            DEACTIVATE MENU
        ELSE
            DEACTIVATE POPUP
        ENDIF (xerno = 176)
        
        DO go_again
        RETRY
        
    CASE xerno = 255 OR xerno = 256
        * ===========================================
        *$ Not a valid RapidFile or Framework II file
        * ===========================================
        DO notright WITH xerno
        DO go_mastr
        
    CASE xerno = 297 OR xerno = 1662 OR xerno = 1678
        * ======================================
        *$ Invalid Lotus 1-2-3 version X file
        * ======================================
        DO badlotus WITH xerno
        DO go_mastr
        
    CASE xerno = 392
        * ===============================================
        *$ Maximum record length exceeded in import file
        * ===============================================
        DO rec2big
        DO go_mastr
        
    CASE xerno = 800 OR xerno = 1800
        * =======================
        *$ SQL Internal Error
        * =======================
        DO sql_intl
        DO setenvmt
        DO save_it
        * =============
        *$ Quit to DOS
        * =============
        DO qquit
        
    CASE xerno = 821 OR xerno = 1821
        * ========================================
        *$ Temporary SQL file has been corrupted
        * ========================================
        DO sqltrash
        DO go_mastr
        
    CASE xerno = 830 OR xerno = 1830
        * =========================
        *$ SQL index not found
        * =========================
        DO nosqlidx
        DO go_mastr
        
    CASE xerno = 831 OR xerno = 1831
        * ==================================
        *$ SQL err building temporary index
        * ==================================
        STORE .F. TO printit
        DO sql_idx WITH printit
        
        IF printit
            * ============================
            * Send error info to printer
            * ============================
            DO to_prn
        ENDIF (printit)
        * ======================================
        *$ Quit to DOS - No attempt is
        *$ made to close databases since
        *$ the error condition may preclude it
        * ======================================
        SET CURSOR ON
        SET COLOR TO W/N
        CLEAR
        SET CLEAR OFF && Suppresses "Normal
        QUIT && Shutdown" message
        
    CASE xerno = 839 OR xerno = 1839
        * =======================================
        *$ User pressed ESC during SQL operation
        * =======================================
        STORE .F. TO kancel
        DO sqlabort WITH kancel
        
        IF kancel
            * ============================
            *$ Return to Main Menu if user
            *$ really wants to abort
            * ============================
            DO go_mastr
        ELSE
            * ============================
            *$ Otherwise retry query
            * ============================
            DO go_again
            RETRY
        ENDIF (kancel)
        
    CASE xerno = 1002
        * =================================
        *$ I/O operation failure
        *  DOS is unable to perform a file
        *  or hardware operation.
        * =================================
        DO io_failed
        DO setenvmt
        DO save_it
        * =============
        *$ Quit to DOS
        * =============
        DO qquit
        
    CASE xerno = 1003 OR xerno = ;
        1004 OR xerno = 1005 OR xerno = ;
        1006 OR xerno = 1009 OR xerno = ;
        1011 OR xerno = 1000 OR xerno = 1296
        * ==============================
        *$ Free handle not found
        *$ Use of invalid handle
        *$ Use of unallocated handle
        *$ Use of transgressed handle
        *$ Incorrect handle found during compaction
        *$ Area can not contain handle
        *$ Internal consistency error
        *$ Error reading resource
        *
        *  Advise user of memory problems
        *  and quit to DOS
        * ==============================
        DO mem_prob
        DO setenvmt
        DO save_it
        * =====================
        *$ Quit to DOS
        * =====================
        DO qquit
        
    CASE xerno = 1007 OR xerno = ;
        1008 OR xerno = 1010
        * ======================================
        *$ #1007 - Transgressed node found during compaction
        *$ #1008 - Foreign node found during compaction
        *$ #1010 - Area size exceeded during compaction
        *
        * Advise user compiled code may have been
        * corrupted and return to DOS.
        * ========================================
        DO kodekorup
        DO setenvmt
        DO save_it
        * =====================
        *$ Quit to DOS
        * =====================
        DO qquit
        
    CASE xerno = 1012
        * =========================================
        *$ OS free memory chain has been scrambled.
        *  The only solution is to return to DOS.
        * =========================================
        DO badchain
        DO setenvmt
        DO save_it
        * =============
        *$ Quit to DOS
        * =============
        DO qquit
        
    CASE xerno = 1098
        * ======================================
        *$ API function _UserError() was called
        *  There is a problem in the API library
        *  being utilized
        * ======================================
        DO bad_api
        DO go_mastr
        
    CASE xerno = 1101 OR xerno = 101
        * ====================
        *$ Cannot open file
        * ====================
        DO badrights
        DO qquit
        
    CASE xerno = 1102 OR xerno = 1157 OR xerno = ;
        1410 OR xerno = 102 OR xerno = 1160
        * ==================================
        *$ Can not create file or update file
        * ==================================
        DO nocreat
        * ============================
        *$ Send error info to printer
        * ============================
        DO to_prn
        DO qquit
        
    CASE xerno = 1104
        * =====================
        *$ File read error
        * =====================
        DO read_err WITH tryagain
        
        IF tryagain
            * =============================
            *$ Retry for use of the file
            * =============================
            DO go_again
            RETRY
        ELSE
            * =======================================
            *$ Abort and return to the MASTER module
            *  Information is saved to FP25EROR database
            * =======================================
            DO go_mastr
        ENDIF (tryagain)
        
    CASE xerno = 1105
        * ===================
        *$ File write error
        * ===================
        DO rite_err WITH tryagain
        
        IF tryagain
            * =============================
            *$ Retry for use of the file
            * =============================
            DO go_again
            RETRY
        ELSE
            * =======================================
            *$ Abort and return to the MASTER module
            *  Information is saved to FP25EROR database
            * =======================================
            DO go_mastr
        ENDIF (tryagain)
        
    CASE xerno = 1106
        * ======================================
        *$ Transaction in progress
        *  For Novell TTS only
        * ======================================
        DO transactn WITH tryagain
        
        IF tryagain
            * =============================
            *$ Retry for use of the file
            * =============================
            DO go_again
            RETRY
        ELSE
            * =======================================
            *$ Abort and return to the MASTER module
            *  Information is saved to FP25EROR database
            * =======================================
            DO go_mastr
        ENDIF (tryagain)
        
    CASE xerno = 1112
        * =====================
        *$ File close error
        * =====================
        DO badclose WITH tryagain
        
        IF tryagain
            * =============================
            *$ Try to close the file again
            * =============================
            DO go_again
            RETRY
        ELSE
            * =======================================
            *$ Abort to DOS
            *  Information is saved to FP25EROR database
            * =======================================
            DO setenvmt
            DO save_it
            DO qquit
        ENDIF (tryagain)
        
    CASE xerno = 1154 OR xerno = 1155
        * ======================================
        *$ #1154 - Invalid buffpoint call
        *$ #1155 - Invalid buffdirty call
        * =======================================
        DO mem_prob
        DO setenvmt
        DO save_it
        * =====================
        *$ Quit to DOS
        * =====================
        DO qquit
        
    CASE xerno = 1190 OR xerno = ;
        1192 OR xerno = ;
        1691 OR xerno = 1711
        * ====================================
        *$ Invalid .LIB signature
        *$ Internal .LIB undefined symbol error
        *$ Library file is invalid
        *$ API library revision mismatch.
        * =====================================
        DO bad_api
        DO go_mastr
        
    CASE xerno = 1195 OR xerno = 1309
        * ===================================
        *$ Object file is the wrong version.
        *$ <file> is not an object file
        * ===================================
        DO bad_obj
        DO go_mastr
        
    CASE xerno = 1196
        * ======================================
        *$ <file> is not a FoxPro .EXE file
        * ======================================
        DO notfoxexe
        DO go_mastr
        
    CASE xerno = 1201 OR xerno = 1308
        * =====================================
        *$ Too many names used (1201)
        *$ or stack overflow (1308)
        *  Since the NAMES table has been
        *  exhausted it will may not be
        *  possible to open the SYSDATA or
        *  FP25EROR databases to save the info
        * =====================================
        STORE .F. TO printit
        DO verbose WITH printit
        
        IF printit
            * ============================
            * Send error info to printer
            * ============================
            DO to_prn
        ENDIF (printit)
        * ===============
        *$ Quit to DOS
        * ===============
        DO qquit
        
    CASE xerno = 1294
        * ===========================
        *$ FOXUSER file is invalid
        * ===========================
        DO bad_resrc
        DO save_it
        DO qquit
        
    CASE xerno = 1405
        * ========================
        *$ RUN/! command failed
        * ========================
        DO norun
        DO go_mastr
        
    CASE xerno = 1462
        * ==================================
        *$ File internal consistence error
        *
        *  Advise user of memory problems
        *  and quit to DOS
        * ==============================
        DO mem_prob
        DO setenvmt
        DO save_it
        * =====================
        *$ Quit to DOS
        * =====================
        DO qquit
        
    CASE xerno = 1632
        * =========================================
        *$ Invalid WINDOW file format (.WIN file)
        * Advise user file has been corrupted and
        * return them to main menu
        * =========================================
        DO bad_win
        DO go_mastr
        
    CASE xerno = 1643 OR xerno = 1644
        * ========================================
        *$ Printer driver is corrupted or missing
        *  Abort & return to Master Module
        * ========================================
        DO pkorrupt
        DO go_mastr
        
    CASE xerno = 1661
        * =========================================
        *$ Invalid Excel version 2.0 file format
        * =========================================
        DO badexcel
        DO go_mastr
        
    CASE xerno = 1671 OR xerno = 1672
        * ===========================================
        *$ Cannot import from a password protected file
        *$ Cannot append from a password protected file
        * ============================================
        DO enkrypted
        DO go_mastr
        
    CASE xerno = 1673 OR xerno = 1674
        * ========================================
        *$ Invalid Symphony version X file format
        * ========================================
        DO badsymph WITH xerno
        DO go_mastr
        
    CASE xerno = 1679
        * ===========================================
        *$ Import only Worksheet A for Lotus 1-2-3
        *  version 3.0 files.
        *
        *  Inform user and provide options to
        *  continue or abort
        * ===========================================
        STORE .F. TO kontinu
        DO a_only WITH kontinu
        
        IF kontinu
            SET CONSOLE &xkonsol
            SET DEVICE TO &xdevice
            DO erorset
            RETURN
        ELSE
            DO go_mastr
        ENDIF (kontinu)
        
    CASE xerno = 1680
        * =========================================
        *$ Worksheet A for Lotus 1-2-3 v 3.0 is hidden
        * =========================================
        DO l_hide
        DO go_mastr
        
    CASE xerno = 1688
        * ===========================================
        *$ Invalid Paradox v 3.5 file format
        * ===========================================
        DO bad_pardx
        DO go_mastr
        
    CASE xerno = 1705
        * ========================================
        *$ File access denied
        *
        *  If user is on a DOS based LAN s/he
        *  is provided with option to retry for
        *  use of the file.  Otherwise, routine
        *  is aborted & return to MASTER module
        * ========================================
        IF ! USED("SYSDATA")
            SELECT 0
            USE sysdata NOUPDATE
        ELSE
            SELECT sysdata
        ENDIF (! USED("SYSDATA"))
        
        DO CASE
            CASE sysdata.multi_user AND sysdata.dos_lan
                * =========================================
                * In multi-user mode on a DOS based LAN
                * where DOS SHARE is utilized.  Provide
                * user with option to retry for use of file.
                * =========================================
                STORE .F. TO re_try
                DO dnoacces WITH re_try
                
                IF ! re_try
                    DO go_mastr
                ELSE
                    DO go_again
                    RETRY
                ENDIF (! re_try)
                
            CASE sysdata.multi_user AND ! sysdata.dos_lan
                * ============================================
                * In multi-user mode on a non-DOS based LAN
                * such as Novell 286/386, Banyan, Lan Man
                * ============================================
                DO noaccess
                DO go_mastr
                
            CASE ! sysdata.multi_user
                * ============================================
                * Working in stand-alone mode
                * ============================================
                DO snoacces
                DO go_mastr
        ENDCASE
        DO go_mastr
        
    CASE xerno = 1707
        * ================================================
        *$ Structural .CDX is missing & must be recreated
        * ================================================
        DO no_cdx
        DO setenvmt
        DO save_it
        * ==============
        *$ Quit to DOS
        * ==============
        DO qquit
        
    CASE xerno = 1709
        * =================================
        *$ Cannot load 16-bit API interface
        *  Extended edition only.  (PROAPI16
        *  not utilized in FoxPro 2.5)
        * =================================
        DO noapi
        DO qquit
        
    CASE xerno = 1715
        * ===================================
        *$ Server "<server>" not found.
        *  Server specified with SET PRINTER TO
        *  command could not be found.
        * ===================================
        DO nopserver WITH xmissing
        DO go_mastr
        
    CASE xerno = 1716
        * ================================
        *$ Queue "<queue>" not found.
        * ================================
        DO no_que WITH xmissing
        DO go_mastr
        
    CASE xerno = 1726
        * ==================================
        *$ API library not found
        *  A SET LIBRARY TO was issued but the
        *  .PLB can not be found OR a RELEASE
        *  LIBRARY command was issued and the
        *  .PLB can not be found.  An earlier
        *  IF clause checks to see if "RELEASE"
        *  was included in the command that
        *  generated the error, so we know at
        *  this point that the .PLB can not
        *  be found.  User is returned to the
        *  main menu.
        * ===================================
        DO no_plb
        DO go_mastr
        
    CASE xerno = 823 OR xerno = 1823
        * ============================================
        *$  Error 823 or 1823 is generated when a SQL
        *   open of a specific file fails.
        *   Abort & return to master
        * ==========================================
        DO nosqlopen
        DO go_mastr
        
    OTHERWISE
        DO progbug
        DO go_mastr
ENDCASE xerno
* End procedure FP25EROR



*!*****************************************************************************
*!
*!      Procedure: GO_MASTR
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: SETENVMT           (procedure in FP25EROR.PRG)
*!               : SAVE_IT            (procedure in FP25EROR.PRG)
*!               : ERORSET            (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE go_mastr
*******************************************************************************
* Save info to FP25EROR database, reset
* environmentals and return to master module
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/20/91
*
*   Modified 1/11/93 by Pat Adams
*       Use of color schemes added
*
*   Modified 4/6/93 by Pat Adams
*       IF traps added for memvars
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DO setenvmt
* ==============================
*$ Save info to FP25EROR database
* ==============================
DO save_it
DO erorset
CLEAR GETS
CLEAR READ ALL
* ==================================
*$ Release all non-public memvars
* ==================================
RELEASE ALL
RELEASE lstext, lmtext
CLEAR TYPEAHEAD

IF TYPE("CURS_SET") <> "U"
    SET CURSOR &curs_set
ENDIF

IF TYPE("scheme20") <> "U"
    SET COLOR OF SCHEME 20 TO &scheme20
ENDIF

RETURN TO MASTER
* End procedure GO_MASTR



*!*****************************************************************************
*!
*!      Procedure: SETENVMT
*!
*!      Called by: FP25EROR.PRG                      
*!               : GO_MASTR           (procedure in FP25EROR.PRG)
*!
*!          Calls: USTRING            (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE setenvmt
*******************************************************************************
*& Change full range of environmentals
*  in anticipation of a RETURN TO MASTER
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 7/24/91
*
*   Modified 1/11/93 by Pat Adams
*       Dynamic naming changed to USTRING()
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE disk_space
STORE DISKSPACE() TO disk_space
SET CONSOLE OFF
* =====================================
* Create a program tree 20 levels deep
* =====================================
FOR xx = 1 TO 20
    nextlevl = "PROGTREE" + ALLTRIM(TRANSFORM(xx, "@Z 99"))
    STORE SYS(16, xx) TO &nextlevl
    
    IF EMPTY(SYS(16,xx))
        EXIT
    ENDIF (EMPTY(SYS(16,xx)))
ENDFOR (xx)

PUBLIC lstext, lmtext
STORE ustring() + ".TXT" TO lstext
LIST STATUS TO (lstext)
* ==================================================
*$ Create files which hold information from LIST STATUS
*$ and LIST MEMORY prior to closing files, etc.
* ==================================================
STORE ustring() + ".TXT" TO lmtext
LIST MEMORY TO (lmtext)
SET CONSOLE ON
* =================================================
* Re-initialize environment for defaults prior to
* commencing any of the following activities
* =================================================
ON KEY && Null out hot keys
CLEAR GETS
CLEAR READ ALL
CLEAR FIELDS
CLEAR MACROS
CLEAR WINDOWS
DEACTIVATE MENUS
CLEAR MENUS
DEACTIVATE POPUPS
CLEAR POPUPS
CLEAR PROMPT
UNLOCK ALL
SET DEVICE TO SCREEN
CLOSE DATA
SET TALK OFF
SET ESCAPE OFF
SET CURSOR OFF
RETURN
* End procedure SETENVMT


*!*****************************************************************************
*!
*!      Procedure: SAVE_IT
*!
*!      Called by: FP25EROR.PRG                      
*!               : GO_MASTR           (procedure in FP25EROR.PRG)
*!
*!          Calls: LOGVIEW            (procedure in FP25EROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!               : FP25EROR.DBF       
*!
*!*****************************************************************************
PROCEDURE save_it
*******************************************************************************
*& Store error info to FP25EROR database
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 7/29/91
*
*   Modified by Pat Adams 9/10/91
*       Bug fix - Corrected by adding SET CONSOLE ON
*
*   Modified 1/11/93 by Pat Adams
*       Use of color schemes & SYSDTA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW moment FROM 12,29 TO 14,51 "","","", ;
    "","","","","" COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW moment
@ 0, 0 SAY REPLICATE("",21)
@ 0, 2 SAY "ONE MOMENT PLEASE"
* ==============================================
* NOTE: In a single user system running on a 386
* machine this window may flash by so rapidly that
* it can be omitted.
* ==============================================
IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))

IF sysdata.multi_user
    PRIVATE uname
    STORE GETENV("USER") TO uname
ENDIF (sysdata.multi_user)
* ==========================
*$ Store info to error file
* ==========================
IF ! USED("FP25EROR")
    SELECT 0
    USE fp25eror
ELSE
    SELECT fp25eror
ENDIF (! USED("FP25EROR"))

SET CONSOLE OFF
APPEND BLANK
REPLACE er_no WITH xerno, er_msg WITH xmsg, ;
    kode WITH xkode, mmodul WITH xmodul, ddate ;
    WITH DATE(), ttime WITH TIME(), line_no WITH xline

IF TYPE("UNAME") <> "U" .AND. ! EMPTY(uname)
    REPLACE lan_user WITH uname
ELSE
    REPLACE lan_user WITH "NOT AVAILABL"
ENDIF (TYPE("UNAME") <> "U" .AND. ! EMPTY(uname))
* ==================================================
*$ Put info from the files created with LIST MEMORY
*$ and LIST STATUS into the memo field and then
*$ erase the text files
* ==================================================
APPEND MEMO notes FROM (lstext)
ERASE (lstext)
APPEND MEMO notes FROM (lmtext)
ERASE (lmtext)
SET CONSOLE ON

IF TYPE("TESTING") <> "U"
    * =================================================
    *$ If memvar TESTING has been initialized at a higher
    *$ level provide developer/programmer with option to
    *$ view error log file now
    * =================================================
    IF testing
        DO logview
    ENDIF (testing)
ENDIF (TYPE("TESTING") <> "U")

CLOSE DATA
RELEASE WINDOW moment
RETURN
* End procedure save_it



*!*****************************************************************************
*!
*!      Procedure: NO_FILE
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE no_file
*******************************************************************************
*& Error #1 - File does not exist or can not be found
*& Error #802 & 1802 - SQL database file can not be found
*& Error #1162 - PROCEDURE can not be found
*
*     The passed parameter is the name of the missing item
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/4/91
*
*   Modified 1/11/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS not_there
not_there = UPPER(ALLTRIM(not_there))
DEFINE WINDOW bugbox FROM 5,19 TO 17,61 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,11 SAY "   BAD NEWS   " COLOR (redblink)
@ 2, 5 SAY "The following file is missing:"
@ 3, 0 SAY PADC(not_there,40)
@ 4,13 SAY "Please contact:"
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO lan_admin
@ 5, 0 SAY PADC(m_call,40)
@ 6, 0 SAY PADC(m_title,40)
@ 7, 0 SAY PADC(m_phone,40)
@ 8, 9 SAY "to report this problem."
@ 10, 1 SAY "Press any key to return " + ;
    "to main menu..." COLOR (lowtext)
DO razberry && SOUND Bronx cheer
= INKEY(0, "MH") && WAIT for keypress or mouse click
CLEAR TYPEAHEAD
RELEASE WINDOW bugbox
RETURN
* End procedure NO_FILE


*!*****************************************************************************
*!
*!      Procedure: RAZBERRY
*!
*!      Called by: XLOW_MEM           (procedure in FP25EROR.PRG)
*!               : LOW_MEM            (procedure in FP25EROR.PRG)
*!               : NO_FILE            (procedure in FP25EROR.PRG)
*!               : TOO_HIGH           (procedure in FP25EROR.PRG)
*!               : LOWFILES           (procedure in FP25EROR.PRG)
*!               : INDEX_ER           (procedure in FP25EROR.PRG)
*!               : UPMVCOUNT          (procedure in FP25EROR.PRG)
*!               : TOOBIG             (procedure in FP25EROR.PRG)
*!               : NOMEMO             (procedure in FP25EROR.PRG)
*!               : BAD_RPT            (procedure in FP25EROR.PRG)
*!               : BADMEMFL           (procedure in FP25EROR.PRG)
*!               : NOSPACE            (procedure in FP25EROR.PRG)
*!               : TO_PRN             (procedure in FP25EROR.PRG)
*!               : KORRUPT            (procedure in FP25EROR.PRG)
*!               : LREADONLY          (procedure in FP25EROR.PRG)
*!               : READONLY           (procedure in FP25EROR.PRG)
*!               : BAD_DIF            (procedure in FP25EROR.PRG)
*!               : BAD_SYLK           (procedure in FP25EROR.PRG)
*!               : INVALPRN           (procedure in FP25EROR.PRG)
*!               : NOTREADY           (procedure in FP25EROR.PRG)
*!               : NOTRIGHT           (procedure in FP25EROR.PRG)
*!               : BADLOTUS           (procedure in FP25EROR.PRG)
*!               : REC2BIG            (procedure in FP25EROR.PRG)
*!               : SQL_INTL           (procedure in FP25EROR.PRG)
*!               : SQLTRASH           (procedure in FP25EROR.PRG)
*!               : NOSQLIDX           (procedure in FP25EROR.PRG)
*!               : SQL_IDX            (procedure in FP25EROR.PRG)
*!               : SQLABORT           (procedure in FP25EROR.PRG)
*!               : IO_FAILED          (procedure in FP25EROR.PRG)
*!               : MEM_PROB           (procedure in FP25EROR.PRG)
*!               : KODEKORUP          (procedure in FP25EROR.PRG)
*!               : BADCHAIN           (procedure in FP25EROR.PRG)
*!               : BAD_API            (procedure in FP25EROR.PRG)
*!               : BADRIGHTS          (procedure in FP25EROR.PRG)
*!               : NOCREAT            (procedure in FP25EROR.PRG)
*!               : READ_ERR           (procedure in FP25EROR.PRG)
*!               : RITE_ERR           (procedure in FP25EROR.PRG)
*!               : TRANSACTN          (procedure in FP25EROR.PRG)
*!               : BADCLOSE           (procedure in FP25EROR.PRG)
*!               : BAD_OBJ            (procedure in FP25EROR.PRG)
*!               : NOTFOXEXE          (procedure in FP25EROR.PRG)
*!               : VERBOSE            (procedure in FP25EROR.PRG)
*!               : BAD_RESRC          (procedure in FP25EROR.PRG)
*!               : NORUN              (procedure in FP25EROR.PRG)
*!               : BAD_WIN            (procedure in FP25EROR.PRG)
*!               : PKORRUPT           (procedure in FP25EROR.PRG)
*!               : BADEXCEL           (procedure in FP25EROR.PRG)
*!               : ENKRYPTED          (procedure in FP25EROR.PRG)
*!               : BADSYMPH           (procedure in FP25EROR.PRG)
*!               : A_ONLY             (procedure in FP25EROR.PRG)
*!               : L_HIDE             (procedure in FP25EROR.PRG)
*!               : BAD_PARDX          (procedure in FP25EROR.PRG)
*!               : DNOACCES           (procedure in FP25EROR.PRG)
*!               : NOACCESS           (procedure in FP25EROR.PRG)
*!               : SNOACCES           (procedure in FP25EROR.PRG)
*!               : NO_CDX             (procedure in FP25EROR.PRG)
*!               : NOAPI              (procedure in FP25EROR.PRG)
*!               : NOPSERVER          (procedure in FP25EROR.PRG)
*!               : NO_QUE             (procedure in FP25EROR.PRG)
*!               : NO_PLB             (procedure in FP25EROR.PRG)
*!               : NOSQLOPEN          (procedure in FP25EROR.PRG)
*!               : PROGBUG            (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE razberry
******************************************************************************
*& Sound bell as a "raspberry" or Bronx Cheer
*
*     Author: Pat Adams, DB Unlimited
*     Date: 7/24/89
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
SET BELL TO 20,15
?? CHR(7)
SET BELL TO
* End Procedure Razberry


*!*****************************************************************************
*!
*!      Procedure: LOGVIEW
*!
*!      Called by: SAVE_IT            (procedure in FP25EROR.PRG)
*!
*!          Calls: YES_NO             (procedure in FP25EROR.PRG)
*!               : MEMOVIEW           (procedure in FP25EROR.PRG)
*!               : QQUIT              (procedure in FP25EROR.PRG)
*!               : KANCEL             (procedure in FP25EROR.PRG)
*!               : ERORSET            (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE logview
*******************************************************************************
*& View error log if user so requests
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/2/91
*
*   Modified 8/16/91 by Pat Adams
*     F2 KEY LABEL setting stored & then reinitialized
*     to original setting
*
*   Modified by Pat Adams 8/19/91
*     Existing ON KEY LABELs changed to SHIFT-Fx
*     to avoid conflicts with more commonly used
*     function keys.
*
*   Modified by Pat Adams 8/22/91
*      Use of ESC key to return to command window
*      if in interactive version of FoxPro 2.0 added
*
*   Modified by Pat Adams 12/16/91
*      Problems with cursor settings corrected
*
*   Modified 1/11/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE do_it, scheme10, cursset, sf2key, sf9key, cqkey, ;
    esckey, escstat, ttitle, clockset
STORE .F. TO do_it
STORE SET("CURSOR") TO cursset
RELEASE WINDOW moment
DEFINE WINDOW question FROM 12,12 TO 14,68 DOUBLE ;
    COLOR N/W,N/W,R+/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW question
@ 0, 1 SAY "Would you like to view the error " + ;
    "log file now?  (Y/N)"
DO yes_no WITH do_it
RELEASE WINDOW question

IF do_it
    STORE SCHEME(10) TO scheme10
    SET COLOR OF SCHEME 10 TO +W/N, N/W, +W/+R, R/W, R/W, N/W, N/W
    SET CURSOR ON
    * ==========================================
    *$ Store any ON KEY LABEL SHIFT-F2 setting
    *  and initialize for exit of BROWSE/MEMO
    * ==========================================
    STORE ON("KEY", "SHIFT-F2") TO sf2key
    ON KEY LABEL shift-f2 KEYBOARD CHR(23) && EXIT from BROWSE
    * ==========================================
    *$ Store any ON KEY LABEL SHIFT-F9 setting
    *  and initialize for exit of BROWSE/MEMO
    * ==========================================
    STORE ON("KEY", "SHIFT-F9") TO sf9key
    ON KEY LABEL shift-f9 DO memoview && OPEN window & view memo field
    * ===========================================
    *$ Store any ON KEY LABEL CTRL-Q TO cqkey
    *  and initialize for return to DOS
    * ===========================================
    STORE ON("KEY", "CTRL-Q") TO cqkey
    ON KEY LABEL ctrl-q DO qquit
    ttitle = IIF("EXE" $ VERS(1), "", " ESC for " + ;
        "COMMAND WIN, ") + "STATS=SHIFT-F9, " + ;
        "EXIT=SHIFT-F2, CTRL-Q=EXIT TO DOS"
    DEFINE WINDOW browin FROM 0,0 TO 24,79 DOUBLE ;
        COLOR W+/N,N/W, W+/R, R/W, R/W, N/W, N/W ;
        TITLE ' &ttitle ' FLOAT ZOOM GROW
    DEFINE WINDOW memwin FROM 7,0 TO 21,79 DOUBLE ;
        COLOR W+/N,N/W,R+/N,R+/N,R+/N, N/W,N/W ;
        TITLE ' PRESS SHIFT-F2 TO EXIT ' FLOAT GROW ZOOM
    STORE SET("CLOCK") TO clockset
    SET CLOCK OFF
    
    IF ! "EXE" $ VERS(1)
        * ===============================================
        *$ If working in interactive development version
        *$ provide opportunity to press ESC to return to
        *$ command window
        * ===============================================
        STORE ON("KEY", "ESC") TO esckey
        STORE SET("ESCAPE") TO escstat
        SET ESCAPE ON
        ON KEY LABEL esc DO kancel
    ENDIF (! "EXE" $ VERS(1))
    
    SET REFRESH TO 200
    BROWSE WINDOW browin
    * =========================================
    *$ Restore previous ON KEY LABEL settings
    * =========================================
    ON KEY LABEL f2 &sf2key
    ON KEY LABEL f9 &sf9key
    ON KEY LABEL ctrl-q &cqkey
    SET CLOCK &clockset
    CLEAR TYPEAHEAD
    
    IF ! "EXE" $ VERS(1)
        ON KEY LABEL esc &esckey
        SET ESCAPE &escstat
    ENDIF (! "EXE" $ VERS(1))
    
    SET REFRESH TO 0, 200
    CLEAR WINDOWS
    SET STATUS OFF
    SET COLOR OF SCHEME 10 TO &scheme10
    SET CURSOR &cursset
ENDIF (do_it)

DO erorset
RETURN
* End procedure LOGVIEW


*!*****************************************************************************
*!
*!      Procedure: MEMOVIEW
*!
*!      Called by: LOGVIEW            (procedure in FP25EROR.PRG)
*!               : MEMOVIEW           (procedure in FP25EROR.PRG)
*!
*!          Calls: MEMOVIEW           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE memoview
*******************************************************************************
*& Open large window to view memo field info in error log
*
*  Routine assumes the F2 key has been enabled at a higher
*  level to exit the window and that window MEMWIN has been
*  defined at a higher level.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/2/91
*
*   Modified 8/19/91 by Pat Adams
*       Changes made to reflect modified ON KEY LABEL usage
*
*   Modified 1/11/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*
*   Modified 3/12/93 by Pat Adams
*       SET WINDOW OF MEMO TO added to clear out
*       memo field window.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ON KEY LABEL shift-f9
SET WINDOW OF MEMO TO memwin
MODIFY MEMO notes NOEDIT
CLOSE MEMO notes
SET WINDOW OF MEMO TO
DEACTIVATE WINDOW memwin
CLEAR TYPEAHEAD
ON KEY LABEL shift-f9 DO memoview
RETURN
* End procedure MEMOVIEW



*!*****************************************************************************
*!
*!      Procedure: YES_NO
*!
*!      Called by: FILE_BUSY          (procedure in FP25EROR.PRG)
*!               : NOSPACE            (procedure in FP25EROR.PRG)
*!               : TO_PRN             (procedure in FP25EROR.PRG)
*!               : REC_BUSY           (procedure in FP25EROR.PRG)
*!               : NOTREADY           (procedure in FP25EROR.PRG)
*!               : SQL_IDX            (procedure in FP25EROR.PRG)
*!               : SQLABORT           (procedure in FP25EROR.PRG)
*!               : READ_ERR           (procedure in FP25EROR.PRG)
*!               : RITE_ERR           (procedure in FP25EROR.PRG)
*!               : TRANSACTN          (procedure in FP25EROR.PRG)
*!               : BADCLOSE           (procedure in FP25EROR.PRG)
*!               : VERBOSE            (procedure in FP25EROR.PRG)
*!               : A_ONLY             (procedure in FP25EROR.PRG)
*!               : DNOACCES           (procedure in FP25EROR.PRG)
*!               : LOGVIEW            (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE yes_no
*******************************************************************************
*& Get user response of Y or N and return
*
*   Passed parameter is a logical .T. or .F. and
*   is returned as a logical value.  This methodology
*   is utilized rather than a GET on a memvar or a lite
*   bar menu in order to avoid potential conflicts with
*   color settings and schemes.  In addition, this
*   "old fashioned" methodology avoids potential problems
*   that might arise if GETs, getless reads, nested reads,
*   etc. are in effect.
*
*   Mouse response is not permitted.  User MUST
*   respond with a Y or N.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 5/2/89
*
*   Modified by Pat Adams 12/16/91
*       Problems with cursor setting corrected.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS answer
PRIVATE kkey, cursset
STORE 0 TO kkey
STORE SET("CURSOR") TO cursset
SET CURSOR OFF

DO WHILE kkey = 0
    kkey = INKEY()
    
    IF kkey > 0
        * =============================
        * Function keys 2 thru 9 return
        * negative values.  This sets up
        * error trapping for that condition.
        * =============================
        IF CHR(kkey) $ "YyNn"
            IF CHR(kkey) $ "Yy"
                STORE .T. TO answer
            ELSE
                STORE .F. TO answer
            ENDIF (CHR(kkey) $ "Yy")
        ELSE
            STORE 0 TO kkey
        ENDIF (CHR(kkey) $ "YyNn")
    ELSE
        STORE 0 TO kkey
    ENDIF (kkey > 0)
ENDDO (kkey = 0)
* ================================
* Restore cursor to original status
* ================================
SET CURSOR &cursset)
CLEAR TYPEAHEAD
RETURN answer
* End procedure YES_NO



*!*****************************************************************************
*!
*!      Procedure: FILE_BUSY
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: NICECHIM           (procedure in FP25EROR.PRG)
*!               : YES_NO             (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE file_busy
*******************************************************************************
*$ Display window informing user required file is busy
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 7/31/91
*
*   Modified 1/4/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS re_try
DEFINE WINDOW busy FROM 8, 8 TO 15,72 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW busy NOSHOW
@ 0,22 SAY "   S O R R Y   " COLOR (redblink)
@ 2, 1 SAY "Someone else was using the file required " + ;
    "at this point."
@ 3, 1 SAY "Attempting a 'retry' may find that " + ;
    "the file is now available."
@ 5, 6 SAY "Would you like to retry for use " + ;
    "of the file?  (Y/N)"
SHOW WINDOW busy
DO nicechim
DO yes_no WITH re_try
RELEASE WINDOW busy
RETURN re_try
* End procedure FILE_BUSY



*!*****************************************************************************
*!
*!      Procedure: GO_AGAIN
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: ERORSET            (procedure in FP25EROR.PRG)
*!
*!    Other Files: &PRNT_DEVIC
*!
*!*****************************************************************************
PROCEDURE go_again
*******************************************************************************
*& Reset environment for RETRY
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/3/91
*
*   Modified 8/19/91 by Pat Adams
*       Selection of CURR_DBF (if ! EMPTY()) added before
*       execution of the RETRY upon return
*       to calling module.  Closure of FP25EROR
*       database added in the event it was used
*       since some modules which do a RETRY also
*       save data into the error log.
*
*   Modified 9/22/91
*       GO RECNO() added following SELECT (curr_dbf)
*       to make sure any changes in a record can be
*       viewed by user.
*
*   Modified 1/11/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
IF USED("SYSDATA")
    SELECT sysdata
    USE
ENDIF (USED("SYSDATA"))

IF USED("FP25EROR")
    SELECT fp25eror
    USE
ENDIF (USED("FP25EROR"))

IF ! EMPTY(curr_dbf)
    SELECT (curr_dbf)
    * =====================================
    *$ Move record pointer so user will see
    *$ any changes made by others on the LAN
    * =====================================
    GO RECNO()
ENDIF (! EMPTY(curr_dbf))

IF ! EMPTY(top_win)
    * ===================================
    * Note that EVALUATE() does not work
    * with ACTIVATE WINDOW so &macro is used
    * ===================================
    ACTIVATE WINDOW &top_win
ENDIF (! EMPTY(top_win))

SET CONSOLE &xkonsol
SET DEVICE TO &xdevice
SET PRINTER TO &prnt_devic
SET PRINT &xprint
RELEASE lstext, lmtext
DO erorset
CLEAR TYPEAHEAD
SET CURSOR &curs_set
SET COLOR OF SCHEME 20 TO (scheme20)
RETURN
* End procedure GO_AGAIN



*!*****************************************************************************
*!
*!      Procedure: ERORSET
*!
*!      Called by: FP25EROR.PRG                      
*!               : GO_MASTR           (procedure in FP25EROR.PRG)
*!               : GO_AGAIN           (procedure in FP25EROR.PRG)
*!               : LOGVIEW            (procedure in FP25EROR.PRG)
*!               : KANCEL             (procedure in FP25EROR.PRG)
*!
*!          Calls: FP25EROR.PRG
*!
*!*****************************************************************************
PROCEDURE erorset
*******************************************************************************
*& Reinitialize error set statement for FP25EROR
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 7/12/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ON ERROR DO fp25eror WITH ERROR(), MESSAGE(), ;
    MESSAGE(1), SYS(16), LINENO(), SYS(102), ;
    SYS(100), SYS(101), LASTKEY(), ALIAS(), ;
    SYS(18), SYS(5), SYS(12), SYS(6), SYS(2003), ;
    WONTOP(), SYS(2011), SYS(2018), SET("CURSOR")
RELEASE lstext, lmtext
RETURN
* End procedure ERORSET


*!*****************************************************************************
*!
*!      Procedure: NICECHIM
*!
*!      Called by: FILE_BUSY          (procedure in FP25EROR.PRG)
*!               : REC_BUSY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE nicechim
*******************************************************************************
* & Sound pleasant 3 part chime
*
*     Author: Pat Adams, DB Unlimited
*   Date: 7/24/89
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
SET BELL TO 2000,5
?? CHR(7)
SET BELL TO 2500,5
?? CHR(7)
SET BELL TO 3000,5
?? CHR(7)
SET BELL TO && RETURN BELL to normal setting
RETURN
* End Procedure NICECHIM



*!*****************************************************************************
*!
*!      Procedure: QQUIT
*!
*!      Called by: FP25EROR.PRG                      
*!               : LOGVIEW            (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE qquit
*******************************************************************************
*& Return user to DOS
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 7/7/91
*
*   Modified 1/12/93 by Pat Adams
*       SET LIBRARY TO added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
CLOSE DATA
SET CURSOR ON
SET LIBRARY TO
SET COLOR TO W/N
CLEAR
SET CLEAR OFF && Suppresses "Normal Shutdown" message
QUIT
* End procedure QQUIT



*!*****************************************************************************
*!
*!      Procedure: REC_BUSY
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: NICECHIM           (procedure in FP25EROR.PRG)
*!               : YES_NO             (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE rec_busy
*******************************************************************************
*& Display window informing user record is locked by another
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/1//91
*
*   Modified 1/11/93 by Pat Adams
*       Use of SYSDATA & color schemes added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS re_try
DEFINE WINDOW busy FROM 7,18 TO 14,61 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW busy NOSHOW
@ 0,12 SAY "   S O R R Y   " COLOR (redblink)
@ 2, 1 SAY "Someone else locked the record you need."
@ 3, 1 SAY "If you try again it may now be available."
@ 5, 6 SAY "WOULD YOU LIKE TO RETRY?  (Y/N)"
SHOW WINDOW busy
DO nicechim
DO yes_no WITH re_try
RELEASE WINDOW busy
RETURN re_try
* End procedure REC_BUSY



*!*****************************************************************************
*!
*!      Procedure: TOO_HIGH
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE too_high
*******************************************************************************
*& Error #5, "Record is out of range"
*
*   This error usually arises from the following conditions:
*
*     1.  Attempts to access a record number greater than
*         the actual number of records in the database.
*
*     2.  FoxPro has been installed with the demonstration
*         key instead of the activation key and the database
*         contains more records than permitted in the demo.
*
*     3.  An index is out of date and no longer matches
*         the database in use.
*
*   Inform user and have them call Application Administrator.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/6//91
*
*   Modified 1/4/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 2,16 TO 21,64 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,12 SAY "    W H O O P S   " COLOR (redblink)
@ 2, 2 SAY "One of the following problems has occurred:"
@ 4, 2 SAY "1.  The demo version of this product is in"
@ 5, 6 SAY "use and an attempt has been made to use"
@ 6, 6 SAY "a database which contains more records"
@ 7, 6 SAY "than permitted by the demo."
@ 9, 2 SAY "2.  One of the indexes is out of date."
@11,18 SAY "Please call"
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
@12, 0 SAY PADC(m.m_call, 46)
@13, 0 SAY PADC(m.m_title, 46)
@14, 0 SAY PADC(m.m_phone, 46)
@15,12 SAY "to report this problem."
DO razberry
@17, 1 SAY "Press any key to return " + ;
    "to Main Menu..." COLOR (lowtext)
= INKEY(0, "MH")
CLOSE DATA
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure TOO_HIGH



*!*****************************************************************************
*!
*!      Procedure: INDEX_ER
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE index_er
*******************************************************************************
*& Index error messages
*
*   Error #19 =   "Index file does not match database"  The
*                 most likely cause is that index uses fields not
*                 in the database or relies upon memvars which are
*                 not initialized.
*
*   Error #20 =   "Record is not in index"  Most likely cause is
*                 that the database structure was changed without
*                 the index being active.
*
*   Error #114 =  "Index does not match database file"  The most
*                 likely cause is corruption within the index file
*                 or in the index file header.  Do not REINDEX but,
*                 rather, recreate index with INDEX ON...TO
*
*   Error #1103 - "Illegal seek offset"
*                 This error is usually received when the index
*                 being used for a SEEK has become corrupted.
*
*   Error #1141 = Unrecognized index file revision.  Recreate index.
*                 The index file is in a format not compatible with
*                 the version of FoxPro being used.
*
*   Since application is not usable until the index problems
*   have been corrected the user will be returned to DOS at the
*   calling level.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/7//91
*
*   Modified 1/4/93 by Pat Adams
*       Error #1141 added.
*
*   Modified 1/11/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*
*   Modified 2/12/93 by Pat Adams
*       Bug fix to correction omission of creation
*       of memvars to use on whom to call.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 5,17 TO 20,62 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,13 SAY "   BAD NEWS   " COLOR (redblink)
@ 2, 1 SAY "There is a problem with the index files"
@ 3, 1 SAY "which means they will need to be recreated."
@ 4, 1 SAY "You will not be able to use the system"
@ 5, 1 SAY "until this has been completed."
@ 7,15 SAY "Please contact"
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
SHOW WINDOW bugbox
@ 8, 0 SAY PADC(m.m_call, 44)
@ 9, 0 SAY PADC(m.m_title, 44)
@10, 0 SAY PADC(m.m_phone, 44)
@11,11 SAY "to report this problem."
@13, 1 SAY "Press any key to return " + ;
    "to DOS..." COLOR (lowtext)
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure index_er



*!*****************************************************************************
*!
*!      Procedure: NO_CDX
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE no_cdx
*******************************************************************************
*& Structural .CDX file not found - Error #1707
*
*   Since application is not usable until the .CDX
*   is recreated the user will be returned to DOS at the
*   calling level.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/7//91
*
*   Modified 1/4/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 5,17 TO 20,62 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,13 SAY "   BAD NEWS   " COLOR (redblink)
@ 2, 1 SAY "The structural index associated with the"
@ 3, 1 SAY "file you need seems to be missing.  You"
@ 4, 1 SAY "will not be able to use this system until"
@ 5, 1 SAY "the problem has been corrected."
@ 7,15 SAY "Please contact"
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
@ 8, 0 SAY PADC(m.m_call, 44)
@ 9, 0 SAY PADC(m.m_title, 44)
@10, 0 SAY PADC(m.m_phone, 44)
@11,11 SAY "to report this problem."
@13, 1 SAY "Press any key to return to DOS..." COLOR (lowtext)
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure NO_CDX



*!*****************************************************************************
*!
*!      Procedure: READONLY
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE readonly
*******************************************************************************
*
*   This module is called if SYSDATA.DBF shows user
*   is working in stand-alone mode.
*
*&Error #111 -  Attempt was made to write to a read-only file
*
*   The most likely cause of this is attempting to
*   write to a file created as read-only or accessed
*   as read-only under program control.  User is in-
*   structed to call the developer because it is probably
*   a programming error.
*
*& #1718 - File is read only
*     1.  An attempt was made to write to a file whose
*         attribute is read only.  If the file is located
*         on a floppy disk the floppy may be write protected.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/7//91
*
*   Modified 1/11/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*
*   Modified 3/25/93 by Pat Adams
*       "WHOOPS" moved to center of window.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 4,15 TO 19,65 ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0, 0 SAY PADC("   W H O O P S   ", 48) COLOR (redblink)
@ 2, 1 SAY "There's a slight problem.  An attempt was made"
@ 3, 1 SAY "to write to a read-only file.  Your input can"
@ 4, 1 SAY "not be saved."
@ 6, 1 SAY "If you are putting information on a floppy disk"
@ 7, 1 SAY "check to make sure the disk is not write pro-"
@ 8, 1 SAY "tected.  Otherwise call:"
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer
@ 9, 0 SAY PADC(m.m_call, 48)
@10, 0 SAY PADC(m.m_title, 48)
@11, 0 SAY PADC(m.m_phone,48)
@13, 1 SAY "Press any key to return to " + ;
    "Main Menu..." COLOR (lowtext)
SHOW WINDOW bugbox
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure READONLY



*!*****************************************************************************
*!
*!      Procedure: PROGBUG
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE progbug
*******************************************************************************
*& Inform user a programming bug has occurred
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/7//91
*
*   Modified 1/11/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 5,23 TO 19,56 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0, 7 SAY "   BAD NEWS   " COLOR (redblink)
@ 2, 1 SAY "An error which is most likely"
@ 3, 1 SAY "a programming bug has occurred."
@ 5,10 SAY "Please call:"
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer
@ 6, 0 SAY PADC(m.m_call, 32)
@ 7, 0 SAY PADC(m_title, 32)
@ 8, 0 SAY PADC(m_phone, 32)
@ 9, 3 SAY "immediately to report this."
@11, 1 SAY "Press any key" COLOR (lowtext)
@12, 1 SAY "to return to Main Menu..." COLOR (lowtext)
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure PROGBUG


*!*****************************************************************************
*!
*!      Procedure: NOCREAT
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE nocreat
*******************************************************************************
*& Can not create file
*
*   Error #1102 = "Cannot create a [new] file"
*
*   Error #102 = "Cannot create file" <file>
*                 Memvar XMISSING provides file name
*
*   Error #1157 = "Cannot update file"
*
*   Error #1160 - Not enough disk space for file <file name>.
*
*&  Error #1410 - Unable to create temporary work file(s)
*                 (i.e., files required for SORT, INDEX,
*                 REINDEX or PACK
*
*   The situation is usually caused by one of the following:
*
*   1.  Insufficient disk space or, on a LAN, insufficient
*       directory space
*
*   2.  Attempted use of an invalid file name, including use
*       of a file name which already exists
*
*   3.  User does not have the correct LAN authorization to
*       create a file
*
*   4.  A hardware error has caused an inability to write to
*       the hard disk.
*
*   Because of the circumstances which may have created the
*   error condition error information output will be sent to
*   the printer and the user returned to DOS upon return to
*   the calling module.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/8//91
*
*   Modified 1/4/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM  3,4 TO 20,75 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,26 SAY "   BAD NEWS   " COLOR (redblink)
@ 2, 3 SAY "It's not possible to create a file which " + ;
    "is needed at this point."
@ 3, 3 SAY "This may be due to several problems, " + ;
    "one of which is insufficient"
@ 4, 3 SAY "disk space.  Because disk space may not " + ;
    "be available error infor-"
@ 5, 3 SAY "mation will be sent to the printer."
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO lan_admin
@ 7,28 SAY "Please contact"
@ 8, 0 SAY PADC(m.m_call, 70)
@ 9, 0 SAY PADC(m.m_title, 70)
@10, 0 SAY PADC(m.m_phone, 70)
@11, 6 SAY "to report this problem and provide " + ;
    "a copy of the printout."
@13, 1 SAY "Make sure your printer is turned on " + ;
    "and on-line and then press any"
@14, 1 SAY "key to begin printing the error " + ;
    "information.  You will be returned"
@15, 1 SAY "to DOS once the printing has " + ;
    "been completed."
SHOW WINDOW bugbox
DO razberry
= INKEY(0, "MH")
CLOSE DATA
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure NOCREAT


*!*****************************************************************************
*!
*!      Procedure: TO_PRN
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in FP25EROR.PRG)
*!               : YES_NO             (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE to_prn
*******************************************************************************
*& Send error info to printer
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/8//91
*
*   Modified by Pat Adams 10/1/92
*       Status of printer checked before
*       attempting to print
*
*   Modified 1/3/93 by Pat Adams
*       Use of color schemes added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE prnstatus
STORE .T. TO prnstatus

DO WHILE SYS(13) # "READY"
    STORE .F. TO prnstatus
    DO razberry
    DEFINE WINDOW noprn FROM 5,18 TO 16,62 DOUBLE;
        COLOR SCHEME 20 SHADOW
    ACTIVATE SCREEN
    ACTIVATE WINDOW noprn NOSHOW
    @ 0,11 SAY "   W H O O P S   " COLOR (redblink)
    @ 2, 3 SAY "Your printer is not ready so we can't"
    @ 3, 3 SAY "print out the necessary information."
    @ 5, 1 SAY "I'll wait while you check to see if your"
    @ 6, 1 SAY "printer is plugged in, is on-line, there"
    @ 7, 1 SAY "is paper or paper jams have been cleared."
    @ 9, 1 SAY "DO YOU WANT TO TRY TO PRINT " + ;
        "AGAIN? (Y/N)" COLOR *N/W
    SHOW WINDOW noprn
    DO yes_no WITH prnstatus
    RELEASE WINDOW noprn
    
    IF ! prnstatus OR SYS(13) = "READY"
        EXIT
    ENDIF (! prnstatus OR SYS(13) = "READY")
ENDDO (SYS(13) # "READY")

IF prnstatus OR SYS(13) = "READY"
    SET CONSOLE OFF
    LIST STATUS TO PRINT
    LIST MEMORY TO PRINT
    SET CONSOLE ON
ENDIF (prnstatus OR SYS(13) = "READY")

RETURN
* End procedure TO_PRN


*!*****************************************************************************
*!
*!      Procedure: BADRIGHTS
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE badrights
*******************************************************************************
*& Cannot open file - Error # 1101 and error #101
*
*   Assuming the name of the file has been spelled correctly and
*   the correct subdirectory has been stated, if necessary, the
*   most likely cause of this error is the user not having
*   the appropriate LAN rights.
*
*   In spite of what the FoxPro manuals may lead you to believe,
*   if the named file does not exist or if an invalid file name
*   or subdirectory has been used, Error #1 is returned, not
*   Error #1101.
*
*   User is sent to DOS after being returned to calling module.
*   Assumption is that if user does not have rights to open this
*   file user will also not have rights to open other files on
*   the LAN, therefore, no attempt is made (at the calling level)
*   to save error info to disk.  Using the same assumption, it
*   will not be possible to open the SYSDATA file to obtain info
*   on the person who should be called.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/8//91
*
*   Modified 1/4/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM  5,23 TO 15,57 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0, 7 SAY "   S O R R Y  " COLOR (redblink)
@ 2, 1 SAY "It appears you do not have the"
@ 3, 1 SAY "correct user rights on the LAN."
@ 5, 1 SAY "Please contact your LAN Admin-"
@ 6, 1 SAY "istrator to report this problem."
@ 8, 1 SAY "Press any key to quit to DOS..." COLOR (lowtext)
SHOW WINDOW bugbox
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure BADRIGHTS



*!*****************************************************************************
*!
*!      Procedure: REALBAD
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FP25EROR.PRG)
*!               : A_LERT             (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE realbad
*******************************************************************************
*& Database is trashed
*
*   Error #15 - Not a database file
*
*   This can be caused by a bad .DBF file header.
*   Error #15 can also occur is attempting to use a non-
*   .DBF file as a .DBF file.
*
*   Error # 1111 - Invalid file descriptor.
*                  FoxPro was unable to open file.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/9/91
*
*   Modified 1/4/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*
*   Modified 1/13/93 by Pat Adams
*       Error # 1111 added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 5,22 TO 18,58 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0, 6 SAY "  REALLY BAD NEWS  " COLOR (redblink)
@ 2, 1 SAY "A database file has been trashed!"
@ 4,10 SAY "Please contact"
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
@ 5, 0 SAY PADC(m.m_call, 35)
@ 6, 0 SAY PADC(m.m_title, 35)
@ 7, 0 SAY PADC(m.m_phone, 35)
@ 8, 6 SAY "to report this problem."
@10, 1 SAY "Press any key to" COLOR (lowtext)
@11, 1 SAY "return to Main Menu..." COLOR (lowtext)
DO a_lert && SOUND siren
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure REALBAD



*!*****************************************************************************
*!
*!      Procedure: A_LERT
*!
*!      Called by: REALBAD            (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE a_lert
*******************************************************************************
*& Sound loud, long warning siren
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/9/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
FOR xx = 1 TO 3
    SET BELL TO 1650-(18*xx), 3
    ?? CHR(7)
    SET BELL TO 650-(5*xx),3
    ?? CHR(7)
ENDFOR (xx)

SET BELL TO
RETURN
* End procedure a_lert


*!*****************************************************************************
*!
*!      Procedure: KORRUPT
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE korrupt
*******************************************************************************
*& Corrupted object file
*
*   Error #67 - Internal consistency error
*
*   Error #1309 - Not an object file
*
*   Compiled object file has been corrupted - Recompile
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/9/91
*
*   Modified 1/9/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 5,22 TO 18,58 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0, 9 SAY "  BAD NEWS  " COLOR (redblink)
@ 2, 1 SAY "An object file has been corrupted."
@ 4,10 SAY "Please contact"
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
@ 5, 0 SAY PADC(m.m_call, 35)
@ 6, 0 SAY PADC(m.m_title, 35)
@ 7, 0 SAY PADC(m.m_phone, 35)
@ 8, 6 SAY "to report this problem."
DO razberry
@10, 1 SAY "Press any key to" COLOR (lowtext)
@11, 1 SAY "return to Main Menu..." COLOR (lowtext)
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure KORRUPT


*!*****************************************************************************
*!
*!      Procedure: READ_ERR
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!               : YES_NO             (procedure in FP25EROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE read_err
*******************************************************************************
*  Error #1104 - File read error
*
*  The operating system returned an error to FoxPro
*  while FoxPro was attempting to read a file.  It could
*  just be a "hiccup" or there could be problems with the
*  disk, controller or LAN connection.  Provide user with
*  option to retry
*
*   Author: Pat Adams, DB Unlimited
*   Date: 8/9/91
*
*   Modified 1/7/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*       Routine also updated to differentiate
*       between multi-user and stand-alone environment.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS rretry
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone

IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))

IF sysdata.multi_user
    * ====================================
    *$ Tell user to call LAN administrator
    *  if working in a multi-user environment
    * ====================================
    DEFINE WINDOW bugbox FROM 3,14 TO 20,66 DOUBLE ;
        COLOR SCHEME 20 SHADOW
    ACTIVATE SCREEN
    ACTIVATE WINDOW bugbox NOSHOW
    @ 0,16 SAY "   BAD NEWS   " COLOR (redblink)
    @ 2, 1 SAY "Your hardware and/or operating system returned an"
    @ 3, 1 SAY "error while attempting to read a file.  It may be"
    @ 4, 1 SAY "that this was just a minor 'hiccup' or you may be"
    @ 5, 1 SAY "experiencing serious hardware problems."
    @ 7, 1 SAY "If this is the first time you have received this"
    @ 8, 1 SAY "error message try things again.  If not, your"
    @ 9, 1 SAY "hard disk, controller and LAN connections should"
    @10, 1 SAY "be checked - report the problem to:"
    SHOW WINDOW bugbox
    * ========================================
    *$ Get info on appropriate person to call
    * ========================================
    DO lan_admin
    @11, 0 SAY PADC(m.m_call, 51)
    @12, 0 SAY PADC(m.m_title, 51)
    @13, 0 SAY PADC(m.m_phone, 51)
    @15, 9 SAY "Do you want to try again?   (Y/N)"
ELSE
    * ============================================
    *$ Otherwise simply advise user of the problem
    * ============================================
    DEFINE WINDOW bugbox FROM 5,14 TO 19,66 DOUBLE ;
        COLOR SCHEME 20 SHADOW
    ACTIVATE SCREEN
    ACTIVATE WINDOW bugbox NOSHOW
    @ 0,16 SAY "   BAD NEWS   " COLOR (redblink)
    @ 2, 1 SAY "Your hardware and/or " + ;
        "operating system returned an"
    @ 3, 1 SAY "error while attempting " + ;
        "to read a file.  It may be"
    @ 4, 1 SAY "that this is just a minor 'hiccup' " + ;
        "or you may be"
    @ 5, 1 SAY "experiencing serious " + ;
        "hardware problems."
    @ 7, 1 SAY "If this is the first time " + ;
        "you have received this"
    @ 8, 1 SAY "message, try things again.  " + ;
        "However, if this"
    @ 9, 1 SAY "message continually " + ;
        "reappears your hard disk and"
    @10, 1 SAY "controller should be checked."
    @12,12 SAY "DO YOU WANT TO RETRY? (Y/N)"
    SHOW WINDOW bugbox
ENDIF (sysdata.multi_user)

DO razberry
DO yes_no WITH rretry
RELEASE WINDOW bugbox
RETURN rretry
* End procedure READ_ERR



*!*****************************************************************************
*!
*!      Procedure: RITE_ERR
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!               : YES_NO             (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE rite_err
*******************************************************************************
*& File write error - Error #1105
*
*   The most likely causes of this error are:
*
*   1.  An attempt to write to a floppy which is
*       write protected or a LAN subdirectory to
*       which the user does not have correct rights
*
*   2.  A problem with the operating system, hard disk,
*       controller, or LAN connections
*
*   3.  TMPFILES are directed to the local work node's
*       hard disk and there are errors writing these
*       files.  Often caused by loose clusters.  Run
*       CHKDSK /F to test & resolve.
*
*   User is provided with option to retry
*
*   Author: Pat Adams, DB Unlimited
*   Date: 8/9/91
*
*   Modified 1/11/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS re_try
DEFINE WINDOW bugbox FROM  3,4 TO 20,76 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,26 SAY "   BAD NEWS   " COLOR (redblink)
@ 2, 1 SAY "A problem has occurred while attempting " + ;
    "to write information to disk."
@ 3, 1 SAY "If you are attempting to write " + ;
    "to a floppy disk it may be that the"
@ 4, 1 SAY "disk is write protected.  If so, " + ;
    "unprotect the disk and try again."
@ 6, 1 SAY "If not, a 'hiccup' in the operating " + ;
    "system may have occurred.  You"
@ 7, 1 SAY "can simply try again.  However, if " + ;
    "this message continues to appear"
@ 8, 1 SAY "it may be that there is a problem " + ;
    "with the hard disk, controller,"
@ 9, 1 SAY "LAN connections or your LAN " + ;
    "authorization rights.  Please contact:"
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO lan_admin
@10, 0 SAY PADC(m.m_call, 71)
@11, 0 SAY PADC(m.m_title, 71)
@12, 0 SAY PADC(m.m_phone, 71)
@13, 1 SAY "to report this problem."
DO razberry
@15,20 SAY "Do you want to try again? (Y/N)"
DO yes_no WITH re_try
RELEASE WINDOW bugbox
RETURN re_try
* End procedure RITE_ERR


*!*****************************************************************************
*!
*!      Procedure: INVALPRN
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE invalprn
*******************************************************************************
*   Error #124 - Invalid printer redirection
*
*  This normally occurs when attempts are made to share a non-
*  sharable printer on a LAN or the path to the print device
*  has not been properly defined.
*
*  User will be returned to MASTER module.
*
*     Author: Pat Adams, DB Unlimited
*     Date: 8/9/91
*
*   Modified 1/7/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 3,17 TO 21,62 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,12 SAY "   W H O O P S   " COLOR (redblink)
@ 2, 1 SAY "An attempt was made to use an unavailable"
@ 3, 1 SAY "print device.  Either the printer you want"
@ 4, 1 SAY "is not sharable or the correct DOS PATH"
@ 5, 1 SAY "setting has not been made.  This latter"
@ 6, 1 SAY "problem can only be fixed by returning to"
@ 7, 1 SAY "DOS, correcting matters there and then"
@ 8, 1 SAY "entering this application again."
@10,15 SAY "Please contact"
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO lan_admin
@11, 0 SAY PADC(m.m_call, 43)
@12, 0 SAY PADC(m.m_title, 43)
@13, 0 SAY PADC(m.m_phone, 43)
@14,11 SAY "to report this problem."
@16, 1 SAY "Press any key to return to " + ;
    "Main Menu..." COLOR (lowtext)
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure INVALPRN



*!*****************************************************************************
*!
*!      Procedure: NOTREADY
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in FP25EROR.PRG)
*!               : YES_NO             (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE notready
*******************************************************************************
* Error #125 - Printer not ready
*
*   This error is triggered by a variety of problems:
*
*   1.  The printer is not turned on or plugged in.
*
*   2.  Printer is not on-line
*
*   3.  Printer out of paper or a paper jam has occurred
*
*   4.  The printer is timing out.  Changing the CONFIG.FP file
*       to include the statement:
*
*           TIME=10000000
*
*       and issuing a DOS command:
*
*           MODE LPT1,,p
*
*       to set up DOS for infinite retry of the printer will
*       usually help.
*
*   5.  The connection between the computer and the printer may
*       not be solid or the printer cable may be squashed.
*
*   Note that this error will occur infrequently, if at all, on a
*   LAN because output will normally be sent to a print spooler.
*
*   User is provided the option to try again for the printer or
*   Abort to the MASTER module.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/13/91
*
*   Modified 1/9/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS re_try
DEFINE WINDOW bugbox FROM 5,9 TO 18,71 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,20 SAY "   W H O O P S   " COLOR (redblink)
@ 2, 1 SAY "There is a problem with your printer.  Check the following:"
@ 4, 1 SAY "1.  Is the printer turned on?"
@ 6, 1 SAY "2.  Is the printer on-line? (A green light on the printer"
@ 7, 5 SAY "usually indicates the printer is on-line.)"
@ 9, 1 SAY "3.  Is the printer out of paper or is there a paper jam?"
@11, 2 SAY "WOULD YOU LIKE TO TRY FOR USE OF THE PRINTER AGAIN?  (Y/N)"
* ====================
*$ Sound Bronx cheer
* ====================
DO razberry
DO yes_no WITH re_try
RELEASE WINDOW bugbox
RETURN re_try
* End procedure NOTREADY



*!*****************************************************************************
*!
*!      Procedure: PKORRUPT
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE pkorrupt
*******************************************************************************
*& Error #1643 - Printer driver corrupted
** Error #1644 - Printer driver is missing
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/13/91
*
*   Modified 1/8/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 5,14 TO 18,66 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,17 SAY "  BAD NEWS  " COLOR (redblink)
@ 2, 1 SAY "Your printer driver has been corrupted.  Printing"
@ 3, 1 SAY "can not be done until this is corrected."
@ 5,18 SAY "Please contact"
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
@ 6, 0 SAY PADC(m.m_call, 50)
@ 7, 0 SAY PADC(m.m_title, 50)
@ 8, 0 SAY PADC(m.m_phone, 50)
@ 9,15 SAY "to report this problem."
@11, 1 SAY "Press any key to return " + ;
    "to Main Menu..." COLOR (lowtext)
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure PKORRUPT


*!*****************************************************************************
*!
*!      Procedure: LOWFILES
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE lowfiles
*******************************************************************************
*$ Error #6 - Too many files open
*
*   FoxPro 2.5 supports 99 open file handles in FoxPro.  A FILES=
*   statement in the FoxPro CONFIG.FP file is not necessary and, if
*   present will be ignored.  However, the following conditions
*   must be present on the computer, work node and file server:
*
*   1.  CONFIG.SYS must include the FILES= statement.  Although
*       different vendor editions of different versions of DOS
*       support a different FILES= maximum, in general DOS 3.3
*       and above supports a maximum of 250 file handles.  Usually
*       a CONFIG.SYS statement of FILES=99 is sufficient.
*
*   2.  Depending upon the LAN OS in use, the work node may need
*       a specific file handles statement for the LAN OS.  DOS
*       based LANs such as InvisibleNET and LANtastic use the DOS
*       CONFIG.SYS statement while LANs such as Novell require the
*       SHELL.CFG or NET.CFG file on each work station with a
*       FILE HANDLES=xxxx statement.  Otherwise Novell will default
*       to 40 file handles no matter what the CONFIG.SYS setting.
*       If both a NET.CFG and SHELL.CFG are present on the work node
*       the NET.CFG file settings take precedence.
*
*   3.  Novell LANs also require that the FILE HANDLES setting for
*       the SERVER be adjusted upwards.  Otherwise the default will
*       be 40 file handles and this will take precedence over any
*       settings on the work node.
*
*   4.  LANtastic needs a FILES= setting on the server that will
*       provide for sufficient file handles for all files opened
*       by the work nodes on the server as well as those opened
*       by the server in work node mode.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/13/91
*
*   Modified 1/4/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
DEFINE WINDOW bugbox FROM 1,12 TO 22,68 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
CLOSE DATA
ACTIVATE WINDOW bugbox NOSHOW
@ 0,19 SAY "  BAD NEWS  " COLOR (redblink)
@ 2, 9 SAY "You don't have enough 'file handles!'"
@ 4, 1 SAY "1.  Increase the FILES= statement in your CONFIG.SYS."
@ 6, 1 SAY "2.  If working on a Novell LAN increase the FILE"
@ 7, 5 SAY "HANDLES= statement in the SHELL.CFG file."
* =============================================
* NOTE: This message should be modified for
*       those working with a stand-alone system
* =============================================
@ 9, 1 SAY "3.  If you are attached to a Novell LAN the FILE"
@10, 5 SAY "HANDLES= statement on the LAN server may also"
@11, 5 SAY "need to be increased."
@13,19 SAY "Please contact"
SHOW WINDOW bugbox
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO lan_admin
@14, 0 SAY PADC(m.m_call, 55)
@15, 0 SAY PADC(m.m_title, 55)
@16, 0 SAY PADC(m.m_phone, 55)
@17,16 SAY "to report this problem."
@19, 1 SAY "Press any key to return " + ;
    "to Main Menu..." COLOR (lowtext)
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure LOWFILES


*!*****************************************************************************
*!
*!      Procedure: NOMEMO
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE nomemo
*******************************************************************************
*& Error #41 - MEMO file is missing/invalid
*
*   The most likely cause of this error is an attempt to
*   USE a database file whose associated memo file (either
*   .DBT or .FPT) has been erased.
*
*   Other possible causes include a trashed .DBT or .FPT file
*   or a .DBT/.FPT file which does not match the .DBF file.
*
*   User is returned to the MASTER module.  Depending upon the
*   application, it may be desirable to change this so the user
*   is returned to DOS.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/14/91
*
*   Modified 1/5/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 3,16 TO 19,63 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,15 SAY "  BAD NEWS  " COLOR (redblink)
@ 2, 1 SAY "A 'memo field' file which contains free form"
@ 3, 1 SAY "text has been erased or does not properly"
@ 4, 1 SAY "match its corresponding database file.  It's"
@ 5, 1 SAY "not possible to continue until this has been"
@ 6, 1 SAY "corrected."
@ 8,16 SAY "Please contact"
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
@ 9, 0 SAY PADC(m.m_call, 46)
@10, 0 SAY PADC(m.m_title, 46)
@11, 0 SAY PADC(m.m_phone, 46)
@12,12 SAY "to report the problem."
@14, 1 SAY "Press any key to return " + ;
    "to Main Menu..." COLOR (lowtext)
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure NOMEMO


*!*****************************************************************************
*!
*!      Procedure: BAD_RPT
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE bad_rpt
*******************************************************************************
*& Error #50 - Report file invalid
*& Error #54 - Label file invalid
*& Error #1241 - Improper data type in group expression
*& Error #1243 - Internal error: Too many characters in report
*& Error #1245 - Error in label field definition
*& Error #1246 - Total label width exceeds maximum allowable
*& Error #1645 - Report nesting error
*& Error #1646 - Total field type in report must be numeric
*& Error #1647 - Improper data type in field expression
*& Error #1653 - Label nesting error
*
*   The most likely causes of this error are:
*
*   1.  Syntax error in the REPORT FORM .FRX file
*       or the LABEL FORM file
*
*   2.  Descriptions in the REPORT or LABEL FORM file do
*       not match the database
*
*   3.  The REPORT or LABEL file has become corrupted
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/14/91
*
*   Modified 1/6/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS error_no
PRIVATE which1, which2

IF error_no = 50 OR error_no = 1241 OR error_no = 1243 ;
        OR error_no = 1645 OR error_no = 1646 OR error_no ;
        = 1647
    STORE "report" TO which1, which2
ELSE
    STORE "label" TO which1
    STORE "labels" TO which2
ENDIF (error_no = 50 OR error_no = 1241 OR error_no = 1243 ;)

DEFINE WINDOW bugbox FROM 5,19 TO 19,61 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,10 SAY "   W H O O P S  " COLOR (redblink)
@ 2, 1 SAY "There is a problem with the &which1 form"
@ 3, 1 SAY "file.  The &which2 can not be generated"
@ 4, 1 SAY "until the problem is corrected."
@ 6,13 SAY "Please contact"
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer
@ 7, 0 SAY PADC(m.m_call, 41)
@ 8, 0 SAY PADC(m.m_title, 41)
@ 9, 0 SAY PADC(m.m_phone, 41)
@10, 9 SAY "to report the problem."
@12, 1 SAY "Press any key to return to " + ;
    "Main Menu..." COLOR (lowtext)
DO razberry
=INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure BAD_RPT


*!*****************************************************************************
*!
*!      Procedure: BADMEMFL
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE badmemfl
*******************************************************************************
*& Error #55 - Memory Variable file is invalid
*
*   An attempt was made to RESTORE FROM a .MEM file
*   which has been trashed.
*
*   If info in the .MEM file is necessary to the overall
*   application change this module so user is returned to DOS.
*
*   Note that .MEM files should not be used in a LAN
*   environment because they can not be locked but can
*   be overwritten.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/14/91
*
*   Modified 1/4/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*
*   Modified 3/8/93 by Pat Adams
*       Minor bug fix - necessary memvars added.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
DEFINE WINDOW bugbox FROM 4,19 TO 19,61 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,10 SAY "   W H O O P S  " COLOR (redblink)
@ 2, 1 SAY "There is a problem with a 'memory' file"
@ 3, 1 SAY "which contains necessary information."
@ 4, 1 SAY "This option can not be used until the"
@ 5, 1 SAY "problem has been corrected."
@ 7,13 SAY "Please contact"
SHOW WINDOW bugbox
DO developer
@ 8, 0 SAY PADC(m.m_call, 41)
@ 9, 0 SAY PADC(m.m_title, 41)
@10, 0 SAY PADC(m.m_phone, 41)
@11, 9 SAY "to report the problem."
@13, 1 SAY "Press any key to return " + ;
    "to Main Menu..." COLOR (lowtext)
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure BADMEMFL



*!*****************************************************************************
*!
*!      Procedure: NOSPACE
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in FP25EROR.PRG)
*!               : YES_NO             (procedure in FP25EROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE nospace
*******************************************************************************
*& Error #56 - Not enough disk space
*
*   User has run out of disk space on a local hard disk,
*   a floppy disk, or in a LAN server subdirectory.
*
*   If user has a printer available send error output to
*   the printer.  An attempt is not made to USE the SYSDATA
*   file since this error condition may preclude such activity.
*
*   Menachem Bazian reports that the "out of disk" error has
*   been erroneously reported under both Novell 2.15C and Novell
*   3.11 at times.  This has been traced to files which have no
*   "owner" but, instead, are classified as N/A under Novell.
*   Without a Novell owner the size of a file can not be
*   increased.  Theoretically it should not be possible for a
*   file to be created under Novell without an owner, however...
*
*   Fox Software indicates they are planning an enhancement
*   to FoxPro 2.0 which will also report the disk which is
*   out of disk space.  Once this is available FP25EROR will
*   be modified to make use of this option.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/14/91
*
*   Modified 1/7/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*
*   Modified 3/8/93 by Pat Adams
*       The word "send" corrected to "sent"
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS doprint

IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))

IF sysdata.multi_user
    * ==========================================
    *$ Provide user with error info appropriate
    *$ to those using a LAN
    * ==========================================
    DEFINE WINDOW bugbox FROM 5,14 TO 17,66 DOUBLE ;
        COLOR SCHEME 20 SHADOW
    ACTIVATE SCREEN
    ACTIVATE WINDOW bugbox NOSHOW
    @ 0,14 SAY "  REALLY BAD NEWS  " COLOR (redblink)
    @ 2, 1 SAY "You have run out of space on the LAN subdirectory"
    @ 3, 1 SAY "in use, on your local hard disk or on the floppy"
    @ 4, 1 SAY "disk if you are attempting to write to a floppy."
    @ 6, 1 SAY "Information about this problem will be sent to"
    @ 7, 1 SAY "the printer before returning you to DOS.  Please"
    @ 8, 1 SAY "give a copy to your LAN administrator."
    @10, 1 SAY "Press any key to continue..." COLOR (lowtext)
    SHOW WINDOW bugbox
    DO razberry
    = INKEY(0, "MH")
    * ==================================
    * Assumption is that a printer will
    * always be available on a LAN
    * ==================================
    STORE .T. TO doprint
ELSE
    * ==========================================
    *$ Otherwise display error info appropriate
    *$ to a stand-alone system
    * ==========================================
    DEFINE WINDOW nospace FROM 6,16 TO 15,64 DOUBLE ;
        COLOR SCHEME 20 SHADOW
    ACTIVATE SCREEN
    ACTIVATE WINDOW nospace
    @ 0,12 SAY "  REALLY BAD NEWS  " COLOR (redblink)
    @ 2, 1 SAY "There is no more space on your hard disk or,"
    @ 3, 1 SAY "if you are writing to a floppy disk, on that"
    @ 4, 1 SAY "floppy disk."
    @ 6, 1 SAY "Would you like to print out error information"
    @ 7, 1 SAY "before returning to DOS?  (Y/N)"
    DO razberry
    DO yes_no WITH doprint
    
    IF doprint
        DEFINE WINDOW makesure FROM 9,10 TO 12,70 "", ;
            "","","","","","","" ;
            COLOR W+*/N,N/W,W+*/N SHADOW
        ACTIVATE SCREEN
        ACTIVATE WINDOW makesure
        @ 0, 0 SAY REPLICATE("",59)
        @ 1, 0 SAY REPLICATE("",59)
        @ 0, 2 SAY "Please make sure your printer " + ;
            "is turned on and on-line."
        @ 1,12 SAY " Press any key to begin printing..."
        = INKEY(0, "MH")
        RELEASE WINDOW makesure
    ENDIF (doprint)
ENDIF (sysdata.multi_user)

RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN doprint
* End procedure NOSPACE



*!*****************************************************************************
*!
*!      Procedure: BAD_DIF
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE bad_dif
*******************************************************************************
*& Error #115 - Invalid DIF file header
*& Error #116 - Invalid DIF vector-DBF field mismatch
*& Error #117 - Invalid DIF type indicator
*
*   The DIF file user is attempting to import may not
*   be in the DIF file format, the file may be corrupted,
*   or if APPEND FROM...DIF has been used the data elements
*   of the DIF file may not match the database in use.
*
*   Author: Pat Adams
*   Date: 8/1/91
*
*   Modified 1/6/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*
*   Modified 3/25/93 by by Pat Adams
*       Telephone number/extension SAY centered
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 4,12 TO 19,68 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,18 SAY "   S O R R Y   " COLOR (redblink)
@ 2, 1 SAY "There's a problem with the DIF " + ;
    "(VisiCalc) file you"
@ 3, 1 SAY "are attempting to import.  " + ;
    "It may not actually be a"
@ 4, 1 SAY "DIF file, the file header may " + ;
    "be corrupted, or the"
@ 5, 1 SAY "data elements may not match the " + ;
    "database file in use."
@ 7,20 SAY "Please contact"
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
@ 8, 0 SAY PADC(m.m_call, 55)
@ 9, 0 SAY PADC(m.m_title, 55)
@10, 0 SAY PADC(m.m_phone, 55)
@11,17 SAY "to report this problem."
@13, 1 SAY "Press any key to return to " + ;
    "Main Menu..." COLOR (lowtext)
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure BAD_DIF


*!*****************************************************************************
*!
*!      Procedure: BAD_SYLK
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE bad_sylk
*******************************************************************************
*& Error #119 - Invalid SYLK file header -
*    File header may have been trashed
*
*& Error #120 - Invalid SYLK dimension bounds -
*    The file being imported is indicating invalid
*    rows or columns - it is 'out of bounds'
*
*& Error #121 - Invalid SYLK file format -
*    File is not a SYLK (Multiplan) file.  It may
*    be that the file is a Multiplan 4.01 file in
*    which case the MOD option should be used.
*
*& Error #1670 - Invalid Multiplan v 4.0 file format
*    File being imported is not a v. 4.0 file or
*    has been corrupted
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/14/91
*
*   Modified 1/11/93 by Pat Adams
*     Use of color schemes added and error
*     #1670 added.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM  4,12 TO 19,68 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,18 SAY "   S O R R Y   " COLOR (redblink)
@ 2, 1 SAY "There's a problem with the Multiplan " + ;
    "SYLK file that"
@ 3, 1 SAY "is being imported.  The SYLK " + ;
    "file may be corrupted"
@ 4, 1 SAY "or it may be that the file is a " + ;
    "Multiplan 4.01 file"
@ 5, 1 SAY "which uses the MOD file structure " + ;
    "rather than SYLK."
@ 7,20 SAY "Please contact"
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
@ 8, 0 SAY PADC(m.m_call, 55)
@ 9, 0 SAY PADC(m.m_title, 55)
@10, 0 SAY PADC(m.m_phone, 55)
@11,17 SAY "to report this problem."
@13, 1 SAY "Press any key to return " + ;
    "to Main Menu..." COLOR (lowtext)
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure BAD_SYLK


*!*****************************************************************************
*!
*!      Procedure: NOTRIGHT
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE notright
*******************************************************************************
*& Error #255 - Not a valid Rapidfile database
*& Error #256 - Not a valid Framework II database\spreadsheet
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/14/91
*
*   Modified 1/5/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS error_no
PRIVATE ftype

IF error_no = 255
    ftype = "RapidFile"
ELSE
    ftype = "Framework II"
ENDIF (error_no = 255)

DEFINE WINDOW bugbox FROM 5,14 TO 18,65 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,15 SAY "   S O R R Y   " COLOR (redblink)
@ 2, 1 SAY "The file from which you are attempting to import"
@ 3, 1 SAY "data is not a valid &ftype file."
@ 5, 7 SAY "If you would like help please contact"
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
@ 6, 0 SAY PADC(m.m_call, 50)
@ 7, 0 SAY PADC(m.m_title, 50)
@ 8, 0 SAY PADC(m.m_phone, 50)
@ 9,14 SAY "to report this problem."
@11, 1 SAY "Press any key to return to " + ;
    "Main Menu..." COLOR (lowtext)
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure NOTRIGHT



*!*****************************************************************************
*!
*!      Procedure: BADLOTUS
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE badlotus
*******************************************************************************
*& Error #297 - Invalid Lotus 1-2-3 version 2.0 file format
*& Error #1662 - Invalid Lotus 1-2-3 Version 1.0 file format
*& Error #1678 - Invalid Lotus 1-2-3 version 3.0 file format
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/4/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS error_no
PRIVATE which1

DO CASE error_no
    CASE error_no = 297
        STORE "2.0" TO which1
        
    CASE error_no = 1662
        STORE "1.0" TO which1
        
    CASE error_no = 1678
        STORE "3.0" TO which1
ENDCASE error_no

DEFINE WINDOW bugbox FROM 4,12 TO 17,68 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,18 SAY "   S O R R Y   " COLOR (redblink)
@ 2, 1 SAY "The file from which you are " + ;
    "attempting to import data"
@ 3, 1 SAY "is not a valid Lotus 1-2-3 " + ;
    "version &which1 file."
@ 5, 9 SAY "If you would like help please contact"
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
@ 6, 0 SAY PADC(m.m_call, 54)
@ 7, 0 SAY PADC(m.m_title, 54)
@ 8, 0 SAY PADC(m.m_phone, 54)
@ 9,17 SAY "to report this problem."
@11, 1 SAY "Press any key to return " + ;
    "to Main Menu..." COLOR (lowtext)
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure BADLOTUS


*!*****************************************************************************
*!
*!      Procedure: BADSYMPH
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE badsymph
*******************************************************************************
*& Error #1673 - Invalid Symphony version 1.0 file format
*& Error #1674 - Invalid Symphony version 1.1 file format
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/4/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS error_no
PRIVATE which1

DO CASE error_no
    CASE error_no = 1673
        STORE "1.0" TO which1
        
    CASE error_no = 1674
        STORE "1.1" TO which1
ENDCASE error_no

DEFINE WINDOW bugbox FROM 4,12 TO 17,68 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,18 SAY "   S O R R Y   " COLOR (redblink)
@ 2, 1 SAY "The file from which you are " + ;
    "attempting to import data"
@ 3, 1 SAY "is not a valid Symphony " + ;
    "version &which1 file."
@ 5, 9 SAY "If you would like help please contact"
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
@ 6, 0 SAY PADC(m.m_call, 54)
@ 7, 0 SAY PADC(m.m_title, 54)
@ 8, 0 SAY PADC(m.m_phone, 54)
@ 9,17 SAY "to report this problem."
@11, 1 SAY "Press any key to return to Main Menu..." COLOR (lowtext)
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure BADSYMPH


*!*****************************************************************************
*!
*!      Procedure: BADEXCEL
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE badexcel
*******************************************************************************
*& Error #1661 - Invalid Excel version 2.0 file format
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/5/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 4,12 TO 17,68 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,18 SAY "   S O R R Y   " COLOR (redblink)
@ 2, 1 SAY "The file from which you are " + ;
    "attempting to import data"
@ 3, 1 SAY "is not a valid Excel " + ;
    "version 2.0 file."
@ 5, 9 SAY "If you would like help please contact"
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
@ 6, 0 SAY PADC(m.m_call, 54)
@ 7, 0 SAY PADC(m.m_title, 54)
@ 8, 0 SAY PADC(m.m_phone, 54)
@ 9,17 SAY "to report this problem."
@11, 1 SAY "Press any key to return " + ;
    "to Main Menu..." COLOR (lowtext)
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure BADEXCEL


*!*****************************************************************************
*!
*!      Procedure: SQL_INTL
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE sql_intl
*******************************************************************************
*& Error #800 & 1800 - SQL Internal Err
*
*   User is instructed to call developer and then is
*   returned to DOS since the internal SQL error may
*   disrupt memory management.  Developer should report
*   details of the problem to Fox Software Technical
*   Support
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/5/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 4,17 TO 19,63 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,12 SAY "   W H O O P S   " COLOR (redblink)
@ 2, 1 SAY "An internal SQL error has occurred.  This"
@ 3, 1 SAY "may disrupt other memory management, there-"
@ 4, 1 SAY "fore, you will be returned to DOS.  You can"
@ 5, 1 SAY "then restart the application."
@ 7,15 SAY "Please contact"
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer
@ 8, 0 SAY PADC(m.m_call, 45)
@ 9, 0 SAY PADC(m.m_title, 45)
@10, 0 SAY PADC(m.m_phone, 45)
@11, 5 SAY "immediately to report this problem."
@13, 1 SAY "Press any key to quit to " + ;
    "DOS..." COLOR (lowtext)
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
*End procedure SQL_INTL


*!*****************************************************************************
*!
*!      Procedure: SQL_IDX
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in FP25EROR.PRG)
*!               : YES_NO             (procedure in FP25EROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE sql_idx
*******************************************************************************
*& Error #831 or #1831 - SQL err building temporary index
*
*   The temporary index necessary to the SQL query
*   count not be built.  Possible causes are:
*
*   1.  Insufficient disk space on the local hard disk
*
*   2.  User may not have the necessary "rights"
*       on the LAN server
*
*   3.  Insufficient space in the LAN subdirectory
*
*   Because of the potential for insufficient disk
*   space no attempt is made to close databases or
*   save the error information except via hard copy.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/5/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*       and 2.5 error #1831 added.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS doprint

IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))

IF sysdata.multi_user
    * ================================
    * Assumption is that a LAN printer
    * will always be available
    * ================================
    DEFINE WINDOW bugbox FROM 3,7 TO 20,73 DOUBLE ;
        COLOR SCHEME 20 SHADOW
    ACTIVATE SCREEN
    ACTIVATE WINDOW bugbox
    @ 0,24 SAY "  BAD NEWS  " COLOR (redblink)
    @ 2, 1 SAY "Unable to build the temporary index " + ;
        "required for the SQL query."
    @ 3, 1 SAY "Possible causes may be:"
    @ 5, 4 SAY "a.  You have run out of disk " + ;
        "space on your local hard disk;"
    @ 7, 4 SAY "b.  You have run out of space " + ;
        "in the LAN subdirectory;"
    @ 9, 4 SAY "c.  You do not have the appropriate " + ;
        "user rights on the LAN"
    @11, 1 SAY "Information on the problem will " + ;
        "be sent to the printer.  Please"
    @12, 1 SAY "contact your LAN administrator " + ;
        "immediately and provide a copy"
    @13, 1 SAY "of the error information."
    @15, 1 SAY "Press any key to print and then " + ;
        "return to DOS..." COLOR (lowtext)
    DO razberry
    = INKEY(0, "MH")
    STORE .T. TO doprint
    USE
ELSE
    * ======================================
    *$ Otherwise provide info pertinent to
    *$ single user situation
    * ======================================
    DEFINE WINDOW bugbox FROM 7,13 TO 16,66 DOUBLE ;
        COLOR N/W,N/W,R+*/W SHADOW
    ACTIVATE SCREEN
    ACTIVATE WINDOW bugbox
    @ 0,15 SAY "  REALLY BAD NEWS  " COLOR (redblink)
    @ 2, 1 SAY "Unable to build the temporary index required for"
    @ 3, 1 SAY "the SQL query.  It is likely that you have run out"
    @ 4, 1 SAY "of disk space."
    DO razberry
    @ 6, 1 SAY "Do you have a printer available to print out error"
    @ 7, 1 SAY "information before returning to DOS?   (Y/N)"
    DO yes_no WITH doprint
    
    IF doprint
        DEFINE WINDOW makesure FROM 9,10 TO 12,70 "", ;
            "","","","","","","" ;
            COLOR W+*/N,N/W,W+*/N SHADOW
        ACTIVATE SCREEN
        ACTIVATE WINDOW makesure
        @ 0, 0 SAY REPLICATE("",59)
        @ 1, 0 SAY REPLICATE("",59)
        @ 0, 2 SAY "Please make sure your printer " + ;
            "is turned on and on-line."
        @ 1,12 SAY " Press any key to begin printing..."
        CLEAR TYPEAHEAD
        = INKEY(0, "MH")
        RELEASE WINDOW makesure
    ENDIF (doprint)
ENDIF (sysdata.multi_user)

RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN doprint
* End procedure SQL_IDX


*!*****************************************************************************
*!
*!      Procedure: SQLTRASH
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE sqltrash
*******************************************************************************
*& Error #821 - SQL invalid temporary file
*
*   The temporary file created by FoxPro for the SQL
*   query has been corrupted.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/5/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*       FoxPro 2.5 error #1821 added.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 5,18 TO 19,61 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,12 SAY "   S O R R Y   " COLOR (redblink)
@ 2, 1 SAY "The temporary file for the SQL query has"
@ 3, 1 SAY "been corrupted.  If this error recurs"
@ 4, 1 SAY "consistently please contact:"
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer
@ 6, 0 SAY PADC(m.m_call, 42)
@ 7, 0 SAY PADC(m.m_title, 42)
@ 8, 0 SAY PADC(m.m_phone, 42)
@10,10 SAY "to report the problem."
@12, 1 SAY "Press any key to return to " + ;
    "Main Menu..." COLOR (lowtext)
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure SQLTRASH


*!*****************************************************************************
*!
*!      Procedure: NOSQLIDX
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE nosqlidx
*******************************************************************************
*& Error #830 & 1830 - SQL index not found
*
*   This may be the result of an incorrect PATH setting
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/5/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*       and FoxPro 2.5 error #1830 added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE m_call, m_title, m_phone
DEFINE WINDOW bugbox FROM 5,23 TO 19,56 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0, 7 SAY "   S O R R Y   " COLOR (redblink)
@ 2, 1 SAY "Not able to find the SQL index"
@ 3, 1 SAY "required for this query."
@ 5, 9 SAY "Please contact"
SHOW WINDOW bugbox
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer
* ===========================================
* NOTE: Size of window may have to be enlarged
* if trimmed data in SYSDATA is longer than
* the BUGBOX window
* ===========================================
@ 6, 0 SAY PADC(m.m_call, 32)
@ 7, 0 SAY PADC(m.m_title, 32)
@ 8, 0 SAY PADC(m.m_phone, 32)
@ 9, 5 SAY "to report the problem."
@11, 1 SAY "Press any key to" COLOR (lowtext)
@12, 1 SAY "return to Main Menu..." COLOR (lowtext)
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure NOSQLIDX



*!*****************************************************************************
*!
*!      Procedure: SQLABORT
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in FP25EROR.PRG)
*!               : YES_NO             (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE sqlabort
*******************************************************************************
*& Error #839 & 1839 - SQL canceled operation
*
*   User pressed ESC key.  Determine if user
*   really wants to abort the query.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/5/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*       and FoxPro 2.5 error 1839 added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS a_bort
DEFINE WINDOW bugbox FROM 10,19 TO 13,60 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0, 1 SAY "You pressed the ESCape key.  Do you"
@ 1, 1 SAY "really want to cancel the query? (Y/N)"
DO razberry
DO yes_no WITH a_bort
RELEASE WINDOW bugbox
RETURN a_bort
* End procedure SQLABORT



*!*****************************************************************************
*!
*!      Procedure: BADCLOSE
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FP25EROR.PRG)
*!               : DEVELOPER          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!               : YES_NO             (procedure in FP25EROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE badclose
*******************************************************************************
*& Error #1112 - File close error
*
*   It may be that the operating system just
*   "hiccuped" or there may be a hardware problem.
*   Advise user & provide option to retry.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/4/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS re_try
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone

IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))

DEFINE WINDOW bugbox FROM 4,16 TO 20,67 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,15 SAY "   W H O O P S   " COLOR (redblink)
@ 2, 1 SAY "A problem occurred while attempting to close a"
@ 3, 1 SAY "file.  It may be that the system just didn't get"
@ 4, 1 SAY "it's coffee and was temporarily feeling grumpy."
@ 5, 1 SAY "If so, trying again will correct the problem."
@ 6, 1 SAY "However, if this message continually appears it"
@ 7, 1 SAY "may be that there is a hardware problem. In that"
@ 8, 1 SAY "case please contact:"
SHOW WINDOW bugbox
* ========================================
*$ Get info on appropriate person to call
* ========================================
IF sysdata.multi_user
    DO lan_admin
ELSE
    DO developer
ENDIF (sysdata.multi_user)

@ 9, 0 SAY PADC(m.m_call, 50)
@10, 0 SAY PADC(m.m_title, 50)
@11, 0 SAY PADC(m.m_phone, 50)
@12,14 SAY "to report the problem."
DO razberry
@14, 9 SAY "DO YOU WANT TO TRY AGAIN?  (Y/N)"
DO yes_no WITH re_try
RELEASE WINDOW bugbox
RETURN re_try
* End procedure BADCLOSE


*!*****************************************************************************
*!
*!      Procedure: VERBOSE
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in FP25EROR.PRG)
*!               : YES_NO             (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE verbose
*******************************************************************************
*$ Error #1201 - Too many names used
*
*   The FoxPro NAME TABLE "collects" the "names" used for
*   memory variables, arrays, data base files and indexes,
*   field names, procedures, etc. as they are used.  If
*   this table is exhausted the only thing that can be done
*   on an immediate basis is to return the user to DOS and
*   then restart the application.
*
*   The developer should modify the code so that memory
*   variable names, array names, window names, etc. are not
*   all unique but, rather, are used frequently in various
*   modules.  Simply use the PRIVATE statement to make sure
*   memvars and arrays do not conflict with others in use with
*   the same name at higher levels.
*
*   An example of this is the name BUGBOX used repeatedly
*   for message windows opened by FP25EROR.
*
*   Do not create procedures of the same name, however.
*
*   Because the name table is exhausted, it may not be
*   possible to open the SYSDATA and FP25EROR databases.
*   Therefore, the developer's name must be hard coded
*   in this module.
*
*$ Error #1308 - Stack overflow - expression too complex
*
*   Usually occurs because UDF's are nested too deeply or
*   the code is too recursive.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/5/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*       and error #1308 added.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS doprint
DEFINE WINDOW bugbox FROM 5,10 TO 19,70 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,19 SAY "   W H O O P S   " COLOR (redblink)
@ 2, 1 SAY "A problem has occurred that can be " + ;
    "cured temporarily by"
@ 3, 1 SAY "returning to DOS and starting this " + ;
    "application over again."
@ 5,13 SAY "It is important that you contact"
* @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
* NOTE: Developer's name is hard coded
* here for reasons stated above and must
* be changed to the appropriate name & phone #
* @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@ 6, 0 SAY PADC("Developer Name", 58)
@ 7, 0 SAY PADC("Company Name/Title", 58)
@ 8, 0 SAY PADC("Phone Number", 58)
@ 9,18 SAY "to report the problem."
DO razberry
@11,12 SAY "DO YOU HAVE A PRINTER AVAILABLE TO"
@12,12 SAY "PRINT THE ERROR INFORMATION? (Y/N)"
DO yes_no WITH doprint

IF doprint
    DEFINE WINDOW makesure FROM 9,10 TO 12,70 "", ;
        "","","","","","","" ;
        COLOR W+*/N,N/W,W+*/N SHADOW
    ACTIVATE SCREEN
    ACTIVATE WINDOW makesure
    @ 0, 0 SAY REPLICATE("",59)
    @ 1, 0 SAY REPLICATE("",59)
    @ 0, 2 SAY "Please make sure your printer " + ;
        "is turned on and on-line."
    @ 1,12 SAY " Press any key to begin printing..."
    = INKEY(0, "MH")
    CLEAR TYPEAHEAD
    RELEASE WINDOW makesure
ENDIF (doprint)

RELEASE WINDOW bugbox
RETURN doprint
* End procedure VERBOSE


*!*****************************************************************************
*!
*!      Procedure: NORUN
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE norun
*******************************************************************************
*& Error #1405 - RUN/! command failed
*
*   Either there is insufficient free memory to execute the
*   program to be run from DOS or COMMAND.COM can not be found.
*   In the latter case make sure that the DOS COMMAND.COM is
*   accessible via the DOS environmental COMSPEC=
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/5/93 by Pat Adams
*       Use of color schemes & SYSDATA added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 4,12 TO 20,67 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,18 SAY "   S O R R Y   " COLOR (redblink)
@ 2, 1 SAY "It was not possible to run a DOS program because:"
@ 4, 2 SAY "a.  Your computer does not have sufficient memory;"
@ 6, 2 SAY "b.  The DOS COMMAND.COM program could not be found."
SHOW WINDOW bugbox
@ 8,20 SAY "Please contact:"
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer
@ 9, 0 SAY PADC(m.m_call, 54)
@10, 0 SAY PADC(m.m_title, 54)
@11, 0 SAY PADC(m.m_phone, 54)
@12,16 SAY "to report this problem."
DO razberry
@14, 1 SAY "Press any key to return to " + ;
    "Main Menu..." COLOR (lowtext)
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure NORUN


*!*****************************************************************************
*!
*!      Procedure: BADCHAIN
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE badchain
******************************************************************************
*& Error #1012 - OS memory error
*
*   The DOS free memory chain has been scrambled.
*   The immediate solution is to return to DOS and
*   restart the application.
*
*   If the problem persists and/or is not cured by a
*   reboot the developer should look to the EMS memory
*   manager as the probable culprit.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/6/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*
*   Modified 3/25/93 by Pat Adams
*       INKEY() pause added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 5,14 TO 19,66 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,15 SAY "   W H O O P S   " COLOR (redblink)
@ 2, 1 SAY "Something has scrambled your computer's memory."
@ 3, 1 SAY "You will be returned to DOS and can restart the"
@ 4, 1 SAY "application.  If the problem persists try turning"
@ 5, 1 SAY "off the computer and starting it again.  If the"
@ 6, 1 SAY "problem still persists contact:"
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer
@ 8, 0 SAY PADC(m.m_call, 50)
@ 9, 0 SAY PADC(m.m_title, 50)
@10, 0 SAY PADC(m.m_phone, 50)
DO razberry
@12, 1 SAY "Press any key to return " + ;
    "to DOS..." COLOR (lowtext)
=INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure BADCHAIN



*!*****************************************************************************
*!
*!      Procedure: KANCEL
*!
*!      Called by: LOGVIEW            (procedure in FP25EROR.PRG)
*!
*!          Calls: ERORSET            (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE kancel
*******************************************************************************
*& Cancel program and return to command window
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/22/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ON KEY && Null out hot keys
CLEAR GETS
CLEAR READ ALL
CLEAR FIELDS
CLEAR MACROS
CLEAR WINDOWS
DEACTIVATE MENUS
CLEAR MENUS
DEACTIVATE POPUPS
CLEAR POPUPS
CLEAR PROMPT
SET REFRESH TO 0, 200
SET DEVICE TO SCREEN
CLOSE DATA
DO erorset
SET LIBRARY TO
* ================================================
* NOTE: Turn on/off the CLOSE PROCEDURE statement
* to suit your particular application
* ================================================
*CLOSE PROCEDURE
CLEAR MEMORY
PUBLIC testing
STORE .T. TO testing
CANCEL
* End procedure KANCEL



*!*****************************************************************************
*!
*!      Procedure: LOW_MEM
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE low_mem
*******************************************************************************
*& Error # 1282 Insufficient memory
*
*& Error #43 - Insufficient memory
*
*& Error #809 & #1809 - SQL out of memory
*
*& Error #845 & #1845 - SQL expression too complex
*               FoxPro ran out of memory when it
*               tried to expand the SELECT
*               statement to analyze it
*
*& Error #1149 - No memory for buffer
*
*& Error #1150 - No memory for file map
*
*& Error #1151 - No memory for file name
*
*& Error #1600 - Not enough memory to USE database
*
*   User will be returned to Main Menu
*
*   Close all windows and databases,
*   inform user of problem and then
*   return to the master module
*
*   NOTE: Often issuing the command:
*
*      SET LIBRARY TO
*
*   even if no .PLB libraries are loaded, will
*   reorganize fragmented memory and help resolve
*   the problem.  Issuing a SYS(12) may also help.
*
*   Author: Pat Adams, DB Unlimited
*   Date: 8/6/91
*
*   Modified: 10/1/92 by Pat Adams
*       If any of these errors triggered FP25EROR
*       this module is called before any other
*       routines or initialization of additional
*       memory variables.
*
*   Modified: 1/4/93 by Pat Adams
*       Additional errors for low memory conditions
*       in FoxPro 2.5 added. Use of color schemes
*       & SYSDATA added
*
*    Modified 4/3/93 by Pat Adams
*       Colors hard coded because memvars not
*       established at calling level due to low
*       memory conditions.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DO razberry
CLEAR WINDOWS
CLOSE DATA
* ===========================================
* NOTE: Depending upon your application,
*       simply clearing all windows and
*       closing databases may not
*       be sufficient.  You may also need
*       to release popups or menus first
* =========================================
DEFINE WINDOW bugbox FROM 5,20 TO 18,59 DOUBLE ;
    COLOR N/W, N/W, +*R/W
* =======================================
* Memvars for color schemes have not
* been initialized therefore hard coding
* of colors is required here
* =======================================
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,10 SAY "   S O R R Y   " COLOR +*R/W
@ 2, 1 SAY "You do not have enough conventional"
@ 3, 1 SAY "DOS memory to continue at this point."
@ 4, 1 SAY "You will need to reconfigure your"
@ 5, 1 SAY "computer to make more memory below"
@ 6, 1 SAY "640k available."
@ 8, 1 SAY "All databases will be closed and you"
@ 9, 1 SAY "will be returned to the main menu."
@11, 1 SAY "Press any key to continue..." COLOR +N/W
SHOW WINDOW bugbox
=INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure LOW_MEM


*!*****************************************************************************
*!
*!      Procedure: XLOW_MEM
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE xlow_mem
*******************************************************************************
*& Error # 1282 Insufficient memory
*
*& Error #43 - Insufficient memory
*
*& Error #809 & #1809 - SQL out of memory
*
*& Error #845 & #1845 - SQL expression too complex
*               FoxPro ran out of memory when it
*               tried to expand the SELECT
*               statement to analyze it
*
*& Error #1149 - No memory for buffer
*
*& Error #1150 - No memory for file map
*
*& Error #1151 - No memory for file name
*
*& Error #1600 - Not enough memory to USE database
*
*   User will be returned to Main Menu
*
*   Close all windows and databases,
*   inform user of problem and then
*   return to the master module
*
*   This procedure is called if using the
*   Extended Edition of FoxPro 2.5 DOS.  Colors
*   are hard coded because memvars for colors
*   can not be initialized at the calling level.
*
*   NOTE: Often issuing the command:
*
*      SET LIBRARY TO
*
*   even if no .PLB libraries are loaded, will
*   reorganize fragmented memory and help resolve
*   the problem.  Issuing a SYS(12) may also help.
*
*   Author: Pat Adams, DB Unlimited
*   Date: 4/6/93
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
CLEAR WINDOWS
CLOSE DATA
* ===========================================
* NOTE: Depending upon your application,
*       simply clearing all windows and
*       closing databases may not
*       be sufficient.  You may also need
*       to release popups or menus first
* =========================================
DEFINE WINDOW bugbox FROM 3,10 TO 22,69 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,19 SAY "   S O R R Y !  " COLOR R+*/W
@ 2, 1 SAY "You do not have enough memory to continue at this point."
@ 3, 1 SAY "There may be a number of different causes.  You may need"
@ 4, 1 SAY "to reconfigure your computer so more conventional DOS"
@ 5, 1 SAY "memory below 640k is available.  It's also possible that"
@ 6, 1 SAY "you do not have enough extended memory available.  Your"
@ 7, 1 SAY "computer should have at least 4 mb. of memory in total"
@ 8, 1 SAY "to run this application and you need at least 2.5 mb. of"
@ 9, 1 SAY "AVAILABLE extended memory before you start this applica-"
@10, 1 SAY "tion.  You can use the DOS MEM.EXE (MEM /C) to check"
@11, 1 SAY "your memory.  If you have a large disk cache, such as"
@12, 1 SAY "SMARTDRV, running decrease it to 256k or 512k."
@14, 1 SAY "All databases will be closed and you will be returned to"
@15, 1 SAY "the main menu."
@17, 1 SAY "Press any key to continue..." COLOR (lowtext)
DO razberry
=INKEY(0, "MH")
RELEASE WINDOW bugbox
RETURN
* End procedure XLOW_MEM





*!*****************************************************************************
*!
*!      Procedure: NOTFOXEXE
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE notfoxexe
*******************************************************************************
*& Error # 1196 - <file> is not a FoxPro .EXE file
*
*   This error would occur only when attempting to
*   DO an .EXE from the interactive version of FoxPro.
*
*   Routine assumes memvar named XMSG which contains
*   the contents of the error message has been
*   initialized at a higher level
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/7/93
* * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE the_exe, postn
STORE AT(".EXE", xmsg) TO postn
the_exe = LEFT(xmsg, postn + 4)
DEFINE WINDOW bugbox FROM 7,20 TO 16,59 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0, 1 SAY "The file you are attempting to DO"
@ 1, 0 SAY PADC("&THE_EXE", 38)
@ 2, 1 SAY "is either not a FoxPro compiled file"
@ 3, 1 SAY "or has been compiled with a different"
@ 4, 1 SAY "version of FoxPro."
@ 6, 1 SAY "Press any key to return" COLOR (lowtext)
@ 7, 1 SAY "to the command window..." COLOR (lowtext)
SHOW WINDOW bugbox
DO razberry
=INKEY(0, "MH")
RELEASE WINDOW bugbox
RETURN
* End procedure NOTFOXEXE



*!*****************************************************************************
*!
*!      Procedure: BAD_RESRC
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE bad_resrc
*******************************************************************************
*& Error # 1294 - FOXUSER file is invalid
*
*   NOTE: You may want to change this message if
*         users are working interactively with
*         FoxPro
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/7/93
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE userfile, m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer
STORE SYS(2005) TO userfile
DEFINE WINDOW bugbox FROM 5,15 TO 17,64 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,12 SAY "   B A D  N E W S   " COLOR (redblink)
@ 2, 1 SAY "Your resource file, &userfile,"
@ 3, 1 SAY "has been corrupted.  Please reinstall the file."
@ 5, 1 SAY "If you do not know how to do this contact:"
@ 6, 0 SAY PADC(m.m_call, 47)
@ 7, 0 SAY PADC(m.m_title, 47)
@ 8, 0 SAY PADC(m.m_phone, 47)
@10, 1 SAY "Press any key to quit to DOS..." COLOR (lowtext)
SHOW WINDOW bugbox
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
RETURN
* End procedure BAS_RESRC


*!*****************************************************************************
*!
*!      Procedure: DEVELOPER
*!
*!      Called by: UPMVCOUNT          (procedure in FP25EROR.PRG)
*!               : TOOBIG             (procedure in FP25EROR.PRG)
*!               : BAD_RPT            (procedure in FP25EROR.PRG)
*!               : BADMEMFL           (procedure in FP25EROR.PRG)
*!               : READONLY           (procedure in FP25EROR.PRG)
*!               : SQL_INTL           (procedure in FP25EROR.PRG)
*!               : SQLTRASH           (procedure in FP25EROR.PRG)
*!               : NOSQLIDX           (procedure in FP25EROR.PRG)
*!               : MEM_PROB           (procedure in FP25EROR.PRG)
*!               : KODEKORUP          (procedure in FP25EROR.PRG)
*!               : BADCHAIN           (procedure in FP25EROR.PRG)
*!               : BAD_API            (procedure in FP25EROR.PRG)
*!               : BADCLOSE           (procedure in FP25EROR.PRG)
*!               : BAD_OBJ            (procedure in FP25EROR.PRG)
*!               : BAD_RESRC          (procedure in FP25EROR.PRG)
*!               : NORUN              (procedure in FP25EROR.PRG)
*!               : NOAPI              (procedure in FP25EROR.PRG)
*!               : NO_PLB             (procedure in FP25EROR.PRG)
*!               : PROGBUG            (procedure in FP25EROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE developer
*******************************************************************************
*& Get info on Developer from SYSDATA database.
*
*   This module assumes that memory variables
*   M_CALL, M_TITLE and M_PHONE have been
*   initialized at the calling level.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 12/30/92
* * * * * * * * * * * * * * * * * * * * * * * * * * *
IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(sysdata.title) == "DEVELOPER"
STORE ALLTRIM(sysdata.call_who) TO m_call
STORE ALLTRIM(sysdata.other) TO m_title
STORE ALLTRIM(sysdata.phone) TO m_phone
USE
RETURN
* End procedure DEVELOPER


*!*****************************************************************************
*!
*!      Procedure: LAN_ADMIN
*!
*!      Called by: NO_FILE            (procedure in FP25EROR.PRG)
*!               : LOWFILES           (procedure in FP25EROR.PRG)
*!               : LREADONLY          (procedure in FP25EROR.PRG)
*!               : INVALPRN           (procedure in FP25EROR.PRG)
*!               : IO_FAILED          (procedure in FP25EROR.PRG)
*!               : MEM_PROB           (procedure in FP25EROR.PRG)
*!               : KODEKORUP          (procedure in FP25EROR.PRG)
*!               : NOCREAT            (procedure in FP25EROR.PRG)
*!               : READ_ERR           (procedure in FP25EROR.PRG)
*!               : RITE_ERR           (procedure in FP25EROR.PRG)
*!               : BADCLOSE           (procedure in FP25EROR.PRG)
*!               : DNOACCES           (procedure in FP25EROR.PRG)
*!               : NOACCESS           (procedure in FP25EROR.PRG)
*!               : NOPSERVER          (procedure in FP25EROR.PRG)
*!               : NO_QUE             (procedure in FP25EROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE lan_admin
*******************************************************************************
*& Get info on LAN ADMINISTRATOR from SYSDATA database
*& or if stand-alone system APP ADMINISTRATOR
*
*   This module assumes that memory variables
*   M_CALL, M_TITLE and M_PHONE have been
*   initialized at the calling level.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 12/30/92
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))
* ========================================
*$ Get info on appropriate person to call
* ========================================
IF sysdata.multi_user
    LOCATE FOR ALLTRIM(sysdata.title) == "LAN ADMINISTRATOR"
ELSE
    LOCATE FOR ALLTRIM(sysdata.title) == "APP ADMINISTRATOR"
ENDIF (sysdata.multi_user)

STORE ALLTRIM(sysdata.call_who) TO m_call
STORE ALLTRIM(sysdata.other) TO m_title
STORE ALLTRIM(sysdata.phone) TO m_phone
USE
RETURN
* End procedure LAN_ADMIN


*!*****************************************************************************
*!
*!      Procedure: APP_ADMIN
*!
*!      Called by: TOO_HIGH           (procedure in FP25EROR.PRG)
*!               : REALBAD            (procedure in FP25EROR.PRG)
*!               : INDEX_ER           (procedure in FP25EROR.PRG)
*!               : NOMEMO             (procedure in FP25EROR.PRG)
*!               : KORRUPT            (procedure in FP25EROR.PRG)
*!               : BAD_DIF            (procedure in FP25EROR.PRG)
*!               : BAD_SYLK           (procedure in FP25EROR.PRG)
*!               : NOTRIGHT           (procedure in FP25EROR.PRG)
*!               : BADLOTUS           (procedure in FP25EROR.PRG)
*!               : BAD_WIN            (procedure in FP25EROR.PRG)
*!               : PKORRUPT           (procedure in FP25EROR.PRG)
*!               : BADEXCEL           (procedure in FP25EROR.PRG)
*!               : BADSYMPH           (procedure in FP25EROR.PRG)
*!               : NO_CDX             (procedure in FP25EROR.PRG)
*!               : NO_QUE             (procedure in FP25EROR.PRG)
*!               : NOSQLOPEN          (procedure in FP25EROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE app_admin
*******************************************************************************
*& Get info on APP ADMINISTRATOR from SYSDATA database
*
*   This module assumes that memory variables
*   M_CALL, M_TITLE and M_PHONE have been
*   initialized at the calling level.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 12/30/92
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(sysdata.title) == "APP ADMINISTRATOR"
STORE ALLTRIM(sysdata.call_who) TO m_call
STORE ALLTRIM(sysdata.other) TO m_title
STORE ALLTRIM(sysdata.phone) TO m_phone
USE
RETURN
* End procedure APP_ADMIN



*!*****************************************************************************
*!
*!      Procedure: DNOACCES
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!               : YES_NO             (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE dnoacces
*******************************************************************************
* This routine is called if running on a DOS based LAN
*
*& #1705 - File access denied
*      An attempt was made to write to a file that is
*      write protected by the DOS ATTRIB command.
*
*  DOS-based LANs:
*  #1705 File is in [exclusive] use by another.
*
*      Error #3 should be returned if a file is in exclusive
*      use by someone else, however, DOS based LANs that utilize
*      DOS SHARE such as InvisibleNet and LANtastic erroneously
*      return error 1705. This also occurs with Novell's Netware
*      Lite because it utilizes SHARE.  The problem does not
*      lie with FoxPro but, rather, with SHARE.
*
*      If you are using a DOS based LAN and get frequent recurrence
*      of error # 1705 and you are sure users have the correct LAN
*      rights this may be the culprit.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/4/93
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS tryagain
DEFINE WINDOW bugbox FROM  2,7 TO 20,73 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,21 SAY "   W H O O P S !  " COLOR (redblink)
@ 2, 1 SAY "One of two problems may have occurred:"
@ 4, 4 SAY "1.  You are attempting to write to a " + ;
    "file that has been made"
@ 5, 8 SAY "read-only with the DOS ATTRIB command;"
@ 7, 4 SAY "2.  Someone else may have had exclusive " + ;
    "use of the file you"
@ 8, 8 SAY "need.  If so, it may be free now."
@10, 2 SAY "You can retry for use of " + ;
    "the file.  However, if this message"
@11, 2 SAY "continues to reappear do not " + ;
    "continue to retry. Instead call:"
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO lan_admin
@12, 0 SAY PADC(m.m_call, 64)
@13, 0 SAY PADC(m.m_title,64)
@14, 0 SAY PADC(m.m_phone, 64)
@16,19 SAY "DO YOU WANT TO RETRY? (Y/N)"
SHOW WINDOW bugbox
DO razberry
DO yes_no WITH tryagain
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN tryagain
* End procedure DNOACCES



*!*****************************************************************************
*!
*!      Procedure: NOACCESS
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE noaccess
*******************************************************************************
*
*   This routine is only called if SYSDATA indicates user
*   is running in a LAN environment and the LAN is not a
*   DOS based LAN such as InvisibleNET, LANtastic, or
*   Novell Netware Lite.
*
*$ #1705 - File access denied
*
*  Attempt has been made to write to a file that is
*  read only.  This may arise for several reasons:
*
*      1.  File is protected by the DOS
*          ATTRIB command as read only
*
*      2.  User rights have not been
*          configured properly for this
*          users LAN access.  Note that
*          a .DBF file may be opened  (for purposes
*          of reading or copying the file) with
*          read only rights on a LAN but
*          index files require both read and
*          write rights.
*
*   Author: Pat Adams, DB Unlimited
*   Date: 8/5/91
*
*   Modified 1/4/93 by Pat Adams
*       Module changed to respond only to error
*       #1705 when it occurs on a non_DOS LAN
*       such as Novell 286/386, Banyan, etc.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
DEFINE WINDOW bugbox FROM 3,18 TO 19,61 DOUBLE ;
    COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE WINDOW bugbox NOSHOW
@ 0,10 SAY "   W H O O P S   " COLOR (redblink)
@ 2, 1 SAY "One of two problems has occurred. Either"
@ 3, 1 SAY "you do not have the appropriate user"
@ 4, 1 SAY "rights on the LAN or the file you need"
@ 5, 1 SAY "has inadvertently been flagged as read"
@ 6, 1 SAY "only."
SHOW WINDOW bugbox
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO lan_admin
@ 8,14 SAY "Please call "
@ 9,0 SAY PADC(m.m_call, 42)
@ 10,0 SAY PADC(m.m_title, 42)
@ 11,0 SAY PADC(m.m_phone, 42)
@ 12,10 SAY "to report the problem."
DO razberry
@14,1 SAY "Press any key to return to " + ;
    "Main Menu..." COLOR (lowtext)
= INKEY(0, "MH")
CLEAR TYPEAHEAD
RELEASE WINDOW bugbox
RETURN
*End procedure NOACCESS




*!*****************************************************************************
*!
*!      Procedure: SNOACCES
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE snoacces
*******************************************************************************
*& Error #1705 - File access denied
*
*  Attempt has been made to write to a file that is
*  read only.   File is protected by the DOS
*  ATTRIB command as read only.
*
*  This module is called if user is working
*  in stand-alone mode.
*
*  Author: Pat Adams, DB Unlimited  (718) 469-4032
*  Date: 1/4/93
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM  8,15 TO 17,64 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,13 SAY "   W H O O P S !  " COLOR (redblink)
@ 2, 1 SAY "You are attempting to write to a file that"
@ 3, 1 SAY "is read only or to a file on a write protected"
@ 4, 1 SAY "floppy disk."
@ 6, 1 SAY "Press any key to" COLOR (lowtext)
@ 7, 1 SAY "return to the Main Menu..." COLOR (lowtext)
SHOW WINDOW bugbox
DO razberry
=INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure SNOACCES



*!*****************************************************************************
*!
*!      Procedure: NOSQLOPEN
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE nosqlopen
*******************************************************************************
*
*& #823 - SQL open of file failed
*& #1823 - SQL open of file failed
*
*   Error # 823 or # 1823 is generated when a SQL open of a
*   specified file fails.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/4/93
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM  6,19 TO 19,60 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,10 SAY "   S O R R Y !  " COLOR (redblink)
@ 2, 1 SAY "Unable to open the required SQL table."
@ 4, 1 SAY "Please call:"
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
@ 5,0 SAY PADC(m.m_call, 39)
@ 6,0 SAY PADC(m.m_title, 39)
@ 7,0 SAY PADC(m.m_phone, 39)
@ 8, 1 SAY "to report the problem."
@10, 1 SAY "Press any key to" COLOR (lowtext)
@11, 1 SAY "return to Main Menu..." COLOR (lowtext)
SHOW WINDOW bugbox
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure NOSQLOPEN



*!*****************************************************************************
*!
*!      Procedure: UPMVCOUNT
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE upmvcount
*******************************************************************************
*& #21 -  String memory variable area overflow
*& #22 -  Too many memory variables
*
*  The MVCOUNT statement in the
*  CONFIG.FP file needs to be increased.
*  Advise user & return to Main Menu
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/4/93
*
*   Modified 3/25/93 by Pat Adams
*       Colors hard coded.  Since a CLEAR MEMORY
*       is issued the memvars for colors can not
*       be utilized here.  Correction made to typo
*       in name of the M_CALL memvar.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
CLOSE DATA
CLEAR MEMORY
DEFINE WINDOW bugbox FROM 5,17 TO 18,63 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0, 0 SAY PADC("  W H O O P S !  ",44) COLOR +*R/W
@ 2, 1 SAY "We've run out of space for memory variables."
@ 3, 1 SAY "The MVCOUNT statement in your CONFIG.FP"
@ 4, 1 SAY "file needs to be increased.  If you don't"
@ 5, 1 SAY "know what this means please call:"
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer
@ 7, 0 SAY PADC(m.m_call, 44)
@ 8, 0 SAY PADC(m.m_title, 44)
@ 9, 0 SAY PADC(m.m_phone, 44)
@11, 1 SAY "Press any key to return " + ;
    "to Main Menu..." COLOR +N/W
SHOW WINDOW bugbox
DO razberry
=INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure UPMVCOUNT



*!*****************************************************************************
*!
*!      Procedure: TOOBIG
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE toobig
*******************************************************************************
*& Error # 39 - Numeric overflow (data was lost)
*
*   A methematical operation resulted in a number that
*   was too large to be stored in the field or memvar
*   in which it was supposed to be placed.
*
*   Inform user info was lost, have them call the
*   developer/programmer and return to main menu.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/4/93
*
*   Modified 3/25/93 by Pat Adams
*       Typo in name of M_CALL memvar corrected
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM  6,17 TO 19,62 ;
    DOUBLE COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,13 SAY "   BAD NEWS!   " COLOR (redblink)
@ 2, 1 SAY "The number being calculated was too large."
@ 3, 1 SAY "The information has been lost."
@ 5, 1 SAY "Please contact:"
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer
@ 6, 0 SAY PADC(m.m_call, 43)
@ 7, 0 SAY PADC(m.m_title, 43)
@ 8, 0 SAY PADC(m.m_phone, 43)
@ 9, 1 SAY "to report the problem."
@11, 1 SAY "Press any key to return " + ;
    "to the Main Menu..." COLOR (lowtext)
SHOW WINDOW bugbox
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure TOOBIG



*!*****************************************************************************
*!
*!      Procedure: LREADONLY
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE lreadonly
*******************************************************************************
*   This routine is called if the SYSDATA file shows
*   user is working in a LAN environment.
*
*&Error #111 -  Attempt was made to write to a read-only file
*
*   The most likely cause of this is attempting to
*   write to a file created as read-only or accessed
*   as read-only under program control.  User is in-
*   structed to call the developer because it is probably
*   a programming error.
*
*& #1718 - File is read only
*
*     1.  An attempt was made to write to a file whose
*         attribute is read only.  If the file is located
*         on a floppy disk the floppy may be write protected.
*
*     2.  User rights have not been
*         configured properly for this
*         users LAN access.  Note that
*         a .DBF file may be opened  (for purposes
*         of reading or copying the file) with
*         read only rights on a LAN but
*         index files require both read and
*         write rights.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/4/93
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 2,10 TO 22,69 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,20 SAY "  W H O O P S  " COLOR (redblink)
@ 2, 1 SAY "It's not possible to save your " + ;
    "information to the file."
@ 3, 1 SAY "One of several problems may be " + ;
    "causing this:"
@ 5, 4 SAY "1.  You are attempting to save " + ;
    "information to a file"
@ 6, 8 SAY "on a floppy disk that has been " + ;
    "write protected."
@ 8, 4 SAY "2.  The file is read only."
@10, 4 SAY "3.  You do not have correct " + ;
    "user rights on the LAN."
@12, 1 SAY "If #1 does not apply please contact:"
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO lan_admin
@13, 0 SAY PADC(m.m_call, 57)
@14, 0 SAY PADC(m.m_title, 57)
@15, 0 SAY PADC(m.m_phone, 57)
@16, 1 SAY "to report the problem."
@18, 1 SAY "Press any key to return " + ;
    "to Main Menu..." COLOR (lowtext)
SHOW WINDOW bugbox
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
RETURN
* End procedure LREADONLY



*!*****************************************************************************
*!
*!      Procedure: REC2BIG
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE rec2big
*******************************************************************************
*& Error #392 - Maximum record length exceeded in import file.
*
*   An attempt has been made to import a file that has a
*   record length greater than 65,000 bytes.
*
*   Advise user & return to main menu.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/4/93
*
*   Modified 3/25/93 by Pat Adams
*       LOWTEXT color added to last text line in window
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM  8,7 TO 16,73 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,23 SAY "  S O R R Y !  " COLOR (redblink)
@ 2, 1 SAY "Each individual record can not be " + ;
    "larger than 65,000 bytes."
@ 3, 1 SAY "The records in the file you " + ;
    "are attempting to import exceed"
@ 4, 1 SAY "this size limit."
@ 6, 1 SAY "Press any key to return to " + ;
    "main menu..." COLOR (lowtext)
SHOW WINDOW bugbox
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
RETURN
* End procedure REC2BIG


*!*****************************************************************************
*!
*!      Procedure: IO_FAILED
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE io_failed
*******************************************************************************
*& Error #1002 - I/O operation failure
*
*  DOS is unable to perform a file
*  or hardware operation.  Inform user
*  and return to DOS.
*
*  Different messages are provided depending
*  upon whether user is working in stand-alone
*  mode or in a LAN environment, as determined
*  by SYSDATA.DBF.
*
*  User is returned to DOS.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/5/93
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))

IF ! sysdata.multi_user
    * ===============================================
    * Message if user is working in stand-alone mode.
    * ===============================================
    DEFINE WINDOW bugbox FROM  7,14 TO 16,66 DOUBLE ;
        COLOR SCHEME 20 SHADOW
    ACTIVATE SCREEN
    ACTIVATE WINDOW bugbox NOSHOW
    @ 0,14 SAY "  REAL BAD NEWS!  " COLOR (redblink)
    @ 2, 1 SAY "A hardware failure or a DOS " + ;
        "failure has occurred!"
    @ 4, 1 SAY "If this message continues " + ;
        "to appear you should"
    @ 5, 1 SAY "have your computer checked."
    @ 7, 1 SAY "Press any key to exit " + ;
        "to DOS..." COLOR (lowtext)
    SHOW WINDOW bugbox
ELSE
    * ===============================================
    * Otherwise, if working in LAN environment call
    * the LAN administrator.
    * ===============================================
    PRIVATE m_call, m_title, m_phone
    STORE SPACE(0) TO m_call, m_title, m_phone
    * ========================================
    *$ Get info on appropriate person to call
    * ========================================
    DO lan_admin
    DEFINE WINDOW bugbox FROM 5,7 TO 17,73 DOUBLE ;
        COLOR SCHEME 20 SHADOW
    ACTIVATE SCREEN
    ACTIVATE WINDOW bugbox NOSHOW
    @ 0,21 SAY "  REAL BAD NEWS!  " COLOR (redblink)
    @ 2, 1 SAY "A hardware failure or an operating " + ;
        "system failure has occurred."
    @ 4, 0 SAY PADC("Please contact:", 64)
    @ 5, 0 SAY PADC(m.m_call, 64)
    @ 6, 0 SAY PADC(m.m_title,64)
    @ 7, 0 SAY PADC(m.m_phone, 64)
    @ 8, 0 SAY PADC("to report the problem.", 64)
    @10, 1 SAY "Press any key to exit " + ;
        "to DOS..." COLOR (lowtext)
    SHOW WINDOW bugbox
ENDIF (! sysdata.multi_user)

DO razberry
=INKEY(0, "MH")
RELEASE WINDOW bugbox
RETURN
* End procedure IO_FAILED



*!*****************************************************************************
*!
*!      Procedure: USTRING
*!
*!      Called by: SETENVMT           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE ustring
*******************************************************************************
*	Create a Unique Character String
*
*   Usage: ? USTRING()
*          Store USTRING() TO memvar
*
*   Author: Pat Adams
*   Date: 4/16/92
*   Copyright 1992 DB Unlimited
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS sendback
STORE SUBSTR(SYS(3), 4, 4) + ;
    SUBSTR(SYS(2015),7,4) TO sendback
RETURN sendback



*!*****************************************************************************
*!
*!      Procedure: MEM_PROB
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FP25EROR.PRG)
*!               : DEVELOPER          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE mem_prob
*******************************************************************************
*& #1003 - Free handle not found
*& #1004 - Use of invalid handle
*& #1005 - Use of unallocated handle
*& #1006 - Use of transgressed handle
*& #1009 - Incorrect handle found during compaction
*& #1011 - Area can not contain handle
*& #1000 - Internal consistency error
*& #1296 - Error reading resource.  (Internal
*            FoxPro error)
*& #1462 - File internal consistency error
*
*   Advise user a memory problem has
*   occurred and return to DOS.  The FoxPro
*   docs request that Microsoft be called if
*   these problems occur.
*
*   Note that it is possible that error #1006
*   may result from a corrupted index file.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/8/93
*
*   Modified 3/25/93 by Pat Adams
*       Correction to typo in MULTI_USER made
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
CLOSE DATA
CLEAR WINDOWS
SELECT 0
USE sysdata NOUPDATE

IF sysdata.multi_user
    DO lan_admin
ELSE
    DO developer
ENDIF (sysdata.multi_user)

DEFINE WINDOW bugbox FROM 7,10 TO 19,69 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,19 SAY "   S O R R Y !   " COLOR (redblink)
@ 2, 1 SAY "A memory management error " + ;
    "has occurred.  Please contact:"
@ 4, 0 SAY PADC(m.m_call, 57)
@ 5, 0 SAY PADC(m.m_title, 57)
@ 6, 0 SAY PADC(m.m_phone, 57)
@ 8, 1 SAY "to report the problem."
@ 10, 1 SAY "Press any key to return to DOS..." COLOR (lowtext)
SHOW WINDOW bugbox
DO razberry
=INKEY(0, "MH")
RELEASE WINDOW bugbox
RETURN
* End procedure MEM_PROB




*!*****************************************************************************
*!
*!      Procedure: KODEKORUP
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FP25EROR.PRG)
*!               : DEVELOPER          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE kodekorup
*******************************************************************************
*& #1007 - Transgressed node found during compaction
*& #1008 - Foreign node found during compaction
*& #1010 - Area size exceeded during compaction
*
*   The most likely causes of these errors is that
*   the compiled code has become corrupted or FoxPro
*   itself has become corrupted.  Advise user and
*   return to DOS.
*
*   Note that the message only informs the user that
*   the compiled code may have become corrupted.
*   This is because FP25EROR is aimed primarily at
*   handling errors in running applications.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/8/93
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
CLOSE DATA
USE sysdata NOUPDATE
CLEAR WINDOWS
CLEAR

IF sysdata.multi_user
    * ===============================
    * If in multi-user mode call
    * LAN administrator
    * ===============================
    DO lan_admin
ELSE
    * ===============================
    * Otherwise call developer
    * ===============================
    DO developer
ENDIF (sysdata.multi_user)

DEFINE WINDOW bugbox FROM 5,20 TO 19,59 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,12 SAY "  WHOOPS!  " COLOR (redblink)
@ 2, 1 SAY "It appears that your source code may"
@ 3, 1 SAY "have become corrupted.  We can not"
@ 4, 1 SAY "continue.  Please contact:"
@ 6, 0 SAY PADC(m.m_call, 37)
@ 7, 0 SAY PADC(m.m_title, 37)
@ 8, 0 SAY PADC(m.m_phone, 37)
@10, 1 SAY "to report the problem."
@12, 1 SAY "Press any key to " + ;
    "return to DOS..." COLOR (lowtext)
SHOW WINDOW bugbox
DO razberry
=INKEY(0, "MH")
RELEASE WINDOW bugbox
RETURN
* End procedure KODEKORUP



*!*****************************************************************************
*!
*!      Procedure: BAD_API
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE bad_api
*******************************************************************************
*& Error #1098 - API function _UserError() was called.
*   There is a problem with the API library being
*   used that resuled in the _UserError being called.
*   The error # returned by _UserError will provide
*   more detailed information on the error in the .PLB.
*
*& Error #1190 - Invalid .LIB signature
*& Error #1192 - Internal .LIB undefined symbol error
*& Error #1691 - Library file is invalid
*& Error #1711 - API library revision mismatch.
*
*   The SET LIBRARY TO command is utilized to remove
*   all .PLBs from memory and user is returned to
*   the main menu or master module.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/8/93
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
SET LIBRARY TO
* ==========================
*$ Get info on person to call
* ==========================
DO developer
DEFINE WINDOW bugbox FROM 6,16 TO 18,63 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,15 SAY "   SORRY!   " COLOR (redblink)
@ 2, 1 SAY "There seems to be a problem with an add-"
@ 3, 1 SAY "in library being used.  Please contact:"
@ 5, 0 SAY PADC(m.m_call, 45)
@ 6, 0 SAY PADC(m.m_title, 45)
@ 7, 0 SAY PADC(m.m_phone, 45)
@ 9, 1 SAY "Press any key to" COLOR (lowtext)
@10, 1 SAY "return to the main menu..." COLOR (lowtext)
SHOW WINDOW bugbox
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
RETURN
* End procedure BAD_API



*!*****************************************************************************
*!
*!      Procedure: TRANSACTN
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in FP25EROR.PRG)
*!               : YES_NO             (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE transactn
*******************************************************************************
*& #1106 - Transaction in progress
*
*   Another user in the midst of a Novell transaction
*   that involves database records, indexes or memo
*   fields needed at this point.  Advise user and
*   provide option to retry.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/8/93
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS re_try
DEFINE WINDOW bugbox FROM 7,15 TO 16,65 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,14 SAY "   S O R R Y !   " COLOR (redblink)
@ 2, 1 SAY "Another user was in the midst of a transaction"
@ 3, 1 SAY "involving data you required.  If you retry the"
@ 4, 1 SAY "transaction may be completed by now and the"
@ 5, 1 SAY "data available."
@ 7, 9 SAY "WOULD YOU LIKE TO RETRY? (Y/N)" COLOR *N/W
SHOW WINDOW bugbox
DO razberry
DO yes_no WITH re_try
RELEASE WINDOW bugbox
RETURN re_try
* End procedure TRANSACTN



*!*****************************************************************************
*!
*!      Procedure: BAD_OBJ
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE bad_obj
*******************************************************************************
*& Error #1195 - Object file is the wrong version
*
*   This message will occur if running the
*   interactive version of FoxPro and the
*   source code can not be found.
*
*& Error #1309 - File is not an object file
*
*   Object file has most likely become corrupted.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/8/93
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
DEFINE WINDOW bugbox FROM  6,16 TO 17,64 ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
DO developer
ACTIVATE WINDOW bugbox NOSHOW
@ 0,15 SAY "   SORRY!   " COLOR (redblink)
@ 2, 1 SAY "Your source code has been compiled with a"
@ 3, 1 SAY "different version of FoxPro.  Please contact:"
* ======================================
*& Instruct user to call developer
* ======================================
@ 5, 0 SAY PADC(m.m_call, 45)
@ 6, 0 SAY PADC(m.m_title, 45)
@ 7, 0 SAY PADC(m.m_phone, 45)
@ 9, 1 SAY "Press any key to " + ;
    "return to Main Menu..." COLOR (lowtext)
SHOW WINDOW bugbox
DO razberry
=INKEY(0, "MH")
RELEASE WINDOW bugbox
RETURN
* End procedure BAD_OBJ



*!*****************************************************************************
*!
*!      Procedure: BAD_WIN
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE bad_win
*******************************************************************************
*& #1632 - Invalid window format
*          .WIN file has become corrupted
*
*   Advise user and return to Main Menu
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/11/93
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
DEFINE WINDOW bugbox FROM 5,20 TO 19,60 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
* ================================
* Get info on app administrator
* from SYSDATA.DBF
* ================================
DO app_admin
ACTIVATE WINDOW bugbox NOSHOW
@ 0,11 SAY "   SORRY!   " COLOR (redblink)
@ 2, 1 SAY "A required file has become corrupted."
@ 3, 1 SAY "This means we are unable to continue."
@ 5, 1 SAY "Please contact:"
@ 6, 0 SAY PADC(m.m_call, 38)
@ 7, 0 SAY PADC(m.m_title, 38)
@ 8, 0 SAY PADC(m.m_phone, 38)
@ 9, 1 SAY "to report the problem."
@11, 1 SAY "Press any key to" COLOR (lowtext)
@12, 1 SAY "return to Main Menu..." COLOR (lowtext)
SHOW WINDOW bugbox
DO razberry
=INKEY(0, "MH")
RELEASE WINDOW bugbox
RETURN
* End procedure bad_win



*!*****************************************************************************
*!
*!      Procedure: ENKRYPTED
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE enkrypted
*******************************************************************************
*& #1671 - Cannot import from password protected file
*& #1672 - Cannot append from password protected file
*
*   Inform user and return to main menu (master module)
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/11/93
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 6,20 TO 16,60 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,11 SAY "   WHOOPS!   " COLOR (redblink)
@ 2, 1 SAY "You are attempting to import or add"
@ 3, 1 SAY "data from a password protected or"
@ 4, 1 SAY "encrypted file.  The file must first"
@ 5, 1 SAY "be unprotected."
@ 7, 1 SAY "Press any key to" COLOR (lowtext)
@ 8, 1 SAY "return to Main Menu..." COLOR (lowtext)
SHOW WINDOW bugbox
DO razberry
=INKEY(0, "MH")
RELEASE WINDOW bugbox
RETURN
* End procedure enkrypted



*!*****************************************************************************
*!
*!      Procedure: A_ONLY
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in FP25EROR.PRG)
*!               : YES_NO             (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE a_only
*******************************************************************************
*& #1679 - Import only Worksheet A for Lotus 1-2-3
*          version 3.0 files
*
*          Worksheets B and C can not be imported
*          because a table is two-dimensional.
*
*   Inform user and provide the option to continue
*   with import or abandon the import.
*
*   The passed parameter, GO_ON, is a logical memvar
*   returned to the calling module.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/11/93
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS go_on
DEFINE WINDOW bugbox FROM 6,19 TO 16,60 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,12 SAY "   WHOOPS!   " COLOR (redblink)
@ 2, 1 SAY "It's only possible to import the first"
@ 3, 1 SAY "Lotus worksheet.  The others can not"
@ 4, 1 SAY "be imported because a table is two"
@ 5, 1 SAY "dimensional."
@ 7, 9 SAY "DO YOU WANT TO CONTINUE"
@ 8, 9 SAY "WITH THE IMPORT?  (Y/N)"
SHOW WINDOW bugbox
DO razberry
DO yes_no WITH go_on
RELEASE WINDOW bugbox
RETURN go_on
* End procedure A_ONLY



*!*****************************************************************************
*!
*!      Procedure: L_HIDE
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE l_hide
*******************************************************************************
*& #1680 - Worksheet for Lotus 1-2-3 v 3.0
*          file is hidden.  FoxPro can not
*          import a hidden worksheet.
*
*   Inform user and return to main menu (master)
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/11/93
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 6,17 TO 15,63 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,14 SAY "   SORRY!   " COLOR (redblink)
@ 2, 1 SAY "The Lotus spreadsheet you are attempting to"
@ 3, 1 SAY "import is hidden.  It can not be imported"
@ 4, 1 SAY "until it has been unhidden."
@ 6, 1 SAY "Press any key to" COLOR (lowtext)
@ 7, 1 SAY "return to Main Menu..." COLOR (lowtext)
SHOW WINDOW bugbox
DO razberry
=INKEY(0, "MH")
RELEASE WINDOW bugbox
RETURN
* End procedure L_HIDE



*!*****************************************************************************
*!
*!      Procedure: BAD_PARDX
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE bad_pardx
*******************************************************************************
*& #1688 - Invalid Paradox v 3.5 file
*
*   File being imported is not a version 3.5
*   Paradox file or else it has become corrupted.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/11/93
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 7,14 TO 16,66 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,18 SAY "   SORRY!  " COLOR (redblink)
@ 2, 1 SAY "Either the file you are trying to import is not a"
@ 3, 1 SAY "Paradox 3.5 file or else it has been corrupted."
@ 4, 1 SAY "Unable to continue with the import."
@ 6, 1 SAY "Press any key to" COLOR (lowtext)
@ 7, 1 SAY "return to Main Menu..." COLOR (lowtext)
SHOW WINDOW bugbox
DO razberry
=INKEY(0, "MH")
RELEASE WINDOW bugbox
RETURN
* End procedure BAD_PARDX



*!*****************************************************************************
*!
*!      Procedure: NOAPI
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE noapi
*******************************************************************************
*& #1709 - Cannot load 16-bit API interface
*
*   The most likely cause is that the FOXPROX.EXE
*   file has become corrupted or the .EXE compiled
*   application has become corrupted.  Inform user
*   and quit to DOS.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/11/93
*
*   Modified 3/25/93 by Pat Adams
*       Corrected bug in ATC() statement
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone

IF ATC("LIBRARY", VERS(1)) > 0
    * ==============================================
    * User is running an .EXE complied application
    * ==============================================
    DO developer
    DEFINE WINDOW bugbox FROM 7,10 TO 18,69 DOUBLE ;
        COLOR SCHEME 20 SHADOW
    ACTIVATE SCREEN
    ACTIVATE WINDOW bugbox NOSHOW
    @ 0,20 SAY "   BAD NEWS!   " COLOR (redblink)
    @ 2, 1 SAY "It appears that your software " + ;
        "may have become corrupted."
    @ 3, 1 SAY "If you have a back-up copy " + ;
        "please reinstall it.  If not,"
    @ 4, 1 SAY "contact:"
    @ 5, 0 SAY PADC(m.m_call, 57)
    @ 6, 0 SAY PADC(m.m_title, 57)
    @ 7, 0 SAY PADC(m.m_phone, 57)
    @ 9, 1 SAY "Press any key to " + ;
        "quit to DOS..." COLOR (lowtext)
ELSE
    * ==============================================
    * User is running interactive FoxPro
    * ==============================================
    DEFINE WINDOW bugbox FROM 8,16 TO 16,63 DOUBLE ;
        COLOR SCHEME 20 SHADOW
    ACTIVATE SCREEN
    ACTIVATE WINDOW bugbox NOSHOW
    @ 0,14 SAY "   BAD NEWS!   " COLOR (redblink)
    @ 2, 1 SAY "Your FOXPROX.EXE file appears to have become"
    @ 3, 1 SAY "corrupted.  Please reinstall FoxPro."
    @ 5, 1 SAY "Press any key" COLOR (lowtext)
    @ 6, 1 SAY "to return to DOS..." COLOR (lowtext)
ENDIF (ATC("LIBRARY", VERS(1)) > 0)

SHOW WINDOW bugbox
DO razberry
=INKEY(0, "MH")
RELEASE WINDOW bugbox
* End procedure NOAPI



*!*****************************************************************************
*!
*!      Procedure: NOPSERVER
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE nopserver
*******************************************************************************
*& #1715 - Server "<server>" could not be found.
*          The server specified with SET PRINTER TO
*          command could not be found.
*
*   The passed parameter is the name of the missing server.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/11/93
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETER pserver
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* ==========================
*$ Get info on person to call
* ==========================
DO lan_admin
DEFINE WINDOW bugbox FROM 6,18 TO 18,61 DOUBLE;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,12 SAY "   SORRY!   " COLOR (redblink)
@ 2, 1 SAY "Print server &pserver could not be found."
@ 3, 1 SAY "Please contact:"
@ 4, 0 SAY PADC(m.m_call, 41)
@ 5, 0 SAY PADC(m.m_title, 41)
@ 6, 0 SAY PADC(m.m_phone, 41)
@ 7, 1 SAY "to report the problem."
@ 9, 1 SAY "Press any key to" COLOR (lowtext)
@10, 1 SAY "return to Main Menu..." COLOR (lowtext)
SHOW WINDOW bugbox
DO razberry
=INKEY(0, "MH")
RELEASE WINDOW bugbox
RETURN
* End procedure NOPSERVER



*!*****************************************************************************
*!
*!      Procedure: NO_QUE
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FP25EROR.PRG)
*!               : APP_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE no_que
*******************************************************************************
*&  #1716 - Queue <queue> not found.
*           The print queue specified in the SET
*           PRINTER TO command can not be found.
*
*   Passed parameter nopq is the name of the print que.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/11/93
*
*   Modified 5/26/93 by Pat Adams
*       Correction to spelling of SYSDATA
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS nopq
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone

IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))

IF sysdata.multi_user
    DO lan_admin
ELSE
    DO app_admin
ENDIF (sysdata.multi_user)

DEFINE WINDOW bugbox FROM 6,19 TO 18,60 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,12 SAY "   SORRY!   " COLOR (redblink)
@ 2, 1 SAY "Print que &nopq could not be found."
@ 3, 1 SAY "Please contact:"
@ 4, 0 SAY PADC(m.m_call, 39)
@ 5, 0 SAY PADC(m.m_title, 39)
@ 6, 0 SAY PADC(m.m_phone, 39)
@ 7, 1 SAY "to report this problem."
@ 9, 1 SAY "Press any key to" COLOR (lowtext)
@10, 1 SAY "return to Main Menu..." COLOR (lowtext)
SHOW WINDOW bugbox
DO razberry
=INKEY(0, "MH")
RELEASE WINDOW bugbox
RETURN
* End procedure NO_QUE


*!*****************************************************************************
*!
*!      Procedure: NO_PLB
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE no_plb
*******************************************************************************
*& #1726 - API library file could not be found
*
*   Author: Pat Adams, DB Unlimited
*   Date: 1/11/93
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone
* =================================
* Get info on person to be called
* =================================
DO developer
DEFINE WINDOW bugbox FROM 5,19 TO 17,61 DOUBLE ;
    COLOR SCHEME 20 SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox NOSHOW
@ 0,12 SAY "   WHOOPS!   " COLOR (redblink)
@ 2, 1 SAY "An API library file could not be found."
@ 3, 1 SAY "Please contact:"
@ 4, 0 SAY PADC(m.m_call, 40)
@ 5, 0 SAY PADC(m.m_title, 40)
@ 6, 0 SAY PADC(m.m_phone, 40)
@ 7, 1 SAY "to report the problem."
@ 9, 1 SAY "Press any key to" COLOR (lowtext)
@10, 1 SAY "return to Main Menu..." COLOR (lowtext)
SHOW WINDOW bugbox
DO razberry
=INKEY(0, "MH")
RELEASE WINDOW bugbox
RETURN
* End procedure NO_PLB
*: EOF: FP25EROR.PRG
