* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* DB-LOG V1.02 Copyright (c) 1992-1993 DL Systems, Inc. All rights reserved.
*
* This program demonstrates the use of the DBLOGAPI.OBJ procedures included
* with with the DB-LOG package.
*
* All of these procedures follow standard C calling and parameter passing
* conventions.
*
* NOTE: The transaction system procedures are not demonstrated in this program.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*	 Name: DBLOGVER
*
*     Purpose: To determine if the DB-LOG TSR is initialized and return the
*	       version number if initialized.
*
* XBASE Usage: Call DBLOGVER With Logver
*
*	       Logver	>	4 byte character string used on output.
*
*	       On output,
*
*	       Logver = '1.00' if DB-LOG is initialized.
*
*	       Logver = '    ' (spaces decimal 32) if DB-LOG is not initialized.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*	 Name: DBLOGSUSP
*
*     Purpose: To determine if the DB-LOG TSR has been suspended.
*
* XBASE Usage: Call DBLOGSUSP With Logsusp
*
*	       Logsusp	>	1 byte character string used on output.
*
*	       On output,
*
*	       Logsusp = 'S' if DB-LOG is suspended.
*
*	       Logsusp = ' ' (space decimal 32) if DB-LOG is not suspended.
*
*
*	 NOTE: If this procedure is called when DB-LOG is not initialized,
*	       unpredictible results will occur.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*	 Name: DBLOGERROR
*
*     Purpose: To determine if the DB-LOG TSR has encountered any errors.
*
* XBASE Usage: Call DBLOGERROR With Logerror
*
*	       Logerror >	4 byte character string used on output.
*
*	       On output,
*
*	       Logerror
*
*		    Byte 1 = 'F' if file/path not found errors have occurred.
*
*		    Byte 1 = ' ' (space decimal 32) if file/path not found have
*				 not occurred.
*
*		    Byte 2 = 'M' if miscellaneous open file errors have
*				 occurred.
*
*		    Byte 2 = ' ' (space decimal 32) if miscellaneous open file
*				 errors have not occurred.
*
*		    Byte 3 = 'H' if no file handles left errors have occurred.
*
*		    Byte 3 = ' ' (space decimal 32) if no file handles left
*				 errors have not occured.
*
*		    Byte 4 = 'D' if miscellaneous DOS errors have occurred.
*
*		    Byte 4 = ' ' (space decimal 32) if miscellaneous DOS errors
*				 have not occured.
*
*
*	 NOTE: If this procedure is called when DB-LOG is not initialized,
*	       unpredictible results will occur.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*	 Name: DBLOGPATH
*
*     Purpose: To return the path that DB-LOG uses for log files.
*
* XBASE Usage: Call DBLOGPATH With Logpath
*
*	       Logpath >	63 byte character string used on output.
*
*	       On output,
*
*	       Logpath = Complete drive and path starting at the root for log
*			 files.
*
*
*	 NOTE: If this procedure is called when DB-LOG is not initialized,
*	       unpredictible results will occur.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*	 Name: DBLOGTABLE
*
*     Purpose: To return the source file and log file for one of the 2 file
*	       table entries.
*
* XBASE Usage: Call DBLOGTABLE With Word(Entry_num), Sourcefile, Logfile
*
*	       Entry_num >	Entry number (1 - 2) of the file table to
*				return.  Must be in INTEL WORD format.
*
*	       Sourcefile >	12 byte character string used on output.
*
*	       Logfile >	12 byte character string used on output.
*
*	       On output,
*
*	       Sourcefile = Filename and extension of the file being logged.
*			    12 spaces (decimal 32) if entry is not being used.
*
*		  Logfile = Filename and extension of the log file.
*			    12 spaces (decimal 32) if entry is not being used.
*
*
*	 NOTE: If this procedure is called when DB-LOG is not initialized,
*	       unpredictible results will occur.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*	 Name: DBLOGNAME
*
*     Purpose: To return the DOS machine name.
*
* XBASE Usage: Call DBLOGNAME With Logname
*
*	       Logname >	16 byte character string used on output.
*
*	       On output,
*
*	       Logname = ASCIIZ DOS machine name.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *



Logver = SPACE(4)			&& Initialize variable to be used
Logsusp = SPACE(1)			&& as parameters in calls
Logerror = SPACE(4)
Logpath = SPACE(63)
Sourcefile = SPACE(12)
Logfile = SPACE(12)
Logname = SPACE(16)



* DBLOGVER DEMO ================================================================
Call DBLOGVER With Logver		&& Call DBLOG to return version.
If Logver = SPACE(4)			&& If version is space(4) then
   ? 'DB-LOG not initialzed'            && DB-LOG is not initialized.
   ?
   Quit
Else					&& If version is not space(4) then
   ? 'Version ' + LOGVER                && DB-LOG is initialized.
Endif



* DBLOGSUSP DEMO ===============================================================
Call DBLOGSUSP With Logsusp		&& Call DB-LOG to return suspend status.
IF Logsusp = 'S'                        && If status is 'S' then DB-LOG is
   ? 'DB-LOG suspended'                 && suspended.  If status is space(1)
Endif					&& then DB-LOG is not suspended.



* DBLOGERROR DEMO ==============================================================
Call DBLOGERROR With Logerror		&& Call DB-LOG to return errors.
If Substr(Logerror, 1, 1) = 'F'         && If first byte is 'F' then
   ? 'File/path not found errors'       && file/path not found errors have
Endif					&& occurred.
If Substr(Logerror, 2, 1) = 'M'         && If second byte is 'M' then
   ? 'Misc open file errors'            && misc open file errors have occurred.
Endif
If Substr(Logerror, 3, 1) = 'H'         && If third byte is 'H' then
   ? 'No file handles left errors'      && no file handles left errors have
Endif					&& occurred.
If Substr(Logerror, 4, 1) = 'D'         && If fourth byte is 'D' then
   ? 'Misc DOS errors'                  && misc DOS errors have occurred.
Endif



* DBLOGPATH DEMO ===============================================================
Call DBLOGPATH With Logpath		&& Call DB-LOG to return log path.
? 'LOGPATH = ' + Logpath



* DBLOGTABLE DEMO ==============================================================
?
? 'LIST OF LOGGED FILES'

Entry_num = 0

DO WHILE Entry_num < 2			&& Loop to get all 2 file table
					&& entries.
   Entry_num = Entry_num + 1

   Call DBLOGTABLE With ;		&& Call DB-LOG to get file table entry.
      Word(Entry_num), ;
      Sourcefile, ;
      Logfile

   If Sourcefile <> SPACE(12)		&& If source file exists in file table
      ? Sourcefile + ' ' + Logfile      && entry, then this entry of the 2
   Endif				&& possible is being used.

Enddo

?



* DBLOGNAME DEMO ===============================================================
Call DBLOGNAME With Logname		&& Call DOS to return ASCIIZ DOS machine
? 'LOGNAME = ' + Logname                && name.



?
