@echo off

rem QAUTH.BAT v1.5

rem Demo of a batch file which checks archives to see if they have AV
rem information, password-protected files or are part of multi-volume
rem archives et cetera.

rem Such a function is useful for automated archive testing or conversion
rem (such as from a BBS).  If a non-zero exit-level is returned by qaz -ra
rem one should examine the file more closely before automatically convert-
rem ing the archive.

echo Examining: %1
echo 

qaz %1 /ri+ > NUL

rem Change the 'qaz.bad' to the name (w/path) of the file you want as the
rem badlist. If the file does not exist, don't worry: QAZ will ignore it.

if errorlevel 255 goto damaged
if errorlevel 254 goto badlist

qaz %1 /ra+ > NUL

if errorlevel 128 goto damaged

if errorlevel 1 goto authentic

echo This archive appears normal.

rem Note: QAZ can only detect the presence of security envelopes or
rem       authenticity verification info for ARJ, HPACK, SQZ or ZIP
rem       archvies.

rem       For ARC or PAK files, there is no way of determining if
rem       files are encrypted.

rem       Archives split with file-splitters may not be flagged as
rem       multipartite but as damaged.

goto quit

:damaged

echo This archive may be damaged.
echo 

goto quit

:badlist

echo This file is in the QAZ.BAD list.
echo 

goto quit

:authentic

echo This archive may have authentication information, passworded files
echo or it may be part of a multipartitite/multi-volume archive.
echo 
if errorlevel 8 echo This archive may also be a self-extracting archive.
if errorlevel 16 echo This archive may contain non-DOS files (QAZ v3.11a).

rem The non-DOS flag was added because of an archive that contained several
rem long filenames that when reduced to DOS 8.3 were the same: hence auto-
rem conversion utilities would either choke or lose some of the files.

:quit

