/* UDP packet tracing
 * Copyright 1991 Phil Karn, KA9Q
 *
 * ported to WNOS and enhancing with domain dump - DB3FL.92xxxx
 * enhancements - G6DHU.92xxxx
 *
 */
#include <stdio.h>
#include "global.h"
#include "config.h"
#ifdef UDP
#include "mbuf.h"
#include "netuser.h"
#include "internet.h"
#include "udp.h"
#include "ip.h"
#include "socket.h"
#include "trace.h"
#include "domain.h"

static void near
trput_rr(FILE *fp,struct rr *rrp)
{
	if(rrp == NULLRR) {
		return;
	}
	trprintf(fp,"%s",rrp->name);

	if(rrp->name[strlen(rrp->name)-1] != '.' && rrp->origin != NULLCHAR) {
		trprintf(fp,".%s",rrp->origin);
	}
	if(rrp->ttl) {
		trprintf(fp," %lu",rrp->ttl);
	}
	if(rrp->class == CLASS_IN) {
		trprintf(fp," IN");
    } else {
		if(rrp->ttl == 0) {
			trprintf(fp," %lu",rrp->ttl);
		}
		trprintf(fp," %u",rrp->class);
	}
	if(rrp->type < NDTYPES) {
		trprintf(fp," %s ",type2str(rrp->type));
	} else {
		trprintf(fp," %u ",rrp->type);
	}
	/* Null data portion, indicates nonexistent record */
	if(rrp->rdlength != 0) {
		switch(rrp->type) {
		case TYPE_A:
			trprintf(fp,"%s\n",inet_ntoa(rrp->rdata.addr));
			return;
		case TYPE_MINFO:	/* Unsupported type */
			trprintf(fp,"%s %s\n",rrp->rdata.minfo.rmailbx,rrp->rdata.minfo.emailbx);
			return;
		case TYPE_MD:		/* Unsupported type */
		case TYPE_MF:		/* Unsupported type */
		case TYPE_NULL:		/* Unsupported type */
		case TYPE_WKS:		/* Unsupported type */
			trprintf(fp,"%s\n",rrp->rdata.data);
			return;
		case TYPE_CNAME:
		case TYPE_MB:
		case TYPE_MG:
		case TYPE_MR:
		case TYPE_NS:
		case TYPE_PTR:
		case TYPE_TXT:
			/* These are all printable text strings */
			trprintf(fp,"%s\n",rrp->rdata.data);
			return;
		case TYPE_MX:
			trprintf(fp,"%u %s\n",rrp->rdata.mx.pref,rrp->rdata.mx.exch);
			return;
		case TYPE_SOA:
			trprintf(fp,"%s %s %lu %lu %lu %lu %lu\n",
				rrp->rdata.soa->mname,rrp->rdata.soa->rname,
				rrp->rdata.soa->serial,rrp->rdata.soa->refresh,
				rrp->rdata.soa->retry,rrp->rdata.soa->expire,
				rrp->rdata.soa->minimum);
			return;
		case TYPE_HINFO:
			trprintf(fp,"%s %s\n",rrp->rdata.hinfo.cpu,rrp->rdata.hinfo.os);
		default:
			return;
		}
	}
}

/* Dump a UDP header */
void
udp_dump(FILE *fp,struct mbuf **bpp,int32 source,int32 dest,int check)
{
	struct udp udp;
	struct pseudo_header ph;
	int16 csum = 0;

	if(bpp == NULLBUFP || *bpp == NULLBUF) {
		return;
	}
	/* Compute checksum */
	ph.source = source;
	ph.dest = dest;
	ph.protocol = UDP_PTCL;
	ph.length = len_p(*bpp);

	if(check) {
		csum = cksum(&ph,*bpp,ph.length);
	}
	ntohudp(&udp,bpp);

	trprintf(fp,"UDP: len %u %u->%u",udp.length,udp.source,udp.dest);

	if(csum) {
		trprintf(fp," CHECKSUM ERROR (%u)",csum);
	}
	trprintf(fp,"\n");

	if(udp.source == IPPORT_DOMAIN || udp.dest == IPPORT_DOMAIN) {
		static char *Dopcode[] = {
			"QUERY","IQUERY","STATUS","3a","4a","5a","6a","7a","8a","UPDATEA",
			"UPDATED","UPDATEDA","UPDATEM","UPDATEMA","ZONEINIT","ZONEREF",
		};
		static char *Drcode[] = {
			"NOERROR","FORMERR","SERVFAIL","NXDOMAIN","NOTIMP","REFUSED",
			"6b","7b","8b","9b","10b","11b","12b","13b","14b","NOCHANGE",
		};
		int i;
		struct dhdr *dhdr = mxallocw(sizeof(struct dhdr));

		ntohdomain(dhdr,bpp);

		trprintf(fp,"DOMAIN: opcode %s status %s id %lu",
			Dopcode[dhdr->opcode],Drcode[dhdr->rcode],dhdr->id);

		trprintf(fp,"%s%s%s%s%s\n",
			dhdr->aa ? " AA" : "",
			dhdr->qr ? " QR" : "",
			dhdr->rd ? " RD" : "",
			dhdr->ra ? " RA" : "",
			dhdr->tc ? " TC" : "");

		if(dhdr->qdcount) {
			for(i = 0; i < dhdr->qdcount; i++) {
				struct quest *qp = dhdr->qlist[i];
				trprintf(fp,"        Quest%4d: name %s type %s class %s\n",
					i + 1,
					qp->qname,
					type2str(qp->qtype),
					qp->qclass == 1 ? "Internet" : "[unknown]");
			}
		}
		if(dhdr->ancount) {
			for(i = 0; i < dhdr->ancount; i++){
				trprintf(fp,"        Answer%3d: ",i + 1);
				trput_rr(fp,dhdr->ans[i]);
			}
		}
		if(dhdr->nscount) {
			for(i = 0; i < dhdr->nscount; i++){
				trprintf(fp,"        Author%3d: ",i + 1);
				trput_rr(fp,dhdr->ns[i]);
			}
		}
		if(dhdr->arcount) {
			for(i = 0; i < dhdr->arcount; i++){
				trprintf(fp,"        Addit%4d: ",i + 1);
				trput_rr(fp,dhdr->add[i]);
			}
		}
		free_dhdr(dhdr);
	}
	return;
}
#endif /* UDP */
