#include <stdio.h>
#include <ctype.h>
#include <time.h>
#ifdef	__TURBOC__
#include <io.h>
#endif
#include "global.h"
#include "config.h"
#include "mbuf.h"
#include "socket.h"
#include "telnet.h"
#include "session.h"
#include "proc.h"
#include "tty.h"
#include "commands.h"
#include "netuser.h"
#include "clients.h"

static int near gen_telnet __ARGS((char *name,int ipport,int bbs));

static int Refuse_echo = 0;
static int Tn_cr_mode = 0;    /* if true turn <cr> to <cr-nul> */

#ifdef DEBUG
char *T_options[] = {
	"Transmit Binary",
	"Echo",
	"",
	"Suppress Go Ahead",
	"",
	"Status",
	"Timing Mark"
};
#endif

#ifdef MAILBOX
/* Execute user BBS command */
int
dobbs(int argc,char **argv,void *p)
{
	if(Ip_addr == 0) {
		tputs(Noipaddr);
		return -1;
	}
	return gen_telnet("LocBBS",IPPORT_TELNET,TRUE);
}
#endif

/* Execute user chat command */
int
dochat(int argc,char **argv,void *p)
{
	return gen_telnet(argv[1],IPPORT_TTYLINK,FALSE);
}

/* Execute user telnet command */
int
dotelnet(int argc,char **argv,void *p)
{
	int arg = (argc < 3) ? IPPORT_TELNET : atoi(argv[2]);

	return gen_telnet(argv[1],arg,FALSE);
}

static int near
gen_telnet(char *name,int ipport,int bbs)
{
	int split = 0;
	struct session *sp;
	struct sockaddr_in fsocket;

	switch(ipport) {
	case IPPORT_TELNET:
	case IPPORT_TTYLINK:
	case IPPORT_CONVERS:
		split = 1;
		break;
	}
	/* Allocate a session descriptor */
	if((sp = newsession(name,TELNET,split | SWAP)) == NULLSESSION) {
		tputs(Nosess);
		return 1;
	}
	fsocket.sin_family = AF_INET;
	fsocket.sin_port = ipport;

	if(bbs == TRUE) {
		fsocket.sin_addr.s_addr = Ip_addr;
	} else {
		strlwr(sp->name);
		tprintf("Resolving %s... ",sp->name);

		if((fsocket.sin_addr.s_addr = resolve(sp->name)) == 0){
			tprintf(Badhost,sp->name);
			goto quit;
		}
	}
	if((sp->s = socket(AF_INET,SOCK_STREAM,0)) == -1){
		tputs(Nosocket);
		goto quit;
	}
	if(!(tel_connect(sp,(char *)&fsocket,SOCKSIZE)))
		return 0;
quit:
	keywait(NULLCHAR,1);
	freesession(sp);
	return 1;
}

/* Generic interactive connect routine, used by Telnet, AX.25, NET/ROM */
int
tel_connect(struct session *sp,char *fsocket,int len)
{
	struct telnet tn;

/*	struct sockaddr_in *lsocket = (struct sockaddr_in *)fsocket;	*/

	memset(&tn,0,sizeof(struct telnet));

	tn.eolmode = Tn_cr_mode;
	tn.session = sp;				/* Upward pointer */
	sp->cb.telnet = &tn;			/* Downward pointer */
	sockmode(sp->s,SOCK_ASCII);		/* Default to ascii mode */

	tprintf("Trying %s...\n",psocket((struct sockaddr *)fsocket));
	if(connect(sp->s,fsocket,len) == -1) {
		tprintf("%s session failed: %s errno %d\n",
			Sestypes[sp->type], sockerr(sp->s),errno);
		return 1;
	}
	tprintf("%s session connected to %s\n",Sestypes[sp->type],sp->name);

	log(sp->s,9983,"%4.4s connect",Sestypes[sp->type]);

/*	cli_login(lsocket->sin_port,(void *)&tn);						*/

	tnrecv(&tn);
	return 0;
}

/* Telnet input routine, common to both telnet and ttylink */
void
tnrecv(struct telnet *tn)
{
	char *cp = NULLCHAR;
	struct session *sp = tn->session;
	int c, s = sp->s;

	/* Fork off the transmit process */
	sp->proc1 = newproc("tnrecv",768,tel_output,0,tn,NULL,0);

	/* Process input on the connection */
	while((c = recvchar(s)) != -1){
		if(c != IAC){
			/* Ordinary character */
			usputc(Curproc->output,c);
			continue;
		}
		/* IAC received, get command sequence */
		c = recvchar(s);
		switch(c){
		case WILL:
			c = recvchar(s);
			willopt(tn,c);
			break;
		case WONT:
			c = recvchar(s);
			wontopt(tn,c);
			break;
		case DO:
			c = recvchar(s);
			doopt(tn,c);
			break;
		case DONT:
			c = recvchar(s);
			dontopt(tn,c);
			break;
		case IAC:	/* Escaped IAC */
			usputc(Curproc->output,IAC);
			break;
		}
	}
	/* A close was received from the remote host.
	 * Notify the user, kill the output task and wait for a response
	 * from the user before freeing the session.
	 */
	sockmode(sp->output,SOCK_ASCII); /* Restore newline translation */

	if((cp = sockerr(s)) == NULLCHAR) {
		cp = "EOF";
	}
	tprintf("%s session closed: %s at %s",
		Sestypes[sp->type],cp,ctime(&currtime));

	log(sp->s,9983,"%4.4s closed %s",Sestypes[sp->type],cp);

	killproc(sp->proc1);
	sp->proc1 = NULLPROC;
	keywait(NULLCHAR,1);
	freesession(sp);
}

/* User telnet output task, started by user telnet command */
static void
tel_output(int unused,void *tn1,void *p)
{
	int c;
	struct telnet *tn = (struct telnet *)tn1;
	struct session *sp = tn->session;

	/* Send whatever's typed on the terminal */
	while((c = recvchar(sp->input)) != -1) {
		usputc(sp->s,c);

		if(!tn->remote[TN_ECHO] && sp->record != NULLFILE) {
			fputc(c,sp->record);
		}
		/* By default, output is transparent in remote echo mode.
		 * If eolmode is set, turn a cr into cr-null.
		 * This can only happen when in remote echo (raw) mode, since
		 * the tty driver normally maps \r to \n in cooked mode.
		 */
		if(c == '\r' && tn->eolmode) {
			usputs(sp->s,"\0");
		}
		if(tn->remote[TN_ECHO]) {
			usflush(sp->s);
		}
	}
	/* Make sure our parent doesn't try to kill us after we exit */
	sp->proc1 = NULLPROC;
}

int
doecho(int argc,char **argv,void *p)
{
	if(argc < 2) {
		tprintf("Echo %s\n",Refuse_echo ? "refuse" : "accept");
	} else {
        switch(*argv[1]) {
			case 'r':
				Refuse_echo = 1;
				break;
			case 'a':
				Refuse_echo = 0;
				break;
			default:
				tputs("Usage: echo <refuse|accept>\n");
				return -1;
		}
	}
	return 0;
}

/* set for unix end of line for remote echo mode telnet */
int
doeol(int argc,char **argv,void *p)
{
	if(argc < 2) {
		tprintf("Eol %s\n",Tn_cr_mode ? "null" : "standard");
	} else {
        switch(*argv[1]) {
			case 'n':
				Tn_cr_mode = 1;
				break;
			case 's':
				Tn_cr_mode = 0;
				break;
			default:
				tputs("Usage: eol <standard|null>\n");
				return -1;
		}
	}
	return 0;
}

#ifdef	__TURBOC__
/* Set end-of-line translation mode on file */
static int near
filemode(FILE *fp,int mode)
{
	int omode = (fp->flags & _F_BIN) ? SOCK_BINARY : SOCK_ASCII;

	if(fp == NULLFILE)
		return -1;

	switch(mode){
	case SOCK_BINARY:
		fp->flags = _F_BIN;
		setmode(fileno(fp),O_BINARY);
		break;
	case SOCK_ASCII:
		fp->flags &= ~_F_BIN;
		setmode(fileno(fp),O_TEXT);
		break;
	}
	return omode;
}
#else
static int near
filemode(FILE *fp,int mode)
{
	return 0;
}
#endif

/* The guts of the actual Telnet protocol: negotiating options */
static void
willopt(struct telnet *tn,int opt)
{
	int ack;

#ifdef	DEBUG
	tputs("recv: will ");
	if(uchar(opt) <= NOPTIONS)
		tprintf("%s\n",T_options[opt]);
	else
		tprintf("%u\n",opt);
#endif

	switch(uchar(opt)){
	case TN_TRANSMIT_BINARY:
	case TN_ECHO:
	case TN_SUPPRESS_GA:
		if(tn->remote[uchar(opt)] == 1)
			return;		/* Already set, ignore to prevent loop */
		if(uchar(opt) == TN_ECHO){
			if(Refuse_echo){
				/* User doesn't want to accept */
				ack = DONT;
				break;
			} else {
				/* Put tty into raw mode */
				tn->session->ttystate.edit = 0;
				tn->session->ttystate.echo = 0;
				sockmode(tn->session->s,SOCK_BINARY);
				sockmode(tn->session->input,SOCK_BINARY);
				sockmode(tn->session->output,SOCK_BINARY);
				if(tn->session->record != NULLFILE)
					filemode(tn->session->record,SOCK_BINARY);

			}
		}
		tn->remote[uchar(opt)] = 1;
		ack = DO;
		break;
	default:
		ack = DONT;	/* We don't know what he's offering; refuse */
	}
	answer(tn,ack,opt);
}

static void
wontopt(struct telnet *tn,int opt)
{
#ifdef	DEBUG
	tputs("recv: wont ");
	if(uchar(opt) <= NOPTIONS)
		tprintf("%s\n",T_options[uchar(opt)]);
	else
		tprintf("%u\n",uchar(opt));
#endif
	if(uchar(opt) <= NOPTIONS){
		if(tn->remote[uchar(opt)] == 0)
			return;		/* Already clear, ignore to prevent loop */
		tn->remote[uchar(opt)] = 0;
		if(uchar(opt) == TN_ECHO){
			/* Put tty into cooked mode */
			tn->session->ttystate.edit = 1;
			tn->session->ttystate.echo = 1;
			sockmode(tn->session->s,SOCK_ASCII);
			sockmode(tn->session->input,SOCK_ASCII);
			sockmode(tn->session->output,SOCK_ASCII);
			if(tn->session->record != NULLFILE)
				filemode(tn->session->record,SOCK_ASCII);
		}
	}
	answer(tn,DONT,opt);	/* Must always accept */
}

static void
doopt(struct telnet *tn,int opt)
{
	int ack;

#ifdef	DEBUG
	tputs("recv: do ");
	if(uchar(opt) <= NOPTIONS)
		tprintf("%s\n",T_options[uchar(opt)]);
	else
		tprintf("%u\n",uchar(opt));
#endif
	switch(uchar(opt)){
	case TN_SUPPRESS_GA:
		if(tn->local[uchar(opt)] == 1)
			return;		/* Already set, ignore to prevent loop */
		tn->local[uchar(opt)] = 1;
		ack = WILL;
		break;
	default:
		ack = WONT;	/* Don't know what it is */
	}
	answer(tn,ack,opt);
}

static void
dontopt(struct telnet *tn,int opt)
{
#ifdef	DEBUG
	tputs("recv: dont ");
	if(uchar(opt) <= NOPTIONS)
		tprintf("%s\n",T_options[uchar(opt)]);
	else
		tprintf("%u\n",uchar(opt));
#endif
	if(uchar(opt) <= NOPTIONS){
		if(tn->local[uchar(opt)] == 0){
			/* Already clear, ignore to prevent loop */
			return;
		}
		tn->local[uchar(opt)] = 0;
	}
	answer(tn,WONT,opt);
}

static void
answer(struct telnet *tn,int r1,int r2)
{
	char s[3];

#ifdef	DEBUG
	switch(r1){
	case WILL:
		tputs("sent: will ");
		break;
	case WONT:
		tputs("sent: wont ");
		break;
	case DO:
		tputs("sent: do ");
		break;
	case DONT:
		tputs("sent: dont ");
		break;
	}
	if(r2 <= 6)
		tprintf("%s\n",T_options[r2]);
	else
		tprintf("%u\n",r2);
#endif

	s[0] = IAC;
	s[1] = r1;
	s[2] = r2;
	send(tn->session->s,s,3,0);
}

