/* Miscellaneous machine independent utilities */
#include <stdio.h>
#include <ctype.h>
#include "global.h"
#include "socket.h"
#include "mbuf.h"
#include "files.h"
#include "netuser.h"
#include "cmdparse.h"
#include "smtp.h"			/* used for 'months' */

/* Convert hex-ascii to integer */
int
htoi(char *s)
{
	int i = 0;
	char c;

	while((c = *s++) != '\0'){
		if(c == 'x')
			continue;	/* allow 0x notation */
		if('0' <= c && c <= '9')
			i = (i * 16) + (c - '0');
		else if('a' <= c && c <= 'f')
			i = (i * 16) + (c - 'a' + 10);
		else if('A' <= c && c <= 'F')
			i = (i * 16) + (c - 'A' + 10);
		else
			break;
	}
	return i;
}

/* replace terminating end of line marker with null */
void
rip(char *s)
{
	char *cp;

	if((cp = strpbrk(s,"\r\n")) != NULLCHAR)
		*cp = '\0';
}

char *
timestr(int32 gmt)
{
	static char buf[20];
	struct tm *tm = gmtime(&gmt);

	sprintf(buf,"%02d%s%02d/%02d%02dz",
		tm->tm_mday,
		Months[tm->tm_mon],
		tm->tm_year,
		tm->tm_hour,
		tm->tm_min);

	return buf;
}

void
gethelp(int16 port,int s,char *topic)
{
  FILE *fp;
  char line[MAXPATH + 2];
  static char nohelp[] = "No help available for '%s'\n";

  sprintf(line,"%s/%s.hlp",EtcRoot,tcp_port(port));

  if((fp = Fopen(line,READ_TEXT,0,0)) == NULLFILE) {
	usprintf(s,nohelp,topic);
    return;
  }
  if(stricmp(topic,"all") == 0) {
	while(fgets(line,MAXPATH,fp) != NULL) {
	  if(*line != '^') {
		usputs(s,line);
	  }
	}
  } else if(stricmp(topic,"topic") == 0) {
	int i = 0;
	while(fgets(line,MAXPATH,fp) != NULL) {
	  if(*line == '^') {
		rip(line);
		usprintf(s,(i++ % 5) < 4 ? "%-15.14s" : "%s\n",line + 1);
	  }
	}
	if(i % 5) {
	  usputs(s,"\n");
	}
  } else {
	char *p;
	int state = 0;

	while(fgets(line,MAXPATH,fp) != NULL) {

	  for(p = line; *p; p++) ;
	  while(--p >= line && isspace(uchar(*p))) ;
	  p[1] = 0;

	  if(state == 0 && *line == '^' && stricmp(line + 1,topic) == 0) {
		state = 1;
	  }
	  if(state == 1 && *line != '^') {
		state = 2;
	  }
	  if(state == 2) {
		if(*line == '^') {
		  break;
		}
		usprintf(s,"%s\n",line);
      }
    }
	if(state < 2)
	  usprintf(s,nohelp,topic);
  }
  Fclose(fp);
}

#ifdef XXX

... in pcgen.asm ...

/* Host-network conversion routines, replaced on the 8086 with assembler */

/* Put a long in host order into a char array in network order */
char *
put32(char *cp,int32 x)
{
	*cp++ = x >> 24;
	*cp++ = x >> 16;
	*cp++ = x >> 8;
	*cp++ = x;
	return cp;
}

/* Put a short in host order into a char array in network order */
char *
put16(char *cp,int16 x)
{
	*cp++ = x >> 8;
	*cp++ = x;

	return cp;
}

int16
get16(char *cp)
{
	int16 x = uchar(*cp++);

	x <<= 8;
	x |= uchar(*cp);

	return x;
}

/* Machine-independent, alignment insensitive network-to-host long conversion */
int32
get32(char *cp)
{
	int32 rval = uchar(*cp++);

	rval <<= 8;
	rval |= uchar(*cp++);
	rval <<= 8;
	rval |= uchar(*cp++);
	rval <<= 8;
	rval |= uchar(*cp);

	return rval;
}

/* Compute int(log2(x)) */
int
log2(int16 x)
{
	int n = 16;

	for(;n != 0;n--){
		if(x & 0x8000)
			break;
		x <<= 1;
	}
	n--;
	return n;
}

#endif

