#include "global.h"
#include "devparam.h"
#include "mbuf.h"
#include "kiss.h"
#include "ax25.h"
#include "trace.h"

void
ki_dump(FILE *fp,struct mbuf **bpp,int check)
{
	int para = PULLCHAR(bpp);
	int port = para >> 4;

	if((para & 0x0f) == PARAM_DATA) {
		if(port)
			trprintf(fp,"(%d) ",port);
		ax25_dump(fp,bpp,check);
	} else {
		int val = PULLCHAR(bpp);
		trprintf(fp,"KISS %s: ",para < 6 ? parmname(para) : "\b");

		switch(para){
		case PARAM_TXDELAY:
		case PARAM_SLOTTIME:
		case PARAM_TXTAIL:
			trprintf(fp,"%lu ms\n",val * 10L);
			break;
		case PARAM_PERSIST:
			trprintf(fp,"%u/256\n",val + 1);
			break;
		case PARAM_FULLDUP:
			trprintf(fp,"%s\n",val ? "Yes" : "No");
			break;
		case PARAM_HW:
			trprintf(fp,"%u\n",val);
			break;
		case PARAM_RETURN:
			break;
		default:
			trprintf(fp,"code %u arg %u\n",para,val);
			break;
		}
	}
	return;
}

int
ki_forus(struct iface *iface,struct mbuf *bp)
{
	struct mbuf *bpp;
	int i = 0;

	if((*bp->data & 0x0f) == PARAM_DATA) {
		if(dup_p(&bpp,bp,1,AXALEN) == AXALEN)
			i = ax_forus(iface,bpp);
		free_p(bpp);
	}
	return i;
}
