#ifndef _GLOBAL_H
#define _GLOBAL_H

#define __CPLUSPLUS             1
#define __CPLUSPLUS3    1

#undef  MDEBUG                  1

/* Global definitions used by every source file.
 * Some may be compiler dependent.
 */

#if     defined(__TURBOC__) || defined(__STDC__) || defined(LATTICE)
#define ANSIPROTO               1
#if defined (MAXPATH)
#undef MAXPATH
#endif
#define MAXPATH 80
#endif

#ifndef __ARGS
#ifdef  ANSIPROTO
#define __ARGS(x)               x
#else
#define __ARGS(x)               ()
#endif
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined(__TIME_H)
#include <time.h>
#endif

#if     !defined(AMIGA) && (defined(LATTICE) || defined(MAC) || defined(__TURBOC__))
/* These compilers require special open modes when reading binary files.
 *
 * "The single most brilliant design decision in all of UNIX was the
 * choice of a SINGLE character as the end-of-line indicator" -- M. O'Dell
 *
 * "Whoever picked the end-of-line conventions for MS-DOS and the Macintosh
 * should be shot!" -- P. Karn's corollary to O'Dells' declaration
 */
#define READ_BINARY             "rb"
#define WRITE_BINARY    "wb"
#define APPEND_BINARY   "ab+"
#define READ_TEXT               "rt"
#define WRITE_TEXT              "wt"
#define APPEND_TEXT             "at+"

#else

#define READ_BINARY             "r"
#define WRITE_BINARY    "w"
#define APPEND_BINARY   "a+"
#define READ_TEXT               "r"
#define WRITE_TEXT              "w"
#define APPEND_TEXT             "a+"

#endif

/* These two lines assume that your compiler's longs are 32 bits and
 * shorts are 16 bits. It is already assumed that chars are 8 bits,
 * but it doesn't matter if they're signed or unsigned.
 */
typedef long int32;                             /* 32-bit signed integer */
typedef unsigned short int16;   /* 16-bit unsigned integer */
#define uchar(x) ((unsigned char)(x))
#define MAXINT16 65535L                 /* Largest 16-bit integer */
#define MAXINT32 4294967295L    /* Largest 32-bit integer */

/*----------------------------------------------------------------------*
* The "interrupt" keyword is non-standard, so make it configurable      *
* The 'near' keyword is customary to those strange Intel machines       *
*-----------------------------------------------------------------------*/
#if defined(__TURBOC__)
#  define INTERRUPT       void interrupt
#  if defined __CPLUSPLUS3
#     define NEAR near /*_fastcall*/
#     define FASTCALL /*_fastcall*/
#  else
#     define NEAR near
#     define FASTCALL
#  endif
#else
#  define INTERRUPT       void
#  define NEAR
#  define FASTCALL
#endif

/* Note that these definitions are on by default if none of the Turbo-C style
 * memory model definitions are on; this avoids having to change them when
 * porting to 68K environments.
 */
#if     !defined(__TINY__) && !defined(__SMALL__) && !defined(__MEDIUM__)
#define LARGEDATA       1
#endif

#if     !defined(__TINY__) && !defined(__SMALL__) && !defined(__COMPACT__)
#define LARGECODE       1
#endif

/* Since not all compilers support structure assignment, the ASSIGN()
 * macro is used. This controls how it's actually implemented.
 */
#ifdef  NOSTRUCTASSIGN  /* Version for old compilers that don't support it */
#define ASSIGN(a,b)     memcpy((char *)&(a),(char *)&(b),sizeof(b));
#else                   /* Version for compilers that do */
#define ASSIGN(a,b)     ((a) = (b))
#endif

/* Define null object pointer in case stdio.h isn't included */
#ifndef NULL
/* General purpose NULL pointer */
#define NULL (void *)0
#endif
#define NULLCHAR (char *)0      /* Null character pointer */
#define NULLCHARP (char **)0    /* Null character pointer pointer */
#define NULLINT (int *)0        /* Null integer pointer */
#define NULLFP   (int (*)())0   /* Null pointer to function returning int */
#define NULLVFP  (void (*)())0  /* Null pointer to function returning void */
#define NULLVIFP (INTERRUPT (*)())0
#define NULLFILE (FILE *)0      /* Null file pointer */

/* standard boolean constants */
#define FALSE 0
#define TRUE 1
#define NO 0
#define YES 1

/* string equality shorthand */
#define STREQ(x,y) (strcmp(x,y) == 0)

/* Extract a short from a long */
#define hiword(x)       ((int16)((x) >> 16))
#define loword(x)       ((int16)(x))

/* Extract a byte from a short */
#define hibyte(x)       ((unsigned char)((x) >> 8))
#define lobyte(x)       ((unsigned char)(x))

/* Extract nibbles from a byte */
#define hinibble(x)     (((x) >> 4) & 0xf)
#define lonibble(x)     ((x) & 0xf)

/* Various low-level and miscellaneous functions */
int dirps __ARGS((void));
int getopt __ARGS((int argc,char *argv[],char *opts));
int htoi __ARGS((char *));
long htol __ARGS((char *));
char *inbuf __ARGS((int16 port,char *buf,int16 cnt));
int istate __ARGS((void));
void log __ARGS((int s,int16 protocol,char *fmt, ...));
int log2 __ARGS((int16 x));
void *ltop __ARGS((long));
void *shtop __ARGS((char *));
char *outbuf __ARGS((int16 port,char *buf,int16 cnt));
long ptol __ARGS((void *));
void restore __ARGS((int int_status));
void rflush __ARGS((void));
void rip __ARGS((char *));
char *timestr __ARGS((int32 gmt));
int tprintf __ARGS((char *fmt,...));
int tputs __ARGS((char *s));
int wildmat __ARGS((char *s,char *p,char **argv));

/* in misc.c */
void gethelp __ARGS((int16 ipport,int s,char *topic));

#include <stdlib.h>
#include <string.h>

#ifdef  AZTEC
#define rewind(fp)      fseek(fp,0L,0);
#endif

#if     defined(__TURBOC__)
#define movblock(so,ss,do,ds,c) movedata(ss,so,ds,do,c)

#else

/* General purpose function macros already defined in turbo C */
#ifndef min
#define min(x,y)        ((x)<(y)?(x):(y))       /* Lesser of two args */
#endif
#ifndef max
#define max(x,y)        ((x)>(y)?(x):(y))       /* Greater of two args */
#endif

#define MK_FP(seg,ofs)  ((void far *) \
			(((unsigned long)(seg) << 16) | (unsigned)(ofs)))

#endif  /* __TURBOC __ */

/* Externals used by getopt */
extern int optind;
extern char *optarg;

/* check availalbe memory */
extern int availmem __ARGS((void));

/* System clock - count of ticks since startup */
extern int32 Clock;
extern int32 currtime;
extern int32 Memthresh;

#define SECONDS     (1L)
#define MINUTES     (60L * SECONDS)
#define HOURS       (60L * MINUTES)
#define DAYS        (24L * HOURS)

extern struct timer Statustimer;

extern char uploadstatus;
extern unsigned char Nrows, Ncols;

/* Various useful standard error messages */
extern char Hostname[];
extern char Badhost[];
extern char Notval[];
extern char Version[];
extern char Badif[];
extern char Badasy[];
extern char Badax[];
extern char Nosocket[];
extern char Nosess[];
extern char Noipaddr[];
extern char Invcall[];

/* Your system's end-of-line convention */
extern char Eol[];

#ifdef __CPLUSPLUS
extern struct ax25_cb;
extern struct dirsort;
extern struct iface;
extern struct ip;
extern struct mbx;
extern struct mbuf;
extern struct nr4cb;
extern struct session;
extern struct slip;

#  ifndef MDEBUG
      void *mxalloc(unsigned nb);
      void *mxallocw(unsigned nb);
      void *cxalloc(unsigned nelem,unsigned size);
      void *cxallocw(unsigned nelem,unsigned size);
      void xfree(void *adr);
	  char *strxdup(const char *s);
#else
      void *mxalloc(char *file,unsigned line,unsigned nb);
      void *mxallocw(char *file,unsigned line,unsigned nb);
      void *cxalloc(char *file,unsigned line,unsigned nelem,unsigned size);
      void *cxallocw(char *file,unsigned line,unsigned nelem,unsigned size);
      void xfree(char *file,unsigned line,void *adr);
      char *strxdup(char *file,unsigned line,const char *s);
#     ifndef __ALLOC_C
#        define mxalloc(nb) mxalloc(__FILE__,__LINE__,nb)
#        define mxallocw(nb) mxallocw(__FILE__,__LINE__,nb)
#        define cxalloc(elem,nb) cxalloc(__FILE__,__LINE__,elem,nb)
#        define cxallocw(elem,nb) cxallocw(__FILE__,__LINE__,elem,nb)
#        define xfree(blk) xfree(__FILE__,__LINE__,blk)
#        define strxdup(s) strxdup(__FILE__,__LINE__,s)
#     endif __ALLOC_C
#   endif

#endif __CPLUSPLUS

/* General structure for remote servers */
struct Server {
	struct Server *next;
	char *name;
	int32 address;
	int busy;
	int16 protocol;
	char *arg1;
	char *arg2;
	char *arg3;
	char *arg4;
} ;
#define NULLSERVER (struct Server *)0

extern struct Server *Server;

#endif  /* _GLOBAL_H */

