#include "global.h"
#include "config.h"
#ifdef ETHER
#include "mbuf.h"
#include "enet.h"
#include "trace.h"

void
ether_dump(fp,bpp,check)
FILE *fp;
struct mbuf **bpp;
int check;	/* Not used */
{
	struct ether ehdr;
	char s[20], d[20];

	ntohether(&ehdr,bpp);
	trprintf(fp,"Ether: len %u %s->%s type ",
		ETHERLEN + len_p(*bpp),pether(s,ehdr.source),pether(d,ehdr.dest));

	switch(ehdr.type){
	case IP_TYPE:
		trprintf(fp,"IP\n");
		ip_dump(fp,bpp,1);
		break;
	case ARP_TYPE:
	case REVARP_TYPE:
		trprintf(fp,"%sARP\n",(ehdr.type == ARP_TYPE) ? "" : "REV");
		arp_dump(fp,bpp);
		break;
	default:
		trprintf(fp,"0x%x\n",ehdr.type);
		break;
	}
}

int
ether_forus(iface,bp)
struct iface *iface;
struct mbuf *bp;
{
	/* Just look at the multicast bit */
	return (*bp->data & 1);
}

#endif /* ETHER */