#include "global.h"
#include "config.h"
#ifdef ARCNET
#include "mbuf.h"
#include "arcnet.h"
#include "trace.h"

void
arc_dump(FILE *fp,struct mbuf **bpp,int check)
{
	struct arc ahdr;

	ntoharc(&ahdr,bpp);

	trprintf(fp,"Arcnet: len %u %02x->%02x type ",
		ARCLEN + len_p(*bpp),uchar(*ahdr.source),uchar(*ahdr.dest));

	switch(uchar(ahdr.type)){
	case ARC_IP:
		trprintf(fp,"IP\n");
		ip_dump(fp,bpp,1);
		break;
	case ARC_ARP:
		trprintf(fp,"ARP\n");
		arp_dump(fp,bpp);
		break;
	default:
		trprintf(fp,"0x%x\n",ahdr.type);
		break;
	}
}

int
arc_forus(struct iface *iface,struct mbuf *bp)
{
	return 1;
}

#endif /* ARCNET */