'
'  Login.BAS Example Program
'

'$INCLUDE: 'LCL4B.INC'
'$INCLUDE: 'MODEM_IO.INC'

 DECLARE FUNCTION Buf256Seg CDECL ()

 DECLARE SUB MyExit (Port)
 DECLARE FUNCTION Login (Port, Send$, Pace, Expect$, Tics)

 CONST ESC = 27
 DIM RATES$(12)

 RATES$(1) = "300"
 RATES$(2) = "600"
 RATES$(3) = "1200"
 RATES$(4) = "2400"
 RATES$(5) = "4800"
 RATES$(6) = "9600"
 RATES$(7) = "19200"
 RATES$(8) = "38400"
 RATES$(9) = "57600"
 RATES$(10) = "115200"

 PARMS$ = RTRIM$(COMMAND$)
 I = INSTR(PARMS$, " ")
 IF I < 1 THEN
   PRINT "  Usage: Login <Port> <BaudRate>"
   PRINT "Example: Login 1 9600"
   END
 END IF
 L = LEN(PARMS$)
 ARG1$ = LEFT$(PARMS$, I - 1)
 ARG2$ = LTRIM$(RIGHT$(PARMS$, L - I))
 BaudCode = -1
 'Get COM port
 Port = VAL(ARG1$) - 1
 'Get baud code
 FOR I = 1 TO 10
   IF RATES$(I) = ARG2$ THEN
      BaudCode = I - 1
      EXIT FOR
   END IF
 NEXT I
 'Verify good baud rate
 IF BaudCode = -1 THEN
   PRINT "Cannot recognize baud rate "; ARG2$
   END
 END IF
'Reset port
 Code = SioRxBuf(Port, Buf256Seg(), Size256)
 IF Code < 0 THEN
   PRINT "Error "; Code; " returned from SioRxBuf()"
   Code = SioError(Code)
   END
 END IF
 Code = SioReset(Port, BaudCode)
 CLS
 IF Code < 0 THEN
   PRINT "Error "; Code; " returned from SioReset()"
   Code = SioError(Code)
   END
 END IF

 PRINT "Login 7/29/94"
 PRINT " "
 LIBVER = SioInfo(ASC("V"))
 PRINT "Library Version: "; LIBVER \ 16; ".";
 PRINT LIBVER - 16 * (LIBVER \ 16)

 Code = SioDTR(Port, SET_LINE)
 Code = SioRTS(Port, SET_LINE)

 'send "AT" to modem & expect "OK" back
 IF NOT Login(Port, "!AT!", 5, "OK", 180) THEN MyExit (Port)
 'initialize modem & expect "OK" back
 IF NOT Login(Port, "AT E1 S7=60 S11=60 V1 X1 Q0 S0=1!", 5, "OK", 90) THEN MyExit (Port)
 'send "ATDT1,205,880,9748" & expect "CONNECT" back
 IF NOT Login(Port, "ATDT1,205,880,9748!", 5, "CONNECT", 1092) THEN MyExit (Port)
 PRINT "Entering TERMINAL loop..."

 DO
   'Look at incoming serial
   Code = SioGetc(Port, 1)
   IF Code > -1 THEN
     Code = SioCrtWrite(Code)
   END IF
   'Anything to send
   AnyKey$ = INKEY$
   IF AnyKey$ <> "" THEN Code = SioPutc(Port, ASC(AnyKey$))
   IF AnyKey$ = CHR$(ESC) THEN EXIT DO
 LOOP

 PRINT "User typed ESC..."
 MyExit (Port)

 END

 FUNCTION Login (Port, Send$, Pace, Expect$, Tics)
 rc = ModemSendTo(Port, Pace, Send$)
 IF ModemWaitFor(Port, Tics, FALSE, Expect$) THEN
   PRINT
   Login = TRUE
 ELSE
   PRINT Expect$; " not received"
   Login = FALSE
 END IF
 END FUNCTION

 SUB MyExit (Port)
 rc = SioDone(Port)
 END
 END SUB

                                                                              