GRn-Term								GRn-Term

NAME

	GRn-Term

SYNOPSIS

	GRn-Term [DEVICE <devicename>] [UNIT <unitnumber>] [7WIRE] [BAUD <rate>]
		 [DIAL <dialstring>]   [NL=NEWLINE] [IOADDR] [HANGUP]

DECRIPTION

	GRn-Term is a *really* stupid terminal program, which uses the
	standard console, provided to assist users in connecting to an
	NNTP server via the serial port. GRn-Term open the device/unit
	in shared mode, as does GRn. This allows the use of devices
	other than serial.device, that can work with shared mode.

	GRn-Term does require that DEVICE either be, or emulate, the
	CBM serial.device.

	DEVICE specifies the device name to connect to. It defaults to
	serial.device.

	UNIT specifies the unit number of the DEVICE to connect to. It
	defaults to zero.

	7WIRE indicates that hardware handshaking should be used to
	communicate with DEVICE. Default is set in user preferences.

	BAUD indicates what speed to communicate with DEVICE. The default
	is set in user preferences.

	DIAL indicates a character string to be output to DEVICE upon
	startup. Typically, a phone number.

	NEWLINE indicates that each line output to DEVICE should be
	terminated by a carriage-return linefeed combination, and not
	just the default carriage-return.

	IOADDR indicates that it is not possible to re-open the specified
	DEVICE and UNIT and receive the same connection to the destination
	(this is a problem with dnet.device, sockser.device, and perhaps
	others). This option causes a special option to be passed to GRn
	so that it will "copy" GRn-Term's I/O parameters.

	HANGUP tells GRn-Term to hang up the phone line using the standard
	"+++" etc. sequence.

	GRn-Term has five commands:

		\dial <number>
		\grn  <arguments>
		\hangup
		\quit
		\redial

	\dial causes <number> to be dialed. It is required because some
	modems require a carriage-return/line-feed combination for the
	dial string.

	\grn starts GRn with the <arguments> specified. While GRn is running,
	GRn-Term ignores all input and output via the console; as well as
	any device/unit combination specified. After GRn complete, GRn-Term
	begins using the device/unit combination again.

	\hangup causes the +++, followed by ATH0 sequence to be emitted
	to hang up the modem.

	\quit terminates GRn-Term. The modem IS NOT HUNG UP. You MUST
	do this yourself.

	\redial causes GRn-Term to redial the number specified in the
	DIAL program parameter.

WARNINGS

	This is NOT meant to be a general purpose terminal program.
	GRn-Term is very simple, and will stay that way. It is there
	to help make a simple connection, and then start GRn. Nothing
	else.

EXAMPLES

	GRn-Term

	    Starts GRn-Term using serial.device, unit 0, seven-wire false,
	    and baud-rate set to preferences default.

	GRn-Term device dnet.device unit 8192

	    Starts GRn-Term using dnet.device, unit 8192.

	\grn nntp device dnet.device unit 8192

	    Causes GRn to be initialized, and GRn-Term will ignore
	    all input and output from the console and the device
	    specified when GRn-Term was initiated.

NOTES

	If you have the debug version of GRn installed, the command
	\grn-debug is also available. It takes arguments just like
	\grn.

	If device and unit are not specified, GRn-Term presumes the
	serial.device, unit 0.

	You will need to suppress local echo at the receiving side
	(on SVR4 Unix, "stty -echo"). This will confuse you if you
	don't.

	GRn-Term uses the console, so ALL input is cooked. You cannot
	send control characters that the console.device does not pass.
	Make sure you don't get in a situation where you need to.

	GRn-Term does NOT use OwnDevUnit style locking, as you'd
	deadlock that way. We don't have a consistent interface going
	between C News, AmigaUUCP and NNTP. So, if you are using it
	with AmigaUUCP then do:

		lockserial GRn-Term serial.device 0

	etc.
