;
;           The ANSWER Voice Mail System software configuration file
;
;              Configuration file for ANSWER.EXE, ZOOM version

; This is a plain ASCII text file which is used to initialize the default
; options for ANSWER.EXE.  To edit this file, you should use either a straight
; ASCII text editor, or a word processor in non-document mode.


; When ANSWER starts, it will set all options to a hard coded default
; value.  It will then read "OPTIONS.DAT" if it exists.  If not, then the
; Options menu will be invoked.  Otherwise, the defaults are changed to
; those saved in the "OPTIONS.DAT" file.  It will then read this
; configuration file if and only if this file is specified on the command
; line.  Any options set here will override the defaults with any new
; values specified.  If any options are not specified here, then they will
; remain the default value.  If an unrecogized key word is found, or if any
; of the parameters are found to be invalid, then ANSWER will terminate
; with an error message identifying the unrecognized key word or invalid
; parameter.  Once the file is read in, the options are written to the
; "OPTIONS.DAT" file and become the new defaults for all successive
; executions of ANSWER.  This means that once this file is read in and the
; options are saved, this file is no longer needed unless you wish to
; change the defaults.  Any options which are changed from within ANSWER
; (in the Control or Options menu) are written to "OPTIONS.DAT", but are
; not changed in this file.  This means that the next time ANSWER is run,
; it will read the changed defaults from "OPTIONS.DAT" but will override
; those options with the values read from this file.  Future version might
; write out the changed options to this file.

; Lines beginning with a letter character are considered key word lines.
; All characters after the first semi-colon on a line are ignored.
; If the last line in the file is a key word line, it must have a CR after it.
; All blank lines are ignored.
; All parameters must be separated from key words by spaces or tabs.

; For the following pathname key words, please specify the full pathname
; to the directory.  If the drive letter is not specified, then the current
; drive will be used.  If a '\' does not precede the pathname, then it will
; be considered a subdirectory off of the current directory.  No trailing '\'
; is required.  If the directory does not exists, it will be automatically and
; recursively created.

; The 'PGMDir' key word tells ANSWER where to find its operating files.  This
; defaults to the current directory.

PGMDir		c:\answer	; Program Directory

; The 'OGMDir' key word tells ANSWER where to find OutGoing Messages.  These
; are OGM*.BIN and the Information Server message files.  This defaults to
; the current directory.

OGMDir		c:\answer\ogm	; Outgoing Messages Directory

; The 'ICMDir' key word tells ANSWER where to keep and find InComing Messages.
; These are ICM*.BIN and the Voice Mail Box message files.  This defaults to
; the current directory.

ICMDir		c:\answer\icm	; Incoming Messages Directory

; The 'TMPDir' key word tells ANSWER where it can write its temporary files.
; This defaults to the current directory.

TMPDir		c:\answer\tmp	; Temporary Working Directory

; The 'BINDir' key word tells ANSWER where to find the required operating
; voice files (all pre-recorded voice files).  This defaults to a subdirectory
; of "BIN" off of the current directory.

BINDir		c:\answer\bin	; Operating Messages Directory

; The 'FAXDir' key word tells ANSWER where to get/put FAX files.  This defaults
; to the current directory.

FAXDir		c:\answer\fax	; Fax Receive Directory

; Log filename

Log	c:\answer\answer.log	; Log file

; The 'Mouse' key word enables/disables the mouse.  Valid parameters are
; Yes and No.  This defaults to No.

Mouse		No		; Mouse enabled/disabled

; The 'MouseSens' key word sets the mouse sensitivity.  Valid parameter range
; is from 0 to 256.  This defaults to 128.

MouseSens	128		; Mouse sensitivity

; The 'ICMLimit' key word sets the limit of incoming messages.  Valid parameter
; range is from 1 to 255 and is measured seconds.  This defaults to 30.

ICMLimit	30		; Incoming Message recording limit in seconds

; The 'OGMLimit' key word sets the limit of outgoing messages.  Valid parameter
; range is from 1 to 255 and is measured seconds.  This defaults to 90.

OGMLimit	90		; Outgoing Message recording limit in seconds

; The 'VMBLimit' key word sets the limit of incoming voice mail box messages.
; Valid parameter range is from 1 to 255 and is measured seconds.  This
; defaults to 60.

VMBLimit	60		; Voice Mail Box message limit in seconds

; The 'MsgBufSize' key word set the size of RAM buffer to be used during
; message playback and record.  When using the no interrupt method for
; messages, an audible gap can be heard in the message while ANSWER reads
; or writes to or from the hard disk.  Use this option to reduce the amount
; of gap.  This is only used for some voice mail cards (not used by the ZOOM).
; Valid parameter range is 1 to 63 is measured in kbytes.  This defaults to 10.

MsgBufSize	10		; Size of message buffer

; The 'Rings' key word sets the number of rings to allow before answering the
; telephone.  Valid parameter range is 1 to 9.  This defaults to 2.

Rings		2		; number of rings to allow before answering

; The 'Prompt' key word enables or disables the playing of "PROMPT.BIN" after
; answering the phone.  This is only valid for Answer mode Data or Fax.  Valid
; parameters are Yes and No.  This defaults to No.

Prompt		No		; prompt caller for touch tone keypress

; The 'Mode' key words sets the answer mode.  If set to Voice, then the call
; is processed normally.  If set to Data, then if a touch-tone is received
; within the 'Timeout', then the call will be processed as a voice call.
; Otherwise, if after the 'Timeout' period, no touch tone is received, then
; ATA will be sent to the modem and the call will be processed as a data call.
; That is, if "CONNECT" is received from the modem, ANSWER will drop with an
; errorlevel equal to the value of the numeric result code of the connect.
; If no connect is received, ANSWER returns to waiting for calls.
; If set to Fax, the same processing occurs as in Data mode except if a
; "CONNECT" is receive, the call is processed as a FAX call, and ANSWER will
; exit with Fax code errorlevel 33.  Valid parameters are Voice, Data, and
; Fax.  This defaults to Voice.

Mode		Voice		; Answer Voice/Fax/Data mode

; The 'LocalArea' key word is used for outgoing calls.  If the area code of
; the number to be called equals this number, only the remaining seven digits
; of the number to call will be dialed.  Valid parameter is a 3 digit
; telephone area code.  This defaults to no parameter (left blank).

LocalArea			; Local Area Code

; The 'NullPhone' key word is used during local message play and record.  If a
; number is entered here, it will be dialed when messages are played or
; recorded locally.  Some telephone exchanges have a number which you can call
; for testing purposes and will produce just silence.  If no number is entered
; here, a '4' will be dialed every 'DialTime' seconds during play and record.
; This should be a seven digit number, but can be up to 29 ditits.  This
; defaults to no parameter (left blank).

NullPhone			; null connect telephone number

; The 'RemoteCode' key word is the password required to enter the Remote
; Programming Mode.  It can be up to 13 characters long and must be all digits.
; This defaults to 5.

RemoteCode	5		; remote programming mode access code

; The 'RCodeLen' key word tells ANSWER how long the RemoteCode is.  The valid
; parameter range is 1 to 13.  This defaults to 1.

RCodeLen	1		; length of remote access code

; The 'CallBack' key word defines a telephone number used by ANSWER to deliver
; incoming messages.  It may contain up to 29 digits and defaults to blank.
; If the callback is successful, the remote programming mode is entered.

CallBack			; number to call to deliver incoming messages

; The 'CBCount' key word tells ANSWER when to initiate call back.  When the
; number of incoming calls exceeds this number, the CallBack number will be
; dialed.  The valid parameter range is 0 to 255, where 0 disables the call
; back feature.  This defaults to 0 (disabled).  Currently, this is disabled
; in the Voice Mail Box mode, however in a future version, each mail box
; owner will be able to enter a call back number.

CBCount		0		; number of incoming messages before calling

; The 'CBWait' key word tells ANSWER how long to wait between failed call back
; attempts.  If the last call back attempt did not result in delivering
; incoming messages, the attempt will be made again after this number of
; minutes.  The valid parameter range is 1 to 255 and is measured in minutes.
; The default is 30.

CBWait		30		; time between successive call back attempts

; The 'Retries' key word tells ANSWER how many failed attempts to allow while
; outdialing a number.  This only refers to the current dialing attempt (in
; the callback mode, this number of retries is again attempted after CBWait
; minutes).  The valid parameter range is 0 to 255.  The default is 3.  0
; disables all automated outdialing attempts.

Retries		3		; number of times to attempt redialing a number

; The 'Redial' key word tells ANSWER how many seconds to wait between
; successive redials of a number in the outdialing mode.  The valid parameter
; range is 1 to 255 and is measured in seconds.  This defaults to 15.

Redial		15		; redial pause length in seconds

; The 'Timeout' key word tells ANSWER how long to wait for a touch tone
; keypress from the caller before giving up, or prompting again.  The valid
; parameter range is 1 to 255 and is measured in seconds.  This defaults to 3.

Timeout		3		; caller timeout for touch tone key in secs

; The 'Pause' key word tells ANSWER how long of a silence period to accept
; while recording a message.  Valid parameter range is 1 to 255 and is
; measured in seconds.  This defaults to 3.

Pause		3		; pause time in record mode before stop in secs

; The 'DialTime' key word tells ANSWER how often to dial a dummy number when
; recoding and playing messages locally.  Valid parameter range is 1 to 255
; and is measured in seconds.  This defaults to 10.

DialTime	10		; time before dialing a '4' in seconds

; The 'Blank' key word tells ANSWER how long to wait before blanking the screen
; while waiting for calls.  Valid parameter range is 1 to 255 and is measured
; in seconds.  This defaults to 10.

Blank		10		; delay time to screen blank in seconds

; The 'SoundCard' key word tells ANSWER which sound card to use while playing
; and recording messages.  This parameter is unused at present, but will be
; used when support is added for additional sound cards.  Currently, only the
; SoundBlaster is supported and it is auto-detected.  This defaults to 0.

SoundCard	0		; type of sound card to use 4 = SB, 0 = none

; The 'VMCType' key word tells ANSWER which voice mail card or modem to use.
; This defaults to 0.  Valid parameters are:
;
; VMCType	0		; Selects the DigiPhone
; VMCType	1		; Selects the CompuCom
; VMCType	2		; Selects the ZyXEL
; VMCType	3		; Selects the ZOOM

VMCType		3		; type of vmc hardware

; The 'ComAddr' key word tells ANSWER the base address of the voice mail card
; or modem comm port.  Valid parameter range is 0x0200 to 0x3F8 hex.  This
; defaults to 02E8.

ComAddr		03F8		; comm port base address or vmc address

; The 'ComIntr' key words tells ANSWER which interrupt line (IRQ) to use.
; Valid parameter range is 0 to 15.  This defaults to 3.

ComIntr		4		; comm port irq or vmc irq

; The 'ComPort' key word tells ANSWER which number to assign to the above
; ComAddr/ComIntr pair.  This defaults to 4.

ComPort		1		; comm port number

; The 'ComBaud' key word tells ANSWER what baud rate to use for the comm port.
; Valid parameters are valid baud rates.  This defaults to 19200.
; ZOOM Note:  The minimum here should be 38400, and I have not tested it
; at rates above (or for that matter, other) than this. 

ComBaud		38400		; comm port baud rate

;
; Modem Commands
;

; The following key words are used to set modem commands.  Do not alter
; these unless you are sure you know what you are doing.  The only one
; you might have a need to change is the 'ComInit'.  The others should be
; fixed values that only differ from one modem type to another.

; The 'ComInit' key word is the modem initialization string which is sent to
; the modem when ANSWER first starts and when recycling wait for calls mode.

ComInit		ATX4|

; The 'ComDial' key word is the string which is sent to the modem before the
; number to dial.

ComDial		ATDT

; The 'ComGetDTMF' key word is the string which is sent to the modem to
; instruct it to receive a touch tone from the caller.

ComGetDTMF	AT|

; The 'ComRecord' key word is the string which is sent to the modem to
; instruct it to begin recording voice.
; ZOOM Note:  ANSWER looks for the #VSD=15,30 string and alters it to set
; the silence time.  If you change ComRecord or ComPlay, be sure to include
; this mentioned string.

ComRecord	AT#VSS=2#VBS=2#VSP=30#VSD=1#VRX|

; The 'ComPlay' key word is the string which is sent to the modem to instruct
; it to begin playing voice.

ComPlay		AT#VSS=2#VBS=2#VSP=30#VSD=1#VTX|

; The 'ComEnd' key word is the string which is sent to the modem to instruct
; it end recording or playing voice.

ComEnd		AT#VLS=0|

; The 'ComTone' key word is the string which is sent to the modem to instruct
; it to generate an audible tone.

ComTone		AT#VTS

; The 'ComReply' key word is the string which is received from the modem when
; it enters or exits voice play or record mode.

ComReply	OK|
