
#include "pop.h"

struct Library *CxBase;

int setupcx(void)
{

	CxObj *filter, *sender, *translate;

	sprintf(cxname,"AmiPOP(%s)",username);
	newbroker.nb_Name=cxname;

	sprintf(cxdesc,"POP Client for '%s'",username);
	newbroker.nb_Descr=cxdesc;

	if (CxBase = OpenLibrary("commodities.library", 37L) )
	{
		if (amipop_mp = CreateMsgPort() )
		{
			newbroker.nb_Port = amipop_mp;
			broker = CxBroker(&newbroker, NULL);
			if ( broker == NULL  )
			{
				closecx();
				return(0);
			}

			if (hotkey)
			{
				if ( filter=CxFilter(hotkey) )
				{
					AttachCxObj(broker, filter);
					if ( sender=CxSender(amipop_mp, EVT_HOTKEY) )
					{
						AttachCxObj(filter,sender);
						if (translate= CxTranslate(NULL))
						{
							AttachCxObj(filter,translate);
							ActivateCxObj(broker, 1L);
						}
						else
						{
							closecx();
							return(0);
						}
					}
					else
					{
						closecx();
						return(0);
					}
				}
				else
				{
					closecx();
					return(0);
				}
			}

			cxsigflag = 1L << amipop_mp->mp_SigBit;
		}
		else
		{
			closecx();
			return(0);
		}

		return(1);
	}
	else
	{
		closecx();
		return(0);
	}
}

void closecx( void )
{

	CxMsg *msg;

	if (amipop_mp)
	{
         	if (broker) DeleteCxObj(broker);

		while (msg = (CxMsg *)GetMsg(amipop_mp) )
		{
			ReplyMsg( (struct Message *)msg );
		}

		DeleteMsgPort(amipop_mp);
	}

	if (CxBase) CloseLibrary(CxBase);

	cxsigflag=NULL;
	amipop_mp=NULL;
	CxBase=NULL;
	broker=NULL;
}

int docx (void)
{
	CxMsg *msg;
	ULONG msgid;
	int keepgoing=1;

	while (msg = (CxMsg *)GetMsg(amipop_mp) )
	{
		msgid = CxMsgID(msg);
		ReplyMsg( (struct Message *)msg);

		switch(msgid)
		{
			case CXCMD_DISABLE:
				checkper=FALSE;
				GT_SetGadgetAttrs(Project0Gadgets[GD_MYGAD_TIME], Project0Wnd, NULL, GA_Disabled, !checkper,TAG_END);
				GT_SetGadgetAttrs(Project0Gadgets[GD_MYGAD_CRONCHECK], Project0Wnd, NULL, GTCB_Checked, checkper,TAG_END);

    			break;

			case CXCMD_ENABLE:
				checkper=TRUE;
				GT_SetGadgetAttrs(Project0Gadgets[GD_MYGAD_TIME], Project0Wnd, NULL, GA_Disabled, !checkper,TAG_END);
				GT_SetGadgetAttrs(Project0Gadgets[GD_MYGAD_CRONCHECK], Project0Wnd, NULL, GTCB_Checked, checkper,TAG_END);

				break;

			case CXCMD_KILL:
				keepgoing=0;
				break;

			case CXCMD_APPEAR:
				if (winop==FALSE) openup();
				break;

			case CXCMD_DISAPPEAR:
				if (winop) closedown();
				break;

			case CXCMD_UNIQUE:
				if (winop==FALSE) openup();
				doreq("AmiPOP already active\nfor this user","Oops");
				break;

			case EVT_HOTKEY:
				if (winop==FALSE) openup();
				break;
		}
	}
	return(keepgoing);
}

