/*

 11/94 KSG Note:
 Added colors.asm in place of Grumpfish library function

 I did my best at documentation, but it is best to review the demo
 code for usage.

 Included is MAKEFILE.RMK that will create the library

 KSG 06/94
 This version does not need to link in NANFOR.LIB since i have all the
 supporting routines built into this source file.

 KSG 11/94
 Added code from [twocolor.prg] authored by Todd C. MacDonald, who
 placed the code into Public Domain for submission into the nanforum toolkit.
 It allows a mixture of two colors to be displayed on the console. I use it
 to hilight text in the ft_xbox function.

 KSG 11/94
 Added several SetGet functions, along with a UDC to set colors independent
 of ft_xbox.

 KSG 11/94
 Removed colors and boxtypes from parameter list for ft_xBox(), and now
 you select the colors and boxtypes via companion functions.
 See demo code for syntax on colors

 The following section of ft_xbox sets the default border type
 local cBoxColor := xBoxBord()

 When the box is drawn the default boxtype is gotten from xBoxType()
 which is a setget function. You can override the default by passing
 your own character string asper Clipper syntax, ie.

    xBoxType(B_SINGLE+" ")

 dispBox(nTRow,nLCol,nBRow,nRCol,xBoxType(),cBoxColor)

 KSG 11/94
 Removed test function to its own program file

 KSG 11/94
 Ft_xbox() now returns a logical which is of use if you pass "Q" in the
 second parameter <cRetWait> which still takes "W". If you check to see
 the return value w/o using "Q" ft_xbox will always return .T., while
 using "Q", it will return .T. if the user presss "Yy" and .F. for "Nn".
 This allows you to ask a YesNo question. If you pass "W" the return is
 allows .T., which is the same as passing nothing for parameter two.


*/

#xcommand DEFAULT <p> TO <v> => IF <p> == NIL ; <p> := <v> ; END


#define BD_DOUBLE       "ͻȺ "
#define BS_SINGLE       "Ŀ "
#define B_BLANK         space(9)

/*
 * File......: XBOX.PRG
 * Author....: Don Opperthauser
 * Date......: $Date:   17 Aug 1991 15:47:06  $
 * Revision..: $Revision:   1.3  $
 * Log file..: $Logfile:   E:/nanfor/src/xbox.prv  $
 *
 * This is an original work by Don Opperthauser and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 * 
 * --------------------------------------------------------------------------
 * $Log:   E:/nanfor/src/xbox.prv  $
 *
 *    Rev 1.3   17 Aug 1991 15:47:06   GLENN
 * Don Caton fixed some spelling errors in the doc
 *
 *    Rev 1.2   15 Aug 1991 23:05:12   GLENN
 * Forest Belt proofread/edited/cleaned up doc
 *
 *    Rev 1.1   14 Jun 1991 17:55:50   GLENN
 * Fixed bug where extra blank line was displayed in the box.
 *
 *    Rev 1.0   01 Apr 1991 01:02:34   GLENN
 * Nanforum Toolkit
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *     FT_XBOX()
 *  $CATEGORY$
 *     Menus/Prompts
 *  $ONELINER$
 *     Display a self-sizing message box and message
 *  $SYNTAX$
 *     FT_XBOX( [ <cJustType> ], [ <cRetWait> ], [ <nStartRow> ], ;
 *              [ <nStartCol> ], <cLine1>,  <cLine2>, <cLine3>,   ;
 *              <cLine4>, <cLine5>, <cLine6>, <cLine7>, <cLine8> ) -> NIL
 *  $ARGUMENTS$
 *     <cJustType> is a character indicating the type of text justification.
 *     "L" or "l" will cause the text to be left-justified in the box.
 *     Centered text is the default.
 *
 *     <cRetWait> is a character which determines if the function will wait
 *     for a keypress after displaying the box.  "W" or "w" will cause the
 *     function to wait for a keypress before returning control to the
 *     calling routine.  Not waiting is the default
 *
 *     <cBorType> Not used as in original, uses setget functions now
 *                The default is still a DOUBLE box
 *
 *     <cBorColor> Not used as in original, uses setget functions now
 *
 *     <cBoxColor> Not used as in original, uses setget functions now
 *
 *     <nStartRow> is a number denoting the starting row.  If '99' is passed,
 *     the box is centered vertically.  If necessary, nStartRow is decreased
 *     so the entire box can be displayed.
 *
 *     <nStartCol> is a number denoting the starting column.  If '99' is passed,
 *     the box is centered horizontally.  If necessary, nStartCol is decreased
 *     so the entire box can be displayed.
 *
 *     <cLine1> thru <cLine8> are 1 to 8 character strings to be displayed.
 *     They are truncated to fit on the screen if necessary.
 *  $RETURNS$
 *     NIL
 *  $DESCRIPTION$
 *     FT_XBOX() allows the programmer to display a message box on the screen
 *     without needing to calculate the dimensions of the box.  Only the upper
 *     left corner needs to be defined.  The function will calculate the lower
 *     right corner based on the number and length of strings passed.
 *
 *     A maximum of eight strings can be displayed.  If a string is too long
 *     to fit on the screen it is truncated.
 *
 *     The default settings are:
 *        Lines of text are centered.
 *        Control is returned to the calling routine immediately.
 *        A double line border is painted.
 *        The border is bright white on black
 *        The text is white on black.
 *        The box is centered both vertically and horizontally.
 *
 *     WARNING:  Shadowing is achieved by a call to FT_SHADOW(), an assembly
 *               routine not found in this .PRG.  In order to use XBOX,
 *               SHADOW.OBJ must also be present somewhere (if you are using
 *               NANFOR.LIB, then it is).
 *
 *     This version uses a alternate shadow that uses Clipper's GT API
 *     and is perfectly OKay to use w/o any problems. It does not offer
 *     the same option that ft_shadow does, which allows you to select
 *     color to paint the shadow... See shadow.c for more details.
 *
 *  $EXAMPLES$
 *     The following displays a two-line box with default settings:
 *
 *       FT_XBOX(,,,,,,,'This is a test','of the XBOX() function')
 *
 *     The following uses all optional parameters and displays a three-line
 *     box.  The box is left-justified with a double border.  It has a
 *     bright white on black border and white on black text.  The function
 *     will wait for a keypress before returning control to the calling
 *     routine.
 *
 *       FT_XBOX('L','W',5,10,'It is so nice',;
 *                       'to not have to do the messy chore',;
 *                       'of calculating the box size!')
 *  $END$
 */



#translate ISCHAR( <v1> )   => ( valtype( <v1> ) == "C" )
#translate ISNUM( <v1> )    => ( valtype( <v1> ) == "N" )

FUNCTION FT_XBOX(cJustType,cRetWait,nStartRow,nStartCol,cLine1,cLine2,;
         cLine3,cLine4,cLine5, cLine6, cLine7, cLine8                 ;
    )

    local aLines_[8]
    local aOutTxt_[8]
    local cColor,cSayStr
    local nLCol,nRCol,nTRow,nBRow
    local nLoop
    local nSayRow,nSayCol,nNumRows
    local xx
    local yy
    local nLLen     := 0
    local cBoxColor := xBoxBord()
    local cOldColor := setcolor()
    local lRetValue := .T.

    // request to restore a screen
    if valtype(cJustType) == "L"
        if !empty(cJustType)
            FT_RGNSTACK("pop")
            return nil
        endif
    endif

    cJustType  := if(ISCHAR(cJustType), upper(cJustType),"")
    cRetWait   := if(ISCHAR(cRetWait ), upper(cRetWait) ,"")
    nStartRow  := if(ISNUM(nStartRow) , nStartRow       ,99)
    nStartCol  := if(ISNUM(nStartCol) , nStartCol       ,99)
    nNumRows   := min(PCount()-4,8)
    aLines_[1] := if(ISCHAR(cLine1)   , alltrim(Subs(cLine1,1,74)),"")
    aLines_[2] := if(ISCHAR(cLine2)   , alltrim(Subs(cLine2,1,74)),"")
    aLines_[3] := if(ISCHAR(cLine3)   , alltrim(Subs(cLine3,1,74)),"")
    aLines_[4] := if(ISCHAR(cLine4)   , alltrim(Subs(cLine4,1,74)),"")
    aLines_[5] := if(ISCHAR(cLine5)   , alltrim(Subs(cLine5,1,74)),"")
    aLines_[6] := if(ISCHAR(cLine6)   , alltrim(Subs(cLine6,1,74)),"")
    aLines_[7] := if(ISCHAR(cLine7)   , alltrim(Subs(cLine7,1,74)),"")
    aLines_[8] := if(ISCHAR(cLine8)   , alltrim(Subs(cLine8,1,74)),"")

    asize(aLines_ ,min(nNumRows,8))
    asize(aOutTxt_,min(nNumRows,8))

    aeval(aLines_,{|a_,n| aOutTxt_[n] := strtran(a_,chr(1),"")})

    // determine longest line
    // the for/next loop is for a WIP function, not yet here.
    nLoop := 1
    aeval(aOutTxt_,{|| nLLen:=Max(nLLen,Len(aOutTxt_[nLoop])),nLoop++})
    yy := nLoop
    for xx := 1 to nLoop -1
        if empty(aLines_[xx])
            yy--
        endif
    next

    nLCol := if(nStartCol=99,int((76-nLLen)/2),Min(nStartCol,74-nLLen))
    nRCol := nLCol+nLLen+3
    nTRow := if(nStartRow=99,int((24-nNumRows)/2),Min(nStartRow,22-nNumRows))
    nBRow := nTRow+yy
    cColor:= SetColor(cBoxColor)
    ft_rgnstack("push",nTRow,nLCol,nBRow+2,nRCol+2)
    if nLoop >1
        dispBox(nTRow,nLCol,nBRow,nRCol,xBoxType(),cBoxColor)
        ft_shadow(nTRow,nLCol,nBRow,nRCol,8)
        SetColor(xBoxText())
        nLoop := 1
        aeval( aLines_,{ |cSayStr|;
           nSayRow := nTRow+nLoop,;
           nSayCol := if(cJustType = 'L', ;
           nLCol+2,;
           nLCol+2+(nLLen-Int(Len(aOutTxt_[nLoop])))/2),;
           nLoop++,;
            _FTSAY(nSayRow,nSayCol,cSayStr);
                   };
        )

        // wait for keypress if desired
        if cRetWait == 'W'
            ft_sinkey(0)
        endif
        if cRetWait == 'Q'
            lRetValue := Question()
        endif
    endif

    setcolor(cOldColor)
return lRetValue

static function _FTSAY(nRow,nCol,cSayStr)
    if len(cSayStr) >1
        ft_2clrSay(ft_2clrMak(cSayStr,nRow,nCol,xLowColor(),xHiColor()))
        setpos(nRow,nCol +len(cSayStr))
    endif
return nil

*****************************************************************************
* Misc support routines *
*****************************************************************************
*    Author: Kevin S Gallagher
*          :
*  Function: Shadow( <t>, <l>, <b>, <r>[,<x>] )
*          :
*   Purpose: Guess!
*          :
* Arguments: <t>  - Top row of shadow                    -  "N"
*          : <l>  - Left top column of shadow            -  "N"
*          : <b>  - Bottom row of shadow                 -  "N"
*          : <r>  - Bottom right column of the shadow    -  "N"
*          : <x>  - Color attribute for shadow           -  "N"
*          :
*  Comments: The shadow does not paint an entire area, just the
*          : right side and bottom of the first four coordinates.
*          : This helps speed things up.
*          :
*          : This procedure will not be linked in if MY_NANNY
*          : has been defined. Which allows you to use the REAL
*          : ft_shadow if so desired.
*          : Also grump.lib has a shadow routine that could be used!
*
#ifdef MY_NANNY
procedure ft_Shadow( t, l, b, r, x )
    x := if(x == NIL,       7, x)
    x := if(x >8 .or. x < 0,7, x)
    ShadowStrip( b+1, l+1, b+1, r+1, x )
    ShadowStrip( t+1, r+1, b+1, r+1, x )
return
#endif

#ifdef MY_NANNY
static procedure ShadowStrip( t, l, b, r, x )
    local cStrip
    local cTemplate
    cTemplate := replicate('x'+chr(x),len(cStrip := savescreen(t,l,b,r)) /2)
    cStrip    := transform( cStrip, cTemplate )
    restscreen( t, l, b, r, cStrip )
return
#endif

*
* Author....: David A. Richardson
* Tweaker...: Kevin S. Gallagher
*
function ft_rgnstack(cAction, nTop, nLeft, nBottom, nRight)
    static aRgnStack_[0], nStackPtr := 0
    local nPopTop

    if cAction == "push"
        asize(aRgnStack_,++nStackPtr)[nStackPtr] =  ;
                ft_savrgn(nTop,nLeft,nBottom, nRight)

    elseif cAction == "pop" .or. cAction = "pop all"
        nPopTop := if("all" $ cAction, 0, nStackPtr-1)
        if len(aRgnStack_) >0
            while nStackPtr > nPopTop
                FT_RSTRGN(aRgnStack_[nStackPtr--])
            enddo
        endif
        asize(aRgnStack_, nStackPtr)
    endif
return nil

*
* Author....: David A. Richardson
*
function ft_savrgn(nTop, nLeft, nBottom, nRight)
return (CHR(nTop) + CHR(nLeft) + CHR(nBottom) + CHR(nRight) + ;
      SAVESCREEN(nTop, nLeft, nBottom, nRight))

*
* Author....: David A. Richardson
*
function ft_rstrgn(cScreen, nTop, nLeft)
    if pcount() == 3
        restscreen(nTop,nLeft,(nTop - asc(cScreen)) + asc(subs(cScreen,3)),;
        (nLeft - asc(subs(cScreen, 2))) + asc(subs(cScreen, 4)), ;
        subs(cScreen, 5))
    else
        restscreen(asc(cScreen),asc(subs(cScreen, 2)),asc(subs(cScreen,3)),;
        asc(subs(cScreen,4)), subs(cScreen,5))
   endif
return nil



