
From: Kevin S. Gallagher [70034,2313]
  To: ?
Subj: ft_xbox() modifications

The original ft_xbox that is in the Nanforum ToolKit II is a nice box
function, but as i saw it needed a few enchancements. The first thing
that was needed was code to save the current applications colors that
were being used prior to a call to ft_xbox, and then restore then, so
i added a local to do this. At this point it i figured it was done!
But as the story goes, its never done <g>.

In a nutshell:

    1. I removed some of the original parameters, and now use SetGet
       functions in place of the removed parameters. Also added some
       support functions.

    2. Incorporated modified code from FT_RGNSTACK so that it couldn't
       cause things like BASE/1132's

    3. Added ft_2clrSay(), which allows enchance colors in ft_xbox
            a. added color_s2n from grump.lib
            b. removed color_s2n, and replaced with Clr2Attr() so
               that i could upload to others w/o breaking any (c)'s
               from Greg Lief's Grumpfish library.




    FT_XBOX([<cJustType>],[<RetWait>],[<nStartRow>],[<nStartCol>],  ;
            <cLine1>, <cLine2>, <cLine3>, <cLine4>, <cLine5>,       ;
            <cLine6>, <cLine7>, <cLine8>                            )

    Arguments (cut/pasted from Nanforum ToolKit NG file)
    ----------------------------------------------------

    <cJustType> is a character indicating the type of text justification.
    "L" or "l" will cause the text to be left-justified in the box.
    Centered text is the default.

    <cRetWait> is a character which determines if the function will wait
    for a keypress after displaying the box.  "W" or "w" will cause the
    function to wait for a keypress before returning control to the
    calling routine.  Not waiting is the default

    <nStartRow> is a number denoting the starting row.  If '99' is passed,
    the box is centered vertically.  If necessary, nStartRow is decreased
    so the entire box can be displayed.

    <nStartCol> is a number denoting the starting column.  If '99' is passed,
    the box is centered horizontally.  If necessary, nStartCol is decreased
    so the entire box can be displayed.

    <cLine1> thru <cLine8> are 1 to 8 character strings to be displayed.
    They are truncated to fit on the screen if necessary.

    By adding pairs of chr(1)'s you can hilight text within any of the lines
    in the box.

     The following UDC basicly changes some or all colors used by ft_xbox

    #xcommand XBOX COLORS                      ;
        [BOX <cBox>]                           ;
        [TEXT <cText>]                         ;
        [REGULAR <cLow>]                       ;
        [HILIGHT <cHi>]                        ;
                                            => ;
        xboxcolors( <cBox>, <cText>, <cLow>, <cHi>)


     This UDC changes the border and text colors only for ft_xbox

    #xcommand FT_XCOLORS( <c> )             => ;
        xBoxBord( <c> )                       ;;
        xBoxText( xBoxBord() )

     This UDC changes the regular/hilite colors used to show text in
      the lines of text in ft_xbox (seealso twocolors.prg).

    #xcommand FT_NCOLORS( <s1>, <s2> )      => ;
        xLowColor( <s1> )                     ;;
        xHiColor( <s2> )

     Use the following translation definitions for using ft_xbox as a
      GetBox (see demo code in test.prg)

    #xtranslate FT_XSPACES( <n> )           => ;
        replicate(chr(255), <n> )

    #xtranslate FT_LSPACE( <s> )            => ;
        replicate(chr(255), len( <s> ) )




