/*

    P O W E R   P A C K E D   P R I N T O U T S
    Copyright (c) 1994
    Stephen L. Woolstenhulme
    All Rights Reserved

    CIS:  73060,1302

*/

// PPPdemo.prg:   demo program turns default directory into a report.

#include "ppp.ch"
#include "inkey.ch"

function PPPdemo()
   local i
   local aItem := {}
   local nFiles := 0
   local nSize := 0

   // get data for the report.  
   local aDirectory := directory( '*.*' )
   
   // set up page and column headers.
   local aPageHead := { 'Files in ' + curdir(), date(), '' }
   
   local aColumnHead := { ;
      '===================================================', ;
      'File              Size       Date      Time    Attr', ;
      '============  ===========  ========  ========  ====' ;
      }
   
   // Store the new values into the static array.  Note you need store
   // only values you want changed.  All others can be left to default
   // values.

   // See PPP.CH for a list of all variables you can set.

   pppSet( PPP_PAGEHEAD,    aPageHead   )  // set new page header. 
   pppSet( PPP_COLUMNHEAD,  aColumnHead )  // set new column header.
   pppSet( PPP_COLUMNSPACE, 2 )            // double space between columns.
   pppSet( PPP_DESPOOL, .f. )              // gather before printing.
   pppSet( PPP_COPIES, 1 )                 // don't waste paper <g>.

   // Stick in code to set 80 column print on an HP.  Use chr( 18 ) on Epson.
   pppSet( PPP_PRNINIT, chr(27) + chr(38) + 'k0S' )
   
   // And a printer reset afterward.
   pppSet( PPP_PRNRESET, chr(27) + 'E' )

   if ! pppInit() == 'E'                   // Returns S for screen, P for
                                           // printer, F for file, or 
                                           // E for exit.  You can optionally
                                           // pass in S or P as a parameter
                                           // and the program won't pause to
                                           // ask.
      
      // let's sort it to make it pretty.  This slows things just a bit.
      aDirectory := asort( aDirectory,,, { | x, y | x[1] < y[1] } )

      for i := 1 to len( aDirectory )
         
         // build an array of items to send.  
         aItem := array( 5 )
         aItem[1] := strtran( aDirectory[ i, 1 ], '.', space( 13 - len( aDirectory[ i, 1 ] ) ) )
         aItem[2] := transform( aDirectory[ i, 2 ], '999,999,999' )
         aItem[3] := aDirectory[ i, 3 ]
         aItem[4] := aDirectory[ i, 4 ]
         aItem[5] := padc( aDirectory[ i, 5 ], 4 )
         
         // send array to be printed, with each element as a separate column.
         pppLine( aItem )

         // accumulate totals.
         nFiles++
         nSize += aDirectory[ i, 2 ]

         if stopNow()
            exit
         endif

      next
      
      // print underlines.
      pppLine( aColumnHead[ 3 ] )
      
      // format and print grand totals.
      aItem := { padr( ltrim( str( nFiles ) ) + ' files', 12 ), ;
                 transform( nSize, '999,999,999' ) }
      pppLine( aItem )

      // adds final underline, lets user browse;
      // cleans up temp files and clears settings after.
      pppDone()
   endif

return NIL


Function stopNow
   local nPause := inkey()
   local lRetVal := .f.

   if ! nPause == 0
      lRetVal := alert( ' You pressed a key.  Please select... ', ;
                      { ' Continue ' , ' Quit ' }  ) == 2
   endif

return lRetVal
