*:*****************************************************************************
*:
*: Procedure file: E:\MAILMERG\PRB_POP.PRG
*:
*:         System: Mail Merge
*:         Author: Phil Barnett
*:      Copyright (c) NONE, Donated to Public Domain June 1994
*:  Last modified: 06/26/94     23:49
*:
*:  Procs & Fncts: ATTENTION()
*:               : POP_MSG()
*:               : POP_MSGSCR()
*:               : CNT()
*:               : C()
*:               : AMAXSTRLEN()
*:               : VERIFY()
*:               : ASK_FOR()
*:               : CLS()
*:
*:         Set by: MERGE()            (function  in MERGE.PRG)
*:
*:      Documented 06/26/94 at 23:50                SNAP!  version 5.02
*:*****************************************************************************
#include "common.ch"
#include "box.ch"
#include "set.ch"

static THISSCRN,TL,BOXHIGH

*!*****************************************************************************
*!
*!       Function: POP_MSG()
*!
*!      Called by: MERGE()            (function  in MERGE.PRG)
*!               : MERGPRNT()         (function  in MERGPRNT.PRG)
*!               : VERIFY()           (function  in PRB_POP.PRG)
*!               : ASK_FOR()          (function  in PRB_POP.PRG)
*!               : EXPAND_TXT()       (function  in NEWXPND.PRG)
*!
*!          Calls: ISARRAY()          (function  in ?)
*!               : ATTENTION()        (function  in PRB_POP.PRG)
*!
*!*****************************************************************************
function POP_MSG( SOME_TXT, MSG_LOGIC, BORDCOLOR, MAINCOLOR )

local MAXLEN, x, ARLEN, INCOLOR, CROW, CCOL, LC

Default MSG_LOGIC to .t.

Default BORDCOLOR to 'B+/W'
Default MAINCOLOR to 'N/W,W+/B'

if !ISARRAY( SOME_TXT )
   SOME_TXT := { SOME_TXT }
endif

ARLEN := len( SOME_TXT )

TL := ( maxrow() / 2 ) - ( ( ARLEN / 2 ) + 2 )

MAXLEN := min( Maxcol() - 4, max( Amaxstrlen( SOME_TXT ), 25 ) + 6 )

BOXHIGH := ARLEN + 2
THISSCRN := Savescreen( TL - 2, 0, BOXHIGH + TL + 1, Maxcol() )
CROW = row()
CCOL = col()

LC := int( ( Maxcol() - MAXLEN ) / 2 )

dispbox( TL-1, LC, BOXHIGH+TL, LC+MAXLEN-1, B_DOUBLE_SINGLE + ' ', BORDCOLOR )

dispbegin()

INCOLOR := setcolor( MAINCOLOR )

for x := 1 to ARLEN
   cnt( SOME_TXT[ x ], TL + x )
next

dispend()

if MSG_LOGIC
   ATTENTION( 'Press any key to continue', BOXHIGH + TL )
   inkey(0)
   restscreen( TL - 2, 0, BOXHIGH + TL + 1, 79, THISSCRN )
   THISSCRN := ''
   devpos( CROW, CCOL )
endif

setcolor( INCOLOR )

return NIL

*!*****************************************************************************
*!
*!       Function: POP_MSGSCR()
*!
*!      Called by: MERGPRNT()         (function  in MERGPRNT.PRG)
*!               : VERIFY()           (function  in PRB_POP.PRG)
*!               : ASK_FOR()          (function  in PRB_POP.PRG)
*!
*!*****************************************************************************
function POP_MSGSCR()

restscreen( TL - 2, 0, BOXHIGH + TL + 1, 79, THISSCRN )

THISSCRN := ''

return NIL

*!*****************************************************************************
*!
*!       Function: ATTENTION()
*!
*!      Called by: MERGE()            (function  in MERGE.PRG)
*!               : POP_MSG()          (function  in PRB_POP.PRG)
*!               : MERGEDIT()         (function  in MERGEDIT.PRG)
*!               : MERGPRNT()         (function  in MERGPRNT.PRG)
*!               : EXPAND_TXT()       (function  in NEWXPND.PRG)
*!               : M_EDIT()           (function  in MERGEDIT.PRG)
*!
*!*****************************************************************************
function ATTENTION( CSTRING, NLINENUM, CCOLOR )

local COLDCOLOR, STR_LEN

Default NLINENUM to 24
Default CCOLOR to 'GR+/R'

COLDCOLOR := setcolor( CCOLOR )

CSTRING := '  '+alltrim( CSTRING ) + '  '

devpos( NLINENUM, c( CSTRING ) )

devout( CSTRING )

setcolor( COLDCOLOR )

return NIL

*!*****************************************************************************
*!
*!       Function: CNT()
*!
*!*****************************************************************************
function cnt( CSTRING, NLINENUM )

devpos( NLINENUM, c( CSTRING ) )

devout( CSTRING )

return NIL

*!*****************************************************************************
*!
*!       Function: C()
*!
*!*****************************************************************************
function c( CSTRING )

return max( ( Maxcol() / 2 ) - int( len( CSTRING ) / 2 ), 0 )

*!*****************************************************************************
*!
*!       Function: AMAXSTRLEN()
*!
*!          Calls: ISARRAY()          (function  in ?)
*!
*!*****************************************************************************
function Amaxstrlen( ANARRAY )

local ARLEN, THISLEN, max := 0, x

if ISARRAY( ANARRAY )
   
   ARLEN := len( ANARRAY )
   
   for x := 1 to ARLEN
      THISLEN := len( ANARRAY[ X ] )
      if THISLEN > max
         max := THISLEN
      endif
   next
   
endif

return max

*!*****************************************************************************
*!
*!       Function: VERIFY()
*!
*!      Called by: MERGEDIT()         (function  in MERGEDIT.PRG)
*!               : MERGPRNT()         (function  in MERGPRNT.PRG)
*!
*!          Calls: ISLOGIC()          (function  in ?)
*!               : ISARRAY()          (function  in ?)
*!               : POP_MSG()          (function  in PRB_POP.PRG)
*!               : POP_MSGSCR()       (function  in PRB_POP.PRG)
*!
*!*****************************************************************************
function VERIFY( SOME_TXT, LNORMANS, YES_PRMPT, NO_PRMPT, BORDCOLOR, MAINCOLOR )

local INCOLOR, VERI, ARLEN

Default BORDCOLOR to 'W+/R'
Default MAINCOLOR to 'W+/R,W+/B'

LNORMANS := iif( ISLOGIC( LNORMANS ), LNORMANS, .t. )
YES_PRMPT := iif( YES_PRMPT = NIL, ' YES ', ' ' + alltrim( YES_PRMPT ) + ' ' )
NO_PRMPT := iif( NO_PRMPT = NIL, ' NO ', ' ' + alltrim( NO_PRMPT )+' ' )

if !ISARRAY( SOME_TXT )
   SOME_TXT := { SOME_TXT }
endif

ARLEN := len( SOME_TXT ) + 2

asize( SOME_TXT, ARLEN )

SOME_TXT[ ARLEN - 1 ] := ''
SOME_TXT[ ARLEN ] := ''

POP_MSG( SOME_TXT, .f., BORDCOLOR, MAINCOLOR )

VERI := iif( LNORMANS, 1, 2 )

INCOLOR := setcolor( MAINCOLOR )
@ TL - 2 + BOXHIGH, 33-( len( YES_PRMPT ) / 2 ) prompt YES_PRMPT
@ TL - 2 + BOXHIGH, 46-( len( NO_PRMPT  ) / 2 ) prompt NO_PRMPT

menu to VERI

POP_MSGSCR()

setcolor( INCOLOR )

return ( VERI == 1 )

*!*****************************************************************************
*!
*!       Function: ASK_FOR()
*!
*!      Called by: MERGEDIT()         (function  in MERGEDIT.PRG)
*!               : MERGPRNT()         (function  in MERGPRNT.PRG)
*!
*!          Calls: ISARRAY()          (function  in ?)
*!               : ISCHARACTER()      (function  in ?)
*!               : ISDATE()           (function  in ?)
*!               : ISNUMBER()         (function  in ?)
*!               : POP_MSG()          (function  in PRB_POP.PRG)
*!               : POP_MSGSCR()       (function  in PRB_POP.PRG)
*!
*!*****************************************************************************
function ASK_FOR( SOME_TXT, Getvar, PICVAR, BORDCOLOR, MAINCOLOR )

local GETLIST := {}

local INCOLOR := setcolor()
local INCURSOR := set( _SET_CURSOR )
local ARLEN, VCNT, RETVAL
local CROW := row()
local CCOL := col()

Default BORDCOLOR to 'G+/GR'
Default MAINCOLOR to 'GR+/GR,W+/B,,,W+/N'

if !ISARRAY( SOME_TXT )
   SOME_TXT := { SOME_TXT }
endif

ARLEN := len( SOME_TXT ) + 2

asize( SOME_TXT, ARLEN )

do case
case ISCHARACTER( Getvar )
   VCNT := c( Getvar )
case ISDATE( Getvar )
   VCNT := 35
case ISNUMBER( Getvar )
   VCNT := c( PICVAR )
otherwise
   VCNT := Maxcol() / 2
endcase

SOME_TXT[ ARLEN - 1 ] := ''
SOME_TXT[ ARLEN ] := space( ( ( Maxcol() / 2 ) - VCNT ) * 2 )

POP_MSG( SOME_TXT, .f., BORDCOLOR, MAINCOLOR )


setcolor( MAINCOLOR )

if ISDATE( Getvar )
   @ TL + BOXHIGH - 2, VCNT get Getvar
else
   @ TL + BOXHIGH - 2, VCNT get Getvar picture PICVAR
endif

set cursor ( .t. )
read
set( _SET_CURSOR, INCURSOR )

POP_MSGSCR()

RETVAL := Getvar

if ISCHARACTER( Getvar )
   Getvar := alltrim( Getvar )
endif

setcolor( INCOLOR )
devpos( CROW, CCOL )

return RETVAL

*!*****************************************************************************
*!
*!       Function: CLS()
*!
*!*****************************************************************************
function Cls( NEWCOLOR, BKGCHR )

Default NEWCOLOR to 'GB+/N,R/W,,,W+/N'
Default BKGCHR to 177

setcolor( NEWCOLOR )

dispbox( 0, 0, maxrow(), Maxcol(), replicate( chr( BKGCHR ), 9 ) )

return NIL

*: EOF: PRB_POP.PRG
