*:*****************************************************************************
*:
*: Procedure file: E:\MAILMERG\MERGPRNT.PRG
*:
*:         System: Mail Merge
*:         Author: Phil Barnett
*:      Copyright (c) NONE, Donated to Public Domain June 1994
*:  Last modified: 06/26/94     23:50
*:
*:  Procs & Fncts: MERGPRNT()
*:
*:      Documented 06/26/94 at 23:50                SNAP!  version 5.02
*:*****************************************************************************
#include 'mailmerg.ch'
#include 'common.ch'

*!*****************************************************************************
*!
*!       Function: MERGPRNT()
*!
*!      Called by: MERGE()            (function  in MERGE.PRG)
*!
*!          Calls: VERIFY()           (function  in PRB_POP.PRG)
*!               : POP_MSG()          (function  in PRB_POP.PRG)
*!               : ATTENTION()        (function  in PRB_POP.PRG)
*!               : ASK_FOR()          (function  in PRB_POP.PRG)
*!               : CR_COUNT()         (function  in ?)
*!               : EXPAND_TXT()       (function  in NEWXPND.PRG)
*!               : POP_MSGSCR()       (function  in PRB_POP.PRG)
*!
*!*****************************************************************************
function MERGPRNT( TXT )

local MSG:={}, PAGE_PAUSE, ABORTED, header, FOOTER, HST, HEND, FST, FEND
local GOTFOOTER, GOTHEADER, LINES_USED, OUTFILE := space(40)
local LINK_DATAEND := at( HEADER_SEPARATOR, txt )
LOCAL SPLIT, DATA_FILE, LINK_DATA, PAGE_LENGTH

if LINK_DATAEND > 0
   LINK_DATA := mmheadtake( @txt )
else
   POP_MSG('Use the Edit function to link this mailmerge to data')
   RETURN .F.
endif

Cls()

ABORTED := .f.

DATA_FILE   := link_data[ 1 ]
page_length := link_data[ 2 ]
PAGE_PAUSE  := link_data[ 3 ]

if !file( data_file )
   pop_msg( data_file +' was not found')
   return nil
endif

if select( 'FILE_BASE' ) > 0
   select FILE_BASE
else
   select 0
endif
use ( DATA_FILE ) alias FILE_BASE
go top

* get the header

HST := at( LEFTPDELIM + 'HEADSTART' + RIGHTPDELIM, TXT )
HEND := at( LEFTPDELIM + 'HEADEND' + RIGHTPDELIM, TXT )

GOTHEADER := HST > 0 .and. HEND > 0

if GOTHEADER
   header := substr( TXT, HST + 11, HEND - HST - 13 )
   TXT := left( TXT, HST - 1 ) + substr( TXT, HEND + 11 )
endif

* get the footer

FST := at( LEFTPDELIM + 'FOOTSTART' + RIGHTPDELIM, TXT )
FEND := at( LEFTPDELIM + 'FOOTEND' + RIGHTPDELIM, TXT )

GOTFOOTER := FST > 0 .and. FEND > 0

if GOTFOOTER
   FOOTER := substr( TXT, FST + 13, FEND - FST - 13 )
   TXT := left( TXT, FST - 1 ) + substr( TXT, FEND + 11 )
endif

if VERIFY( 'Redirect output to a file?' )
   ASK_FOR( 'Enter the name of the output file', @OUTFILE, '@!' )
   if Empty( OUTFILE )
      POP_MSGSCR()
      return NIL
   endif
   set printer to ( OUTFILE )
endif

set print (.t.)
set console (.f.)

do while !eof()
   
   LINES_USED := 0
   
   if GOTHEADER
      LINES_USED += CR_COUNT( header )
   endif
   
   if GOTFOOTER
      LINES_USED += CR_COUNT( FOOTER )
   endif
   
   * print the header
   
   if GOTHEADER
      EXPAND_TXT( header, @ABORTED )
   endif
   
   do while LINES_USED < PAGE_LENGTH - 3 .and. !eof()
      
      LINES_USED += EXPAND_TXT( TXT, @ABORTED )
      
      if ABORTED
         exit
      endif
      
      skip
      
   enddo
   
   * print the footer
   
   if GOTFOOTER
      EXPAND_TXT( FOOTER, @ABORTED )
   endif
   
   if PAGE_PAUSE
      inkey( 0 )
   endif
   
enddo

set print (.f.)
set console (.t.)

return NIL

*: EOF: MERGPRNT.PRG
