#INCLUDE "MAILMERG.CH"

function mmheadmake( aData )

// this function saves a single dimentional array to a string

local nArrayLen := len( aData )
local x
local text_out := ''

for x := 1 to nArrayLen
   text_out += valtype( aData[ x ] ) + STRINGIFY( aData[ x ] ) + MINOR_SEPARATOR
NEXT

RETURN TEXT_OUT + HEADER_SEPARATOR


FUNCTION MMHEADTAKE( MERGE_TXT )

// PASS MERGE_TXT BY REFERENCE AND THE HEADER WILL BE REMOVED

LOCAL aOutArry := {}
LOCAL nHeaderLoc := at( HEADER_SEPARATOR, MERGE_TXT )
LOCAL cHeader := left( merge_txt, nHeaderLoc - 1 )
LOCAL nSepAt := at( MINOR_SEPARATOR, cHeader )
LOCAL cThisPart, cThisType

merge_txt := substr( merge_txt, nHeaderLoc + len( HEADER_SEPARATOR ) )

do while nSepAt > 0

   cThisType := left( cHeader, 1 )
   cThisPart := substr( left( cHeader, nSepAt - 1 ), 2 )

   do case
   case cThisType == 'C'
           aadd( aOutArry, cThisPart )
   case cThisType == 'N'
           aadd( aOutArry, val( cThisPart ) )
   case cThisType == 'D'
           aadd( aOutArry, ctod( cThisPart ) )
   case cThisType == 'L'
           aadd( aOutArry, cThisPart == 'True' )
   otherwise
           aadd( aOutArry, NIL )
   endcase

   cHeader := substr( cHeader, nSepAt + len( MINOR_SEPARATOR ) )
   nSepAt := at( MINOR_SEPARATOR, cHeader )

ENDDO

return aOutArry

function STRINGIFY( ANY_VAR )

local UNK_TYPE := valtype( ANY_VAR )
local RETVAL := ''

do case
case UNK_TYPE = 'C'
  RETVAL := ANY_VAR
case UNK_TYPE = 'N'
  RETVAL := str( ANY_VAR )
case UNK_TYPE = 'D'
  RETVAL := dtoc( ANY_VAR )
case UNK_TYPE = 'L'
  RETVAL := iif( ANY_VAR, 'True', 'False' )
endcase

return RETVAL

