*:*****************************************************************************
*:
*: Procedure file: E:\MAILMERG\MERGEDIT.PRG
*:
*:         System: Mail Merge
*:         Author: Phil Barnett
*:      Copyright (c) NONE, Donated to Public Domain June 1994
*:  Last modified: 06/26/94     23:49
*:
*:  Procs & Fncts: MERGEDIT()
*:               : M_EDIT()
*:               : MEMO_FUNC()
*:
*:      Documented 06/26/94 at 23:50                SNAP!  version 5.02
*:*****************************************************************************
#include 'mailmerg.ch'
#include 'inkey.ch'
#include 'common.ch'

static P_PROMPTS:={}
static P_TOKENS:={}
static FNAMES := {}
static LINK_DATA := ''

*!*****************************************************************************
*!
*!       Function: MERGEDIT()
*!
*!      Called by: MERGE()            (function  in MERGE.PRG)
*!
*!          Calls: ATTENTION()        (function  in PRB_POP.PRG)
*!               : PICKFILE()         (function  in PICKFILE.PRG)
*!               : ASK_FOR()          (function  in PRB_POP.PRG)
*!               : VERIFY()           (function  in PRB_POP.PRG)
*!               : M_EDIT()           (function  in MERGEDIT.PRG)
*!
*!    Other Files: FILE_NAME
*!
*!*****************************************************************************
function MERGEDIT( )

local x, FILE_NAME, WHEREAT, Handle, TXT

Cls()
ATTENTION( 'Select a Text File to Edit', 5 )
ATTENTION( 'Press <Esc> to start a new Text File.', 23 )

FILE_NAME := PICKFILE( "*.MRG", '' )

* Make sure file exists
if lastkey() = 27 .or. Empty( FILE_NAME )
   
   FILE_NAME := space(40)
   
   * Get the name of file
   ASK_FOR({'Enter Name of new Text File',;
            '(No extension, .MRG will be appended)'},;
            @FILE_NAME,'@!')

   if Empty(FILE_NAME)
      return NIL
   endif
   
   WHEREAT := at( '.', FILE_NAME )
   if !Empty(WHEREAT)
      FILE_NAME += left(FILE_NAME,WHEREAT-1)
   endif
   
   WHEREAT := at( '.MRG', FILE_NAME )
   if Empty(WHEREAT)
      FILE_NAME += '.MRG'
   endif
   
   if VERIFY('Create '+FILE_NAME+'?',.t.,'Create','Abort')
      Handle := fopen(FILE_NAME)
      fclose(Handle)
   endif
endif

Cls()

select PR_CODES

x := reccount()

asize( P_PROMPTS, x )
asize( P_TOKENS,  x )

x := 1
go top
do while !eof()
   P_PROMPTS[ x ] := PR_CODES->PR_PROMPT
   P_TOKENS[ x ]  := PR_CODES->PR_TOKEN
   x++
   skip
enddo

M_EDIT( FILE_NAME )

close

setcursor(1)

Cls()

asize( P_PROMPTS, 0 )
asize( P_TOKENS,  0 )
asize( FNAMES, 0 )

return NIL

*!*****************************************************************************
*!
*!       Function: M_EDIT()
*!
*!      Called by: MERGEDIT()         (function  in MERGEDIT.PRG)
*!
*!          Calls: ATTENTION()        (function  in PRB_POP.PRG)
*!               : MEMO_FUNC()        (function  in MERGEDIT.PRG, called from MemoEdit())
*!
*!*****************************************************************************
function M_EDIT( FILE_NAME )

local TXT       := memoread( FILE_NAME )
local LINK_DATAEND := at( HEADER_SEPARATOR, txt )
LOCAL INSCREEN, DATA_FILE, SPLIT

if LINK_DATAEND > 0
   LINK_DATA := mmheadtake( @txt )
else

   EDIT_LINK_DATA( TXT )
   IF LASTKEY() == 27
      POP_MSG('You must select a file before you can edit')
      RETURN nil
   ENDIF
   LINK_DATA := mmheadtake( LINK_DATA )
endif


DATA_FILE := LINK_DATA[ 1 ]

if !file( data_file)
   pop_msg( data_file +' was not found')
   return nil
endif

if select( 'FILE_BASE' ) > 0
   select file_base
else
   select 0
endif
use ( DATA_FILE ) alias FILE_BASE

asize( FNAMES, fcount() )
afields( FNAMES )

* force initial insert mode
readinsert( .t. )

setcolor( 'G+/BG' )

@ 0, 0 to 0, 79 double
ATTENTION( 'Mail Merge Text Editor', 0 )
@ 23,0 to 23,79 double
@ 23,40 say ' Current Text File: ' + FILE_NAME + ' '
ATTENTION( '^W-Save  <Esc>-Abort  <F3>-Fields  <F4>-Printer Codes  <F5>-Link Data', 24 )
setcolor( 'N/BG' )
TXT := memoedit( TXT, 1, 0, 22, 79, .t., "memo_func" )

if !lastkey()=27
   txt := MMHEADMAKE( LINK_DATA ) + txt
   memowrit( FILE_NAME, TXT )
endif

Cls()

return NIL

*!*****************************************************************************
*!
*!       Function: MEMO_FUNC()
*!
*!      Called by: M_EDIT()           (function  in MERGEDIT.PRG)
*!
*!          Calls: POPAPICK()         (function  in POPAPICK.PRG)
*!
*!*****************************************************************************
function MEMO_FUNC( MODE, line, col )

local RET_VAL, LKEY, FIELD_NUM, SAVE_SCR, KEYSTROKES

setcursor( 0 )
@ 23,6 say " Line: "+substr( ltrim( str( line, 4 ) ) + space( 4 ), 1, 4 )
@ 23,17 say " Col: "+substr( ltrim( str( col, 4 ) ) + space( 4 ), 1, 4 )
setcursor( 1 )

if MODE == MEMO_STARTUP
   RET_VAL := MEMO_DEFAULT
else
   LKEY := lastkey()
   do case
   case LKEY == K_F3
      setcolor( 'GR+/GR,W+/B,,,W+/N' )
      FIELD_NUM := POPAPICK( 1, 60, 22, 71, FNAMES )
      setcolor( 'N/BG' )
      if FIELD_NUM != 0
         KEYSTROKES := LEFT_DELIM + trim( FNAMES[ field_num ] ) + RIGHT_DELIM
         keyboard KEYSTROKES
      endif
      RET_VAL := MEMO_IGNORE
   case LKEY == K_F4
      setcolor( 'GR+/GR,W+/B,,,W+/N' )
      FIELD_NUM := POPAPICK( 1, 40, 22, 71, P_PROMPTS )
      setcolor( 'N/BG' )
      if FIELD_NUM != 0
         KEYSTROKES := LEFTPDELIM + trim( P_TOKENS[ field_num ] ) + RIGHTPDELIM
         keyboard KEYSTROKES
      endif
      RET_VAL := MEMO_IGNORE
   case LKEY == K_F5
      EDIT_LINK_DATA()
      RET_VAL := MEMO_IGNORE
   otherwise
      RET_VAL := MEMO_DEFAULT
   endcase
endif

return RET_VAL

FUNCTION EDIT_LINK_DATA( TXT )

local inscreen
local DATA_FILE
local page_length
local PAGE_PAUSE
LOCAL SPLIT

LINK_DATA   := mmheadtake( TXT )

IF HEADER_SEPARATOR $ TXT
   DATA_FILE   := link_data[ 1 ]
   PAGE_LENGTH := link_data[ 2 ]
   PAGE_PAUSE  := link_data[ 3 ]
ELSE
   DATA_FILE   := ''
   PAGE_LENGTH := 66
   PAGE_PAUSE  := .F.
ENDIF

if verify('Do you want to change the data link to this .MRG file?')
   inscreen := savescreen( 0, 0, 24, 79 )
   ATTENTION( 'Select a .DBF File to Merge', 5 )
   DATA_FILE := PICKFILE( "*.DBF", DATA_FILE )

   page_length := ask_for('Enter the page length',IIF( PAGE_LENGTH > 0, page_length, 66 ), '999')

   PAGE_PAUSE := VERIFY( 'Pause between Pages?', PAGE_PAUSE, 'Pause', 'Continuous' )

   restscreen( 0, 0, 24, 79, inscreen)
endif

if !empty( DATA_FILE )
   if select( 'FILE_BASE' ) > 0
      select file_base
   else
      select 0
   endif
   use ( DATA_FILE ) alias FILE_BASE
endif

LINK_DATA := mmheadmake( { DATA_FILE, page_length, page_pause } )

RETURN nIL

*: EOF: MERGEDIT.PRG
