
/*
   ==============================================================
   Programa de Ejemplo para determinar la efectividad de MINIMEMO
   ==============================================================
                    (c) 1.993 by Swansoft
                        made in spain
   ==============================================================
*/

#define TAB    chr(9)
#define CR_LF  chr(13) + chr(10)
#define LOOPS  1000

procedure main()

   local i, j
   local apos
   local ctexto
   local creport
   local nelapsed

   ctexto  := memoread( "memos.txt" )
   creport := ""

   j := seconds()

   scroll()
   for i = 1 to mlcount( ctexto )
      ? memoline( ctexto,, i )
   next

   nelapsed := seconds() - j
   creport += "Display       :" + str( nelapsed, 10, 2 ) + CR_LF

   /*
   // Let's replace the awfull loop with something more elegant :
   memoshow( ctexto )
   */

   /*    Test code
   for i := 1 to 5
      ? mlpos( ctexto, 79, i )
      ?? " : " + substr( cTexto, mlpos( cTexto, 79, i ), 10 ) + " : "
      for j := 0 to 6
         ?? str( mlctopos( ctexto, 79, i, j ), 4 )
         ?? "[" + substr( ctexto, mlctopos( ctexto, 79, i, j ), 1 ) + "]"
      next
   next

   for i := 1 to 3

      for j:=1 to 3
         ? str( i, 2 ) + str( j, 2)
         ?? str( mlctopos( ctexto, 79, i, j ), 3 ) + " - "

         apos = mpostolc( ctexto, 79, mlctopos( ctexto, 79, i, j ) )
         ?? str( apos[1], 2 )
         ?? str( apos[2], 2 )
      next

   next

   ? mlcount( ctexto )
   */

   inkey(0)

   // -------------- MLCOUNT
   j := seconds()
   for i := 1 to LOOPS
      mlCOUNT( ctexto )
   next

   nelapsed := seconds() - j

   ? "MLCOUNT :"
   ?? nelapsed

   creport += "mlCount       :" + str( nelapsed, 10, 2 ) + CR_LF

   // -------------- MEMOLINE
   j := seconds()
   for i := 1 to LOOPS
      memoline( ctexto, 79, 15 )
   next

   nelapsed := seconds() - j

   ? "MEMOLINE :"
   ?? nelapsed

   creport += "memoLine      :" + str( nelapsed, 10, 2 ) + CR_LF

   // -------------- MEMOTRAN
   j := seconds()
   for i := 1 to LOOPS
      memotran( ctexto )
   next

   nelapsed := seconds() - j

   ? "MEMOTRAN :"
   ?? nelapsed

   creport += "memoTran      :" + str( nelapsed, 10, 2 ) + CR_LF

   // -------------- MLCTOPOS
   j := seconds()
   for i := 1 to LOOPS
      mlctopos( ctexto, 79, 15, 18 )
   next

   nelapsed := seconds() - j

   ? "MLCTOPOS :"
   ?? nelapsed

   creport += "mLcToPos      :" + str( nelapsed, 10, 2 ) + CR_LF

   // --------------- MPOSTOLC
   j := seconds()
   for i := 1 to LOOPS
      mpostolc( ctexto, 79, 300 )
   next

   nelapsed := seconds() - j

   ? "MPOSTOLC :"
   ?? nelapsed

   creport += "mPosToLc      :" + str( nelapsed, 10, 2 ) + CR_LF

   // -------------------- MLPOS

   j := seconds()
   for i := 1 to LOOPS
      mlpos( ctexto, 79, 15 )
   next

   nelapsed := seconds() - j

   ? "MLPOS :"
   ?? nelapsed

   creport += "mLPos         :" + str( nelapsed, 10, 2 ) + CR_LF

   // -------------- MEMOREAD
   j := seconds()
   for i := 1 to LOOPS
      memoread( "memos.txt" )
   next

   nelapsed := seconds() - j

   ? "MEMOREAD :"
   ?? nelapsed

   creport += "memoRead      :" + str( nelapsed, 10, 2 ) + CR_LF

   // -------------- MEMOWRIT
   j := seconds()
   for i := 1 to LOOPS
      memowrit( "prueba.txt", ctexto )
   next

   nelapsed := seconds() - j

   ? "MEMOWRIT :"
   ?? nelapsed

   creport += "memoWrit      :" + str( nelapsed, 10, 2 ) + CR_LF

   memoWrit( "report.txt", creport )

return

