/*****************************************************************************
*                                                                            *
*  GhostLib Assistant by GhostWare                                           *
*  Copyright (c) 1994  -  all rights reserved                                *
*                                                                            *
*  File : GW_EXPND.S                                                         *
*                                                                            *
*  Description :                                                             *
*  GhostLib Assistant macro's                                                *
*                                                                            *
*  Date/time : 08-06-94 21:41                                                *
*                                                                            *
*****************************************************************************/
macro_file GW_EXPND;

#include GHOST.GWH                     // GhostLib header file

//--------------------------------------------------------------------------//
// Expansion macro activated if a '-' was typed                             //
//--------------------------------------------------------------------------//
macro ExpandMinus trans2 {
	int nCurrLine = c_line ;
	str cPrevWord ;

	mark_pos;
	word_left;                           // Go left 1 one word
	if (nCurrLine == c_line) {           // Cursor stayed on the same line
		cPrevWord = get_word('-') + '-' ;  // The previous typed word, before '-'
	} else {
		cPrevWord = '-' ;
	} ;
	goto_mark;
	set_global_str('!GWPrevWord', cPrevWord) ;  // Save the previous word
	rm('GW_EXPND^ExpandGWLib') ;         // Run the actual expansion macro
};

//--------------------------------------------------------------------------//
// GhostLib Assistant code                                                  //
//--------------------------------------------------------------------------//
macro ExpandGWLib trans2 {

	str cPrevWord, cGenText, cMessage, cSameLineComment='', cLine;
	int nOldColor, nOldInsertMode;

	refresh = FALSE ;                    // Turn refreshing off, to speed up macro
	push_undo ;                          // Define the beginning of a undo record

	// If the filename extension not equal to PRG then exit
	if (caps(get_extension(file_name)) != 'PRG') {
		// If the macro was NOT entered via a menu then a '-' is printed
		if (xpos('/E', caps(mparm_str), 1)==0){
			text('-') ;                      // Print a normal '-'
		} else {
			// Display an error message
			rm('GW_EXPND^GWMessageBox /M=GhostLib Assistant can be used in .PRG files only!/T= Error /SM=Use GhostLib Assistant in .PRG files only!') ;
		};
		goto Exit;
	};

	if( xpos('/E', caps(mparm_str), 1) ) {
		// Be sure that the cursor is positioned on an empty line, otherwise
		// the original text would be destroyed.
		cLine = shorten_str(get_line);     // Get current line
		if( svl(cLine) != 0 ) {            // If line is NOT blank then go to new line
			nOldInsertMode = insert_mode;    // Save current mode
			insert_mode = 1;                 // Set to insert mode
			eol;                             // Go to EndOfLine
			PRESS_ENTER;                     // Simulate pressing the ENTER-key, this
			                                 //   is done because of smart-indenting.
			insert_mode = nOldInsertMode;    // Reset to old mode
		};
		// If function expansion is chosen from the GhostLib menu, then
		// fill !GWPrevWord with the selected keyword.
	  set_global_str('!GWPrevWord', parse_str('/E=', mparm_str)) ;
		// First print the keyword so it can be removed with the statements below
	  text(global_str('!GWPrevWord')) ;
	};

	cPrevWord = caps(global_str('!GWPrevWord')) ;  // Put it in a local variable

	if( FALSE ) {                        // Dummy test

//--------------------------------------------------------------------------//
// BROWSER FUNCTIONS                                                        //
//--------------------------------------------------------------------------//

	// ARRB- == GWARRBROWSE
	} else if( cPrevWord == 'ARRB-' ) {
		call init;
		cMessage = 'GWARRBROWSE';
		cGenText = '#INCLUDE "GHOST.CH"';
	  call WriteLine; cr;
		cGenText = 'GWARRBROWSE ;' ;
	  call WriteLine; cr;
		indent;                            // indent 1 level
		cGenText = 'AT nTop, nLeft, nBottom, nRight ;';
		cSameLineComment = 'Position of the browse';
	  call WriteLine; cr;
		cGenText = 'ARRAY aInfo ;';
		cSameLineComment = 'Array to browse';
	  call WriteLine; cr;
		cGenText = 'VAR aResult ;';
		cSameLineComment = 'Variable for result data of browsing';
	  call WriteLine; cr;
		cGenText = 'TITLES aColTitles ;';
		cSameLineComment = 'Titles for the columns';
	  call WriteLine; cr;
		cGenText = 'FREEZE nFreezeCol ;';
		cSameLineComment = 'Freeze column';
	  call WriteLine; cr;
		cGenText = 'COLOR cColors ;';
		cSameLineComment = 'Colors for the browse';
	  call WriteLine; cr;
		cGenText = 'COUNTER ;';
		cSameLineComment = 'Row and column counter in top right corner';
	  call WriteLine; cr;
		cGenText = 'VERTICAL ;';
		cSameLineComment = 'Add vertical slider';
	  call WriteLine; cr;
		cGenText = 'HORIZONTAL ;';
		cSameLineComment = 'Add horizontal slider';
	  call WriteLine; cr;
		cGenText = 'ENTERISCHOICE ;';
		cSameLineComment = 'After "ENTER" the browse is exited';
	  call WriteLine; cr;
		cGenText = 'TAG ;';
		cSameLineComment = 'Allow tagging of rows';
	  call WriteLine; cr;
		cGenText = 'SPECIAL ;';
		cSameLineComment = 'Use special font characters';
	  call WriteLine; cr;
		cGenText = 'PRINT ;';
		cSameLineComment = 'Allow printing';
	  call WriteLine; cr;
		cGenText = 'RESTORE ;';
		cSameLineComment = 'Restore screen after exit';
	  call WriteLine; cr;
		cGenText = 'STABLEBLOCK bStableBlock ;';
		cSameLineComment = 'Codeblock to evaluated after stabilize';
	  call WriteLine; cr;
		cGenText = 'HELPLINE ;';
		cSameLineComment = 'Show helpline';
	  call WriteLine; cr;
		cGenText = 'SEPARATORS aSeparators ;';
		cSameLineComment = 'Custom header and column separators';
	  call WriteLine; cr;
		cGenText = 'KEYS aKeys';
		cSameLineComment = 'Additional keys';
	  call WriteLine;
		undent;                            // undent 1 level
		goto_mark;
		MARK_ONE_LINE;
		READY;

	// DBFB- == GWDBFBROWSE
	} else if( caps(global_str('!GWPrevWord')) == 'DBFB-' ) {
		call init;
		cMessage = 'GWDBFBROWSE';
		cGenText = '#INCLUDE "GHOST.CH"';
	  call WriteLine; cr;
		cGenText = 'GWDBFBROWSE ;' ;
	  call WriteLine; cr;
		indent;                            // indent 1 level
		cGenText = 'AT nTop, nLeft, nBottom, nRight ;';
		cSameLineComment = 'Position of the browse';
	  call WriteLine; cr;
		cGenText = 'FIELDS aFields ;';
		cSameLineComment = 'Fields to browse';
	  call WriteLine; cr;
		cGenText = 'TITLES aFieldtitles ;';
		cSameLineComment = 'Titles for the fields';
	  call WriteLine; cr;
		cGenText = 'FREEZE nFreezeCol ;';
		cSameLineComment = 'Freeze column';
	  call WriteLine; cr;
		cGenText = 'EDIT ;';
		cSameLineComment = 'Allow editing';
	  call WriteLine; cr;
		cGenText = 'DEL ;';
		cSameLineComment = 'Allow deleting';
	  call WriteLine; cr;
		cGenText = 'ADD ;';
		cSameLineComment = 'Allow adding';
	  call WriteLine; cr;
		cGenText = 'COLOR cColors ;';
		cSameLineComment = 'Colors for the browse';
	  call WriteLine; cr;
		cGenText = 'COUNTER ;';
		cSameLineComment = 'Row and column counter in top right corner';
	  call WriteLine; cr;
		cGenText = 'VERTICAL ;';
		cSameLineComment = 'Add vertical slider';
	  call WriteLine; cr;
		cGenText = 'HORIZONTAL ;';
		cSameLineComment = 'Add horizontal slider';
	  call WriteLine; cr;
		cGenText = 'ENTERISCHOICE ;';
		cSameLineComment = 'After "ENTER" the browse is exited';
	  call WriteLine; cr;
		cGenText = 'FUNCTION bEditfunction ;';
		cSameLineComment = 'Custom edit function for the browse';
	  call WriteLine; cr;
		cGenText = 'SAT nSWtop, nSWleft, nSWbottom, nSWright ;';
		cSameLineComment = 'Position of the synchronized window';
	  call WriteLine; cr;
		cGenText = 'SFIELDS aSWfields ;';
		cSameLineComment = 'Fields of synchronized window';
	  call WriteLine; cr;
		cGenText = 'STITLES aSWfieldtitles ;';
		cSameLineComment = 'Titels of synchronized window fields';
	  call WriteLine; cr;
		cGenText = 'SPECIAL ;';
		cSameLineComment = 'Use special font characters';
	  call WriteLine; cr;
		cGenText = 'SPACEEDIT ;';
		cSameLineComment = 'Allow editing of current browse cel';
	  call WriteLine; cr;
		cGenText = 'PRINT ;';
		cSameLineComment = 'Allow printing';
	  call WriteLine; cr;
		cGenText = 'KEYS aKeys ;';
		cSameLineComment = 'Additional keys';
	  call WriteLine; cr;
		cGenText = 'RESTORE ;';
		cSameLineComment = 'Restore screen after exit';
	  call WriteLine; cr;
		cGenText = 'STABLEBLOCK bStableBlock ;';
		cSameLineComment = 'Codeblock to evaluated after stabilize';
	  call WriteLine; cr;
		cGenText = 'HELPLINE ;';
		cSameLineComment = 'Show helpline';
	  call WriteLine; cr;
		cGenText = 'SEPARATORS aSeparators ;';
		cSameLineComment = 'Custom header and column separators';
	  call WriteLine; cr;
		cGenText = 'NOCONFIRM';
		cSameLineComment = 'No confirmation asked after deleting';
	  call WriteLine;
		undent;                            // undent 1 level
		goto_mark;
		MARK_ONE_LINE;
		READY;

	// TXTB- == GWTXTBROWSE
	} else if( cPrevWord == 'TXTB-' ) {
		call init;
		cMessage = 'GWTXTBROWSE';
		cGenText = '#INCLUDE "GHOST.CH"';
	  call WriteLine; cr;
		cGenText = 'GWTXTBROWSE ;' ;
	  call WriteLine; cr;
		indent;                            // indent 1 level
		cGenText = 'FILE cFile ;';
		cSameLineComment = 'File to browse';
	  call WriteLine; cr;
		cGenText = 'AT nTop, nLeft, nBottom, nRight ;';
		cSameLineComment = 'Position of the browse';
	  call WriteLine; cr;
		cGenText = 'COLOR cColors ;';
		cSameLineComment = 'Colors for the browse';
	  call WriteLine; cr;
		cGenText = 'LINENUM ;';
		cSameLineComment = 'Row and column counter in top right corner';
	  call WriteLine; cr;
		cGenText = 'SPECIAL ;';
		cSameLineComment = 'Use special font characters';
	  call WriteLine; cr;
		cGenText = 'PRINT ;';
		cSameLineComment = 'Allow printing';
	  call WriteLine; cr;
		cGenText = 'RESTORE';
		cSameLineComment = 'Restore screen after exit';
	  call WriteLine;
		undent;                            // undent 1 level
		goto_mark;
		MARK_ONE_LINE;
		READY;

//--------------------------------------------------------------------------//
// CONVERSION FUNCTIONS                                                     //
//--------------------------------------------------------------------------//

	// AM2D- == GWAddM2Date
	} else if( cPrevWord == 'AM2D-' ) {
		call init;
		cMessage = 'GWAddM2Date()' ;
		cGenText = 'dResult := GWAddM2Date(dDate, nMonths)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// AY2D- == GWAddY2Date
	} else if( cPrevWord == 'AY2D-' ) {
		call init;
		cMessage = 'GWAddY2Date()' ;
		cGenText = 'dResult := GWAddY2Date(dDate, nYears)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// DECR- == GWDecrypt()
	} else if( cPrevWord == 'DECR-' ) {
		call init;
		cMessage = 'GWDecrypt()' ;
		cGenText = 'cResult := GWDecrypt(cString, cKey)' ;
		cSameLineComment = 'Decrypt a string with a key';
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// ENCR- == GWEncrypt()
	} else if( cPrevWord == 'ENCR-' ) {
		call init;
		cMessage = 'GWEncrypt()' ;
		cGenText = 'cResult := GWEncrypt(cString, cKey)' ;
		cSameLineComment = 'Encrypt a string with a key';
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// NEDA- == GWNedAmount()
	} else if( cPrevWord == 'NEDA-' ) {
		call init;
		cMessage = 'GWNedAmount()' ;
		cGenText = 'cResult := GWNedAmount(nAmount, nLength, nDecimals)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// NEDD- == GWNedDate()
	} else if( cPrevWord == 'NEDD-' ) {
		call init;
		cMessage = 'GWNedDate()' ;
		cGenText = 'cResult := GWNedDate(dDate, nMonthLength, lJustify)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// NEDP- == GWNedPercent()
	} else if( cPrevWord == 'NEDP-' ) {
		call init;
		cMessage = 'GWNedPercent()' ;
		cGenText = 'cResult := GWNedPercent(nPerc, nLength, nDecimals)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

//--------------------------------------------------------------------------//
// DATABASE FUNCTIONS                                                       //
//--------------------------------------------------------------------------//

	// AR- == GWAddRec()
	} else if( cPrevWord == 'AR-' ) {
		call init;
		cMessage = 'GWAddRec()';
		cSameLineComment = 'Try adding a record for 5 seconds';
		cGenText = 'IF GWAddRec(5)' ;
	  call WriteLine; cr;
	  cGenText = 'ELSE';
	  call WriteLine; cr;
	  cGenText = 'ENDIF';
	  call WriteLine;
		goto_mark;
		eol; PRESS_ENTER;
		READY;

	// FL- == GWFileLock()
	} else if( cPrevWord == 'FL-' ) {
		call init;
		cMessage = 'GWFileLock()';
		cGenText = 'IF GWFileLock(5)' ;
		cSameLineComment = 'Try locking a file for 5 seconds';
	  call WriteLine; cr;
	  cGenText = 'ELSE';
	  call WriteLine; cr;
	  cGenText = 'ENDIF';
	  call WriteLine;
		goto_mark;
		eol; PRESS_ENTER;
		READY;

	// NE- == GWNetUse()
	} else if( cPrevWord == 'NE-' ) {
		call init;
		cMessage = 'GWNetUse()';
		cGenText = 'IF GWNetUse(cDBF, cNTX, "S", "N", 5, cAlias, cDriver)' ;
	  call WriteLine; cr; cr;
		tab_right;
	  cGenText = 'DBCLOSEAREA()' ;
	  call WriteLine; cr;
	  cGenText = 'ENDIF';
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 12);
		READY;

	// RL- == GWRecLock()
	} else if( cPrevWord == 'RL-' ) {
		call init;
		cMessage = 'GWRecLock()';
		cGenText = 'IF GWRecLock(5)' ;
		cSameLineComment = 'Try locking a record for 5 seconds';
	  call WriteLine; cr;
	  cGenText = 'ELSE';
	  call WriteLine; cr;
	  cGenText = 'ENDIF';
	  call WriteLine;
		goto_mark;
		eol; PRESS_ENTER;
		READY;

	// OP- == GWOpenDBF()
	} else if( cPrevWord == 'OP-' ) {
		call init;
		cMessage = 'GWOpenDBF()';
		cGenText = 'SETKEY(K_ALT_O, {|||| GWOpenDBF(.T.) })' ;
	  call WriteLine; cr;
		READY;

	// DBF2A- == GWDBF2Array()
	} else if( cPrevWord == 'DBF2A-' ) {
		call init;
		cMessage = 'GWDBF2Array()';
		cGenText = 'aResult := GWDBF2Array(aFields)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// STATI- == STATISTIC ...
	} else if( cPrevWord == 'STATI-' ) {
		call init;
		cMessage = 'STATISTIC ...';
		cGenText = '// Initialize the statistic system';
	  call WriteLine; cr;
		cGenText = 'STATISTIC TO FILE cFile BREAK ON cBreak INDEX';
	  call WriteLine; cr; cr;
		cGenText = '// Add column with the data for the breakpoints';
	  call WriteLine; cr;
		cGenText = 'STATISTIC LABEL cLabel TO cField';
	  call WriteLine; cr; cr;
		cGenText = '// Count the number of record per breakpoints';
	  call WriteLine; cr;
		cGenText = 'STATISTIC COUNT TO cField LENGTH nLen,nDec FOR cExpr';
	  call WriteLine; cr; cr;
		cGenText = '// Totals per breakpoints';
	  call WriteLine; cr;
		cGenText = 'STATISTIC SUM cSum TO cField LENGTH nLen,nDec FOR cExpr';
	  call WriteLine; cr; cr;
		cGenText = '// Perform the statistic calculations';
	  call WriteLine; cr;
		cGenText = 'STATISTIC GO TOTALS COUNTER FUNCTION cFunc';
	  call WriteLine;
		goto_mark; down;
		goto_col(c_col + 18);
		READY;

//--------------------------------------------------------------------------//
// DOS FUNCTIONS                                                            //
//--------------------------------------------------------------------------//

	// CF- == GWCopyFile()
	} else if( cPrevWord == 'CF-' ) {
		call init;
		cMessage = 'GWCopyFile()';
		cGenText = 'GWCopyFile(xFromDir, cTo, xExcludeFiles, lStatusbar, lPrompt)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 11);
		READY;

	// GD- == GWGetDir()
	} else if( cPrevWord == 'GD-' ) {
		call init;
		cMessage = 'GWGetDir()';
		cGenText = 'aResult := GWGetDir(xFromDir, xExcludeFiles, cAttributes, cSort, cOrder, lFullPath, lStatus)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// GT- == GWGetTree()
	} else if( cPrevWord == 'GT-' ) {
		call init;
		cMessage = 'GWGetTree()';
		cGenText = 'aResult := GWGetTree(cPath, lSize, lDisplay, lGraphic)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// IS- == GWIsValid()
	} else if( cPrevWord == 'IS-' ) {
		call init;
		cMessage = 'GWIsValid()';
		cGenText = 'aResult := GWIsValid(cName, lFile, lMessage)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// MEM- == GWMemory()
	} else if( cPrevWord == 'MEM-' ) {
		call init;
		cMessage = 'GWMemory()';
		cGenText = 'SETKEY(K_ALT_M, {|||| GWMemory()})' ;
	  call WriteLine; cr;
		READY;

	// ENV- == GWSave/RestEnv()
	} else if( cPrevWord == 'ENV-' ) {
		call init;
		cMessage = 'GWSave/RestEnv()';
		cSameLineComment = 'Save the OS environment' ;
		cGenText = 'GWSaveEnv()' ;
	  call WriteLine; cr; cr;
		cSameLineComment = 'Restore the OS environment' ;
		cGenText = 'GWRestEnv()' ;
	  call WriteLine;
		goto_mark; down;
		READY;

//--------------------------------------------------------------------------//
// GETLIST FUNCTIONS                                                        //
//--------------------------------------------------------------------------//

	// BUT- == GET BUTTON ...
	} else if( cPrevWord == 'BUT-' ) {
		call init;
		cMessage = 'GET BUTTON...';
		cGenText = '@ x,  y SAY cText GET nVar BUTTON "OK" DO cFunc STAY EXITREAD';
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// CALC- == GET CALCULATOR ...
	} else if( cPrevWord == 'CALC-' ) {
		call init;
		cMessage = 'GET CALCULATOR...';
		cGenText = '@ x,  y SAY cText GET nVar CALCULATOR';
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// CAL- == GET CALENDER ...
	} else if( cPrevWord == 'CAL-' ) {
		call init;
		cMessage = 'GET CALENDER...';
		cGenText = '@ x,  y SAY cText GET dDate CALENDER';
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// CH- == GET CHECKBOX ...
	} else if( cPrevWord == 'CH-' ) {
		call init;
		cMessage = 'GET CHECKBOX...';
		cGenText = '@ x,  y SAY cText ;';
	  call WriteLine; cr;
		indent;                            // indent 1 level
		cGenText = 'SAYCOLOR cColQuest ;';
	  call WriteLine; cr;
		cGenText = 'GET cVar ;';
	  call WriteLine; cr;
		cGenText = 'CHECKBOX aOptions ;';
	  call WriteLine; cr;
		cGenText = 'CHECKCOLOR cColCheck ;';
	  call WriteLine; cr;
		cGenText = 'ANSWERS aAnswers ;';
	  call WriteLine; cr;
		cGenText = 'HORIZONTAL ;';
	  call WriteLine; cr;
		cGenText = 'CHECK cCheck';
	  call WriteLine;
		undent;                            // undent 1 level
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// HI- == GET HISTORY ...
	} else if( cPrevWord == 'HI-' ) {
		call init;
		cMessage = 'GET HISTORY...';
		cGenText = '@ x,  y SAY cText ;';
	  call WriteLine; cr;
		indent;                            // indent 1 level
		cGenText = 'COLOR cColor ;';
	  call WriteLine; cr;
		cGenText = 'GET cVar ;';
	  call WriteLine; cr;
		cGenText = 'HISTORY nMaxHistory ;';
	  call WriteLine; cr;
		cGenText = 'WHEN bWhen ;';
	  call WriteLine; cr;
		cGenText = 'VALID bValid';
	  call WriteLine;
		undent;                            // undent 1 level
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// INI- == GET INITIALS ...
	} else if( cPrevWord == 'INI-' ) {
		call init;
		cMessage = 'GET INITIALS...';
		cGenText = '@ x,  y SAY cText GET cVar INITIALS';
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// ME- == GET MEMO ...
	} else if( cPrevWord == 'ME-' ) {
		call init;
		cMessage = 'GET MEMO...';
		cGenText = '@ x,  y SAY cText ;';
	  call WriteLine; cr;
		indent;                            // indent 1 level
		cGenText = 'COLOR cColor ;';
	  call WriteLine; cr;
		cGenText = 'GET MEMO cVar ;';
	  call WriteLine; cr;
		cGenText = 'AT nTop, nLeft, nBottom, nRight ;';
	  call WriteLine; cr;
		cGenText = 'KEY aKey ;';
	  call WriteLine; cr;
		cGenText = 'TITLE cTitle ;';
	  call WriteLine; cr;
		cGenText = 'WHEN bWhen ;';
	  call WriteLine; cr;
		cGenText = 'VALID bValid ;';
	  call WriteLine; cr;
		cGenText = 'BLOCK bBlock';
	  call WriteLine;
		undent;                            // undent 1 level
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// PAS- == GET PASSWORD ...
	} else if( cPrevWord == 'PAS-' ) {
		call init;
		cMessage = 'GET PASSWORD...';
		cGenText = '@ x,  y SAY cText GET cVar PASSWORD';
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// PIC- == GET PICK ...
	} else if( cPrevWord == 'PIC-' ) {
		call init;
		cMessage = 'GET PICK...';
		cGenText = '@ x,  y SAY cText ;';
	  call WriteLine; cr;
		indent;                            // indent 1 level
		cGenText = 'COLOR cColor ;';
	  call WriteLine; cr;
		cGenText = 'GET cVar ;';
	  call WriteLine; cr;
		cGenText = 'PICK aAnswers ;';
	  call WriteLine; cr;
		cGenText = 'QUESTION cQuestion ;';
	  call WriteLine; cr;
		cGenText = 'WHEN bWhen ;';
	  call WriteLine; cr;
		cGenText = 'VALID bValid';
	  call WriteLine;
		undent;                            // undent 1 level
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// RA- == GET RADIO ...
	} else if( cPrevWord == 'RA-' ) {
		call init;
		cMessage = 'GET RADIO...';
		cGenText = '@ x,  y SAY cText ;';
	  call WriteLine; cr;
		indent;                            // indent 1 level
		cGenText = 'SAYCOLOR cColQuest ;';
	  call WriteLine; cr;
		cGenText = 'GET cVar ;';
	  call WriteLine; cr;
		cGenText = 'RADIO aOptions ;';
	  call WriteLine; cr;
		cGenText = 'RADIOCOLOR cColRadio ;';
	  call WriteLine; cr;
		cGenText = 'ANSWERS aAnswers ;';
	  call WriteLine; cr;
		cGenText = 'HORIZONTAL ;';
	  call WriteLine; cr;
		cGenText = 'CHECK cCheck';
	  call WriteLine;
		undent;                            // undent 1 level
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// PRE- == GWPrePick()
	} else if( cPrevWord == 'PRE-' ) {
		call init;
		cMessage = 'GWPrePick()';
		cGenText = 'WHEN GWPrePick(cText, aAnswers, cColors, cBorder)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 16);
		READY;

	// POST- == GWPostPick()
	} else if( cPrevWord == 'POST-' ) {
		call init;
		cMessage = 'GWPostPick()';
		cGenText = 'VALID GWPostPick(cText, aAnswers, cColors, cBorder)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 17);
		READY;

	// GETN- == GWGetNumber()
	} else if( cPrevWord == 'GETN-' ) {
		call init;
		cMessage = 'GWGetNumber()';
		cGenText = 'nResult := GWGetNumber(GetList, cFieldName)' ;
		cSameLineComment = 'Get element no. of field in GETLIST' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// GETF- == GWGetFill()
	} else if( cPrevWord == 'GETF-' ) {
		call init;
		cMessage = 'GWGetFill()';
		cGenText = 'GWGetFill(@GetList, nGetNumber, xInfo)' ;
		cSameLineComment = 'Fill GETLIST element with data' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 21);
		READY;

//--------------------------------------------------------------------------//
// HOTSPOT FUNCTIONS                                                        //
//--------------------------------------------------------------------------//

	// DEFH- == DEFINE HOTSPOT
	} else if( cPrevWord == 'DEFH-' ) {
		call init;
		cMessage = 'DEFINE HOTSPOT';
		cGenText = 'DEFINE HOTSPOT nVar ;';
		cSameLineComment = 'Define a new hotspot';
	  call WriteLine; cr;
		indent;                            // indent 1 level
		cGenText = 'AT nTop, nRow, nBottom, nRight ;';
		cSameLineComment = 'Location of the hotspot';
	  call WriteLine; cr;
		cGenText = 'OFF ;';
		cSameLineComment = 'Initially turn hotspot off';
	  call WriteLine; cr;
		cGenText = 'KEY nKey ;';
		cSameLineComment = 'Shortcut key combination';
	  call WriteLine; cr;
		cGenText = 'DO cDo ;';
		cSameLineComment = 'Function(s) to execute';
	  call WriteLine; cr;
		cGenText = 'WARM COLOR cWarmColor ;';
		cSameLineComment = 'Colors of a "warm" hotspot';
	  call WriteLine; cr;
		cGenText = 'COLD COLOR cColdColor';
		cSameLineComment = 'Colors of a "cold" hotspot';
	  call WriteLine;
		undent;                            // undent 1 level
		goto_mark;
		goto_col(c_col + 15);
		READY;

	// COOLA- == COOL ALL HOTSPOTS
	} else if( cPrevWord == 'COOLA-' ) {
		call init;
		cMessage = 'COOL ALL HOTSPOTS';
		cGenText = 'COOL ALL HOTSPOTS';
		cSameLineComment = 'Turn all hotspots off';
	  call WriteLine; cr;
		READY;

	// COOL- == COOL HOTSPOT
	} else if( cPrevWord == 'COOL-' ) {
		call init;
		cMessage = 'COOL HOTSPOT';
		cGenText = 'COOL HOTSPOT nId';
		cSameLineComment = 'Turn a hotspot off';
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 13);
		READY;

	// DELA- == DELETE ALL HOTSPOTS
	} else if( cPrevWord == 'DELA-' ) {
		call init;
		cMessage = 'DELETE ALL HOTSPOTS';
		cGenText = 'DELETE ALL HOTSPOTS';
		cSameLineComment = 'Delete all hotspots';
	  call WriteLine; cr;
		READY;

	// DEL- == DELETE HOTSPOT
	} else if( cPrevWord == 'DEL-' ) {
		call init;
		cMessage = 'DELETE HOTSPOT';
		cGenText = 'DELETE HOTSPOT nId';
		cSameLineComment = 'Delete a hotspot';
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 15);
		READY;

	// PAI- == PAINT HOTSPOTS
	} else if( cPrevWord == 'PAI-' ) {
		call init;
		cMessage = 'PAINT HOTSPOTS';
		cGenText = 'PAINT HOTSPOTS';
		cSameLineComment = 'Re-paint all hotspots';
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 15);
		READY;

	// RESH- == RESTORE HOTSPOTS
	} else if( cPrevWord == 'RESH-' ) {
		call init;
		cMessage = 'RESTORE HOTSPOTS';
		cGenText = 'RESTORE HOTSPOTS FROM aSpots REPAINT' ;
		cSameLineComment = 'Restore hotspots from array';
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 22);
		READY;

	// SAVH- == SAVE HOTSPOTS
	} else if( cPrevWord == 'SAVH-' ) {
		call init;
		cMessage = 'SAVE HOTSPOTS';
		cGenText = 'SAVE HOTSPOTS TO aSpots ;' ;
		cSameLineComment = 'Save hotspots to array';
	  call WriteLine; cr;
		indent;                            // indent 1 level
		cGenText = 'DELETE' ;
		cSameLineComment = 'Delete the current hotspots';
	  call WriteLine;
		undent;                            // undent 1 level
		goto_mark;
		goto_col(c_col + 17);
		READY;

	// WARMA- == WARM ALL HOTSPOTS
	} else if( cPrevWord == 'WARMA-' ) {
		call init;
		cMessage = 'WARM ALL HOTSPOTS';
		cGenText = 'WARM ALL HOTSPOTS';
		cSameLineComment = 'Turn all hotspots on';
	  call WriteLine; cr;
		READY;

	// WARM- == WARM HOTSPOT
	} else if( cPrevWord == 'WARM-' ) {
		call init;
		cMessage = 'WARM HOTSPOT';
		cGenText = 'WARM HOTSPOT nId';
		cSameLineComment = 'Turn a hotspot on';
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 13);
		READY;

//--------------------------------------------------------------------------//
// MENU FUNCTIONS                                                           //
//--------------------------------------------------------------------------//

	// ASK- == GWASKTHIS
	} else if( cPrevWord == 'ASK-' ) {
		call init;
		cMessage = 'GWASKTHIS';
		cGenText = '#INCLUDE "GHOST.CH"';
	  call WriteLine; cr;
		cGenText = 'GWASKTHIS ;' ;
	  call WriteLine; cr;
		indent;                            // indent 1 level
		cGenText = 'QUESTION cText ;';
		cSameLineComment = 'The question to ask the user' ;
	  call WriteLine; cr;
		cGenText = 'WITH ANSWERS aAnswers ;';
		cSameLineComment = 'Possible answers';
	  call WriteLine; cr;
		cGenText = 'TO nResult ;';
		cSameLineComment = 'Variable to store chosen option in';
	  call WriteLine; cr;
		cGenText = 'INITPOSITION nInitPos ;';
		cSameLineComment = 'Initial answer';
	  call WriteLine; cr;
		cGenText = 'COLOR cColors ;';
		cSameLineComment = 'Colors to be used';
	  call WriteLine; cr;
		cGenText = 'VERTICAL ;';
		cSameLineComment = 'Display answers vertically';
	  call WriteLine; cr;
		cGenText = 'HORIZONTAL ;';
		cSameLineComment = 'Display answers horizontally (default)';
	  call WriteLine; cr;
		cGenText = 'AT nRow, nCol ;';
		cSameLineComment = 'Location of the question box';
	  call WriteLine; cr;
		cGenText = 'BORDER cBorder ;';
		cSameLineComment = 'Used border for the box';
	  call WriteLine; cr;
		cGenText = 'ALLOWED aAllowed';
		cSameLineComment = 'Option that are allowed';
	  call WriteLine;
		undent;                            // undent 1 level
		goto_mark;
		MARK_ONE_LINE;
		READY;

	// PD- == GWPullDown()
	} else if( cPrevWord == 'PD-' ) {
		call init;
		cMessage = 'GWPullDown()';
		cGenText = 'GWPDown(aOptions, cColOption, cColHotkey, cColActiveOption, cColActiveHotkey, ;' ;
	  call WriteLine; cr;
		cGenText = 'cBorder, lExplode, lWarning, nSeconds, bFunc, aRows)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 9);
		READY;

	// MEN- == MENU COMMAND
	} else if( cPrevWord == 'MEN-' ) {
		call init;
		cMessage = 'BEGIN MENU';
		cGenText = '#INCLUDE "GWMENU.CH"';
	  call WriteLine; cr;
		cGenText = 'BEGIN MENU aMenu' ;
	  call WriteLine; cr;
		indent;                            // indent 1 level
		cGenText = 'OPTION cOption ;';
		cSameLineComment = 'Option name' ;
	  call WriteLine; cr;
		indent;                            // indent 1 level
		cGenText = 'DO cDo ;';
		cSameLineComment = 'Execute this funtion if option is chosen';
	  call WriteLine; cr;
		cGenText = 'SUBMENU aSubMenu ;';
		cSameLineComment = 'OR show a submenu (USE ONLY ONE OF THESE 2 LINES)';
	  call WriteLine; cr;
		cGenText = 'HOTKEY nHotkey ;';
		cSameLineComment = 'Hotkey character position';
	  call WriteLine; cr;
		cGenText = 'MESSAGE cMessage ;';
		cSameLineComment = 'Help message displayed on bottom line';
	  call WriteLine; cr;
		cGenText = 'WHEN cWhen ;';
		cSameLineComment = 'When clause for this option';
	  call WriteLine; cr;
		cGenText = 'SHORTCUT nShortCut';
		cSameLineComment = 'Shortcut key combination for this option';
	  call WriteLine; cr;
		undent;                            // undent 1 level
		cGenText = 'END MENU';
		cSameLineComment = 'End of this submenu';
	  call WriteLine;
		undent;                            // undent 1 level
		goto_mark;
		MARK_ONE_LINE;
		down;
		goto_col(c_col + 11);
		READY;

	// OPT- == OPTION .. DO
	} else if( cPrevWord == 'OPT-' ) {
		call init;
		cMessage = 'OPTION ... DO';
		cGenText = 'OPTION cOption ;';
		cSameLineComment = 'Option name' ;
	  call WriteLine; cr;
		indent;                            // indent 1 level
		cGenText = 'DO cDo ;';
		cSameLineComment = 'Execute this funtion if option is chosen';
	  call WriteLine; cr;
		cGenText = 'HOTKEY nHotkey ;';
		cSameLineComment = 'Hotkey character position';
	  call WriteLine; cr;
		cGenText = 'MESSAGE cMessage ;';
		cSameLineComment = 'Help message displayed on bottom line';
	  call WriteLine; cr;
		cGenText = 'WHEN cWhen ;';
		cSameLineComment = 'When clause for this option';
	  call WriteLine; cr;
		cGenText = 'SHORTCUT nShortCut';
		cSameLineComment = 'Shortcut key combination for this option';
	  call WriteLine;
		undent;                            // undent 1 level
		goto_mark;
		goto_col(c_col + 7);
		READY;

	// SUB- == OPTION ... SUBMENU
	} else if( cPrevWord == 'SUB-' ) {
		call init;
		cMessage = 'OPTION ... SUBMENU';
		cGenText = 'OPTION cOption ;';
		cSameLineComment = 'Option name' ;
	  call WriteLine; cr;
		indent;                            // indent 1 level
		cGenText = 'SUBMENU aSubMenu ;';
		cSameLineComment = 'Show a submenu';
	  call WriteLine; cr;
		cGenText = 'HOTKEY nHotkey ;';
		cSameLineComment = 'Hotkey character position';
	  call WriteLine; cr;
		cGenText = 'MESSAGE cMessage ;';
		cSameLineComment = 'Help message displayed on bottom line';
	  call WriteLine; cr;
		cGenText = 'WHEN cWhen ;';
		cSameLineComment = 'When clause for this option';
	  call WriteLine; cr;
		cGenText = 'SHORTCUT nShortCut';
		cSameLineComment = 'Shortcut key combination for this option';
	  call WriteLine;
		undent;                            // undent 1 level
		goto_mark;
		goto_col(c_col + 7);
		READY;

	// ACTI- == ACTIVATE MENU
	} else if( cPrevWord == 'ACTI-' ) {
		call init;
		cMessage = 'ACTIVATE MENU';
		cGenText = 'ACTIVATE MENU aMenu ;';
		cSameLineComment = 'Activate the menu system';
	  call WriteLine; cr;
		indent;                            // indent 1 level
		cGenText = 'OPTION COLOR cColOption ;';
		cSameLineComment = 'Colors of the options';
	  call WriteLine; cr;
		cGenText = 'HOTKEY COLOR cColHotkey ;';
		cSameLineComment = 'Colors of the hotkeys';
	  call WriteLine; cr;
		cGenText = 'ACTIVEOPTION COLOR cActColOption ;';
		cSameLineComment = 'Colors of the active option';
	  call WriteLine; cr;
		cGenText = 'ACTIVEHOTKEY COLOR cActColHotkey ;';
		cSameLineComment = 'Colors of the active hotkey';
	  call WriteLine; cr;
		cGenText = 'BORDER cBorder ;';
		cSameLineComment = 'Border of the submenus';
	  call WriteLine; cr;
		cGenText = 'EXPLODE ;';
		cSameLineComment = 'Show submenus exploded';
	  call WriteLine; cr;
		cGenText = 'WARNING ;';
		cSameLineComment = 'Warn user if topmenu is left with ESCape';
	  call WriteLine; cr;
		cGenText = 'BLOCK cBlock AFTER nSeconds ;';
		cSameLineComment = 'Screensaver after x seconds';
	  call WriteLine; cr;
		cGenText = 'TOPROW nTopRow ;';
		cSameLineComment = 'Row of the topmenu';
	  call WriteLine; cr;
		cGenText = 'MESSAGEROW nMessRow';
		cSameLineComment = 'Row of the help messages';
	  call WriteLine;
		undent;                            // undent 1 level
		goto_mark;
		goto_col(c_col + 14);
		READY;

//--------------------------------------------------------------------------//
// MISCELLANEOUS FUNCTIONS                                                  //
//--------------------------------------------------------------------------//

	// MEMD- == GWMemoDisplay()
	} else if( cPrevWord == 'MEMD-' ) {
		call init;
		cMessage = 'GWMemoDisplay()';
		cGenText = 'aResult := GWMemoDisplay(cString, nTop, nLeft, nBottom, nRight, cTitle, cColor, lSave)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// MEME- == GWMemoEdit()
	} else if( cPrevWord == 'MEME-' ) {
		call init;
		cMessage = 'GWMemoEdit()';
		cGenText = 'cResult := GWMemoEdit(cString, nTop, nLeft, nBottom, nRight, lEditMode, ;' ;
	  call WriteLine; cr;
		indent;
		cGenText = 'cTitle, cUserFunction, nLineLength, nTabSize,  nTextBufferRow, ;' ;
	  call WriteLine; cr;
		cGenText = 'nTextBufferColumn, nWindowRow,nWindowColumn)' ;
	  call WriteLine;
		undent;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// TR- == GWTrace()
	} else if( cPrevWord == 'TR-' ) {
		call init;
		cMessage = 'GWTrace()';
		cGenText = 'SETKEY(K_ALT_T, {|||| GWTrace(.T.) })' ;
	  call WriteLine; cr;
		READY;

	// WK- == GWWaitKey()
	} else if( cPrevWord == 'WK-' ) {
		call init;
		cMessage = 'GWWaitKey()';
		cGenText = 'nResult := GWWaitKey(nWaitTime, bFunc, nSeconds)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// AS- == GWaSearch()
	} else if( cPrevWord == 'AS-' ) {
		call init;
		cMessage = 'GWaSearch()';
		cGenText = 'nResult := GWaSearch(aArray, nColumn, xVar)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

//--------------------------------------------------------------------------//
// MOUSE FUNCTIONS                                                          //
//--------------------------------------------------------------------------//

	// ACT- == GWAction()
	} else if( cPrevWord == 'ACT-' ) {
		call init;
		cMessage = 'GWAction()';
		cGenText = 'nResult := GWAction(bFunc, nSeconds, aValues)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// IN- == GWmInArea()
	} else if( cPrevWord == 'IN-' ) {
		call init;
		cMessage = 'GWmInArea()';
		cGenText = 'lResult := GWmInArea(nTop, nLeft, nBottom, nRight)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// MR- == GWmRead()
	} else if( cPrevWord == 'MR-' ) {
		call init;
		cMessage = 'GWmRead()';
		cGenText = '#INCLUDE "MOUSE.CH"' ;
	  call WriteLine; cr;
		cGenText = 'LOCAL aMouse := ARRAY(M_SIZE_ARRAY)' ;
	  call WriteLine; cr;
		cGenText = 'GWmRead(aMouse)' ;
	  call WriteLine;
		goto_mark;
		block_begin; down; block_end;      // make a block of first lines
		READY;

	// MU- == GWmUse()
	} else if( cPrevWord == 'MU-' ) {
		call init;
		cMessage = 'GWmUse()';
		cGenText = 'lResult := GWmUse(lUseMouse)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

//--------------------------------------------------------------------------//
// PRINTER FUNCTIONS                                                        //
//--------------------------------------------------------------------------//

	// HPB- == GWHPBehavior()
	} else if( cPrevWord == 'HPB-' ) {
		call init;
		cMessage = 'GWHPBehavior()' ;
		cGenText = 'lResult := GWHPBehavior(lBehavior)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// HPF- == GWHPFont()
	} else if( cPrevWord == 'HPF-' ) {
		call init;
		cMessage = 'GWHPFont()' ;
		cGenText = '#INCLUDE "HP.CH"' ;
	  call WriteLine; cr;
		cGenText = 'cResult := GWHPFont(nTypeFace, nSpacing, nPitch, nPoints, nStyle, nStroke)' ;
	  call WriteLine;
		goto_mark;
		MARK_ONE_LINE;
		//goto_col(c_col + 1);
		READY;

	// PF- == GWPageFull()
	} else if( cPrevWord == 'PF-' ) {
		call init;
		cMessage = 'GWPageFull()' ;
		cGenText = 'lResult := GWPageFull(nPageLength, nToPrint, nTopMargin)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// PT- == GWPrintText()
	} else if( cPrevWord == 'PT-' ) {
		call init;
		cMessage = 'GWPrintText()' ;
		cGenText = 'GWPrintText(cText, nLen, nPageLength, nTop)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 12);
		READY;

	// LAB- == LABEL...
	} else if( cPrevWord == 'LAB-' ) {
		call init;
		cMessage = 'LABEL...' ;
		cGenText = 'LABEL xFields ;';
		cSameLineComment = 'Simple labels/reporting';
	  call WriteLine; cr;
		indent;                            // indent 1 level
		cGenText = 'LINES nLines ;';
		cSameLineComment = 'Lines per label';
	  call WriteLine; cr;
		cGenText = 'WIDTH nWidth ;';
		cSameLineComment = 'Width of a label';
	  call WriteLine; cr;
		cGenText = 'HORIZONTAL SPACE nHSpace ;';
		cSameLineComment = 'Chars between 2 labels';
	  call WriteLine; cr;
		cGenText = 'VERTICAL SPACE nVSpace ;';
		cSameLineComment = 'Lines between 2 labels';
	  call WriteLine; cr;
		cGenText = 'COLUMNS nColumns ;';
		cSameLineComment = 'Number of columns';
	  call WriteLine; cr;
		cGenText = 'PAGELENGTH nLength ;';
		cSameLineComment = 'Length of a page';
	  call WriteLine; cr;
		cGenText = 'LEFTMARGIN nLMargin ;';
		cSameLineComment = 'Left margin';
	  call WriteLine; cr;
		cGenText = 'TOPMARGIN nTMargin ;';
		cSameLineComment = 'Top margin';
	  call WriteLine; cr;
		cGenText = 'COPIES nCopies ;';
		cSameLineComment = 'Number of copies per label';
	  call WriteLine; cr;
		cGenText = 'SAMPLES';
		cSameLineComment = 'First print test labels';
	  call WriteLine;
		undent;                            // undent 1 level
		goto_mark;
		goto_col(c_col + 6);
		READY;

//--------------------------------------------------------------------------//
// SCREEN FUNCTIONS                                                         //
//--------------------------------------------------------------------------//

	// CLS- == GWClearScreen()
	} else if( cPrevWord == 'CLS-' ) {
		call init;
		cMessage = 'GWClearScreen()' ;
		cGenText = 'GWClearScreen(cColors, cFillchars)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 14);
		READY;

	// MES- == GWMessage()
	} else if( cPrevWord == 'MES-' ) {
		call init;
		cMessage = 'GWMessage()' ;
		cGenText = 'aResult := GWMessage(cText, cColors, nRow, nColumn, cBorder)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// SAS- == GWSaveScreen()
	} else if( cPrevWord == 'SAS-' ) {
		call init;
		cMessage = 'GWSaveScreen()' ;
		cGenText = 'aScreen := GWSaveScreen(nTop, nLeft, nBottom, nRight)' ;
	  call WriteLine; cr; cr;
		cGenText = 'GWRestScreen(aScreen,.T.)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// BOX- == GWBOX
	} else if( cPrevWord == 'BOX-' ) {
		call init;
		cMessage = 'GWBOX';
		cGenText = '#INCLUDE "GHOST.CH"';
	  call WriteLine; cr;
		cGenText = 'GWBOX ;' ;
	  call WriteLine; cr;
		indent;                            // indent 1 level
		cGenText = 'TO aResult ;';
		cSameLineComment = 'The overwritten screen part information' ;
	  call WriteLine; cr;
		cGenText = 'AT nTop, nLeft, nBottom, nRight ;';
		cSameLineComment = 'Location of the box' ;
	  call WriteLine; cr;
		cGenText = 'COLOR cColors ;';
		cSameLineComment = 'Colors to be used';
	  call WriteLine; cr;
		cGenText = 'LEVEL 1 ;';
		cSameLineComment = 'Height of the shadow';
	  call WriteLine; cr;
		cGenText = 'BORDER cBorder ;';
		cSameLineComment = 'Border to be used';
	  call WriteLine; cr;
		cGenText = 'EXPLODE';
		cSameLineComment = 'Explode the box';
	  call WriteLine;
		undent;                            // undent 1 level
		goto_mark;
		MARK_ONE_LINE;
		READY;

	// STB- == GWStatusBar()
	} else if( cPrevWord == 'STB-' ) {
		call init;
		cMessage = 'GWStatusBar()' ;
		cGenText = 'aScreen := GWStatusBar(xInput, nRow, cColors)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// STL- == GWStatusLine()
	} else if( cPrevWord == 'STL-' ) {
		call init;
		cMessage = 'GWStatusLine()' ;
		cGenText = 'GWStatusLine(cText, nRow, cColors)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 13);
		READY;

	// EXP- == SET EXPLOSION
	} else if( cPrevWord == 'EXP-' ) {
		call init;
		cMessage = 'SET EXPLOSION' ;
		cGenText = 'SET EXPLOSION ON' ;
	  call WriteLine; cr;
		READY;

	// SCR- == SET SCREENSAVER
	} else if( cPrevWord == 'SCR-' ) {
		call init;
		cMessage = 'SET SCREENSAVER' ;
		cGenText = 'SET SCREENSAVER TO bSaver AFTER nSeconds' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 19);
		READY;

	// SHH- == SET SHADOWHEIGHT TO ...
	} else if( cPrevWord == 'SHH-' ) {
		call init;
		cMessage = 'SET SHADOWHEIGHT' ;
		cGenText = 'SET SHADOWHEIGHT TO 1' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 20);
		READY;

//--------------------------------------------------------------------------//
// VIDEO FUNCTIONS                                                          //
//--------------------------------------------------------------------------//

	// ENCOL- == GWEn/DisableColor()
	} else if( cPrevWord == 'ENCOL-' ) {
		call init;
		cMessage = 'GWEnableColor()' ;
		cGenText = 'lResult := GWEnableColor()' ;
	  call WriteLine; cr; cr;
		cGenText = 'GWDisableColor()' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// AVGA- == GWAllVGAColor()
	} else if( cPrevWord == 'AVGA-' ) {
		call init;
		cMessage = 'GWAllVGAColor()' ;
		cGenText = 'cResult := GWAllVGAColor(cColors)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// VGA- == GWVGAColor()
	} else if( cPrevWord == 'VGA-' ) {
		call init;
		cMessage = 'GWVGAColor()' ;
		cGenText = 'aResult := GWVGAColor(cColor, {nRed, nGreen, nBlue})' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// SPEC- == GWUseSpecial()
	} else if( cPrevWord == 'SPEC-' ) {
		call init;
		cMessage = 'GWUseSpecial()' ;
		cGenText = 'lResult := GWUseSpecial(lSpecial)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// LF- == GWLoadFont()
	} else if( cPrevWord == 'LF-' ) {
		call init;
		cMessage = 'GWLoadFont()' ;
		cGenText = 'GWLoadFont(cFont, nStartFont, nBlock)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 11);
		READY;

	// MC- == GWMakeChar()
	} else if( cPrevWord == 'MC-' ) {
		call init;
		cMessage = 'GWMakeChar()' ;
		cGenText = 'LOCAL aFont:=ARRAY(GWScanLines())' ;
	  call WriteLine; cr;
		cGenText = 'aFont[ 1] := " 1   1  "' ;
		cSameLineComment = 'Design of a new character';
	  call WriteLine; cr;
		cGenText = 'aFont[ 2] := " 1   1  "' ;
	  call WriteLine; cr;
		cGenText = 'aFont[ 3] := " 1   1  "' ;
	  call WriteLine; cr;
		cGenText = 'aFont[ 4] := " 1   1  "' ;
	  call WriteLine; cr;
		cGenText = 'aFont[ 5] := " 11111  "' ;
	  call WriteLine; cr;
		cGenText = 'aFont[ 6] := "1  1  1 "' ;
	  call WriteLine; cr;
		cGenText = 'aFont[ 7] := "1  1  1 "' ;
	  call WriteLine; cr;
		cGenText = 'aFont[ 8] := "1  11111"' ;
	  call WriteLine; cr;
		cGenText = 'aFont[ 9] := "1     1 "' ;
	  call WriteLine; cr;
		cGenText = 'aFont[10] := "1     1 "' ;
	  call WriteLine; cr;
		cGenText = 'aFont[11] := " 11111  "' ;
	  call WriteLine; cr;
		cGenText = 'aFont[12] := " 1   1  "' ;
	  call WriteLine; cr;
		cGenText = 'aFont[13] := " 1   1  "' ;
	  call WriteLine; cr;
		cGenText = 'aFont[14] := " 1   1  "' ;
	  call WriteLine; cr;
		cGenText = 'IF LEN(aFont) == 16' ;
		cSameLineComment = 'If VGA is available' ;
	  call WriteLine; cr;
		indent ;
		cGenText = 'aFont[15] := " 1   1  "' ;
	  call WriteLine; cr;
		cGenText = 'aFont[16] := " 1   1  "' ;
	  call WriteLine; cr;
		undent ;
		cGenText = 'ENDIF' ;
	  call WriteLine; cr;
		cGenText = 'GWLoadFont(GWMakeChar(aFont), nChar, nBlock)' ;
		cSameLineComment = 'Load the new character' ;
	  call WriteLine;
		goto_mark;
		MARK_ONE_LINE;
		READY;

	// RF- == GWReadFont()
	} else if( cPrevWord == 'RF-' ) {
		call init;
		cMessage = 'GWReadFont()' ;
		cGenText = 'nResult := GWReadFont("GHOSTVGA.FON", nBlock)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 1);
		READY;

	// UF- == GWUseFonts()
	} else if( cPrevWord == 'UF-' ) {
		call init;
		cMessage = 'GWUseFonts()' ;
		cGenText = 'GWUseFonts(nNormalBlock, nBrightBlock)' ;
	  call WriteLine;
		goto_mark;
		goto_col(c_col + 11);
		READY;

	} else {
		// No keyword typed, so a normal '-' must be typed in
		text('-') ;                        // Print a normal '-'

	};
	goto Exit;                           // Leave the macro

//
// End of Expansion statements
//

Init:
	nOldInsertMode = insert_mode;        // Current insert mode
	insert_mode = 1;                     // Put editor in insert mode
	return_int = 1;                      // Set a flag so that the template system will know we did something here
	first_word;
	del_chars(length(global_str('!GWPrevWord')) );  // delete the template characters
	mark_pos ;                           // Mark the current cursor position
	ret;

WriteLine:
// Writes a line of text and optionally adds a same line comment
// if the variable 'cSameLineComment' is not equal to ''.
	text( cGenText );                    // Write the text into the buffer
	if (cSameLineComment != '') {;
		rm('GW_EXPND^EOLComment');
		text(cSameLineComment);            // Print comment
		cSameLineComment = '';             // Be sure that the next NO commant is printed
	};
	ret;

MessageOnScreen:
	pop_undo ;                           // Define the end of the undo buffer
	insert_mode = nOldInsertMode ;       // Restore old insert mode
	if( xpos('()', cMessage, 1)) {
		// A function is expanded
		cMessage = 'function "'+cMessage ;
	} else {
		// A command is expanded
		cMessage = 'command "'+cMessage ;
	}
	// Display which function is expanded
	cMessage = ' '+GW_NAME+' '+cMessage+'" expanded ';
	rm('GHOST^center_message /M='+cMessage+' /COLOR=79') ;
	rm('GHOST^GWTempBox /M=Thanx for using GhostLib Assistant/D=500') ;

Exit:
	refresh = TRUE;                      // enable the screen
};

//--------------------------------------------------------------------------//
// End-of-line commenting                                                   //
//--------------------------------------------------------------------------//
macro EOLComment trans2 {

	str cLine ;

	mark_Pos;                            // Mark current cursor position
	cLine = shorten_str(get_line);       // Get current line
	if( svl(cLine) == 0 ) {              // If line is blank then do nothing
		goto_mark;
	} else if( (svl(cLine)+2) < global_int('!GWPosEOLComment') ) {
		goto_col(global_int('!GWPosEOLComment')); // Go to EOL comment position
		pop_mark;                          // Kill current cursor mark
	} else {
		goto_col(svl(cLine)+3);            // Go to EOL + 2
		pop_mark;
	};
	text(GW_EOLCOMMENTCHARS);            // Comment characters
};

//--------------------------------------------------------------------------//
// GhostLib Main Menu                                                       //
//--------------------------------------------------------------------------//
macro GWAssist trans2 {
	str   gstr[17];

	gstr = '!GW!_';
	create_global_str(gstr+'1','/S=0/M=GWBrowMenu');
	create_global_str(gstr+'X1','Browser functions       ');
	create_global_str(gstr+'2','/S=0/M=GWConMenu');
	create_global_str(gstr+'X2','Conversion functions    ');
	create_global_str(gstr+'3','/S=0/M=GWDBFMenu');
	create_global_str(gstr+'X3','Database functions      ');
	create_global_str(gstr+'4','/S=0/M=GWDOSMenu');
	create_global_str(gstr+'X4','dOS functions           ');
	create_global_str(gstr+'5','/S=0/M=GWGetMenu');
	create_global_str(gstr+'X5','GetList functions       ');
	create_global_str(gstr+'6','/S=0/M=GWHotMenu');
	create_global_str(gstr+'X6','Hotspot functions       ');
	create_global_str(gstr+'7','/S=0/M=GWMenuMenu');
	create_global_str(gstr+'X7','Menu functions          ');
	create_global_str(gstr+'8','/S=0/M=GWMisMenu');
	create_global_str(gstr+'X8','mIscellaneous functions ');
	create_global_str(gstr+'9','/S=0/M=GWMouseMenu');
	create_global_str(gstr+'X9','moUse functions         ');
	create_global_str(gstr+'10','/S=0/M=GWPrMenu');
	create_global_str(gstr+'X10','Printer functions       ');
	create_global_str(gstr+'11','/S=0/M=GWScrMenu');
	create_global_str(gstr+'X11','Screen functions        ');
	create_global_str(gstr+'12','/S=0/M=GWVidMenu');
	create_global_str(gstr+'X12','Video functions         ');
  create_global_str(gstr+'X13','|254');
	create_global_str(gstr+'14','/S=2/M=GHOST^STRING2CHR');
	create_global_str(gstr+'X14','sTring to CHR() call');
	create_global_str(gstr+'15','/S=2/M=GHOST^FUNCONVERT');
	create_global_str(gstr+'X15','''Fun-convert'' a string');
	create_global_str(gstr+'16','/S=2/M=GW_CONFG^GWCONFIG');
	create_global_str(gstr+'X16','coNfiguration...');
	create_global_str(gstr+'17','/S=2/M=AboutGhostLib');
	create_global_str(gstr+'X17','About '+GW_NAME+'...       ');

	rm('UserIn^SubMenu /X=25/GCLR=1/#=17/M=' + gstr + 'X' + '/S=' + global_str(gstr+'0') + '/L= '+GW_NAME+' Assistant ' + GW_VERSION + ' /G=' + gstr + MParm_Str);

};

//--------------------------------------------------------------------------//
// GhostLib Browser functions                                               //
//--------------------------------------------------------------------------//
macro GWBrowMenu trans2 {
	str   gstr[3];

	gstr = '!GWBrow!_';
	create_global_str(gstr+'1','/S=2/M=GW_EXPND^ExpandGWLib /E=ARRB-');
	create_global_str(gstr+'X1','A. GWARRBROWSE    (ARRB)');
	create_global_str(gstr+'2','/S=2/M=GW_EXPND^ExpandGWLib /E=DBFB-');
	create_global_str(gstr+'X2','B. GWDBFBROWSE    (DBFB)');
	create_global_str(gstr+'3','/S=2/M=GW_EXPND^ExpandGWLib /E=TXTB-');
	create_global_str(gstr+'X3','B. GWTXTBROWSE    (TXTB)');

	rm('UserIn^SubMenu /X=27/GCLR=1/#=3/M=' + gstr + 'X' + '/S=' + global_str(gstr+'0') + '/L=/G=' + gstr + MParm_Str);

};

//--------------------------------------------------------------------------//
// GhostLib Conversion functions                                            //
//--------------------------------------------------------------------------//
macro GWConMenu trans2 {
	str   gstr[7];

	gstr = '!GWCON!_';
	create_global_str(gstr+'1','/S=2/M=GW_EXPND^ExpandGWLib /E=AM2D-');
	create_global_str(gstr+'X1','A. GWAddM2Date()  (AM2D)');
	create_global_str(gstr+'2','/S=2/M=GW_EXPND^ExpandGWLib /E=AY2D-');
	create_global_str(gstr+'X2','B. GWAddY2Date()  (AY2D)');
	create_global_str(gstr+'3','/S=2/M=GW_EXPND^ExpandGWLib /E=DECR-');
	create_global_str(gstr+'X3','C. GWDecrypt()    (DECR)');
	create_global_str(gstr+'4','/S=2/M=GW_EXPND^ExpandGWLib /E=ENCR-');
	create_global_str(gstr+'X4','D. GWEncrypt()    (ENCR)');
	create_global_str(gstr+'5','/S=2/M=GW_EXPND^ExpandGWLib /E=NEDA-');
	create_global_str(gstr+'X5','E. GWNedAmount()  (NEDA)');
	create_global_str(gstr+'6','/S=2/M=GW_EXPND^ExpandGWLib /E=NEDD-');
	create_global_str(gstr+'X6','F. GWNedDate()    (NEDD)');
	create_global_str(gstr+'7','/S=2/M=GW_EXPND^ExpandGWLib /E=NEDP-');
	create_global_str(gstr+'X7','G. GWNedPercent() (NEDP)');

	rm('UserIn^SubMenu /X=27/GCLR=1/#=7/M=' + gstr + 'X' + '/S=' + global_str(gstr+'0') + '/G=' + gstr + MParm_Str);

};

//--------------------------------------------------------------------------//
// GhostLib Database functions                                              //
//--------------------------------------------------------------------------//
macro GWDBFMenu trans2 {
	str   gstr[7];

	gstr = '!GWDBF!_';
	create_global_str(gstr+'1','/S=2/M=GW_EXPND^ExpandGWLib /E=AR-');
	create_global_str(gstr+'X1','A. GWAddRec()     (AR)  ');
	create_global_str(gstr+'2','/S=2/M=GW_EXPND^ExpandGWLib /E=FL-');
	create_global_str(gstr+'X2','B. GWFileLock()   (FL)  ');
	create_global_str(gstr+'3','/S=2/M=GW_EXPND^ExpandGWLib /E=NE-');
	create_global_str(gstr+'X3','C. GWNetUse()     (NE)  ');
	create_global_str(gstr+'4','/S=2/M=GW_EXPND^ExpandGWLib /E=RL-');
	create_global_str(gstr+'X4','D. GWRecLock()    (RL)  ');
	create_global_str(gstr+'5','/S=2/M=GW_EXPND^ExpandGWLib /E=OP-');
	create_global_str(gstr+'X5','F. GWOpenDBF()    (OP)  ');
	create_global_str(gstr+'6','/S=2/M=GW_EXPND^ExpandGWLib /E=DBF2A-');
	create_global_str(gstr+'X6','G. GWDBF2Array()  (DBF2A)');
	create_global_str(gstr+'7','/S=2/M=GW_EXPND^ExpandGWLib /E=STATI-');
	create_global_str(gstr+'X7','H. STATISTIC ...  (STATI)');

	rm('UserIn^SubMenu /X=27/GCLR=1/#=7/M=' + gstr + 'X' + '/S=' + global_str(gstr+'0') + '/G=' + gstr + MParm_Str);

};

//--------------------------------------------------------------------------//
// GhostLib DOS functions                                                   //
//--------------------------------------------------------------------------//
macro GWDOSMenu trans2 {
	str   gstr[6];

	gstr = '!GWDOS!_';
	create_global_str(gstr+'1','/S=2/M=GW_EXPND^ExpandGWLib /E=CF-');
	create_global_str(gstr+'X1','A. GWCopyFile()     (CF) ');
	create_global_str(gstr+'2','/S=2/M=GW_EXPND^ExpandGWLib /E=GD-');
	create_global_str(gstr+'X2','B. GWGetDir()       (GD) ');
	create_global_str(gstr+'3','/S=2/M=GW_EXPND^ExpandGWLib /E=GT-');
	create_global_str(gstr+'X3','C. GWGetTree()      (GT) ');
	create_global_str(gstr+'4','/S=2/M=GW_EXPND^ExpandGWLib /E=IS-');
	create_global_str(gstr+'X4','D. GWIsValid()      (IS) ');
	create_global_str(gstr+'5','/S=2/M=GW_EXPND^ExpandGWLib /E=MEM-');
	create_global_str(gstr+'X5','E. GWMemory()       (MEM)');
	create_global_str(gstr+'6','/S=2/M=GW_EXPND^ExpandGWLib /E=ENV-');
	create_global_str(gstr+'X6','F. GWSave/RestEnv() (ENV)');

	rm('UserIn^SubMenu /X=27/GCLR=1/#=6/M=' + gstr + 'X' + '/S=' + global_str(gstr+'0') + '/G=' + gstr + MParm_Str);

};

//--------------------------------------------------------------------------//
// GhostLib GetList functions                                               //
//--------------------------------------------------------------------------//
macro GWGetMenu trans2 {
	str   gstr[14];

	gstr = '!GWGET!_';
	create_global_str(gstr+'1','/S=2/M=GW_EXPND^ExpandGWLib /E=BUT-');
	create_global_str(gstr+'X1','A. GET BUTTON...     (BUT) ');
	create_global_str(gstr+'2','/S=2/M=GW_EXPND^ExpandGWLib /E=CALC-');
	create_global_str(gstr+'X2','B. GET CALCULATOR... (CALC)');
	create_global_str(gstr+'3','/S=2/M=GW_EXPND^ExpandGWLib /E=CAL-');
	create_global_str(gstr+'X3','C. GET CALENDER...   (CAL) ');
	create_global_str(gstr+'4','/S=2/M=GW_EXPND^ExpandGWLib /E=CH-');
	create_global_str(gstr+'X4','D. GET CHECKBOX...   (CH)  ');
	create_global_str(gstr+'5','/S=2/M=GW_EXPND^ExpandGWLib /E=HI-');
	create_global_str(gstr+'X5','E. GET HISTORY...    (HI)  ');
	create_global_str(gstr+'6','/S=2/M=GW_EXPND^ExpandGWLib /E=INI-');
	create_global_str(gstr+'X6','F. GET INITIALS...   (INI) ');
	create_global_str(gstr+'7','/S=2/M=GW_EXPND^ExpandGWLib /E=ME-');
	create_global_str(gstr+'X7','G. GET MEMO...       (ME)  ');
	create_global_str(gstr+'8','/S=2/M=GW_EXPND^ExpandGWLib /E=PAS-');
	create_global_str(gstr+'X8','H. GET PASSWORD...   (PAS) ');
	create_global_str(gstr+'9','/S=2/M=GW_EXPND^ExpandGWLib /E=PIC-');
	create_global_str(gstr+'X9','I. GET PICK...       (PIC)  ');
	create_global_str(gstr+'10','/S=2/M=GW_EXPND^ExpandGWLib /E=RA-');
	create_global_str(gstr+'X10','J. GET RADIO...      (RA)  ');
	create_global_str(gstr+'11','/S=2/M=GW_EXPND^ExpandGWLib /E=PRE-');
	create_global_str(gstr+'X11','K. GWPrePick()       (PRE) ');
	create_global_str(gstr+'12','/S=2/M=GW_EXPND^ExpandGWLib /E=POST-');
	create_global_str(gstr+'X12','L. GWPostPick()      (POST)');
	create_global_str(gstr+'13','/S=2/M=GW_EXPND^ExpandGWLib /E=GETN-');
	create_global_str(gstr+'X13','M. GWGetNumber()     (GETN)');
	create_global_str(gstr+'14','/S=2/M=GW_EXPND^ExpandGWLib /E=GETF-');
	create_global_str(gstr+'X14','N. GWGetFill()       (GETF)');

	rm('UserIn^SubMenu /X=27/GCLR=1/#=14/M=' + gstr + 'X' + '/S=' + global_str(gstr+'0') + '/G=' + gstr + MParm_Str);

};

//--------------------------------------------------------------------------//
// GhostLib Hotspot functions                                               //
//--------------------------------------------------------------------------//
macro GWHotMenu trans2 {
	str   gstr[10];

	gstr = '!GWHOT!_';
	create_global_str(gstr+'1','/S=2/M=GW_EXPND^ExpandGWLib /E=DEFH-');
	create_global_str(gstr+'X1','A. DEFINE HOTSPOT...   (DEFH) ');
	create_global_str(gstr+'2','/S=2/M=GW_EXPND^ExpandGWLib /E=COOLA-');
	create_global_str(gstr+'X2','B. COOL ALL HOTSPOTS   (COOLA)');
	create_global_str(gstr+'3','/S=2/M=GW_EXPND^ExpandGWLib /E=COOL-');
	create_global_str(gstr+'X3','C. COOL HOTSPOT...     (COOL) ');
	create_global_str(gstr+'4','/S=2/M=GW_EXPND^ExpandGWLib /E=DELA-');
	create_global_str(gstr+'X4','D. DELETE ALL HOTSPOTS (DELA) ');
	create_global_str(gstr+'5','/S=2/M=GW_EXPND^ExpandGWLib /E=DEL-');
	create_global_str(gstr+'X5','E. DELETE HOTSPOT...   (DEL)  ');
	create_global_str(gstr+'6','/S=2/M=GW_EXPND^ExpandGWLib /E=PAI-');
	create_global_str(gstr+'X6','F. PAINT HOTSPOTS      (PAI)  ');
	create_global_str(gstr+'7','/S=2/M=GW_EXPND^ExpandGWLib /E=RESH-');
	create_global_str(gstr+'X7','G. RESTORE HOTSPOTS... (RESH) ');
	create_global_str(gstr+'8','/S=2/M=GW_EXPND^ExpandGWLib /E=SAVH-');
	create_global_str(gstr+'X8','H. SAVE HOTSPOTS...    (SAVH) ');
	create_global_str(gstr+'9','/S=2/M=GW_EXPND^ExpandGWLib /E=WARMA-');
	create_global_str(gstr+'X9','I. WARM ALL HOTSPOTS   (WARMA)');
	create_global_str(gstr+'10','/S=2/M=GW_EXPND^ExpandGWLib /E=WARM-');
	create_global_str(gstr+'X10','J. WARM HOTSPOT...     (WARM) ');

	rm('UserIn^SubMenu /X=27/GCLR=1/#=10/M=' + gstr + 'X' + '/S=' + global_str(gstr+'0') + '/G=' + gstr + MParm_Str);

};

//--------------------------------------------------------------------------//
// GhostLib Menu functions                                                  //
//--------------------------------------------------------------------------//
macro GWMenuMenu trans2 {
	str   gstr[6];

	gstr = '!GWMENU!_';
	create_global_str(gstr+'1','/S=2/M=GW_EXPND^ExpandGWLib /E=ASK-');
	create_global_str(gstr+'X1','A. GWASKTHIS        (ASK) ');
	create_global_str(gstr+'2','/S=2/M=GW_EXPND^ExpandGWLib /E=PD-');
	create_global_str(gstr+'X2','B. GWPullDown()     (PD)  ');
	create_global_str(gstr+'3','/S=2/M=GW_EXPND^ExpandGWLib /E=MEN-');
	create_global_str(gstr+'X3','C. BEGIN MENU ...   (MEN) ');
	create_global_str(gstr+'4','/S=2/M=GW_EXPND^ExpandGWLib /E=OPT-');
	create_global_str(gstr+'X4','D. OPTION DO ...    (OPT) ');
	create_global_str(gstr+'5','/S=2/M=GW_EXPND^ExpandGWLib /E=SUB-');
	create_global_str(gstr+'X5','E. OPTION SUBMENU ..(SUB) ');
	create_global_str(gstr+'6','/S=2/M=GW_EXPND^ExpandGWLib /E=ACTI-');
	create_global_str(gstr+'X6','F. ACTIVATE MENU ...(ACTI)');

	rm('UserIn^SubMenu /X=27/GCLR=1/#=6/M=' + gstr + 'X' + '/S=' + global_str(gstr+'0') + '/G=' + gstr + MParm_Str);

};

//--------------------------------------------------------------------------//
// GhostLib Miscellaneous functions                                         //
//--------------------------------------------------------------------------//
macro GWMisMenu trans2 {
	str   gstr[5];

	gstr = '!GWMIS!_';
	create_global_str(gstr+'1','/S=2/M=GW_EXPND^ExpandGWLib /E=MEMD-');
	create_global_str(gstr+'X1','A. GWMemoDisplay()  (MEMD)');
	create_global_str(gstr+'2','/S=2/M=GW_EXPND^ExpandGWLib /E=MEME-');
	create_global_str(gstr+'X2','B. GWMemoEdit()     (MEME)');
	create_global_str(gstr+'3','/S=2/M=GW_EXPND^ExpandGWLib /E=TR-');
	create_global_str(gstr+'X3','C. GWTrace()        (TR)  ');
	create_global_str(gstr+'4','/S=2/M=GW_EXPND^ExpandGWLib /E=WK-');
	create_global_str(gstr+'X4','D. GWWaitKey()      (WK)  ');
	create_global_str(gstr+'5','/S=2/M=GW_EXPND^ExpandGWLib /E=AS-');
	create_global_str(gstr+'X5','E. GWaSearch()      (AS)  ');

	rm('UserIn^SubMenu /X=27/GCLR=1/#=5/M=' + gstr + 'X' + '/S=' + global_str(gstr+'0') + '/G=' + gstr + MParm_Str);

};

//--------------------------------------------------------------------------//
// GhostLib Mouse functions                                                 //
//--------------------------------------------------------------------------//
macro GWMouseMenu trans2 {
	str   gstr[4];

	gstr = '!GWMOUSE!_';
	create_global_str(gstr+'1','/S=2/M=GW_EXPND^ExpandGWLib /E=ACT-');
	create_global_str(gstr+'X1','A. GWAction()       (ACT)');
	create_global_str(gstr+'2','/S=2/M=GW_EXPND^ExpandGWLib /E=IN-');
	create_global_str(gstr+'X2','B. GWmInArea()      (IN) ');
	create_global_str(gstr+'3','/S=2/M=GW_EXPND^ExpandGWLib /E=MR-');
	create_global_str(gstr+'X3','C. GWmRead()        (MR) ');
	create_global_str(gstr+'4','/S=2/M=GW_EXPND^ExpandGWLib /E=MU-');
	create_global_str(gstr+'X4','D. GWmUse()         (MU) ');

	rm('UserIn^SubMenu /X=27/GCLR=1/#=4/M=' + gstr + 'X' + '/S=' + global_str(gstr+'0') + '/G=' + gstr + MParm_Str);
};

//--------------------------------------------------------------------------//
// GhostLib Printer functions                                               //
//--------------------------------------------------------------------------//
macro GWPrMenu trans2 {
	str   gstr[5];

	gstr = '!GWPR!_';
	create_global_str(gstr+'1','/S=2/M=GW_EXPND^ExpandGWLib /E=HPB-');
	create_global_str(gstr+'X1','A. GWHPBehavior()   (HPB)');
	create_global_str(gstr+'2','/S=2/M=GW_EXPND^ExpandGWLib /E=HPF-');
	create_global_str(gstr+'X2','B. GWHPFont()       (HPF)');
	create_global_str(gstr+'3','/S=2/M=GW_EXPND^ExpandGWLib /E=PF-');
	create_global_str(gstr+'X3','C. GWPageFull()     (PF) ');
	create_global_str(gstr+'4','/S=2/M=GW_EXPND^ExpandGWLib /E=PT-');
	create_global_str(gstr+'X4','D. GWPrintText()    (PT) ');
	create_global_str(gstr+'5','/S=2/M=GW_EXPND^ExpandGWLib /E=LAB-');
	create_global_str(gstr+'X5','E. LABEL...         (LAB)');

	rm('UserIn^SubMenu /X=27/GCLR=1/#=5/M=' + gstr + 'X' + '/S=' + global_str(gstr+'0') + '/G=' + gstr + MParm_Str);

};

//--------------------------------------------------------------------------//
// GhostLib Screen functions                                                //
//--------------------------------------------------------------------------//
macro GWScrMenu trans2 {
	str   gstr[9];

	gstr = '!GWSCR!_';
	create_global_str(gstr+'1','/S=2/M=GW_EXPND^ExpandGWLib /E=CLS-');
	create_global_str(gstr+'X1','A. GWClearScreen()     (CLS)');
	create_global_str(gstr+'2','/S=2/M=GW_EXPND^ExpandGWLib /E=MES-');
	create_global_str(gstr+'X2','B. GWMessage()         (MES)');
	create_global_str(gstr+'3','/S=2/M=GW_EXPND^ExpandGWLib /E=SAS-');
	create_global_str(gstr+'X3','C. GWSave/RestScreen() (SAS)');
	create_global_str(gstr+'4','/S=2/M=GW_EXPND^ExpandGWLib /E=BOX-');
	create_global_str(gstr+'X4','D. GWBOX               (BOX)');
	create_global_str(gstr+'5','/S=2/M=GW_EXPND^ExpandGWLib /E=STB-');
	create_global_str(gstr+'X5','E. GWStatusBar()       (STB)');
	create_global_str(gstr+'6','/S=2/M=GW_EXPND^ExpandGWLib /E=STL-');
	create_global_str(gstr+'X6','F. GWStatusLine()      (STL)');
	create_global_str(gstr+'7','/S=2/M=GW_EXPND^ExpandGWLib /E=EXP-');
	create_global_str(gstr+'X7','G. SET EXPLOSION ...   (EXP)');
	create_global_str(gstr+'8','/S=2/M=GW_EXPND^ExpandGWLib /E=SCR-');
	create_global_str(gstr+'X8','H. SET SCREENSAVER ... (SCR)');
	create_global_str(gstr+'9','/S=2/M=GW_EXPND^ExpandGWLib /E=SHH-');
	create_global_str(gstr+'X9','I. SET SHADOWHEIGHT .. (SHH)');

	rm('UserIn^SubMenu /X=27/GCLR=1/#=9/M=' + gstr + 'X' + '/S=' + global_str(gstr+'0') + '/G=' + gstr + MParm_Str);

};

//--------------------------------------------------------------------------//
// GhostLib Video functions                                                 //
//--------------------------------------------------------------------------//
macro GWVidMenu trans2 {
	str   gstr[8];

	gstr = '!GWVID!_';
	create_global_str(gstr+'1','/S=2/M=GW_EXPND^ExpandGWLib /E=ENCOL-');
	create_global_str(gstr+'X1','A. GWEn/DisableColor() (ENCOL)');
	create_global_str(gstr+'2','/S=2/M=GW_EXPND^ExpandGWLib /E=AVGA-');
	create_global_str(gstr+'X2','B. GWAllVGAColor()     (AVGA) ');
	create_global_str(gstr+'3','/S=2/M=GW_EXPND^ExpandGWLib /E=VGA-');
	create_global_str(gstr+'X3','C. GWVGAColor()        (VGA)  ');
	create_global_str(gstr+'4','/S=2/M=GW_EXPND^ExpandGWLib /E=SPEC-');
	create_global_str(gstr+'X4','D. GWUseSpecial()      (SPEC) ');
	create_global_str(gstr+'5','/S=2/M=GW_EXPND^ExpandGWLib /E=LF-');
	create_global_str(gstr+'X5','E. GWLoadFont()        (LF)   ');
	create_global_str(gstr+'6','/S=2/M=GW_EXPND^ExpandGWLib /E=MC-');
	create_global_str(gstr+'X6','F. GWMakeChar()        (MC)   ');
	create_global_str(gstr+'7','/S=2/M=GW_EXPND^ExpandGWLib /E=RF-');
	create_global_str(gstr+'X7','G. GWReadFont()        (RF)   ');
	create_global_str(gstr+'8','/S=2/M=GW_EXPND^ExpandGWLib /E=UF-');
	create_global_str(gstr+'X8','H. GWUseFonts()        (UF)   ');

	rm('UserIn^SubMenu /X=27/GCLR=1/#=8/M=' + gstr + 'X' + '/S=' + global_str(gstr+'0') + '/G=' + gstr + MParm_Str);

};

//--------------------------------------------------------------------------//
// Display About GhostLib window                                            //
//--------------------------------------------------------------------------//
macro AboutGhostLib TRANS {
	int  menu = menu_create, iCount=25;
	// Just to get attention, and for fun (of the programmer)
	while (iCount < 2000) {
  //	sound(iCount);
		delay(5);
		iCount = iCount + 25 ;
	};
	sound(0);

	// Colors for displaying GHOSTLIB are the colors of the 'highlighted menu-bar'
	menu_set_item( menu, 1, '','',	'/L=1/C=2/ATTR=' + str( m_h_color ),10,0, 0);
	menu_set_item( menu, 2, '             ','',	'/L=2/C=2/ATTR=' + str( m_h_color ),10,0, 0);
	menu_set_item( menu, 3, '                      ','',	'/L=3/C=2/ATTR=' + str( m_h_color ),10,0, 0);
	menu_set_item( menu, 4, '                  ','',	'/L=4/C=2/ATTR=' + str( m_h_color ),10,0, 0);
	menu_set_item( menu, 5, '                      ','',	'/L=5/C=2/ATTR=' + str( m_h_color ),10,0, 0);
	menu_set_item( menu, 6, '              ','',	'/L=6/C=2/ATTR=' + str( m_h_color ),10,0, 0);
	menu_set_item( menu, 7, '','',	'/L=7/C=2/ATTR=' + str( m_h_color ),10,0, 0);
	menu_set_item( menu, 8, 'Version ' + GW_VERSION,'',	'/L=9/C=22',10,0, 0);
  menu_set_item( menu, 9, 'Copyright(c) '+GW_COPYRIGHTYEAR+' by GhostWare','', '/L=10/C=10',10,0, 0);

	menu_set_item( menu, 10, GW_NAME+' is a Clipper 5.2 multipurpose shareware   ','',
			'/L=12/C=2',10,0, 0);
	menu_set_item( menu, 11, 'library created by Ren van Geest / GhostWare.     ','',
			'/L=13/C=2',10,0, 0);
	menu_set_item( menu, 12, 'A demo of the library can be obtained from many    ','',
			'/L=14/C=2',10,0, 0);
	menu_set_item( menu, 13, 'Bulletin Board Systems. After registration you     ','',
			'/L=15/C=2',10,0, 0);
	menu_set_item( menu, 14, 'will receive the complete library and Norton Guide.','',
			'/L=16/C=2',10,0, 0);
	return_int = menu;
	RM('UserIn^Data_In /HN=1/H=*/A=1/#=14/T=');
	menu_delete( menu );
	while (iCount > 25) {
  	//sound(iCount);
		delay(5);
		iCount = iCount - 25 ;
	};
	sound(0);
}
