/*
 * GT CLIPPER STANDARD HEADER
 *
 * File......: xseek.prg
 * Author....: Andy M Leighton
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Andy Leighton
 * Date......: $Date$
 * Revision..: $Revision$
 *
 * This is an original work by Andy Leighton and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *       GT_XSEEK()
 *  $CATEGORY$
 *       General
 *  $ONELINER$
 *       Special seek function. (x = xtra)
 *  $SYNTAX$
 *       GT_xSeek(xValue, nSeekNum, nOrder, bBlock) --> xRet
 *  $ARGUMENTS$
 *       <xValue>    -  The value to seek for
 *       <nSeekNum>  -  Option (type of seek (see Description))
 *       <nOrder>    -  The index order to seek
 *       <bBlock>    -  A block to eval to get a return value iff
 *                      required
 *  $RETURNS$
 *       <xRet>      -  If nSeekNum == 1, xRet == found()
 *                   -  If nSeekNum == 2, xRet == found()
 *                   -  If nSeekNum == 3, xRet == ""
 *                   -  If nSeekNum == 4, xRet == eval(bBlock)
 *  $DESCRIPTION$
 *       This function does four separate things dependant on nSeekNum
 *
 *       nSeekNum    What Happens
 *           
 *              1    leave record pointer where found and return found()
 *              2    return record pointer to previous, return found()
 *              3    leave record pointer where found and return ''
 *              4    value = eval(bBlock), go previous rec, return value
 *
 *  $EXAMPLES$
 *        .
 *        .
 *     xLookup := DBFILE->(GT_xSeek("KEYS", 4, 1, {|| DESC_40}))
 *        .
 *        .
 *  $SEEALSO$
 *  $END$
 */

#include "gt_LIB.ch"

function GT_xSeek(xValue, nSeekNum, nOrder, bBlock)

   local nOldOrder
   local xRet
   local nRec

   if nOrder == NIL
      nOldOrder := -1
   else
      nOldOrder := indexOrd()
      set order to nOrder
   endif

   nRec := recno()
   seek xValue
   xRet := found()

   if nSeekNum == 2 .or. nSeekNum == 4
      if valtype(bBlock) == "B"
         xValue = eval(bBlock)
      endif

      go nRec
   endif

   if nOldOrder != -1
      set order to nOldOrder
   endif

return if(nSeekNum == 3, '', if(nSeekNum == 4, xValue, xRet))
