/*
 * GT CLIPPER STANDARD HEADER
 *
 * File......: xplodasc.prg
 * Author....: Andy M Leighton
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Andy Leighton
 * Date......: $Date$
 * Revision..: $Revision$
 *
 * This is an original work by Andy Leighton and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *       GT_EXPLODEASCII()
 *  $CATEGORY$
 *       String
 *  $ONELINER$
 *       Explode a string into an array of ascii values
 *  $SYNTAX$
 *       GT_ExplodeAscii(<cStr>) --> aAscVals
 *  $ARGUMENTS$
 *       <cStr>     -  The string to explode
 *  $RETURNS$
 *       aAscVals   -  An array of ascii values
 *  $DESCRIPTION$
 *       Explode a string into an array of ascii values
 *  $EXAMPLES$
 *       aVals := GT_ExplodeAscii("Hello World")
 *
 *       for i := 1 to len(aVals)
 *          ? aVals[i], "   ", chr(aVals[i])
 *       next
 *
 *  $SEEALSO$
 *       GT_IMPLODEASCII()
 *  $END$
 */

#include "gt_LIB.ch"

function GT_ExplodeAscii(cStr)

   local aAscVals := array(len(cStr))
   local i

   for i := 1 to len(cStr)
      aAscVals := asc(substr(cStr, i, 1))
   next

return aAscVals
