/*
 * File......: X2CHAR.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_X2CHAR()
 *  $CATEGORY$
 *      String
 *  $ONELINER$
 *      Convert a value of any type into a string
 *  $SYNTAX$
 *      GT_X2Char( xExp )
 *  $ARGUMENTS$
 *      xExp - Expression to convert
 *  $RETURNS$
 *      A string of xExp
 *  $DESCRIPTION$
 *      Finds the type of xExp and converts it to a string
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

*
FUNCTION GT_X2Char( xValue , nWidth )

/*****************************************************************************
 Purpose - Convert any type into a justified char of the given width
 Returns - Char value
 Author  - Log
 Created - 19/01/93
******************************************************************************
 Parameters - xValue - Value to convert to char
              nWidth - Width to make char
 Privates   - None
 Locals     - None
 Externals  - None
*****************************************************************************/

DO CASE
    CASE VALTYPE( xValue ) == "N"
        xValue := PADL( STR( xValue ) , nWidth )

    CASE VALTYPE( xValue ) == "D"
        xValue := PADR( DTOC( xValue ) , nWidth )

    CASE VALTYPE( xValue ) == "C"
        xValue := PADR( xValue , nWidth )

    CASE VALTYPE( xValue ) == "L"
        xValue := PADR( IIF( xValue , "T" , "F" ) , nWidth )

    CASE VALTYPE( xValue ) == "A"
        xValue := PADR( "ARRAY!" , nWidth )

    CASE VALTYPE( xValue ) == "M"
        xValue := PADR( "MEMO" , nWidth )

    OTHERWISE   // just in case
        xValue := PADR( STR( RECNO() ) , nWidth )

ENDCASE

RETURN( xValue )
*
