/*
 * File......: VERIFY.C
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

// NOTE: This code has been written for and compiled with Borland C++
//       Version 3.1
//

#include <extend.h>

Boolean GetVerify(void);
void    SetVerify(char);

/*  $DOC$
 *  $FUNCNAME$
 *      GT_VERIFY()
 *  $CATEGORY$
 *      Environment
 *  $ONELINER$
 *      Set/Get the DOS verify flag.
 *  $SYNTAX$
 *      GT_Verify([<lNewSetting>]) --> lOldSetting
 *  $ARGUMENTS$
 *      <lNewSetting> is an optional logical parameter. If true (.T.)
 *      the DOS verify flag will be turned on, if false (.F.) it will be
 *      turned off. If not passed GT_Verify() just returns the current
 *      setting.
 *  $RETURNS$
 *      The status of the verify flag. If a new setting is passed then
 *      the previous setting is returned. If a new setting is not
 *      passed then the current setting is returned.
 *  $DESCRIPTION$
 *      GT_Verify() can be used to set and get the status of the DOS verify
 *      flag.
 *  $EXAMPLES$
 *      // Set the DOS verify flag on.
 *
 *      GT_Verify(TRUE)
 *
 *      // Display the current DOS verify flag setting.
 *
 *      ? GT_Verify()
 *  $SEEALSO$
 *      GT_BREAK()
 *  $END$
 */

CLIPPER GT_Verify()
{
        Boolean OldSetting = GetVerify();

        if (PCOUNT == 1 && ISLOG(1))
        {
                SetVerify((char) _parl(1));
        }
        _retl(OldSetting);
}

/*****************************************************************************
* Function: GetVerify()                                                      *
* Syntax..: Boolean GetVerify(void)                                          *
* Usage...: Internal function to get the verify flag.                        *
* By......: David A Pearson                                                  *
*****************************************************************************/

static Boolean GetVerify(void)
{
        asm     Mov     AH,0x54
        asm     Int     0x21
        return(_AL);
}

/*****************************************************************************
* Function: SetVerify()                                                      *
* Syntax..: Boolean SetVerify(void)                                          *
* Usage...: Internal function to set the verify flag.                        *
* By......: David A Pearson                                                  *
*****************************************************************************/

static void SetVerify(char NewSetting)
{
        asm     Mov     AH,0x2E
        asm     Mov     AL,NewSetting
        asm     Mov     DL,0
        asm     Int     0x21
}
