/*
 * File......: STOD.C
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: 30/03/93
 * Revision..: 1.0
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

// NOTE: This code has been written for and compiled with Borland C++
//       Version 3.1
//

#include <Extend.H>

/*  $DOC$
 *  $FUNCNAME$
 *      GT_STOD()
 *  $CATEGORY$
 *      Date
 *  $ONELINER$
 *      Convert a YYYYMMDD string to a Clipper date.
 *  $SYNTAX$
 *      GT_SToD(<cDateString>) --> dClipperDate
 *  $ARGUMENTS$
 *      <cDateString> is a string in the same format as that returned by
 *      the Clipper function dtos(). The format is "YYYYMMDD" where "YYYY"
 *      is the year, "MM" is the month and "DD" is the day.
 *  $RETURNS$
 *      A Clipper date.
 *  $DESCRIPTION$
 *      GT_SToD() can be used to convert a string date into a Clipper date
 *      variable. This is of use if you wish to hard code a date into a
 *      program but you don't know what date format will be used.
 *  $EXAMPLES$
 *      set date    british
 *      set century off
 *      dDate := GT_SToD("19671209")
 *      ? dDate                         // Prints `09/12/67'
 *  $END$
 */

CLIPPER GT_SToD()
{
        if (PCOUNT == 1 && ISCHAR(1))
        {
                _retds(_parc(1));
        }
        else
        {
                _retds(NULL);
        }
}
