/*
 * File......: SETDATE.C
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

// NOTE: This code has been written for and compiled with Borland C++
//       Version 3.1
//

#include <extend.h>
#include "internal.h"

Boolean SetDosDate(char, char, int);

/*  $DOC$
 *  $FUNCNAME$
 *      GT_SETDATE()
 *  $CATEGORY$
 *      Date
 *  $ONELINER$
 *      Set the DOS system date.
 *  $SYNTAX$
 *      GT_SetDate(<dDate>) --> lSetOk
 *  $ARGUMENTS$
 *      <dDate> is a date parameter.
 *  $RETURNS$
 *      If the date was set ok, GT_SetDate() returns true (.T.), if not
 *      it returns false (.F.).
 *  $DESCRIPTION$
 *      GT_SetDate() can be used to set the DOS system date to a new
 *      value.
 *  $EXAMPLES$
 *      // Set the DOS system date forward one week.
 *
 *      ? GT_SetDate(date()+7)
 *  $SEEALSO$
 *      GT_SETTIME()
 *  $END$
 */

CLIPPER GT_SetDate()
{
        char    *Date;
        Boolean Result = FALSE;

        if (PCOUNT == 1 && ISDATE(1))
        {
                Date = _pards(1);
                if (Date[0] != ' ')
                {
                        Result = SetDosDate((char) _GT_Internal_StringAsInt(Date,6,7),
                                            (char) _GT_Internal_StringAsInt(Date,4,5),
                                            _GT_Internal_StringAsInt(Date,0,3));
                }
        }
        _retl(Result);
}

/*****************************************************************************
* Function: SetDosDate()                                                     *
* Syntax..: Boolean SetDosDate(char Day, char Month, int Year)               *
* Usage...: Internal function to call the DOS set date function.             *
* By......: David A Pearson                                                  *
*****************************************************************************/

static Boolean SetDosDate(char Day, char Month, int Year)
{
        asm     Mov     AH,0x2B
        asm     Mov     DH,Month
        asm     Mov     DL,Day
        asm     Mov     CX,Year
        asm     Int     0x21
        return(_AL != 0xFF);
}
