/*
 * File......: RECLOCK.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_RECLOCK()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Lock a record with optional retries
 *  $SYNTAX$
 *      GT_RecLock( nSeconds )
 *  $ARGUMENTS$
 *      nSeconds - Number of retries
 *  $RETURNS$
 *      .T. if record locked
 *  $DESCRIPTION$
 *      Attempts to lock the current record in the current workarea.
 *      If unsuccessful, will pause for 1 second and retry.  After nSeconds
 *      retries it will abort.  If nSeconds is 0, will retry indefinatley.
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */
*
FUNCTION GT_RecLock( nSeconds )

/*****************************************************************************
 Purpose - Attempt to RLOCK() with optional retry
 Returns - .T. if successful
 Author  - Martin Colloby
 Created - 20/05/92
******************************************************************************
 Parameters - nSeconds - Number of attempts
 Privates   - None
 Locals     - lForever - If .T., loop forever
 Externals  - None
*****************************************************************************/

LOCAL lForever := (nSeconds == 0)

IF RLOCK()
    * Locked
    RETURN (.T.)
ENDIF

DO WHILE (lForever .OR. nSeconds > 0)
    IF RLOCK()
        * Locked
        RETURN (.T.)
    ENDIF

    * Wait 1/2 second
    INKEY(.5)
    nSeconds := nSeconds - .5
ENDDO

* Not locked
RETURN (.F.)
*
