/*
 * File......: LOGFILE.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_LOGFILE()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Maintain a text log file
 *  $SYNTAX$
 *      GT_LogFile( cText , cFile , lTimeStamp )
 *  $ARGUMENTS$
 *      cText      - Text to add to log file
 *      cFile      - File to update
 *      lTimeStamp - If .T. add a time stamp
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      Adds the given text to a text log file.  If lTimeStamp is .T.,
 *      a date and time stamp is added before the text.
 *      If cFile does not exist, it is created.
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */
*
#include "GT_LIB.ch"

FUNCTION GT_LogUpdate( cText , cFile, lTimeStamp )

/*****************************************************************************
 Purpose - Output the given text to the log file, together with date and
           time stamps
 Returns - None
 Author  - Martin Colloby
 Created - 13/11/91
******************************************************************************
 Parameters - cText      - Text to be written to file
              cFile      - File to be writtem to
              lTimeStamp - If true append date and time to logfile entry
 Locals     - nHandle - Handle of text file
 Externals  - None
*****************************************************************************/

LOCAL nHandle := 0

DEFAULT lTimeStamp TO .T.

* Check to see if the file exists
IF !FILE( cFile )
    * File doesn't exist, so create it
    nHandle := FCREATE( cFile )
    IF nHandle == -1
        GT_Warning( { "FATAL ERROR :" , ;
                      "Cannot create log file " + cFile } )
        QUIT
    ENDIF
ELSE
    * File exists, so open it
    nHandle := FOPEN( cFile , FO_WRITE )
    IF nHandle == -1
        GT_Warning( { "FATAL ERROR :" , ;
                      "Cannot open log file " + cFile } )
        QUIT
    ENDIF
ENDIF

* Find the end of the file
FSEEK( nHandle , 0 , FS_END )

* Write the new text to the file
IF lTimeStamp
    FWRITE( nHandle , DTOC( DATE() ) + "," + TIME() + "," + cText + K_CRLF )
ELSE
    FWRITE( nHandle , cText + K_CRLF )
ENDIF

* Close the file
FCLOSE( nHandle )

RETURN NIL
*
