/*
 * GT CLIPPER STANDARD HEADER
 *
 * File......: levcost.prg
 * Author....: Andy M Leighton
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Andy Leighton
 * Date......: $Date$
 * Revision..: $Revision$
 *
 * This is an original work by Andy Leighton and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *       GT_LEVCOST()
 *  $CATEGORY$
 *       String
 *  $ONELINER$
 *       Alter the costing of the various operations for GT_LevDist()
 *  $SYNTAX$
 *       GT_LevCost(<aCosts>) --> aOldCosts
 *  $ARGUMENTS$
 *       <aCosts>    -  An array of operation costs
 *                          aCosts[1] == cost of insertion
 *                          aCosts[2] == cost of deletion
 *                          aCosts[3] == cost of substitution
 *  $RETURNS$
 *       aOldCosts   -  The old set of operation costs
 *  $DESCRIPTION$
 *       Alter the costing of the various operations for GT_LevDist()
 *
 *       For  some  applications  of  Levenshtein  distances  it is
 *       important to  alter the  cost of  the various  operations.
 *       For  example  if  analysing  DNA  insertions and deletions
 *       should  be  more  costly  than  substitutions.  However if
 *       trying to write voice recognition software the reverse  is
 *       true (sounds often vary in length)
 *
 *       REFERENCE
 *       Doctor Dobb's Journal #187, April 1992
 *
 *       IMPROVEMENTS
 *       The  main  improvements  in  this  routine will be made by
 *       introducing a more complex operation costing.
 *
 *       ie. have three matrices that record the cost of adding  or
 *           deleting  a  specific   letter,  and  substituting   a
 *           specified letter with another.
 *
 *       More improvements can be achieved  but at the loss of  the
 *       general purpose of the routine.
 *
 *       This is left as an exercise for the foolhardy or brave.
 *  $SEEALSO$
 *       GT_LEVDIST()
 *  $EXAMPLES$
 *  $END$
 */

#include "gt_LIB.ch"
#include "levensht.ch"

function GT_LevCost(aCosts)

   local xRet := array(3)

   xRet[1] := gGT_Cost(LV_INS)
   xRet[2] := gGT_Cost(LV_DEL)
   xRet[3] := gGT_Cost(LV_SUB)

   if valtype("aCosts[1]") == "N"
      gGT_Cost(LV_INS, aCosts[1])
   endif

   if valtype("aCosts[2]") == "N"
      gGT_Cost(LV_DEL, aCosts[2])
   endif

   if valtype("aCosts[3]") == "N"
      gGT_Cost(LV_SUB, aCosts[3])
   endif

return xRet
