/*
 * File......: ISDBF.PRG
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "gt_lib.ch"

/*  $DOC$
 *  $FUNCNAME$
 *      GT_ISDBF()
 *  $CATEGORY$
 *      File I/O
 *  $ONELINER$
 *      Check that a file is a DBF file.
 *  $SYNTAX$
 *      GT_IsDbf(<cFileName>) --> lIsDbf
 *  $ARGUMENTS$
 *      <cFileName> is the name of the DBF file. If the name has no
 *      extension it defaults to DBF.
 *  $RETURNS$
 *      .T. if the file is a DBF file, .F. if not.
 *  $DESCRIPTION$
 *      GT_IsDbf() is designed to check that a file is a Clipper DBF file.
 *  $EXAMPLES$
 *      // Check if a file is a DBF file.
 *
 *      ? GT_IsDbf("Life")
 *  $END$
 */

function GT_IsDbf(cFileName)
local nFile   := 0  ,;
      cIdChar := " ",;
      lIsDbf  := FALSE
if valtype(cFileName) == TYPE_CHAR
   cFileName := GT_DefExt(cFileName,"Dbf")
   if (nFile := fopen(cFileName,FO_READ)) != F_ERROR
      if fread(nFile,@cIdChar,1) == 1
         if asc(cIdChar) == 3 .or. asc(cIdChar) == 131
            lIsDbf := TRUE
         endif
      endif
      fclose(nFile)
   endif
endif
return(lIsDbf)
