/*
 * File......: HELP.PRG
 * Author....: Simon Coates
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Simon Coates
 * Date......: 08/07/1993
 * Revision..: 1.0
 *
 * This is an original work by Simon Coates and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *      GT_HELPREQUEST
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *     Context Sensitive Help Driver
 *  $SYNTAX$
 *      Set Key nn To GT_HelpRequest
 *  $ARGUMENTS$
 *
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      This is a simple 'Help Engine'. It must be simple since I wrote it
 *      <g>. The routine will create the help database automatically if
 *      the file 'HELPFILE', is missing. If the user requests help at any
 *      point where it has not been previously defined, then it will create
 *      a blank entry in the database, with the relevant calling points &
 *      variables.
 *      It also creates and index called
 *      'HelpFil1.NTX' as well.The structure is as follows :-
 *
 *      VARIABLE_   Character   12
 *      ROUTINE_    Character   12
 *      HELPTEXT_   Memo
 *      TITLE_      Character   15
 *
 *      The file should be indexed on Upper(Variable_)+Upper(Routine_)
 *
 *      NB This routine uses the following routines :-
 *      GT_ELEVBAR      by       MartDude
 *      GT_OPEN         by       MortDude
 *      GT_BLOCK        by       Me!
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

/****************************************************************************
 Purpose - Displays context sensitive help based on current get variable
 Returns - None
 Author  - Simon Coates
 Created - 08 June 1993
******************************************************************************
Parameters  - cProc      - Calling Procedure
              nLine      - Current line of procedure
              cVar       - Current variable
Locals      - cOldScreen - Holds old screen
            - cOldColours- Holds existing screen colours
            - cOldArea   - Holds old Alias
            - nBoxT   Ŀ
            - nBoxL   Ĵ
            - nBoxB    Co-ordinates of box
            - nBoxR   
            - nMaxCol    - Screen Size
            - nMaxRow
            - aStructure - Holds the structure of the DBF file
****************************************************************************/

Function GT_HelpRequest(cProc, nLine, cVar)

Local nMaxRow := MaxRow()
Local nMaxCol := MaxCol()

Local nBoxT := 03
Local nBoxL := 04
Local nBoxB := nMaxRow - 3
Local nBoxR := nMaxCol - 4

Local cOldColours := SetColor()
Local cOldArea := Alias()
Local cOldScreen := ""
Local aStructure := {}

LOCAL cTitle := ""
LOCAL cTempMemo := ""

//
// Define an array to hold the structure of the
// help database. This allows me to create the
// file if it is missing.
AADD(aStructure, {"Variable_", "C", 12, 0})
AADD(aStructure, {"Routine_", "C", 12, 0})
AADD(aStructure, {"HelpText_", "M", 10, 0})
AADD(aStructure, {"Title_", "C", 15, 0})

// Were we called from here??
If Upper(cProc) = Upper(ProcName())
    Return(NIL) //Then go pack from whence we came
EndIf

GT_Open("HelpFile", {"Upper(Variable_)+Upper(Routine_)"}, "Help", .F., .F., aStructure)

Save Screen To cOldScreen

SetColor("W+/R")
Seek Upper(cVar)
IF .Not. Found()
    tone(200, 1)
    Append Blank
    Replace help->Variable_ WITH cVar
    Replace help->routine_ With cProc
    Replace help->Helptext_ With " "
End If
nLine := 1
cTitle := If(Empty(help->Title_), "General Help", help->Title_)
cTitle := AllTrim(cTitle)
//
// Ok, now drawq the box on the screen (using GT_BLOCK for effect)
DispBegin()
    GT_Block(nBoxT, nBoxL, nBoxB, nBoxR, "", .T., "n/b", "b+/b", "ͻȺ ")

    // Tidy the thing up a bit
    SetColor("b+/b")
    @ nBoxT+2, nBoxL Say ""
    SetColor("n/b")
    @ nBoxT+2, nBoxR Say ""
    @ nBoxT+2, nBoxL+1 Say Replicate("", nBoxR-(nBoxL+1))
    SetColor("W+/b")
    // Shadow it
    Shadow(nBoxT, nBoxL, nBoxB, nBoxR)
    Centre(nBoxT+1, cTitle)
    //
    // Now edit the stuff
    //
DispEnd()
cTempMemo := MemoEdit(HELP->HELPTEXT_, nBoxT+3, nBoxL+1, nBoxB-1, nBoxR-1, .F., "helpudf")
USE // nothing (Close the file)
SetColor(cOldColours)
If .NOT. Empty(cOldArea)
    Select cOldArea
End If

// Ok, all done, return to calling point

Restore Screen From cOldScreen
Keyboard Chr(1)
Return(NIL)

/****************************************************************************
 Purpose - UDF called from HelpRequest to display scroll bar thingy
 Returns - None
 Author  - Simon Coates
 Created - 08 June 1993
******************************************************************************
Parameters  - nJunk                  - Not Required
              nVertPos      - Current line of Memo
Locals      - cOldScreen    - Holds old screen
            - cOldColours   - Holds existing screen colours
            - nLineCount    - Holds total lines in memo
            - nWidth        - Width of memo box
            - nBoxT   Ŀ
            - nBoxL   Ĵ
            - nBoxB    Co-ordinates of box
            - nBoxR   
            - nMaxCol    - Screen Size
            - nMaxRow
****************************************************************************/

FUNCTION Helpudf( nJunk, nVertPos )
Local cOldScreen, cOldColours
Local nBoxT, nBoxL, nBoxB, nBoxR, nMaxRow, nMaxCol, nWidth, nLinecount

nMaxRow := MaxRow()
nMaxCol := MaxCol()

nBoxT := 03
nBoxL := 04
nBoxB := nMaxRow - 3
nBoxR := nMaxCol - 4
nWidth:= nBoxR - nBoxL

cOldColours := SetColor()

nLineCount  := MlCount(HELP->HELPTEXT_, 10)
nVertPos    := IF(nVertPos>MlCount(HELP->HELPTEXT_, nWidth), ;
               + MlCount(HELP->HELPTEXT_, nWidth), nVertPos)
GT_ElevBar(nBoxT+3, nBoxB-1, nBoxR, "", "", 1, nVertPos, MlCount(HELP->HELPTEXT_, nWidth))
SetColor(cOldColours)
Return(0)


/****************************************************************************
 Purpose - Displays a text string on a specified row
 Returns - None
 Author  - Simon Coates
 Created - 08 June 1993
******************************************************************************
Parameters  - nLine         - Row for message
              cText         - Text string to be displayed
Locals      - nMid          - Used to calculate the middle column
****************************************************************************/

Function Centre(nLine, cText)
Local nMid
nMid := (MaxCol()/2)-(Len(cText)/2)
@ nLine, nMid Say cText
Return(NIL)
