/*
 * File......: HEADER.PRG
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "gt_lib.ch"

/*  $DOC$
 *  $FUNCNAME$
 *      GT_HEADER()
 *  $CATEGORY$
 *      File I/O
 *  $ONELINER$
 *      Get the header size of a DBF file.
 *  $SYNTAX$
 *      GT_Header(<cFileName>) --> nHeaderSize
 *  $ARGUMENTS$
 *      <cFileName> is the name of the DBF file. If the name has no
 *      extension it defaults to DBF.
 *  $RETURNS$
 *      The size of the header in the DBF file.
 *  $DESCRIPTION$
 *      GT_Header() is designed to be the same as the Clipper function
 *      Header(). The main change is that it works on un-opened database
 *      files.
 *  $EXAMPLES$
 *      // Print the header size of an un-opened database file.
 *
 *      ? GT_Header("Life")
 *  $END$
 */

function GT_Header(cFileName)
local nFile       := 0   ,;
      cHeaderSize := "  ",;
      nHeaderSize := 0
if valtype(cFileName) == TYPE_CHAR
   if GT_IsDbf(cFileName)
      cFileName := GT_DefExt(cFileName,"Dbf")
      if (nFile := fopen(cFileName,FO_READ)) != F_ERROR
         fseek(nFile,8,FS_SET)
         if fread(nFile,@cHeaderSize,2) == 2
            nHeaderSize := bin2w(cHeaderSize)
         endif
         fclose(nFile)
      endif
   endif
endif
return(nHeaderSize)
