/*
 * File......: HARDCNT.C
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

// NOTE: This code has been written for and compiled with Borland C++
//       Version 3.1
//

#include <extend.h>

/*  $DOC$
 *  $FUNCNAME$
 *      GT_HARDCNT()
 *  $CATEGORY$
 *      Disk Drive
 *  $ONELINER$
 *      Return a count of the hard drives on a system.
 *  $SYNTAX$
 *      GT_HardCnt() --> nNumberOfDrives
 *  $ARGUMENTS$
 *      None.
 *  $RETURNS$
 *      The number of physical hard drives fitted to a machine.
 *  $DESCRIPTION$
 *      GT_HardCnt() can be used to check the number of hard drives fitted
 *      to a computer system.
 *  $EXAMPLES$
 *      ? "Hard drives on this system =",GT_HardCnt()
 *  $SEEALSO$
 *      GT_FLOPCNT()
 *  $END$
 */

CLIPPER GT_HardCnt()
{
        asm     Mov     AH,08h
        asm     Mov     DL,80h
        asm     Int     13h
        _retni(_AH == 1 ? 0 : _DL);
}
