/*
    File......: GT_Window.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 04/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 04/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_WINDOW()
 *  $CATEGORY$
 *      Video
 *  $ONELINER$
 *      Display a boxed window on the screen.
 *  $SYNTAX$
 *      GT_Window(<nTop>,<nLeft>,<nBottom>,<nRight>, ;
 *          [<cLines>],[<cColour>],[<cTitle>],[<lShadow>]) ;
 *          => lSuccess
 *  $ARGUMENTS$
 *      <nTop>],[<nLeft>],[<nBottom>,<nRight>] are the
 *      corners of the box.
 *
 *      <cColour> is an optional colour string.
 *
 *      <cBoxLines> are the optional box lines to use.
 *
 *      <cTitle> is the optional title.
 *
 *      <lShadow> shadow the box ?
 *  $RETURNS$
 *      .T. / .F. based on the success.
 *  $DESCRIPTION$
 *      Display a boxed window on the screen.
 *  $EXAMPLES$
 *      // Window, default colours, lines and shadow and no
 *      // title
 *      GT_Window(05,10,15,20)
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

FUNCTION GT_Window(nTop,nLeft,nBottom,nRight,cLines, ;
    cColour,cTitle,lShadow)

LOCAL cSaveColour := SETCOLOR()
LOCAL cTemp

Default nTop to -1
Default nLeft to -1
Default nBottom to -1
Default nRight to -1
Default cLines to BOX_SS
Default cColour to SETCOLOR()
Default cTitle to ''
Default lShadow to .T.

SETCOLOR(cColour)

//  Shadow ?
IF lShadow
    lShadow := nBottom < Maxrow() .AND. ;
        nRight < (Maxcol() - 1) .AND. ;
        nTop > 2 .AND. nLeft > 1
ENDIF

//  Draw !
DISPBOX(nTop,nLeft,nBottom,nRight,cLines,cColour)

//  Title ?
IF .NOT. EMPTY(cTitle)

    @ nTop, nLeft + 01 SAY SUBSTR(cLines,10,1) + ' ' + ;
        cTitle + ' ' + SUBSTR(cLines,11,1)

ENDIF

//  Shadow ?
IF lShadow

    GT_Shadow(nTop,nLeft,nBottom,nRight)

ENDIF

//  Restore
SETCOLOR(cSaveColour)

/*
    End of GT_Window()
*/
Return(NIL) // 
