/*
    File......: GT_Setup.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 05/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 05/02/93
    PD Revision.
*/
/*  $DOC$
 *  $FUNCNAME$
 *      GT_SETUP()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      A general purpose Setup function.
 *  $SYNTAX$
 *      GT_Setup() -> lSuccess
 *  $ARGUMENTS$
 *      None
 *  $RETURNS$
 *      lSuccess
 *  $DESCRIPTION$
 *      A general purpose Setup function.
 *  $EXAMPLES$
 *      IF .NOT. GT_Setup()
 *          GT_Quit()
 *      ENDIF
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

FUNCTION GT_Setup()

LOCAL lSuccess := .T.

//  No alternate file in use
Set(_SET_ALTERNATE,.F.)
//  Bell off
Set(_SET_BELL,.F.)
//  Leaving GETs
Set(_SET_CONFIRM,.T.)
//  CONSOLE == Do ?/?? go to the SCREEN ?
Set(_SET_CONSOLE,.F.)
//  Turn cursor off
GT_NoCursor()
//  British date
Set(_SET_DATEFORMAT, 'dd/mm/yyyy')
//  Default to 2 decimals
Set(_SET_DECIMALS,4)
// Current directory is default
Set(_SET_DEFAULT,'')
//  Don't show deleted records
Set(_SET_DELETED,.T.)
//  Delimitors on GETs
Set(_SET_DELIMITERS,.F.)
//  DEVICE == Where do the @ SAY's go to ?
Set(_SET_DEVICE,'SCREEN')
//  Esc works
Set(_SET_ESCAPE,.T.)
//  Exact match not required
Set(_SET_EXACT,.F.)
//  Multi user
Set(_SET_EXCLUSIVE,.F.)
//  ??
Set(_SET_FIXED,.F.)
//  Screen
Set(_SET_INTENSITY,.T.)
//
Setcancel(.F.)

//  Set standard keys
SetKey(K_F1,{ | cProc, nProcLine, cVarName | ;
    GT_Help(cProc,nProcLine,cVarName) } )
SetKey(K_ALT_C,{ | cProc, nProcLine, cVarName | GT_AskQuit() } )

//  Printer margin
Set(_SET_MARGIN,0)
//  Dir path
Set(_SET_PATH,'')
//  PRINT == Do ?/?? go to the PRINTER ?
Set(_SET_PRINTER,.T.)
//  dBase Scoreboard
Set(_SET_SCOREBOARD,.F.)
//  Use softseek
Set(_SET_SOFTSEEK,.T.)
//  Keyboard buffer
Set(_SET_TYPEAHEAD,40)
//  Menu wrapping
Set(_SET_WRAP,.T.)

/*
    Set the Ins key so that when the cursor is off it has no
    effect but when it is on it is large for insert and
    small for overtype.
*/
SetKey(K_INS,{|| If(SETCURSOR()=0,NIL,SETCURSOR(;
    If(READINSERT(!READINSERT()),1,2))) })

/*
    End of GT_Setup()
*/
RETURN(lsuccess)
