/*
 * GT CLIPPER STANDARD HEADER
 *
 * File......: gt_seg.c
 * Author....: Brian Dukes
 * BBS.......: THE CELLAR bbs
 * Net/Node..: 013/203
 * User Name.: Brian Dukes
 * Date......: 10/5/93
 * Revision..: 1.0
 *
 * This is an original work by Brian Dukes and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*
 *  $DOC$
 *  $FUNCNAME$
 *      GT_SEGMENT()
 *  $CATEGORY$
 *      String
 *  $ONELINER$
 *      Returns the segment of the passed character string
 *  $SYNTAX$
 *      GT_Segment(<str>) --> nSegment
 *  $ARGUMENTS$
 *      <str>     - Character String
 *  $RETURNS$
 *      nSegment  - The segment of <str>.
 *  $DESCRIPTION$
 *      This function will become invaluable when calling GT_Int86()
 *      functions, as some of these functions will need to know the address
 *      of strings that are passed in.
 *
 *  $EXAMPLES$
 *      ? GT_Segment(str)
 *
 *  $SEEALSO$
 *      GT_OFFSET()   SYSTEM.EHO:GT_INT86()
 *  $END$
 */

/**** Compiled in MS/C v6.0  as  CL /AL /Gs /Zl -c gt_seg.c        ****/

#include <extend.h>

/* FP_SEG Ripped out of DOS.H - No need to include all the other junk from it */

#define FP_SEG(fp) (*((unsigned _far *)&(fp)+1))


CLIPPER gt_segment()
{
   unsigned segment = 0 ;
   char far * ptr ;

   if (_parinfo(1) == CHARACTER)
      {
         ptr = _parc(1) ;
         segment = FP_SEG(ptr) ;
      }

   _retni(segment) ;
}

/**** end of function ****/
