/*
    File......: GT_Quit.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 04/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 04/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_QUIT()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      To safely quit the application.
 *  $SYNTAX$
 *      GT_Quit([<nErrorLevel>]) -> NIL
 *  $ARGUMENTS$
 *      <nErrorLevel> is a DOS error level to set.
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      To safely quit the application.
 *  $EXAMPLES$
 *      GT_Quit(1)
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

FUNCTION GT_Quit(nErrorLevel)

LOCAL nError := MAX(FERROR(),DOSERROR())

Default nErrorLevel to 0

IF .NOT. (nError = 0 .OR. nError = 32)
    // Message if error other than sharing violation
    GT_Error('Last Error was ....')
ENDIF

SET(_SET_PRINTER,'')
GT_ShowCursor()
SETCOLOR('W/N,N/W,N,N,N/W')
DBCLOSEALL()
SCROLL()
@ 0,0 SAY ''
ERRORLEVEL(nErrorLevel)

QUIT
/*
    End of GT_Quit()
*/
RETURN(NIL)
