/*
    File......: GT_Memo.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 05/03/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 05/03/93
    PD Revision.

    Rev 1.1 17/03/93
    Leave on screen option.
*/

/*  $DOC$
 *  $FUNCNAME$
 *       GT_MEMO()
 *  $CATEGORY$
 *       Array
 *  $ONELINER$
 *       Display a Memo in a box on the screen
 *  $SYNTAX$
 *       GT_Memo(<cText>,[<cTitle>],[<cColour>], ;
 *           [<cBoxLines>],[<nTop>],[<nLeft>],[<nBottom>], ;
 *           [<nRight>],[<lEdit>],[<lScreen>]) => cText
 *  $ARGUMENTS$
 *       <cText> is the Memo to display.
 *       <cTitle> is an optional title for the window.
 *       <cColour> is an optional colour string.
 *       <cBoxLines> are the optional box lines to use.
 *       <nTop>,<nLeft>,<nBottom>,<nRight> are the
 *       corners of the box. As many or as few of these may
 *       be used as required. The default is to use most of
 *       the screen.
 *       <lScreen> Restore screen after use ? (Default .T.)
 *  $RETURNS$
 *       cText
 *  $DESCRIPTION$
 *       Display a Memo in a box on the screen. Optionally
 *       allow editing or just viewing.
 *  $EXAMPLES$
 *  $END$
 */

#include "GtClippe.ch"
#include "MemoEdit.ch"

FUNCTION GT_Memo(cText,cTitle,cColour,cBoxLines,nTop, ;
    nLeft,nBottom,nRight,lEdit,lScreen)

EXTERNAL Memo_udf
EXTERNAL Memo_save

LOCAL nCursor := 0
LOCAL cOptions := ;
    'EscExit                                                 ' + ;
    CHR(24) + CHR(25) + CHR(26) + CHR(27) + 'Cursor Control'

LOCAL cScreen := ''

Default cText to ''
Default cTitle to ''
Default cColour to SETCOLOR()
Default cBoxLines to ''
Default nTop to 04
Default nLeft to 02
Default nBottom to MAXROW() - 04
Default nRight to MAXCOL() - 02
Default lEdit to .F.
Default lScreen to .T.

IF lScreen
    cScreen := SAVESCREEN(00,00,MAXROW(),MAXCOL())
ENDIF

//  Box based on edit mode
IF EMPTY(cBoxLines)
    cBoxLines := IF(lEdit,BOX_DD,BOX_SS)
ENDIF

//  Set cursor
nCursor := IF(lEdit,GT_ShowCursor(),GT_NoCursor())

//  Display
GT_Window(nTop,nLeft,nBottom,nRight,cBoxLines,cColour, ;
    cTitle,.T.)

IF nBottom < MAXROW() - 03

    IF !lScreen
        cScreen := SAVESCREEN(MAXROW()-02,00,MAXROW(),MAXCOL())
    ENDIF

    GT_Message(cOptions,'Options:',cColour,BOX_SS, ;
        MAXROW()-02,00,MAXROW(),MAXCOL())

ENDIF

//Edit
cText := MEMOEDIT(cText,nTop+01,nLeft+01,nBottom-01, ;
    nRight-01,lEdit,'Memo_udf')

//  Reset cursor
SETCURSOR(nCursor)

IF lScreen
    RESTSCREEN(00,00,MAXROW(),MAXCOL(),cScreen)
ELSE
    IF nBottom < MAXROW() - 03
        RESTSCREEN(MAXROW()-02,00,MAXROW(),MAXCOL(),cScreen)
    ENDIF
ENDIF

/*
    End of GT_Memo()
*/
RETURN(cText)

/*
***********************************************************
*/

FUNCTION Memo_udf(nStatus,nLine,nColumn)

LOCAL aKeys := {K_ESC}
LOCAL aBlocks := { ;
    { | nMode | IF(nMode=ME_UNKEYX,Memo_Save(),0) } ;
    }

LOCAL nKey := LASTKEY()
LOCAL nReturn := 0
LOCAL nTest := 0

Default nStatus to ME_UNKEY
Default nLine to 0
Default nColumn to 0

DO CASE

    CASE nStatus = ME_IDLE
        // Idle

    CASE nStatus = ME_INIT
        // Should be startup status

    OTHERWISE
        // Other key
        nTest := ASCAN(aKeys,nKey)
        IF nTest > 0
            nReturn := EVAL(aBlocks[nTest],nStatus)
        ENDIF

ENDCASE

/*
    End of Memo_udf()
*/
RETURN(nReturn)

/*
************************************************************************
*/
FUNCTION Memo_Save()

LOCAL cScreen := SAVESCREEN(00,00,MAXROW(),MAXCOL())
LOCAL lSave := .T.

lSave := (UPPER(CHR(GT_AskUser('Save changes ? (Y/N)', ;
    {ASC('Y'),ASC('y'),ASC('N'),ASC('n')}))) = 'Y')

RESTSCREEN(00,00,MAXROW(),MAXCOL(),cScreen)

/*
    End of Memo_Save()
*/
RETURN(IF(lSave,K_CTRL_W,K_ESC))
