/*
    File......: GT_IsFile.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 04/03/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 04/03/93
    PD Revision.

    Rev 1.1 17/03/93
    Change lWildCards to cType
*/

/*  $DOC$
 *  $FUNCNAME$
 *       GT_ISFILE()
 *  $CATEGORY$
 *       Array
 *  $ONELINER$
 *       Check a file name is valid
 *  $SYNTAX$
 *       GT_IsFile(<oGet|cFile>,[<cType>],[<lExists>])
 *  $ARGUMENTS$
 *       <oGet|cFile> Get object to check the file name or
 *       just pass a name.
 *
 *       <lWildCards> Matching spec.
 *
 *       <lExists> Must the file exist ?
 *  $RETURNS$
 *       .T. / .F. based on the success.
 *  $DESCRIPTION$
 *       Check that a file name is valid and optionally if it
 *       exists.
 *  $EXAMPLES$
 *  $END$
 */

#include "GtClippe.ch"

FUNCTION GT_IsFile(oGet,cType,lExists)

LOCAL cExtent := ''
LOCAL cFile := ''
LOCAL cLegal := 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_-'
LOCAL cPath := ''
LOCAL lSuccess := .T.
LOCAL nCount := 0
LOCAL nFound := 0
LOCAL nLength := 0

Default oGet to ''
Default cType to ''
Default lExists to .F.

//  Get file name to check
IF VALTYPE(oGet) == 'O'
    cFile := UPPER(EVAL(oGet:Block,NIL))
ELSE
    cFile := oGet
ENDIF
nLength := LEN(cFile)

// Check validity
nFound := RAT('\',cFile)

//  Extract path
IF nFound > 0
    cPath := LTRIM(RTRIM(SUBSTR(cFile,1,nFound)))
    cFile := SUBSTR(cFile,nFound+01)
ELSE
    cPath := ''
ENDIF

// Extract extent
nFound := AT('.',cFile)
IF nFound > 0
    cExtent := LTRIM(RTRIM(SUBSTR(cFile,nFound+01,3)))
    cFile := SUBSTR(cFile,1,nFound-01)
ELSE
    cExtent := ''
ENDIF
cFile := LTRIM(RTRIM(cFile))

//  Validate extent
nCount := LEN(cExtent)
DO WHILE nCount > 0 .AND. lSuccess
    lSuccess := SUBSTR(cExtent,nCount--,1) $ cLegal
ENDDO

//  Validate name
nCount := LEN(cFile)
DO WHILE nCount > 0 .AND. lSuccess
    lSuccess := SUBSTR(cFile,nCount--,1) $ cLegal
ENDDO

// Validate path
IF AT(':',cPath) != RAT(':',cPath) .OR. '\\' $ cPath
    lSuccess := .F.
ENDIF
nCount := LEN(cPath)
cLegal += ':\'
DO WHILE nCount > 0 .AND. lSuccess
    lSuccess := SUBSTR(cPath,nCount--,1) $ cLegal
ENDDO

//  Must exist
IF lExists .OR. .NOT. lSuccess

    IF lSuccess

        cFile := cPath + cFile + ;
            IF(EMPTY(cExtent),'','.' + cExtent)

    ELSE

        cPath := ''
        cExtent := ''
        cFile := ''

    ENDIF

    IF !FILE(cFile)

        cFile := GT_Directory(cPath,IF(EMPTY(cType), ;
            cExtent,cType))

        EVAL(oGet:Block,PADR(cFile,nLength))

    ENDIF

    RETURN(!EMPTY(cFile))

ENDIF

IF .NOT. lSuccess

    GT_AskUser('This is not a valid file name',{}, ;
        'Error:',SETCOLOR())

ENDIF

/*
    End of GT_IsFile()
*/
RETURN(lSuccess)

