/*
    File......: GT_DateA.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Brian Dukes
    Date......: 28/8/94
    Revision..: 1.1

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 28/8/94 - PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_DATEADJUST()
 *  $CATEGORY$
 *      Date
 *  $ONELINER$
 *      Take a date and add days, months and years to it
 *  $SYNTAX$
 *      GT_DateAdjust(<dDate>,<nDays>],[<nMonths>],[<nYears>]) -> dReturn
 *  $ARGUMENTS$
 *      <dDate> is a date value to which the values are
 *      added.
 *
 *      <nDays> is the number of days to add to <dDate>.
 *
 *      <nMonths> is the number of months to add to <dDate>.
 *
 *      <nYears> is the number of years to add to <dDate>.
 *  $RETURNS$
 *      GT_DateAdjust() always returns a legal date.
 *  $DESCRIPTION$
 *      Function to take a date and add days, months and
 *      years to it, returning the new date.
 *  $EXAMPLES$
 *      // Same date next month
 *      dDate := GT_DateAdjust(DATE(),0,1,0)
 *
 *      // Same date a year tomorrow
 *      dDate := GT_DateAdjust(DATE(),1,0,1)
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

*/
#include "GT_LIB.ch"

FUNCTION GT_DateAdjust(dDate,nDays,nMonths,nYears)

Local dNewDate
LOCAL nMonth   := 0
LOCAL nYear    := 0

Default dDate   to DATE()
Default nDays   to 0
Default nMonths to 0
Default nYears  to 0

dNewDate := dDate + nDays

nMonth := MONTH( dNewDate ) + nMonths
nYear  := YEAR(  dNewDate ) + nYears

IF nMonth < 1
    nYear  -= 1
    nMonth += 12
ELSE
    IF nMonth > 12
        nYear  += 1
        nMonth -= 12
    ENDIF
ENDIF

dNewDate := CTOD( STRZERO( DAY( dNewDate ) , 2 ) + "/" + ;
                  STRZERO( nMonth , 2 )          + "/" + ;
                  STRZERO( nYear , 4 ) )

RETURN dNewDate
