/*
 * File......: GT_BLOCK.PRG
 * Author....: Simon Coates
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Simon Coates
 * Date......: 21/07/1993
 * Revision..: 1.0
 *
 * This is an original work by Simon Coates and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_BLOCK()
 *  $CATEGORY$
 *      Video
 *  $ONELINER$
 *     Draws a '3d(ish)' box, and opptionally labels it
 *  $SYNTAX$
 *      GT_Block( nTop, nLeft, nBottom, nRight, ;
 *                <cLabel>, <lShadow>, <cDull>, <cBright>, <cBoxChars>)
 *  $ARGUMENTS$
 *      nTop,nLeft,nBottom & nRight are the coordinates
 *      cLabel    -   text string to be displayed *ABOVE* the box
 *      lShadow   -   .T./.F. for shadowing the box
 *      cDull     -   Darker colour pair
 *      cBright   -   Brighter colour pair
 *      cBoxChars -   Box Characters
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      This routine was written to smarten up the screen display a bit.
 *      The idea is to try and emulate "Windows" type boxes, i.e. to draw
 *      them in two colours, one brighter than the other.
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include 'gt_lib.ch'

/****************************************************************************
 Purpose -
 Returns - None
 Author  - Simon Coates
 Created - 08 June 1993
******************************************************************************
Parameters  - nTop       - Top of box
              nLeft      - Left hand column of box
              nBottom    - Bottom of box
              nRight     - Right hand column (suprise, suprise)
              cLabel    -  text string to be displayed *ABOVE* the box
              lShadow   -  .T./.F. for shadowing the box
              cDull     -  Darker colour pair
              cBright   -  Brighter colour pair
              cBoxChars -  Box Characters
Locals      - cOldColours- Holds existing screen colours
            - cTopLeft   - BoxChar
            - cTopCent   -   "
            - cTopRight  -   "
            - cVertRight -   "
            - cBotLeft   -   "
            - cBotCent   -   "
            - cBotRight  -   "
            - cVertLeft  -   "
****************************************************************************/

FUNCTION GT_Block(nTop, nLeft, nBottom, nRight, cLabel, lShadow, cDull, cBright, cBoxChars)

Local cOldColours := SETCOLOR()
Local cTopLeft    := ""
Local cTopCent    := ""
Local cTopRight   := ""
Local cVertRight  := ""
Local cBotLeft    := ""
Local cBotCent    := ""
Local cBotRight   := ""
Local cVertLeft   := ""
LOCAL l           := 0

If Pcount() < 9
    cBoxChars := BOX_SS     // Defined in GT_LIB.CH
End If

If Pcount() < 8
    cBright := "W+/W"
End If

If Pcount() < 7
    cDull := "N/W"
End If

If Pcount() < 6
    lShadow := FALSE
End If

If Pcount() < 5
    cLabel := ""
End If

// Ok, everything's been defined (I hope), so lets get started

// Split up the character string
cTopLeft    := SubStr(cBoxChars, 1, 1)
cTopCent    := SubStr(cBoxChars, 2, 1)
cTopRight   := SubStr(cBoxChars, 3, 1)
cVertRight  := SubStr(cBoxChars, 4, 1)
cBotRight   := SubStr(cBoxChars, 5, 1)
cBotCent    := SubStr(cBoxChars, 6, 1)
cBotLeft    := SubStr(cBoxChars, 7, 1)
cVertLeft   := SubStr(cBoxChars, 8, 1)

// Draw the first bit of the box
SetColor(cBright)
@ nTop, nLeft CLEAR TO nBottom, nRight
@ nTop, nLeft SAY cTopLeft + REPLICATE(cTopCent, nRight-nLeft)

// Draw the sides of the box

FOR l:= nTop+1 TO nBottom-1
    SETCOLOR(cBright)
    @ l, nLeft SAY cVertLeft
    SETCOLOR(cDull)
    @ l, nRight SAY cVertRight
NEXT

// And draw the bottom bit as well

SETCOLOR(cBright)
@ nBottom, nLeft SAY cBotLeft
SETCOLOR(cDull)
@ nBottom, nLeft+1 SAY REPLICATE(cBotCent, (nRight-1)-nLeft)+cBotRight
@ nTop, nRight SAY cTopRight


// If a label was passed, then display it
IF Len(cLabel) > 0   // Label was passed
    @ nTop-1, nLeft+1 SAY cLabel
ENDIF

// Finally, draw a shadow (if required)

If lShadow
    Shadow(nTop, nLeft, nBottom, nRight)
End If

SETCOLOR(cOldColours)

RETURN(NIL)
