/*
 * File......: GTMATH03
 * Author....: Philip Ide
 * BBS.......: Dark Knight Returns
 * Net/Node..:
 * User Name.: Philip Ide
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Philip Ide and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *      GT_BTOD()
 *  $CATEGORY$
 *      Maths
 *  $ONELINER$
 *      Convert a binary string into a decimal number
 *  $SYNTAX$
 *      GT_BtoD(<cBin>) --> <nDec>
 *  $ARGUMENTS$
 *      <cBin>   is a binary number held as a character string.
 *  $RETURNS$
 *      <nDec>   is a decimal integer
 *  $DESCRIPTION$
 *      This function takes a stream of '1's and '0's representing a binary
 *      number, and converts them to a decimal.
 *  $EXAMPLES$
 *      ? GT_BtoD('11111111')        // 255
 *
 *      ? GT_BtoD('1011')            // 11
 *  $SEEALSO$
 *      GT_DTOB()  GT_BINARY()
 *  $INCLUDE$
 *
 *  $END$
 */

STATIC bin := '01'

Function GT_BtoD( n )
LOCAL x, y := 0, z, a := 1
FOR x := 1 TO Len(n)                        // once per byte
    z := AT(SubStr(n,-x,1),bin)-1           // get 1 byte, start at far end
    IF x > 1                                // miss this the first time...
       a *= 2                               // exponentiate by 2
    Endif
    y += (a*z)                              // exponentiate the byte,
Next                                        // add to result.
Return (y)
