/*
 * File......: GTCURS.PRG
 * Author....: Philip Ide
 * BBS.......: Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Philip Ide
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Philip Ide and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *      GT_PUSHCUR()
 *  $CATEGORY$
 *      Environment
 *  $ONELINER$
 *      Place cursor state on the stack, optionaly change state
 *  $SYNTAX$
 *      GT_PUSHCUR([<nNewState>]) -> <nOldState>
 *  $ARGUMENTS$
 *      <nNewState> is a numeric constant which identifies the new cursor
 *                  state.  Manifest constants from setcurs.ch are
 *                  recommended.
 *  $RETURNS$
 *      <nOldState> is the state of the cursor before any changes are
 *      applied.
 *  $DESCRIPTION$
 *      This function pushes the current cursor state onto a stack, and then
 *      optionaly changes the state.  To restore the cursor is simply a
 *      matter of 'popping' the stack by calling GT_POPCUR().
 *
 *      It is important to pop the stack as many times as you push it,
 *      otherwise you may get the wrong cursor shape back.
 *  $EXAMPLES$
 *      GT_PUSHCUR(SC_NONE)   // push cursor and turn it off
 *        ..code..            // do something, maybe display a message
 *        ...
 *      GT_POPCUR()           // restore cursor
 *  $SEEALSO$
 *      GT_POPCUR()
 *  $INCLUDE$
 *      SETCURS.CH  GT_LIB.CH
 *  $END$
 */
/*  $DOC$
 *  $FUNCNAME$
 *      GT_POPCUR()
 *  $CATEGORY$
 *      Environment
 *  $ONELINER$
 *      Pop cursor state from the stack.
 *  $SYNTAX$
 *      GT_POPCUR() -> <nOldState>
 *  $ARGUMENTS$
 *  $RETURNS$
 *      <nOldState> is the state of the cursor before any changes are
 *      applied.
 *  $DESCRIPTION$
 *      This function pops the current cursor state off a stack, having
 *      previously been placed there by calling GT_PUSHCUR().
 *
 *      This is used to restore the cursor shape after a temporary change.
 *
 *      It is important to pop the stack as many times as you push it,
 *      otherwise you may get the wrong cursor shape back.
 *  $EXAMPLES$
 *      GT_PUSHCUR(SC_NONE)   // push cursor and turn it off
 *        ..code..            // do something, maybe display a message
 *        ...
 *      GT_POPCUR()           // restore cursor
 *  $SEEALSO$
 *      GT_PUSHCUR()
 *  $INCLUDE$
 *      SETCURS.CH  GT_LIB.CH
 *  $END$
 */

#include "gt_lib.ch"

STATIC aCursor

/***
*
*/
FUNCTION GT_PUSHCUR(nNewState)      // save cursor state
         LOCAL nOldState

         DEFAULT aCursor TO {}      // initialise static array (stack)

         nOldState := SetCursor(nNewState)
         AADD(aCursor,nOldState)
         Return (aCursor[Len(aCursor)])

/***
*
*/
FUNCTION GT_POPCUR()                // restore cursor shape
         LOCAL nOldState, nNewState

         DEFAULT aCursor TO {}      // initialise static array (stack)

         IF Len(aCursor) > 0
            nNewState := aCursor[Len(aCursor)]
            aCursor := ASize(aCursor,Len(aCursor)-1)
         End

         Return(nOldState := SetCursor(nNewState))


