/*
    File......: GtClippe.ch
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 03/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 03/02/93
    PD Revision.

    Documentation
    -------------

    Function Name

        N/A

    Description

        Standard GT_ Header file

    Syntax

        #include "GtClipper.ch"

    Aruments

        N/A

    Returns

        N/A

    Examples

        #include "GtClipper.ch"

*/

#include "Inkey.ch"
#include "SetCurs.ch"

//  End of line Def
#define CRLF        (CHR(13)+CHR(10))

//  New page for printers
#define FORMFEED    CHR(12)

//  Box lines
#define BOX_DD      'ͻȺ '
#define BOX_DS      '͸Գ '
#define BOX_SD      'ķӺ '
#define BOX_SS      'Ŀ '

//  Default command
#translate DEFAULT <x> TO <y>   =>  ;
    IF (<x> == NIL) ; <x> := <y> ; ENDIF

//  Index key as a block
#translate GT_IndexBlock(<n>)   =>  ;
    &('{ || ' + ;
        If(Empty(Indexkey(<n>)),'NIL',Indexkey(<n>)) + ;
        ' }')

//  Turn the cursor on
#translate GT_ShowCursor()      => ;
    SetCursor(If(ReadInsert(),SC_INSERT,SC_NORMAL))

//  Turn the cursor off
#translate GT_NoCursor()        => ;
    SetCursor(SC_NONE)

#translate GT_Read(<a>)         => ;
    AEVAL({ { | |  SETCURSOR(IF(READINSERT(), ;
    SC_INSERT,SC_NORMAL)) }, ;
    { | | READMODAL(<a>) }, ;
    { | | SETCURSOR(SC_NONE) } }, ;
    { | bData, nElem | EVAL(bData) })




